/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gpdb;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipMGpdbKubun;
import com.aimluck.eip.cayenne.om.portlet.EipMGpdbKubunValue;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbItem;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.gpdb.GpdbKubunSelectData;
import com.aimluck.eip.gpdb.GpdbKubunValueResultData;
import com.aimluck.eip.gpdb.util.GpdbUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GpdbKubunFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbKubunFormData.class.getName());
    private ALStringField gpdb_kubun_id;
    private ALStringField gpdb_kubun_name;
    private ALStringField gpdb_kubun_value;
    private boolean is_new_kubun;
    private String gpdbKubunValueId;
    private EipMGpdbKubun gpdbKubun;
    private List<EipMGpdbKubun> gpdb_kubun_list;
    static final String LIST_FILTER_STR = new StringBuffer().append(GpdbKubunSelectData.class.getName()).append("filter").toString();

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.is_new_kubun = rundata.getParameters().getBoolean("is_new_kubun");
        this.gpdb_kubun_list = new ArrayList<EipMGpdbKubun>();
        this.gpdbKubunValueId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
    }

    public void initField() {
        this.gpdb_kubun_id = new ALStringField();
        this.gpdb_kubun_id.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_SELECTION_ITEMS"));
        this.gpdb_kubun_name = new ALStringField();
        this.gpdb_kubun_name.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_SELECTION_ITEMS"));
        this.gpdb_kubun_name.setTrim(true);
        this.gpdb_kubun_value = new ALStringField();
        this.gpdb_kubun_value.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_VALUE"));
        this.gpdb_kubun_value.setTrim(true);
    }

    protected void setValidator() {
        this.gpdb_kubun_value.setNotNull(true);
        this.gpdb_kubun_value.limitMaxLength(50);
        this.gpdb_kubun_name.limitMaxLength(50);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            if (res) {
                if ("new_form".equals(this.getMode())) {
                    this.gpdb_kubun_id.setValue(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)LIST_FILTER_STR));
                }
                SelectQuery fquery = Database.query(EipMGpdbKubun.class);
                fquery.orderAscending("gpdbKubunName");
                this.gpdb_kubun_list = fquery.fetchList();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            res = false;
        }
        return res;
    }

    protected boolean validate(List<String> msgList) {
        try {
            EipMGpdbKubunValue gpdbKubunValue = GpdbUtils.getEipMGpdbKubunValue(this.gpdbKubunValueId);
            if ("update".equals(this.getMode())) {
                int recordCount = GpdbUtils.getRecordCountKubunUsed(this.gpdbKubunValueId);
                if (recordCount > 0 && (this.is_new_kubun || !gpdbKubunValue.getGpdbKubunId().toString().equals(this.gpdb_kubun_id.getValue()))) {
                    msgList.add("\u767b\u9332\u3055\u308c\u3066\u3044\u308b\u5024\u306e\u305f\u3081\u9078\u629e\u9805\u76ee\u306f\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3002");
                    return false;
                }
                if (this.existsItemAndLastKubun(gpdbKubunValue.getGpdbKubunId())) {
                    msgList.add("\u9805\u76ee\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u308b\u9078\u629e\u9805\u76ee\u306e\u305f\u3081\u3001\u5225\u306e\u9078\u629e\u9805\u76ee\u306b\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3002");
                    return false;
                }
            }
            if (this.is_new_kubun) {
                this.gpdb_kubun_name.setNotNull(true);
                if (this.gpdb_kubun_name.validate(msgList)) {
                    SelectQuery query = Database.query(EipMGpdbKubun.class);
                    query.setQualifier(ExpressionFactory.matchExp((String)"gpdbKubunName", (Object)this.gpdb_kubun_name.getValue()));
                    if (!query.fetchList().isEmpty()) {
                        msgList.add("\u9078\u629e\u9805\u76ee\u300e <span class='em'>" + this.gpdb_kubun_name.toString() + "</span> \u300f\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
                    }
                }
            } else {
                this.gpdb_kubun_id.setNotNull(true);
                if (this.gpdb_kubun_id.validate(msgList)) {
                    SelectQuery query = Database.query(EipMGpdbKubunValue.class);
                    query.setQualifier(ExpressionFactory.matchExp((String)"gpdbKubunValue", (Object)this.gpdb_kubun_value.getValue()));
                    query.andQualifier(ExpressionFactory.matchExp((String)"gpdbKubun", (Object)this.gpdb_kubun_id.getValue()));
                    if ("update".equals(this.getMode())) {
                        query.andQualifier(ExpressionFactory.noMatchDbExp((String)"GPDB_KUBUN_VALUE_ID", (Object)Integer.valueOf(this.gpdbKubunValueId)));
                    }
                    if (!query.fetchList().isEmpty()) {
                        msgList.add("\u5024\u300e <span class='em'>" + this.gpdb_kubun_value.toString() + "</span> \u300f\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        this.gpdb_kubun_value.validate(msgList);
        return msgList.isEmpty();
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMGpdbKubunValue value = GpdbUtils.getEipMGpdbKubunValue(rundata, context);
            if (value == null) {
                return false;
            }
            this.gpdb_kubun_id.setValue(value.getGpdbKubun().getGpdbKubunId().toString());
            this.gpdb_kubun_value.setValue(value.getGpdbKubunValue());
            SelectQuery fquery = Database.query(EipMGpdbKubun.class);
            fquery.orderAscending("gpdbKubunName");
            this.gpdb_kubun_list = fquery.fetchList();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            int orderNo = 1;
            if (this.is_new_kubun) {
                if (!this.insertKubunData(msgList)) {
                    return false;
                }
            } else {
                this.gpdbKubun = GpdbUtils.getEipMGpdbKubun(Integer.valueOf(this.gpdb_kubun_id.getValue()));
                SelectQuery query = Database.query(EipMGpdbKubunValue.class);
                query.setQualifier(ExpressionFactory.matchExp((String)"gpdbKubun", (Object)this.gpdbKubun));
                query.orderDesending("orderNo");
                EipMGpdbKubunValue maxOrderKubunValue = (EipMGpdbKubunValue)query.fetchSingle();
                orderNo = maxOrderKubunValue.getOrderNo() + 1;
            }
            EipMGpdbKubunValue value = (EipMGpdbKubunValue)Database.create(EipMGpdbKubunValue.class);
            value.setGpdbKubun(this.gpdbKubun);
            value.setGpdbKubunValue(this.gpdb_kubun_value.getValue());
            value.setOrderNo(Integer.valueOf(orderNo));
            value.setCreateDate(Calendar.getInstance().getTime());
            value.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(value.getGpdbKubunValueId().intValue(), 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u9078\u629e\u9805\u76ee\u300c" + value.getGpdbKubun().getGpdbKubunName() + "\u300d \u5024 \u300c" + value.getGpdbKubunValue() + "\u300d \u8ffd\u52a0");
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean insertKubunData(List<String> msgList) {
        try {
            this.gpdbKubun = (EipMGpdbKubun)Database.create(EipMGpdbKubun.class);
            this.gpdbKubun.setGpdbKubunName(this.gpdb_kubun_name.getValue());
            this.gpdbKubun.setCreateDate(Calendar.getInstance().getTime());
            this.gpdbKubun.setUpdateDate(Calendar.getInstance().getTime());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            msgList.add("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMGpdbKubunValue value = GpdbUtils.getEipMGpdbKubunValue(rundata, context);
            if (value == null) {
                return false;
            }
            if (this.is_new_kubun) {
                if (!this.insertKubunData(msgList)) {
                    return false;
                }
                value.setOrderNo(Integer.valueOf(1));
            } else {
                this.gpdbKubun = GpdbUtils.getEipMGpdbKubun(Integer.valueOf(this.gpdb_kubun_id.getValue()));
            }
            value.setGpdbKubun(this.gpdbKubun);
            value.setGpdbKubunValue(this.gpdb_kubun_value.getValue());
            value.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            if (GpdbUtils.removeGpdbKubunNoValue()) {
                Database.commit();
            }
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(value.getGpdbKubunValueId().intValue(), 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u9078\u629e\u9805\u76ee\u300c" + value.getGpdbKubun().getGpdbKubunName() + "\u300d \u5024 \u300c" + value.getGpdbKubunValue() + "\u300d \u66f4\u65b0");
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMGpdbKubunValue value = GpdbUtils.getEipMGpdbKubunValue(rundata, context);
            if (value == null) {
                return false;
            }
            int kubunCount = GpdbUtils.getRecordCountKubunUsed("" + value.getGpdbKubunValueId());
            if (kubunCount > 0) {
                msgList.add("\u4f7f\u7528\u3055\u308c\u3066\u3044\u308b\u5024\u306e\u305f\u3081\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002");
                return false;
            }
            if (this.existsItemAndLastKubun(value.getGpdbKubunId())) {
                msgList.add("\u9805\u76ee\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u308b\u9078\u629e\u9805\u76ee\u306e\u305f\u3081\u3001\u5168\u3066\u306e\u5024\u306f\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002");
                return false;
            }
            this.gpdbKubun = GpdbUtils.getEipMGpdbKubun(value.getGpdbKubunId());
            Database.delete((Persistent)value);
            Database.commit();
            if (GpdbUtils.removeGpdbKubunNoValue()) {
                Database.commit();
            }
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(value.getGpdbKubunValueId().intValue(), 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u9078\u629e\u9805\u76ee\u300c" + this.gpdbKubun.getGpdbKubunName() + "\u300d \u5024 \u300c" + value.getGpdbKubunValue() + "\u300d \u524a\u9664");
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean existsItemAndLastKubun(int kubunId) {
        SelectQuery query = Database.query(EipTGpdbItem.class);
        query.setQualifier(ExpressionFactory.matchExp((String)"gpdbKubunId", (Object)kubunId));
        if (query.fetchList().isEmpty()) {
            return false;
        }
        List<GpdbKubunValueResultData> valList = GpdbUtils.getGpdbKubunValueList("" + kubunId);
        return valList.size() <= 1;
    }

    public ALStringField getGpdbKubunId() {
        return this.gpdb_kubun_id;
    }

    public ALStringField getGpdbKubunName() {
        return this.gpdb_kubun_name;
    }

    public String getWbrGpdbKubunName() {
        return ALCommonUtils.replaceToAutoCRString((String)this.gpdb_kubun_name.toString());
    }

    public ALStringField getGpdbKubunValue() {
        return this.gpdb_kubun_value;
    }

    public String getWbrGpdbKubunValue() {
        return ALCommonUtils.replaceToAutoCRString((String)this.gpdb_kubun_value.toString());
    }

    public boolean isNewKubun() {
        return this.is_new_kubun;
    }

    public List<EipMGpdbKubun> getGpdbKubunList() {
        return this.gpdb_kubun_list;
    }
}

