/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gpdb;

import com.aimluck.eip.cayenne.om.portlet.EipMGpdbKubun;
import com.aimluck.eip.cayenne.om.portlet.EipMGpdbKubunValue;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbItem;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.gpdb.GpdbKubunValueResultData;
import com.aimluck.eip.gpdb.util.GpdbUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GpdbKubunMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbKubunMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            EipMGpdbKubun Gpdbkubun;
            SelectQuery query = Database.query(EipMGpdbKubunValue.class);
            query.setQualifier(ExpressionFactory.inDbExp((String)"GPDB_KUBUN_VALUE_ID", values));
            List flist = query.fetchList();
            if (flist == null || flist.isEmpty()) {
                return false;
            }
            ArrayList<Integer> checkedKubunList = new ArrayList<Integer>();
            for (EipMGpdbKubunValue value : flist) {
                List<GpdbKubunValueResultData> valList;
                Gpdbkubun = GpdbUtils.getEipMGpdbKubun(value.getGpdbKubunId());
                int kubunCount = GpdbUtils.getRecordCountKubunUsed("" + value.getGpdbKubunValueId());
                if (kubunCount > 0) {
                    msgList.add("\u9078\u629e\u9805\u76ee \u300e" + Gpdbkubun.getGpdbKubunName() + "\u300f \u306e\u5024 \u300e" + value.getGpdbKubunValue() + "\u300f \u306f\u4f7f\u7528\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002");
                    continue;
                }
                int kubunId = value.getGpdbKubunId();
                if (checkedKubunList.contains(kubunId)) continue;
                SelectQuery valQuery = Database.query(EipTGpdbItem.class);
                valQuery.setQualifier(ExpressionFactory.matchExp((String)"gpdbKubunId", (Object)kubunId));
                if (!valQuery.fetchList().isEmpty() && (valList = GpdbUtils.getGpdbKubunValueList("" + kubunId)) != null && !valList.isEmpty()) {
                    msgList.add("\u9078\u629e\u9805\u76ee \u300e" + Gpdbkubun.getGpdbKubunName() + "\u300f \u306f\u9805\u76ee\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u3001\u5168\u3066\u306e\u5024\u306f\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002");
                }
                checkedKubunList.add(kubunId);
            }
            if (!msgList.isEmpty()) {
                return false;
            }
            for (EipMGpdbKubunValue value : flist) {
                Database.delete((Persistent)value);
                Database.commit();
                Gpdbkubun = GpdbUtils.getEipMGpdbKubun(value.getGpdbKubunId());
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(value.getGpdbKubunValueId().intValue(), 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u9078\u629e\u9805\u76ee\u300c" + Gpdbkubun.getGpdbKubunName() + "\u300d \u5024 \u300c" + value.getGpdbKubunValue() + "\u300d \u524a\u9664");
            }
            if (GpdbUtils.removeGpdbKubunNoValue()) {
                Database.commit();
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }
}

