/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gpdb;

import com.aimluck.eip.cayenne.om.portlet.EipTGpdb;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.gpdb.GpdbResultData;
import com.aimluck.eip.gpdb.util.GpdbUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GpdbSelectData
extends ALAbstractSelectData<EipTGpdb, EipTGpdb>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbSelectData.class.getName());
    private int gpdbSum;
    private List<GpdbResultData> gpdbAllList;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"sort");
        }
        this.gpdbAllList = GpdbUtils.getGpdbAllList();
        super.init(action, rundata, context);
    }

    protected ResultList<EipTGpdb> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipTGpdb> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.gpdbSum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTGpdb> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTGpdb.class);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected EipTGpdb selectDetail(RunData rundata, Context context) {
        return GpdbUtils.getEipTGpdb(rundata, context);
    }

    protected Object getResultData(EipTGpdb record) {
        return GpdbUtils.getGpdbResultData(record);
    }

    protected Object getResultDataDetail(EipTGpdb record) {
        return GpdbUtils.getGpdbResultData(record);
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("gpdb_name", "gpdbName");
        return map;
    }

    public int getGpdbSum() {
        return this.gpdbSum;
    }

    public List<GpdbResultData> getGpdbAllList() {
        return this.gpdbAllList;
    }

    public String getViewtype() {
        return "gpdb";
    }
}

