/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gpdb.util;

import com.aimluck.eip.cayenne.om.portlet.EipMGpdbKubun;
import com.aimluck.eip.cayenne.om.portlet.EipMGpdbKubunValue;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdb;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbItem;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbRecord;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbRecordFile;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.gpdb.GpdbItemResultData;
import com.aimluck.eip.gpdb.GpdbKubunResultData;
import com.aimluck.eip.gpdb.GpdbKubunValueResultData;
import com.aimluck.eip.gpdb.GpdbRecordResultData;
import com.aimluck.eip.gpdb.GpdbResultData;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.imageio.ImageIO;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.customlocalization.CustomLocalizationService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.util.RunData;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class GpdbUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbUtils.class.getName());
    public static final String ITEM_NAME_DEFAULT = "\u30bf\u30a4\u30c8\u30eb";
    public static final String ITEM_TYPE_TEXT = "01";
    public static final String ITEM_TYPE_TEXTAREA = "02";
    public static final String ITEM_TYPE_LINK = "03";
    public static final String ITEM_TYPE_SELECT = "04";
    public static final String ITEM_TYPE_SELECT_MULTI = "05";
    public static final String ITEM_TYPE_FILE = "06";
    public static final String ITEM_TYPE_IMAGE = "07";
    public static final String ITEM_TYPE_SEQ = "08";
    public static final String ITEM_TYPE_MAIL = "09";
    public static final String ITEM_TYPE_DATE = "10";
    public static final String ITEM_TYPE_CREATE_DATE = "11";
    public static final String ITEM_TYPE_UPDATE_DATE = "12";
    public static final String ITEM_TYPE_CREATE_USER = "13";
    public static final String ITEM_TYPE_UPDATE_USER = "14";
    public static final String ITEM_TYPE_TITLE_TEXT = "\u30c6\u30ad\u30b9\u30c8";
    public static final String ITEM_TYPE_TITLE_TEXTAREA = "\u30c6\u30ad\u30b9\u30c8\u30a8\u30ea\u30a2";
    public static final String ITEM_TYPE_TITLE_LINK = "\u30ea\u30f3\u30af";
    public static final String ITEM_TYPE_TITLE_SELECT = "\u9078\u629e\u5f0f\uff08\u629e\u4e00\uff09";
    public static final String ITEM_TYPE_TITLE_SELECT_MULTI = "\u9078\u629e\u5f0f\uff08\u8907\u6570\uff09";
    public static final String ITEM_TYPE_TITLE_FILE = "\u30d5\u30a1\u30a4\u30eb";
    public static final String ITEM_TYPE_TITLE_IMAGE = "\u753b\u50cf";
    public static final String ITEM_TYPE_TITLE_SEQ = "\u81ea\u52d5\u63a1\u756a";
    public static final String ITEM_TYPE_TITLE_MAIL = "\u30e1\u30fc\u30eb";
    public static final String ITEM_TYPE_TITLE_DATE = "\u65e5\u4ed8";
    public static final String ITEM_TYPE_TITLE_CREATE_DATE = "\u4f5c\u6210\u65e5";
    public static final String ITEM_TYPE_TITLE_UPDATE_DATE = "\u66f4\u65b0\u65e5\u6642";
    public static final String ITEM_TYPE_TITLE_CREATE_USER = "\u767b\u9332\u8005";
    public static final String ITEM_TYPE_TITLE_UPDATE_USER = "\u66f4\u65b0\u8005";
    public static final String ERRMSG_TITLE_ITEM_DELETE = "\u30bf\u30a4\u30c8\u30eb\u6307\u5b9a\u3055\u308c\u305f\u9805\u76ee\u306f\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002";
    public static final String ERRMSG_DB_DELETE = "\u30c7\u30fc\u30bf\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u3001\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002";
    public static final String SORT_STRING = "sort";
    public static final Map<String, String> ITEM_TYPE = Collections.unmodifiableMap(new LinkedHashMap<String, String>(){
        {
            this.put(GpdbUtils.ITEM_TYPE_TEXT, GpdbUtils.ITEM_TYPE_TITLE_TEXT);
            this.put(GpdbUtils.ITEM_TYPE_TEXTAREA, GpdbUtils.ITEM_TYPE_TITLE_TEXTAREA);
            this.put(GpdbUtils.ITEM_TYPE_LINK, GpdbUtils.ITEM_TYPE_TITLE_LINK);
            this.put(GpdbUtils.ITEM_TYPE_SELECT, GpdbUtils.ITEM_TYPE_TITLE_SELECT);
            this.put(GpdbUtils.ITEM_TYPE_SELECT_MULTI, GpdbUtils.ITEM_TYPE_TITLE_SELECT_MULTI);
            this.put(GpdbUtils.ITEM_TYPE_FILE, GpdbUtils.ITEM_TYPE_TITLE_FILE);
            this.put(GpdbUtils.ITEM_TYPE_IMAGE, GpdbUtils.ITEM_TYPE_TITLE_IMAGE);
            this.put(GpdbUtils.ITEM_TYPE_SEQ, GpdbUtils.ITEM_TYPE_TITLE_SEQ);
            this.put(GpdbUtils.ITEM_TYPE_MAIL, GpdbUtils.ITEM_TYPE_TITLE_MAIL);
            this.put(GpdbUtils.ITEM_TYPE_DATE, GpdbUtils.ITEM_TYPE_TITLE_DATE);
            this.put(GpdbUtils.ITEM_TYPE_CREATE_USER, GpdbUtils.ITEM_TYPE_TITLE_CREATE_USER);
            this.put(GpdbUtils.ITEM_TYPE_UPDATE_USER, GpdbUtils.ITEM_TYPE_TITLE_UPDATE_USER);
            this.put(GpdbUtils.ITEM_TYPE_CREATE_DATE, GpdbUtils.ITEM_TYPE_TITLE_CREATE_DATE);
            this.put(GpdbUtils.ITEM_TYPE_UPDATE_DATE, GpdbUtils.ITEM_TYPE_TITLE_UPDATE_DATE);
        }
    });
    public static final List<String> DISP_FIELD_SELECT_ITEM = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add(GpdbUtils.ITEM_TYPE_SELECT);
            this.add(GpdbUtils.ITEM_TYPE_SELECT_MULTI);
        }
    });
    public static final List<String> DISP_FIELD_SIZE_COL = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add(GpdbUtils.ITEM_TYPE_TEXT);
            this.add(GpdbUtils.ITEM_TYPE_TEXTAREA);
            this.add(GpdbUtils.ITEM_TYPE_LINK);
            this.add(GpdbUtils.ITEM_TYPE_MAIL);
        }
    });
    public static final List<String> DISP_FIELD_SIZE_ROW = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add(GpdbUtils.ITEM_TYPE_TEXTAREA);
        }
    });
    public static final List<String> DISP_FIELD_LINE = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add(GpdbUtils.ITEM_TYPE_SELECT_MULTI);
        }
    });
    public static final List<String> DISP_FIELD_REQUIRED = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add(GpdbUtils.ITEM_TYPE_TEXT);
            this.add(GpdbUtils.ITEM_TYPE_TEXTAREA);
            this.add(GpdbUtils.ITEM_TYPE_LINK);
            this.add(GpdbUtils.ITEM_TYPE_SELECT);
            this.add(GpdbUtils.ITEM_TYPE_SELECT_MULTI);
            this.add(GpdbUtils.ITEM_TYPE_FILE);
            this.add(GpdbUtils.ITEM_TYPE_IMAGE);
            this.add(GpdbUtils.ITEM_TYPE_MAIL);
            this.add(GpdbUtils.ITEM_TYPE_DATE);
        }
    });
    public static final Map<String, List<String>> ITEM_FIELD = Collections.unmodifiableMap(new TreeMap<String, List<String>>(){
        {
            this.put("select_kubun", DISP_FIELD_SELECT_ITEM);
            this.put("size_col", DISP_FIELD_SIZE_COL);
            this.put("size_row", DISP_FIELD_SIZE_ROW);
            this.put("line", DISP_FIELD_LINE);
            this.put("required", DISP_FIELD_REQUIRED);
        }
    });
    public static final String FLG_ON = "t";
    public static final String FLG_OFF = "f";
    public static final int SIZE_COL_DEFAULT = 300;
    public static final String KUBUN_VALUE_SEPARATOR = "|";
    public static final String KUBUN_VALUE_DISP_SEPARATOR = "\u3001";
    private static final String FOLDER_FILEDIR_GPDB = JetspeedResources.getString((String)"aipo.filedir", (String)"");
    protected static final String CATEGORY_KEY = JetspeedResources.getString((String)"aipo.gpdb.categorykey", (String)"");
    public static final String FILE_ENCODING = JetspeedResources.getString((String)"content.defaultencoding", (String)"UTF-8");
    public static final String GPDB_PORTLET_NAME = "Gpdb";

    public static String getItemTypeName(String type) {
        return ITEM_TYPE.get(type);
    }

    public static EipTGpdb getEipTGpdb(RunData rundata, Context context) {
        String gpdbid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        return GpdbUtils.getEipTGpdb(gpdbid);
    }

    public static EipTGpdb getEipTGpdb(String gpdbId) {
        try {
            if (gpdbId == null || Integer.valueOf(gpdbId) == null) {
                logger.debug((Object)"[GpdbUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTGpdb.class);
            query.setQualifier(ExpressionFactory.matchDbExp((String)"GPDB_ID", (Object)gpdbId));
            List gpdbList = query.fetchList();
            if (gpdbList == null || gpdbList.isEmpty()) {
                logger.debug((Object)"[GpdbUtils] Not found ID...");
                return null;
            }
            return (EipTGpdb)gpdbList.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List<GpdbResultData> getGpdbAllList() {
        ArrayList<GpdbResultData> gpdbAllList = new ArrayList<GpdbResultData>();
        try {
            List gpdbList = Database.query(EipTGpdb.class).orderAscending("gpdbName").fetchList();
            for (EipTGpdb gpdb : gpdbList) {
                GpdbResultData data = new GpdbResultData();
                data.initField();
                data.setGpdbId(gpdb.getGpdbId().intValue());
                data.setGpdbName(gpdb.getGpdbName());
                gpdbAllList.add(data);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return gpdbAllList;
    }

    public static GpdbResultData getGpdbResultData(EipTGpdb model) {
        TurbineUser user = model.getTurbineUser();
        GpdbResultData data = new GpdbResultData();
        data.initField();
        data.setGpdbId(model.getGpdbId().intValue());
        data.setGpdbName(model.getGpdbName());
        data.setMailFlg(model.getMailFlg());
        data.setCreateUserName(new StringBuffer().append(user.getLastName()).append(" ").append(user.getFirstName()).toString());
        data.setCreateDate(model.getCreateDate());
        data.setUpdateDate(model.getUpdateDate());
        data.setRecordCnt(GpdbUtils.getRecordCount("" + model.getGpdbId()));
        return data;
    }

    public static EipTGpdbItem getEipTGpdbItem(RunData rundata, Context context) {
        String gpdbItemId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        return GpdbUtils.getEipTGpdbItem(gpdbItemId);
    }

    public static EipTGpdbItem getEipTGpdbItem(String gpdbItemId) {
        try {
            if (gpdbItemId == null) {
                logger.debug((Object)"[GpdbUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTGpdbItem.class);
            query.setQualifier(ExpressionFactory.matchDbExp((String)"GPDB_ITEM_ID", (Object)gpdbItemId));
            List gpdbItemList = query.fetchList();
            if (gpdbItemList == null || gpdbItemList.isEmpty()) {
                logger.debug((Object)"[GpdbUtils] Not found ID...");
                return null;
            }
            return (EipTGpdbItem)gpdbItemList.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List<GpdbItemResultData> getGpdbItemResultList(List<EipTGpdbItem> gpdbItemList) {
        ArrayList<GpdbItemResultData> resultList = new ArrayList<GpdbItemResultData>();
        for (EipTGpdbItem gpdbItem : gpdbItemList) {
            resultList.add(GpdbUtils.getGpdbItemResultData(gpdbItem));
        }
        return resultList;
    }

    public static GpdbItemResultData getGpdbItemResultData(EipTGpdbItem gpdbItem) {
        Integer line;
        Integer sizeRow;
        Integer sizeCol;
        GpdbItemResultData data = new GpdbItemResultData();
        data.initField();
        data.setGpdbItemId(gpdbItem.getGpdbItemId().intValue());
        data.setGpdbItemName(gpdbItem.getGpdbItemName());
        data.setGpdbId(gpdbItem.getGpdb().getGpdbId().intValue());
        data.setGpdbName(gpdbItem.getGpdb().getGpdbName());
        data.setTitleFlg(gpdbItem.getTitleFlg());
        data.setRequiredFlg(gpdbItem.getRequiredFlg());
        data.setType(gpdbItem.getType());
        data.setTypeName(ITEM_TYPE.get(gpdbItem.getType()));
        data.setListFlg(gpdbItem.getListFlg());
        data.setDetailFlg(gpdbItem.getDetailFlg());
        data.setDefaultSortFlg(gpdbItem.getDefaultSortFlg());
        data.setAscDesc(gpdbItem.getAscDesc());
        EipMGpdbKubun kubun = GpdbUtils.getEipMGpdbKubun(gpdbItem.getGpdbKubunId());
        if (kubun != null) {
            data.setGpdbKubunId(kubun.getGpdbKubunId().intValue());
            data.setGpdbKubunName(kubun.getGpdbKubunName());
        }
        if ((sizeCol = gpdbItem.getSizeCol()) != null) {
            data.setSizeCol(sizeCol.intValue());
        }
        if ((sizeRow = gpdbItem.getSizeRow()) != null) {
            data.setSizeRow(sizeRow.intValue());
        }
        if ((line = gpdbItem.getLine()) != null) {
            data.setLine(line.intValue());
        }
        return data;
    }

    public static List<GpdbItemResultData> getGpdbItemResultList(String gpdbId) {
        SelectQuery query = Database.query(EipTGpdbItem.class);
        query.setQualifier(ExpressionFactory.matchDbExp((String)"gpdb", (Object)gpdbId));
        query.orderAscending("orderNo");
        List<GpdbItemResultData> gpdbItemList = GpdbUtils.getGpdbItemResultList(query.fetchList());
        if (gpdbItemList.isEmpty()) {
            logger.debug((Object)"[GpdbUtils] Not found ID...");
            return null;
        }
        return gpdbItemList;
    }

    public static List<EipTGpdbRecord> getEipTGpdbRecord(String gpdbId) {
        return GpdbUtils.getEipTGpdbRecord(gpdbId, null);
    }

    public static List<EipTGpdbRecord> getEipTGpdbRecordTitle(String gpdbId) {
        return GpdbUtils.getEipTGpdbRecord(gpdbId, null, true);
    }

    public static List<EipTGpdbRecord> getEipTGpdbRecord(String gpdbId, String recordNo) {
        return GpdbUtils.getEipTGpdbRecord(gpdbId, recordNo, false);
    }

    public static List<EipTGpdbRecord> getEipTGpdbRecord(String gpdbId, String recordNo, boolean titleOnly) {
        try {
            List gpdbRecordList;
            if (gpdbId == null) {
                logger.debug((Object)"[GpdbUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTGpdbRecord.class);
            query.setQualifier(ExpressionFactory.matchDbExp((String)"gpdb", (Object)gpdbId));
            if (recordNo != null) {
                query.andQualifier(ExpressionFactory.matchExp((String)"recordNo", (Object)recordNo));
            }
            if (titleOnly) {
                SelectQuery titleQuery = Database.query(EipTGpdbItem.class);
                titleQuery.setQualifier(ExpressionFactory.matchDbExp((String)"gpdb", (Object)gpdbId));
                titleQuery.andQualifier(ExpressionFactory.matchExp((String)"titleFlg", (Object)FLG_ON));
                query.andQualifier(ExpressionFactory.matchExp((String)"gpdbItem", (Object)titleQuery.fetchSingle()));
            }
            if ((gpdbRecordList = query.fetchList()) == null || gpdbRecordList.isEmpty()) {
                logger.debug((Object)"[GpdbUtils] Not found ID...");
                return null;
            }
            return gpdbRecordList;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTGpdbRecord getEipTGpdbRecord(String gpdbId, String recordNo, String itemId) {
        try {
            if (gpdbId == null || recordNo == null) {
                logger.debug((Object)"[GpdbUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTGpdbRecord.class);
            query.setQualifier(ExpressionFactory.matchDbExp((String)"gpdb", (Object)gpdbId));
            query.andQualifier(ExpressionFactory.matchExp((String)"recordNo", (Object)recordNo));
            query.andQualifier(ExpressionFactory.matchExp((String)"gpdbItem", (Object)itemId));
            EipTGpdbRecord gpdbRecord = (EipTGpdbRecord)query.fetchSingle();
            if (gpdbRecord == null) {
                logger.debug((Object)"[GpdbUtils] Not found ID...");
                return null;
            }
            return gpdbRecord;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static GpdbRecordResultData getGpdbRecordResultData(EipTGpdbRecord model) {
        try {
            String value = model.getValue();
            ArrayList<String> valueList = new ArrayList<String>();
            if (value != null) {
                EipTGpdbItem item = GpdbUtils.getEipTGpdbItem("" + model.getGpdbItemId());
                String type = item.getType();
                if (ITEM_TYPE_SELECT.equals(type) || ITEM_TYPE_SELECT_MULTI.equals(type)) {
                    String[] list = value.split("\\|");
                    StringBuilder sbVal = new StringBuilder();
                    for (int i = 0; i < list.length; ++i) {
                        EipMGpdbKubunValue kubunValue;
                        if (i > 0) {
                            sbVal.append(KUBUN_VALUE_DISP_SEPARATOR);
                        }
                        if ((kubunValue = GpdbUtils.getEipMGpdbKubunValue(list[i])) != null) {
                            sbVal.append(kubunValue.getGpdbKubunValue());
                        }
                        valueList.add(list[i]);
                    }
                    value = String.valueOf(sbVal);
                } else if (ITEM_TYPE_FILE.equals(type) || ITEM_TYPE_IMAGE.equals(type)) {
                    value = value.replace(KUBUN_VALUE_SEPARATOR, KUBUN_VALUE_DISP_SEPARATOR);
                } else if (ITEM_TYPE_CREATE_USER.equals(type) || ITEM_TYPE_UPDATE_USER.equals(type)) {
                    if (!"".equals(value.trim())) {
                        Integer userid = Integer.valueOf(value);
                        value = ALEipUtils.getALEipUser((int)userid).getAliasName().getValue();
                    }
                } else if (ITEM_TYPE_DATE.equals(type)) {
                    SimpleDateFormat sdf_data = new SimpleDateFormat(ALLocalizationUtils.getl10n((String)"GPDB_DATE_FORMAT_DATA"));
                    SimpleDateFormat sdf_show = new SimpleDateFormat(ALLocalizationUtils.getl10n((String)"GPDB_DATE_FORMAT_SHOW"));
                    String tmpValue = value;
                    try {
                        Date date = sdf_data.parse(value);
                        value = sdf_show.format(date);
                    }
                    catch (Exception e) {
                        value = tmpValue;
                    }
                } else if (ITEM_TYPE_CREATE_DATE.equals(type) || ITEM_TYPE_UPDATE_DATE.equals(type)) {
                    SimpleDateFormat sdf_data = new SimpleDateFormat(ALLocalizationUtils.getl10n((String)"GPDB_TIMESTAMP_FORMAT_DATA"));
                    SimpleDateFormat sdf_show = new SimpleDateFormat(ALLocalizationUtils.getl10n((String)"GPDB_TIMESTAMP_FORMAT_SHOW"));
                    String tmpValue = value;
                    try {
                        Date date = sdf_data.parse(value);
                        value = sdf_show.format(date);
                    }
                    catch (Exception e) {
                        value = tmpValue;
                    }
                }
            }
            GpdbRecordResultData rd = new GpdbRecordResultData();
            rd.initField();
            rd.setGpdbItemId(model.getGpdbItemId().intValue());
            rd.setGpdbRecordId(model.getGpdbRecordId().intValue());
            rd.setRecordNo(model.getRecordNo().intValue());
            rd.setValue(model.getValue());
            rd.setDispValue(value);
            rd.setValueList(valueList);
            return rd;
        }
        catch (RuntimeException ex) {
            logger.error((Object)"RuntimeException", (Throwable)ex);
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static Map<String, GpdbRecordResultData> getGpdbRecordMap(String gpdbId, String recordNo) throws ALPageNotFoundException {
        HashMap<String, GpdbRecordResultData> map = new HashMap<String, GpdbRecordResultData>();
        List<EipTGpdbRecord> recordList = GpdbUtils.getEipTGpdbRecord(gpdbId, recordNo);
        if (recordList == null || recordList.size() == 0) {
            logger.error((Object)"[GpdbUtils] Not found record.");
            throw new ALPageNotFoundException();
        }
        ArrayList<GpdbRecordResultData> list = new ArrayList<GpdbRecordResultData>();
        for (EipTGpdbRecord rec : recordList) {
            list.add(GpdbUtils.getGpdbRecordResultData(rec));
        }
        for (GpdbRecordResultData data : list) {
            map.put("" + data.getGpdbItemId(), data);
        }
        return map;
    }

    public static int getRecordCount(String gpdbId) {
        int cnt = 0;
        try {
            String sql = "SELECT COUNT(0) AS data_cnt FROM (   SELECT record_no FROM eip_t_gpdb_record   WHERE gpdb_id = #bind($gpdb_id)   GROUP BY record_no) a";
            SQLTemplate sqltemp = Database.sql(EipTGpdbRecord.class, (String)String.valueOf(sql));
            sqltemp.param("gpdb_id", (Object)Integer.valueOf(gpdbId));
            List result = sqltemp.fetchListAsDataRow();
            if (result == null || result.isEmpty()) {
                return 0;
            }
            cnt = Integer.valueOf(((DataRow)result.get(0)).get((Object)"data_cnt").toString());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return 0;
        }
        return cnt;
    }

    public static int getRecordCountKubunUsed(String gpdbKubunValueId) {
        int cnt = 0;
        try {
            String sql = "";
            if (Database.isJdbcMySQL()) {
                sql = "SELECT COUNT(0) AS data_cnt FROM eip_t_gpdb_record r   INNER JOIN eip_t_gpdb_item i     ON i.gpdb_item_id = r.gpdb_item_id   WHERE i.type IN (#bind($type1), #bind($type2))   AND r.value REGEXP #bind($gpdb_kubun_value_id)";
            } else if (Database.isJdbcPostgreSQL()) {
                sql = "SELECT COUNT(0) AS data_cnt FROM eip_t_gpdb_record r   INNER JOIN eip_t_gpdb_item i     ON i.gpdb_item_id = r.gpdb_item_id   WHERE i.type IN (#bind($type1), #bind($type2))   AND r.value ~ #bind($gpdb_kubun_value_id)";
            }
            SQLTemplate sqltemp = Database.sql(EipTGpdbRecord.class, (String)String.valueOf(sql));
            sqltemp.param("type1", (Object)ITEM_TYPE_SELECT);
            sqltemp.param("type2", (Object)ITEM_TYPE_SELECT_MULTI);
            if (Database.isJdbcMySQL()) {
                sqltemp.param("gpdb_kubun_value_id", (Object)("(^|\\|)" + gpdbKubunValueId + "(\\||$)"));
            } else if (Database.isJdbcPostgreSQL()) {
                sqltemp.param("gpdb_kubun_value_id", (Object)("(?:^|\\||)" + gpdbKubunValueId + "(?:\\||$)"));
            }
            List result = sqltemp.fetchListAsDataRow();
            if (result == null || result.isEmpty()) {
                return 0;
            }
            cnt = Integer.valueOf(((DataRow)result.get(0)).get((Object)"data_cnt").toString());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return 0;
        }
        return cnt;
    }

    public static EipMGpdbKubun getEipMGpdbKubun(RunData rundata, Context context) {
        String gpdbKubunId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (gpdbKubunId == null) {
                logger.debug((Object)"[GpdbUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipMGpdbKubun.class);
            query.setQualifier(ExpressionFactory.matchDbExp((String)"GPDB_KUBUN_ID", (Object)gpdbKubunId));
            List kubunList = query.fetchList();
            if (kubunList == null || kubunList.isEmpty()) {
                logger.debug((Object)"[GpdbUtils] Not found ID...");
                return null;
            }
            return (EipMGpdbKubun)kubunList.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipMGpdbKubun getEipMGpdbKubun(Integer gpdbKubunId) {
        try {
            if (gpdbKubunId == null) {
                return null;
            }
            SelectQuery query = Database.query(EipMGpdbKubun.class);
            query.setQualifier(ExpressionFactory.matchDbExp((String)"GPDB_KUBUN_ID", (Object)gpdbKubunId));
            List kubunList = query.fetchList();
            if (kubunList == null || kubunList.isEmpty()) {
                logger.debug((Object)"[GpdbUtils] Not found ID...");
                return null;
            }
            return (EipMGpdbKubun)kubunList.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipMGpdbKubunValue getEipMGpdbKubunValue(RunData rundata, Context context) {
        String gpdbKubunValueId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        return GpdbUtils.getEipMGpdbKubunValue(gpdbKubunValueId);
    }

    public static EipMGpdbKubunValue getEipMGpdbKubunValue(String gpdbKubunValueId) {
        try {
            if (gpdbKubunValueId == null || gpdbKubunValueId.isEmpty()) {
                logger.debug((Object)"[GpdbUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipMGpdbKubunValue.class);
            query.setQualifier(ExpressionFactory.matchDbExp((String)"GPDB_KUBUN_VALUE_ID", (Object)gpdbKubunValueId));
            List kubunValueList = query.fetchList();
            if (kubunValueList == null || kubunValueList.isEmpty()) {
                logger.debug((Object)"[GpdbUtils] Not found ID...");
                return null;
            }
            return (EipMGpdbKubunValue)kubunValueList.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List<GpdbKubunResultData> getGpdbKubunAllList() {
        ArrayList<GpdbKubunResultData> kubunAllList = new ArrayList<GpdbKubunResultData>();
        try {
            List kubunList = Database.query(EipMGpdbKubun.class).orderAscending("gpdbKubunName").fetchList();
            for (EipMGpdbKubun kubun : kubunList) {
                GpdbKubunResultData data = new GpdbKubunResultData();
                data.initField();
                data.setGpdbKubunId(kubun.getGpdbKubunId().intValue());
                data.setGpdbKubunName(kubun.getGpdbKubunName());
                kubunAllList.add(data);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return kubunAllList;
    }

    public static List<GpdbKubunValueResultData> getGpdbKubunValueList(String gpdbKubunId) {
        ArrayList<GpdbKubunValueResultData> kubunValueResultList = new ArrayList<GpdbKubunValueResultData>();
        try {
            SelectQuery query = Database.query(EipMGpdbKubunValue.class);
            query.orderAscending("gpdbKubun");
            query.orderAscending("orderNo");
            if (gpdbKubunId != null) {
                query.setQualifier(ExpressionFactory.matchDbExp((String)"gpdbKubun", (Object)gpdbKubunId));
            }
            List kubunValueList = query.fetchList();
            for (EipMGpdbKubunValue kubunValue : kubunValueList) {
                GpdbKubunValueResultData data = new GpdbKubunValueResultData();
                data.initField();
                data.setGpdbKubunValueId(kubunValue.getGpdbKubunValueId().intValue());
                data.setGpdbKubunValue(kubunValue.getGpdbKubunValue());
                data.setGpdbKubunId(kubunValue.getGpdbKubun().getGpdbKubunId().intValue());
                data.setGpdbKubunName(kubunValue.getGpdbKubun().getGpdbKubunName());
                kubunValueResultList.add(data);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return kubunValueResultList;
    }

    public static List<GpdbKubunValueResultData> getGpdbKubunValueAllList() {
        return GpdbUtils.getGpdbKubunValueList(null);
    }

    public static Map<String, List<GpdbKubunValueResultData>> getKubunMap() {
        HashMap<String, List<GpdbKubunValueResultData>> map = new HashMap<String, List<GpdbKubunValueResultData>>();
        List<GpdbKubunValueResultData> allList = GpdbUtils.getGpdbKubunValueAllList();
        ArrayList<GpdbKubunValueResultData> list = null;
        String compareKubunId = null;
        for (GpdbKubunValueResultData data : allList) {
            String kubunId = data.getGpdbKubunId().toString();
            if (!kubunId.equals(compareKubunId)) {
                list = new ArrayList<GpdbKubunValueResultData>();
                map.put(kubunId, list);
            }
            list.add(data);
            compareKubunId = kubunId;
        }
        return map;
    }

    public static List<GpdbKubunValueResultData> getGpdbKubunValueResultList(List<EipMGpdbKubunValue> gpdbKubunValueList) {
        ArrayList<GpdbKubunValueResultData> resultList = new ArrayList<GpdbKubunValueResultData>();
        for (EipMGpdbKubunValue gpdbKubunValue : gpdbKubunValueList) {
            resultList.add(GpdbUtils.getGpdbKubunValueResultData(gpdbKubunValue));
        }
        return resultList;
    }

    public static GpdbKubunValueResultData getGpdbKubunValueResultData(EipMGpdbKubunValue model) {
        GpdbKubunValueResultData data = new GpdbKubunValueResultData();
        data.initField();
        data.setGpdbKubunValueId(model.getGpdbKubunValueId().intValue());
        data.setGpdbKubunName(model.getGpdbKubun().getGpdbKubunName());
        data.setGpdbKubunValue(model.getGpdbKubunValue());
        return data;
    }

    public static boolean removeGpdbItem(EipTGpdb gpdb) {
        try {
            SelectQuery query = Database.query(EipTGpdbItem.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"gpdb", (Object)gpdb.getGpdbId()));
            List gpdbItemList = query.fetchList();
            if (gpdbItemList == null || gpdbItemList.isEmpty()) {
                return true;
            }
            Database.deleteAll((List)gpdbItemList);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static boolean removeGpdbRecord(RunData rundata, EipTGpdbItem gpdbItem) {
        try {
            SelectQuery query = Database.query(EipTGpdbRecord.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"gpdbItem", (Object)gpdbItem.getGpdbItemId()));
            List gpdbRecordList = query.fetchList();
            if (gpdbRecordList == null || gpdbRecordList.isEmpty()) {
                return true;
            }
            Database.deleteAll((List)gpdbRecordList);
            GpdbUtils.removeGpdbRecordFile(rundata, gpdbRecordList);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static boolean removeGpdbRecordFile(RunData rundata, List<EipTGpdbRecord> gpdbRecordList) {
        try {
            ArrayList<String> fpaths = new ArrayList<String>();
            ArrayList<Integer> fownerIds = new ArrayList<Integer>();
            if (gpdbRecordList != null) {
                for (EipTGpdbRecord record : gpdbRecordList) {
                    List<EipTGpdbRecordFile> fileList = GpdbUtils.getEipTGpdbRecordFileList(record.getGpdbRecordId());
                    Database.deleteAll(fileList);
                    for (EipTGpdbRecordFile file : fileList) {
                        if (file.getFilePath() == null || file.getOwnerId() == null) continue;
                        fpaths.add(file.getFilePath());
                        fownerIds.add(file.getOwnerId());
                    }
                }
            }
            if (!fpaths.isEmpty()) {
                int fsize = fpaths.size();
                for (int i = 0; i < fsize; ++i) {
                    ALStorageService.deleteFile((String)(GpdbUtils.getSaveDirPath((Integer)fownerIds.get(i)) + (String)fpaths.get(i)));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static boolean removeGpdbKubunNoValue() {
        try {
            String sql = "SELECT * FROM eip_m_gpdb_kubun a WHERE NOT EXISTS(   SELECT 0 FROM eip_m_gpdb_kubun_value b   WHERE a.gpdb_kubun_id = b.gpdb_kubun_id)";
            List kubunList = Database.sql(EipMGpdbKubun.class, (String)sql).fetchList();
            if (kubunList == null || kubunList.isEmpty()) {
                return true;
            }
            for (EipMGpdbKubun kubun : kubunList) {
                DataContext.getThreadDataContext().registerNewObject((DataObject)kubun);
                kubun.setPersistenceState(3);
            }
            Database.deleteAll((List)kubunList);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static boolean gpdbItemTitleOff(EipTGpdb gpdb) {
        SelectQuery query = Database.query(EipTGpdbItem.class);
        query.setQualifier(ExpressionFactory.matchExp((String)"gpdb", (Object)gpdb));
        query.andQualifier(ExpressionFactory.matchExp((String)"titleFlg", (Object)FLG_ON));
        EipTGpdbItem titleItem = (EipTGpdbItem)query.fetchSingle();
        if (titleItem == null) {
            return true;
        }
        titleItem.setTitleFlg(FLG_OFF);
        return true;
    }

    public static boolean gpdbItemDefaultSortOff(EipTGpdb gpdb) {
        SelectQuery query = Database.query(EipTGpdbItem.class);
        query.setQualifier(ExpressionFactory.matchExp((String)"gpdb", (Object)gpdb));
        query.andQualifier(ExpressionFactory.matchExp((String)"defaultSortFlg", (Object)FLG_ON));
        EipTGpdbItem titleItem = (EipTGpdbItem)query.fetchSingle();
        if (titleItem == null) {
            return true;
        }
        titleItem.setDefaultSortFlg(FLG_OFF);
        titleItem.setAscDesc("");
        return true;
    }

    public static String convertEncording(String str) {
        try {
            String replace = new String(str.getBytes("8859_1"), "UTF-8");
            if (replace != null && replace.matches("^\\?+$")) {
                return str;
            }
            return replace;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getParamValueString(RunData rundata, String field) {
        String[] param = rundata.getParameters().getStrings(field);
        if (param == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < param.length; ++i) {
            param[i] = GpdbUtils.convertEncording(param[i]);
            if (param[i] == null || "".equals(param[i].trim())) continue;
            list.add(param[i]);
        }
        return StringUtils.join((Object[])list.toArray(), (String)KUBUN_VALUE_SEPARATOR);
    }

    public static boolean dipslayField(String field, String type) {
        if (type == null || "".equals(type.trim())) {
            type = ITEM_TYPE_TEXT;
        }
        if (!ITEM_FIELD.containsKey(field)) {
            return false;
        }
        List<String> list = ITEM_FIELD.get(field);
        return list.contains(type);
    }

    public static boolean isUrl(String str) {
        Pattern mailPattern = Pattern.compile("^(https?|ftp)(:\\/\\/[-_.!~*\\'()a-zA-Z0-9;\\/?:\\@&=+\\$,%#]+)$", 2);
        Matcher objMch = mailPattern.matcher(str);
        return objMch.matches();
    }

    public static boolean sendMail(RunData rundata, ALEipUser destUser, EipTGpdb gpdb, String gpdbItemName, String dispValue) throws Exception {
        String orgId = Database.getDomainName();
        String subject = "[" + ALOrgUtilsService.getAlias() + "]Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9";
        try {
            ArrayList<ALEipUser> memberList = new ArrayList<ALEipUser>();
            memberList.add(destUser);
            List destMemberList = ALMailUtils.getALEipUserAddrs(memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
            ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
            for (ALEipUserAddr destMember : destMemberList) {
                ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                message.setPcSubject(subject);
                message.setCellularSubject(subject);
                message.setPcBody(GpdbUtils.createMsgForPc(rundata, gpdb, gpdbItemName, dispValue, true));
                message.setCellularBody(GpdbUtils.createMsgForCellPhone(rundata, gpdb, gpdbItemName, dispValue, true));
                messageList.add(message);
            }
            ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)23)));
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static String createMsgForPc(RunData rundata, EipTGpdb gpdb, String gpdbItemName, String dispValue, Boolean isNew) throws ALDBErrorException {
        VelocityContext context = new VelocityContext();
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        ALEipUser loginUser = null;
        ALBaseUser user = null;
        try {
            loginUser = ALEipUtils.getALEipUser((RunData)rundata);
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(loginUser.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        context.put("loginUser", (Object)loginUser.getAliasName().toString());
        context.put("hasEmail", (Object)(!user.getEmail().equals("") ? 1 : 0));
        context.put("email", (Object)user.getEmail());
        context.put("isNew", (Object)isNew);
        context.put("GpdbName", (Object)gpdb.getGpdbName());
        context.put("GpdbItemName", (Object)gpdbItemName);
        context.put("DispValue", (Object)dispValue);
        context.put("serviceAlias", (Object)ALOrgUtilsService.getAlias());
        context.put("enableAsp", (Object)enableAsp);
        context.put("globalurl", (Object)ALMailUtils.getGlobalurl());
        context.put("localurl", (Object)ALMailUtils.getLocalurl());
        CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService");
        String lang = locService.getLocale(rundata).getLanguage();
        StringWriter writer = new StringWriter();
        try {
            Template template;
            if (lang != null && lang.equals("ja")) {
                template = Velocity.getTemplate((String)("portlets/mail/" + lang + "/gpdb-notification-mail.vm"), (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            } else {
                template = Velocity.getTemplate((String)"portlets/mail/gpdb-notification-mail.vm", (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        writer.flush();
        String ret = writer.getBuffer().toString();
        return ret;
    }

    public static String createMsgForCellPhone(RunData rundata, EipTGpdb gpdb, String gpdbItemName, String dispValue, Boolean isNew) throws ALDBErrorException {
        return GpdbUtils.createMsgForPc(rundata, gpdb, gpdbItemName, dispValue, isNew);
    }

    public static boolean insertFileDataDelegate(RunData rundata, Context context, EipTGpdbRecord record, List<FileuploadLiteBean> fileuploadList, String folderName, List<String> msgList) {
        if (fileuploadList == null || fileuploadList.size() <= 0) {
            fileuploadList = new ArrayList<FileuploadLiteBean>();
        }
        int uid = ALEipUtils.getUserId((RunData)rundata);
        String orgId = Database.getDomainName();
        ArrayList<Integer> hadfileids = new ArrayList<Integer>();
        for (FileuploadLiteBean file : fileuploadList) {
            if (file.isNewFile()) continue;
            hadfileids.add(file.getFileId());
        }
        SelectQuery dbquery = Database.query(EipTGpdbRecordFile.class);
        dbquery.andQualifier(ExpressionFactory.matchDbExp((String)"eipTGpdbRecord", (Object)record.getGpdbRecordId()));
        List existsFiles = dbquery.fetchList();
        ArrayList<EipTGpdbRecordFile> delFiles = new ArrayList<EipTGpdbRecordFile>();
        for (EipTGpdbRecordFile file : existsFiles) {
            if (hadfileids.contains(file.getFileId())) continue;
            delFiles.add(file);
        }
        if (delFiles.size() > 0) {
            int delsize = delFiles.size();
            for (int i = 0; i < delsize; ++i) {
                ALStorageService.deleteFile((String)(GpdbUtils.getSaveDirPath(((EipTGpdbRecordFile)delFiles.get(i)).getOwnerId()) + ((EipTGpdbRecordFile)delFiles.get(i)).getFilePath()));
            }
            Database.deleteAll(delFiles);
        }
        try {
            for (FileuploadLiteBean filebean : fileuploadList) {
                if (!filebean.isNewFile()) continue;
                String[] acceptExts = ImageIO.getWriterFormatNames();
                FileuploadUtils.ShrinkImageSet shrinkImageSet = FileuploadUtils.getBytesShrinkFilebean((String)orgId, (String)folderName, (int)uid, (FileuploadLiteBean)filebean, (String[])acceptExts, (int)86, (int)86, msgList, (boolean)true);
                String filename = "0_" + String.valueOf(System.nanoTime());
                EipTGpdbRecordFile file = (EipTGpdbRecordFile)Database.create(EipTGpdbRecordFile.class);
                file.setOwnerId(Integer.valueOf(uid));
                file.setEipTGpdbRecord(record);
                file.setFileName(filebean.getFileName());
                file.setFilePath(GpdbUtils.getRelativePath(filename));
                if (shrinkImageSet != null && shrinkImageSet.getShrinkImage() != null) {
                    file.setFileThumbnail(shrinkImageSet.getShrinkImage());
                }
                file.setCreateDate(Calendar.getInstance().getTime());
                file.setUpdateDate(Calendar.getInstance().getTime());
                if (shrinkImageSet != null && shrinkImageSet.getFixImage() != null) {
                    ALStorageService.createNewFile((InputStream)new ByteArrayInputStream(shrinkImageSet.getFixImage()), (String)(FOLDER_FILEDIR_GPDB + ALStorageService.separator() + Database.getDomainName() + ALStorageService.separator() + CATEGORY_KEY + ALStorageService.separator() + uid + ALStorageService.separator() + filename));
                    continue;
                }
                ALStorageService.copyTmpFile((int)uid, (String)folderName, (String)String.valueOf(filebean.getFileId()), (String)FOLDER_FILEDIR_GPDB, (String)(CATEGORY_KEY + ALStorageService.separator() + uid), (String)filename);
            }
            if (folderName != null && !"".equals(folderName.trim())) {
                ALStorageService.deleteTmpFolder((int)uid, (String)folderName);
            }
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getSaveDirPath(int uid) {
        return ALStorageService.getDocumentPath((String)FOLDER_FILEDIR_GPDB, (String)(CATEGORY_KEY + ALStorageService.separator() + uid));
    }

    public static String getRelativePath(String fileName) {
        return new StringBuffer().append("/").append(fileName).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FileuploadLiteBean> getFileuploadList(RunData rundata, String keyid) {
        int fileid;
        String[] fileids = rundata.getParameters().getStrings("attachments_" + keyid);
        if (fileids == null) {
            return null;
        }
        ArrayList<String> hadfileids = new ArrayList<String>();
        ArrayList<String> newfileids = new ArrayList<String>();
        for (int j = 0; j < fileids.length; ++j) {
            if (fileids[j].trim().startsWith("s")) {
                hadfileids.add(fileids[j].trim().substring(1));
                continue;
            }
            newfileids.add(fileids[j].trim());
        }
        ArrayList<FileuploadLiteBean> fileNameList = new ArrayList<FileuploadLiteBean>();
        FileuploadBean filebean = null;
        if (newfileids.size() > 0) {
            String folderName = rundata.getParameters().getString("folderName_" + keyid);
            if (folderName == null || folderName.equals("")) {
                return null;
            }
            for (String newfileid : newfileids) {
                if ("".equals(newfileid)) continue;
                fileid = 0;
                try {
                    fileid = Integer.parseInt(newfileid);
                }
                catch (Exception e) {
                    continue;
                }
                if (fileid == 0) {
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName("photo");
                    filebean.setFileName("\u4ee5\u524d\u306e\u5199\u771f\u30d5\u30a1\u30a4\u30eb");
                    fileNameList.add((FileuploadLiteBean)filebean);
                    continue;
                }
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(ALStorageService.getFile((String)FileuploadUtils.FOLDER_TMP_FOR_ATTACHMENT_FILES, (String)(ALEipUtils.getUserId((RunData)rundata) + ALStorageService.separator() + folderName), (String)(fileid + ".txt")), FILE_ENCODING));
                    String line = reader.readLine();
                    if (line == null || line.length() <= 0) continue;
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName(newfileid);
                    filebean.setFileId(fileid);
                    filebean.setFileName(line);
                    fileNameList.add((FileuploadLiteBean)filebean);
                }
                catch (Exception e) {
                    logger.error((Object)"Exception", (Throwable)e);
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Exception", (Throwable)e);
                    }
                }
            }
        }
        if (hadfileids.size() > 0) {
            ArrayList<Integer> hadfileidsValue = new ArrayList<Integer>();
            for (String hadfileid : hadfileids) {
                fileid = 0;
                try {
                    fileid = Integer.parseInt(hadfileid);
                    hadfileidsValue.add(fileid);
                }
                catch (Exception e) {}
            }
            try {
                SelectQuery reqquery = Database.query(EipTGpdbRecordFile.class);
                Expression reqexp1 = ExpressionFactory.inDbExp((String)"FILE_ID", hadfileidsValue);
                reqquery.setQualifier(reqexp1);
                List requests = reqquery.fetchList();
                for (EipTGpdbRecordFile file : requests) {
                    filebean = new FileuploadBean();
                    filebean.initField();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(file.getFileName());
                    filebean.setFlagNewFile(false);
                    fileNameList.add((FileuploadLiteBean)filebean);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"[BlogUtils] Exception.", (Throwable)ex);
            }
        }
        return fileNameList;
    }

    public static EipTGpdbRecordFile getEipTGpdbRecordFile(RunData rundata) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int attachmentIndex = rundata.getParameters().getInt("attachmentIndex", -1);
            if (attachmentIndex < 0) {
                logger.debug((Object)"[GpdbUtils] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTGpdbRecordFile.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)attachmentIndex);
            query.andQualifier(exp);
            List files = query.fetchList();
            if (files == null || files.size() == 0) {
                logger.debug((Object)"[GpdbUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTGpdbRecordFile)files.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[GpdbUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List<EipTGpdbRecordFile> getEipTGpdbRecordFileList(int gpdbRecordId) {
        SelectQuery query = Database.query(EipTGpdbRecordFile.class);
        query.setQualifier(ExpressionFactory.matchDbExp((String)"GPDB_RECORD_ID", (Object)gpdbRecordId));
        return query.fetchList();
    }

    public static List<FileuploadBean> getAttachmentFiles(int gpdbRecordId) {
        List<EipTGpdbRecordFile> fileList = GpdbUtils.getEipTGpdbRecordFileList(gpdbRecordId);
        if (fileList != null && fileList.size() > 0) {
            ArrayList<FileuploadBean> attachmentFileList = new ArrayList<FileuploadBean>();
            FileuploadBean filebean = null;
            EipTGpdbRecordFile file = null;
            int size = fileList.size();
            for (int i = 0; i < size; ++i) {
                file = fileList.get(i);
                String realname = file.getFileName();
                DataHandler hData = new DataHandler((DataSource)new FileDataSource(realname));
                filebean = new FileuploadBean();
                filebean.setFileId(file.getFileId().intValue());
                filebean.setFileName(realname);
                if (hData != null) {
                    filebean.setContentType(hData.getContentType());
                }
                filebean.setIsImage(FileuploadUtils.isImage((String)realname));
                attachmentFileList.add(filebean);
            }
            return attachmentFileList;
        }
        return new ArrayList<FileuploadBean>();
    }

    public static String passPSML(RunData rundata, Context context, String key, String value) {
        VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
        PortletConfig config = portlet.getPortletConfig();
        if (value == null || "".equals(value)) {
            value = config != null ? config.getInitParameter(key) : "";
        } else {
            ALEipUtils.setPsmlParameters((RunData)rundata, (Context)context, (String)key, (String)value);
        }
        return value;
    }
}

