/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.TagToken;
import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.filter.Util;
import info.bliki.wiki.filter.WikipediaScanner;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.WPBoldItalicTag;
import info.bliki.wiki.tags.WPTag;
import info.bliki.wiki.tags.util.TagStack;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParser
extends WikipediaScanner {
    public static final String[] TOC_IDENTIFIERS = new String[]{"TOC", "NOTOC", "FORCETOC"};
    static final String[] HEADER_STRINGS = new String[]{"=", "==", "===", "====", "=====", "======"};
    static final int TokenNotFound = -2;
    static final int TokenIgnore = -1;
    static final int TokenSTART = 0;
    static final int TokenEOF = 1;
    static final int TokenBOLD = 3;
    static final int TokenITALIC = 4;
    static final int TokenBOLDITALIC = 5;
    static final HTMLTag BOLD = new WPTag("b");
    static final HTMLTag ITALIC = new WPTag("i");
    static final HTMLTag BOLDITALIC = new WPBoldItalicTag();
    static final HTMLTag STRONG = new WPTag("strong");
    static final HTMLTag EM = new WPTag("em");
    protected char fCurrentCharacter = '\u0000';
    protected int fCurrentPosition = 0;
    protected boolean fWhiteStart = false;
    protected int fWhiteStartPosition = 0;

    public AbstractParser(String stringSource) {
        super(stringSource);
    }

    protected final boolean readUntil(String untilString) {
        int index = this.fStringSource.indexOf(untilString, this.fCurrentPosition);
        if (index != -1) {
            this.fCurrentPosition = index + untilString.length();
            return true;
        }
        return false;
    }

    protected final int readUntilIgnoreCase(String startString, String endString) {
        int index = Util.indexOfIgnoreCase(this.fStringSource, startString, endString, this.fCurrentPosition);
        if (index != -1) {
            this.fCurrentPosition = index + startString.length() + endString.length();
            return startString.length() + endString.length();
        }
        this.fCurrentPosition = this.fStringSource.length();
        return 0;
    }

    protected final int readUntilNestedIgnoreCase(String endString) {
        int index = Util.indexOfNestedIgnoreCase(this.fStringSource, endString, this.fCurrentPosition);
        if (index != -1) {
            this.fCurrentPosition = index + 2 + endString.length();
            return 2 + endString.length();
        }
        this.fCurrentPosition = this.fStringSource.length();
        return 0;
    }

    protected final boolean readUntilChar(char testedChar) {
        int temp = this.fCurrentPosition;
        try {
            while ((this.fCurrentCharacter = this.fSource[this.fCurrentPosition++]) != testedChar) {
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected final boolean readUntilCharOrStopAtEOL(char testedChar) {
        int temp = this.fCurrentPosition;
        boolean attrMode = false;
        try {
            while ((this.fCurrentCharacter = this.fSource[this.fCurrentPosition++]) != testedChar) {
                if (attrMode) {
                    if (this.fCurrentCharacter != '\"') continue;
                    attrMode = false;
                    continue;
                }
                if (this.fCurrentCharacter == '\n' || this.fCurrentCharacter == '\r') {
                    return false;
                }
                if (this.fCurrentCharacter != '\"') continue;
                attrMode = true;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected final boolean readUntilEOL() {
        try {
            while (true) {
                int newPos;
                this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                if (this.fCurrentCharacter == '\n' || this.fCurrentCharacter == '\r') {
                    return true;
                }
                if (this.fCurrentCharacter != '<' || (newPos = this.readSpecialWikiTags(this.fCurrentPosition)) < 0) continue;
                this.fCurrentPosition = newPos;
            }
        }
        catch (IndexOutOfBoundsException e) {
            --this.fCurrentPosition;
            return true;
        }
    }

    protected boolean isEmptyLine(int diff) {
        int temp = this.fCurrentPosition - diff;
        try {
            char ch;
            do {
                if (Character.isWhitespace(ch = this.fSource[temp++])) continue;
                return false;
            } while (ch != '\n');
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            return true;
        }
    }

    protected int readWhitespaceUntilEndOfLine(int diff) {
        int temp;
        for (temp = this.fCurrentPosition - diff; this.fSource.length > temp; ++temp) {
            char ch = this.fSource[temp];
            if (!Character.isWhitespace(ch)) {
                return -1;
            }
            if (ch != '\n') continue;
            this.fCurrentPosition = temp;
            return temp;
        }
        this.fCurrentPosition = temp - 1;
        return temp;
    }

    protected int readWhitespaceUntilStartOfLine(int diff) {
        int temp;
        for (temp = this.fCurrentPosition - diff; temp >= 0; --temp) {
            char ch = this.fSource[temp];
            if (!Character.isWhitespace(ch)) {
                return -1;
            }
            if (ch != '\n') continue;
            return temp;
        }
        return temp;
    }

    protected boolean parsePHPBBCode(String name, StringBuilder bbCode) {
        int index = 1;
        char ch = ' ';
        while (index < name.length() && 'a' <= (ch = (char)name.charAt(index++)) && ch <= 'z') {
            bbCode.append(ch);
        }
        if (ch != '=' && index != name.length()) {
            return false;
        }
        String bbStr = bbCode.toString();
        String bbEndStr = bbStr + "]";
        int startPos = this.fCurrentPosition;
        this.readUntilIgnoreCase("[/", bbEndStr);
        String bbAttr = null;
        if (ch == '=' && (bbAttr = name.substring(index, name.length())) != null) {
            bbAttr = bbAttr.trim();
        }
        int endPos = this.fCurrentPosition - bbEndStr.length() - 2;
        String innerTag = this.fStringSource.substring(startPos, endPos);
        return this.createBBCode(bbStr, bbAttr, innerTag);
    }

    private int parsePHPBBCodeRecursive(String rawWikitext, int index) {
        char ch = ' ';
        StringBuilder bbCode = new StringBuilder(10);
        while (index < rawWikitext.length() && 'a' <= (ch = (char)rawWikitext.charAt(index++)) && ch <= 'z') {
            bbCode.append(ch);
        }
        String bbStr = bbCode.toString();
        String bbEndStr = bbStr + "]";
        int startPos = index;
        int endIndex = Util.indexOfIgnoreCase(rawWikitext, "[/", bbEndStr, index);
        if (endIndex != -1) {
            String innerTag;
            String bbAttr = null;
            if (ch == '=' && (bbAttr = rawWikitext.substring(index, endIndex)) != null) {
                bbAttr = bbAttr.trim();
            }
            if (this.createBBCode(bbStr, bbAttr, innerTag = rawWikitext.substring(startPos, endIndex))) {
                return endIndex + 3 + bbStr.length();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createBBCode(String bbStr, String bbAttr, String innerTag) {
        if (bbStr.equals("code")) {
            TagNode preTagNode = new TagNode("pre");
            preTagNode.addAttribute("class", "code", true);
            preTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(preTagNode);
            return true;
        }
        if (bbStr.equals("color")) {
            if (bbAttr == null) {
                return false;
            }
            TagNode fontTagNode = new TagNode("font");
            fontTagNode.addAttribute("color", bbAttr, true);
            fontTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(fontTagNode);
            return true;
        }
        if (bbStr.equals("email")) {
            TagNode aTagNode = new TagNode("a");
            aTagNode.addAttribute("href", "emailto:" + innerTag.trim(), true);
            aTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(aTagNode);
            return true;
        }
        if (bbStr.equals("list")) {
            block31: {
                int listStart = 0;
                int listEnd = 0;
                TagNode listTagNode = bbAttr != null ? (bbAttr.equals("a") ? new TagNode("ul") : new TagNode("ol")) : new TagNode("ul");
                this.fWikiModel.pushNode(listTagNode);
                try {
                    while (listEnd >= 0) {
                        listEnd = innerTag.indexOf("[*]", listStart);
                        if (listEnd <= listStart) continue;
                        if (listStart == 0) {
                            this.parseNextPHPBBCode(innerTag.substring(0, listEnd));
                        } else {
                            listTagNode = new TagNode("li");
                            this.fWikiModel.pushNode(listTagNode);
                            try {
                                this.parseNextPHPBBCode(innerTag.substring(listStart, listEnd));
                            }
                            finally {
                                this.fWikiModel.popNode();
                            }
                        }
                        listStart = listEnd + 3;
                    }
                    if (listStart == 0) {
                        this.parseNextPHPBBCode(innerTag);
                        break block31;
                    }
                    if (listStart >= innerTag.length()) break block31;
                    listTagNode = new TagNode("li");
                    this.fWikiModel.pushNode(listTagNode);
                    try {
                        this.parseNextPHPBBCode(innerTag.substring(listStart, innerTag.length()));
                    }
                    finally {
                        this.fWikiModel.popNode();
                    }
                }
                finally {
                    this.fWikiModel.popNode();
                }
            }
            return true;
        }
        if (bbStr.equals("img")) {
            TagNode imgTagNode = new TagNode("img");
            imgTagNode.addAttribute("src", innerTag.trim(), true);
            imgTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(imgTagNode);
            return true;
        }
        if (bbStr.equals("quote")) {
            TagNode quoteTagNode = new TagNode("blockquote");
            this.fWikiModel.pushNode(quoteTagNode);
            try {
                this.parseNextPHPBBCode(innerTag);
            }
            finally {
                this.fWikiModel.popNode();
            }
            return true;
        }
        if (bbStr.equals("size")) {
            if (bbAttr == null) {
                return false;
            }
            TagNode fontTagNode = new TagNode("font");
            fontTagNode.addAttribute("size", bbAttr, true);
            fontTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(fontTagNode);
            return true;
        }
        if (bbStr.equals("url")) {
            if (bbAttr != null) {
                TagNode aTagNode = new TagNode("a");
                aTagNode.addAttribute("href", bbAttr, true);
                aTagNode.addChild(new ContentToken(innerTag));
                this.fWikiModel.append(aTagNode);
                return true;
            }
            TagNode aTagNode = new TagNode("a");
            aTagNode.addAttribute("href", innerTag.trim(), true);
            aTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(aTagNode);
            return true;
        }
        if (bbStr.equals("b")) {
            TagNode boldTagNode = new TagNode("b");
            boldTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(boldTagNode);
            return true;
        }
        if (bbStr.equals("i")) {
            TagNode italicTagNode = new TagNode("i");
            italicTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(italicTagNode);
            return true;
        }
        if (bbStr.equals("u")) {
            TagNode underlineTagNode = new TagNode("u");
            underlineTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(underlineTagNode);
            return true;
        }
        return false;
    }

    protected final boolean getNextChar(char testedChar) {
        int temp = this.fCurrentPosition;
        try {
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (this.fCurrentCharacter != testedChar) {
                this.fCurrentPosition = temp;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected final int getNextChar(char testedChar1, char testedChar2) {
        int temp = this.fCurrentPosition;
        try {
            int result;
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (this.fCurrentCharacter == testedChar1) {
                result = 0;
            } else if (this.fCurrentCharacter == testedChar2) {
                result = 1;
            } else {
                this.fCurrentPosition = temp;
                return -1;
            }
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return -1;
        }
    }

    protected final boolean getNextCharAsDigit() {
        int temp = this.fCurrentPosition;
        try {
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (!Character.isDigit(this.fCurrentCharacter)) {
                this.fCurrentPosition = temp;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected final boolean getNextCharAsWhitespace() {
        int temp = this.fCurrentPosition;
        try {
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (!Character.isWhitespace(this.fCurrentCharacter)) {
                this.fCurrentPosition = temp;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected final boolean getNextCharAsDigit(int radix) {
        int temp = this.fCurrentPosition;
        try {
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (Character.digit(this.fCurrentCharacter, radix) == -1) {
                this.fCurrentPosition = temp;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected final int getNumberOfChar(char testedChar) {
        int number = 0;
        try {
            while ((this.fCurrentCharacter = this.fSource[this.fCurrentPosition++]) == testedChar) {
                ++number;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        --this.fCurrentPosition;
        return number;
    }

    protected final boolean getNextCharAsWikiPluginIdentifierPart() {
        int temp = this.fCurrentPosition;
        try {
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (!Encoder.isWikiPluginIdentifierPart(this.fCurrentCharacter)) {
                this.fCurrentPosition = temp;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    private void parseNextPHPBBCode(String rawWikitext) {
        int index = rawWikitext.indexOf(91);
        int lastIndex = 0;
        int tempIndex = -1;
        if (index < 0) {
            this.fWikiModel.append(new ContentToken(rawWikitext));
            return;
        }
        try {
            while (index >= 0) {
                String temp = rawWikitext.substring(lastIndex, index);
                if (temp.length() > 0) {
                    this.fWikiModel.append(new ContentToken(temp));
                }
                if ((tempIndex = this.parsePHPBBCodeRecursive(rawWikitext, index + 1)) < 0) {
                    lastIndex = index + 1;
                    index = rawWikitext.indexOf(91, index + 1);
                    continue;
                }
                lastIndex = tempIndex;
                index = rawWikitext.indexOf(91, tempIndex);
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (lastIndex < rawWikitext.length()) {
            this.fWikiModel.append(new ContentToken(rawWikitext.substring(lastIndex)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagStack parseRecursiveInternal(IWikiModel wikiModel, boolean createOnlyLocalStack, boolean noTOC) {
        TagStack localStack = new TagStack();
        TagStack globalWikiModelStack = wikiModel.swapStack(localStack);
        try {
            int level = wikiModel.incrementRecursionLevel();
            if (level > 256) {
                TagNode error = new TagNode("span");
                error.addAttribute("class", "error", true);
                error.addChild(new ContentToken("Error - recursion limit exceeded parsing wiki tags."));
                localStack.append(error);
                TagStack tagStack = localStack;
                return tagStack;
            }
            this.setModel(wikiModel);
            this.setNoToC(noTOC);
            this.runParser();
            TagStack error = localStack;
            return error;
        }
        catch (Exception e) {
            e.printStackTrace();
            TagNode error = new TagNode("span");
            error.addAttribute("class", "error", true);
            error.addChild(new ContentToken(e.getClass().getSimpleName()));
            localStack.append(error);
        }
        catch (Error e) {
            e.printStackTrace();
            TagNode error = new TagNode("span");
            error.addAttribute("class", "error", true);
            error.addChild(new ContentToken(e.getClass().getSimpleName()));
            localStack.append(error);
        }
        finally {
            wikiModel.decrementRecursionLevel();
            if (!createOnlyLocalStack) {
                globalWikiModelStack.append(localStack);
            }
            wikiModel.swapStack(globalWikiModelStack);
        }
        return localStack;
    }

    protected final boolean findWikiLinkEnd() {
        int level = 1;
        int position = this.fCurrentPosition;
        boolean pipeSymbolFound = false;
        try {
            block7: {
                char ch;
                do {
                    if ((ch = this.fSource[position++]) == '|') {
                        pipeSymbolFound = true;
                        continue;
                    }
                    if (ch == '[' && this.fSource[position] == '[') {
                        if (pipeSymbolFound) {
                            ++level;
                            ++position;
                            continue;
                        }
                        return false;
                    }
                    if (ch == ']' && this.fSource[position] == ']') {
                        ++position;
                        if (--level != 0) continue;
                        break block7;
                    }
                    if (ch != '{' && ch != '}' && ch != '<' && ch != '>' || pipeSymbolFound) continue;
                    return false;
                } while (pipeSymbolFound || ch != '\n' && ch != '\r');
                return false;
            }
            this.fCurrentPosition = position;
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public abstract void setNoToC(boolean var1);

    public abstract void runParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRedirectedTemplateContent(IWikiModel wikiModel, String redirectedLink, Map<String, String> templateParameters) {
        String redirNamespace = "";
        String redirArticle = redirectedLink;
        int index = redirectedLink.indexOf(":");
        if (index > 0 && wikiModel.isTemplateNamespace(redirNamespace = redirectedLink.substring(0, index))) {
            redirArticle = redirectedLink.substring(index + 1);
            try {
                int level = wikiModel.incrementRecursionLevel();
                if (level > 256) {
                    String string = "Error - getting content of redirected template link: " + redirNamespace + ":" + redirArticle;
                    return string;
                }
                String string = wikiModel.getRawWikiContent(redirNamespace, redirArticle, templateParameters);
                return string;
            }
            finally {
                wikiModel.decrementRecursionLevel();
            }
        }
        return null;
    }

    public static String parseRedirect(String rawWikiText, IWikiModel wikiModel) {
        String redirectedLink;
        int redirectStart = -1;
        int redirectEnd = -1;
        for (int i = 0; i < rawWikiText.length(); ++i) {
            if (rawWikiText.charAt(i) == '#') {
                if (!AbstractParser.startsWith(rawWikiText, i + 1, "redirect", true) || (redirectStart = rawWikiText.indexOf("[[", i + 8)) <= i + 8) break;
                redirectEnd = rawWikiText.indexOf("]]", redirectStart += 2);
                break;
            }
            if (!Character.isWhitespace(rawWikiText.charAt(i))) break;
        }
        if (redirectEnd >= 0 && wikiModel.appendRedirectLink(redirectedLink = rawWikiText.substring(redirectStart, redirectEnd))) {
            return redirectedLink;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createContentToken(int diff) {
        if (this.fWhiteStart) {
            try {
                int count = this.fCurrentPosition - diff - this.fWhiteStartPosition;
                if (count > 0) {
                    this.fWikiModel.append(new ContentToken(this.fStringSource.substring(this.fWhiteStartPosition, this.fWhiteStartPosition + count)));
                }
            }
            finally {
                this.fWhiteStart = false;
            }
        }
    }

    protected void reduceTokenStack() {
        while (this.fWikiModel.stackSize() > 0) {
            this.fWikiModel.popNode();
        }
    }

    protected void reduceTokenStackBoldItalic() {
        boolean found = false;
        while (this.fWikiModel.stackSize() > 0) {
            TagToken token = this.fWikiModel.peekNode();
            if (token.equals(BOLD) || token.equals(ITALIC) || token.equals(BOLDITALIC)) {
                if (this.fWhiteStart) {
                    found = true;
                    this.createContentToken(1);
                }
                this.fWikiModel.popNode();
                continue;
            }
            return;
        }
        if (found) {
            this.fWhiteStart = true;
            this.fWhiteStartPosition = this.fCurrentPosition;
        }
    }

    protected void reduceTokenStack(TagToken node) {
        String allowedParents = node.getParents();
        if (allowedParents != null) {
            int index = -1;
            while (this.fWikiModel.stackSize() > 0) {
                TagToken tag = this.fWikiModel.peekNode();
                index = allowedParents.indexOf("|" + tag.getName() + "|");
                if (index >= 0) break;
                this.fWikiModel.popNode();
                if (!tag.getName().equals(node.getName())) continue;
                break;
            }
        } else {
            while (this.fWikiModel.stackSize() > 0) {
                this.fWikiModel.popNode();
            }
        }
    }
}

