/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template.extension;

import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.template.AbstractTemplateFunction;
import info.bliki.wiki.template.ITemplateFunction;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Allmacros
extends AbstractTemplateFunction {
    public static final ITemplateFunction CONST = new Allmacros();

    @Override
    public String getFunctionDoc() {
        return "Returns all macros";
    }

    @Override
    public String parseFunction(List<String> parts, IWikiModel model, char[] src, int beginIndex, int endIndex, boolean isSubst) throws IOException {
        Map<String, ITemplateFunction> t = model.getTemplateMap();
        StringBuilder sb = new StringBuilder(16);
        sb.append("<table border=\"1\"><th>Template name</th><th>Implemented in class</th><th>Description</th>");
        for (Map.Entry<String, ITemplateFunction> e : t.entrySet()) {
            sb.append("<tr><td>");
            sb.append(e.getKey());
            sb.append("</td><td>");
            ITemplateFunction tf = e.getValue();
            Class<?> cl1 = tf.getClass().getEnclosingClass();
            if (cl1 == null) {
                cl1 = tf.getClass();
            }
            String s1 = cl1.getCanonicalName();
            sb.append(s1);
            sb.append("</td><td>");
            String doc = tf.getFunctionDoc();
            if (doc == null) {
                sb.append("No documentation available");
            } else {
                sb.append(doc);
            }
            sb.append("</td></tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }
}

