/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.addressbook.AddressBookGroupResultData;
import com.aimluck.eip.addressbook.AddressBookWordSelectData;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public abstract class AbstractAddressBookWordSelectData<M1, M2>
extends ALAbstractSelectData<M1, M2> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookWordSelectData.class.getName());
    protected ALStringField searchWord;
    protected String currentTab;
    private boolean hasAuthorityList;

    public static AbstractAddressBookWordSelectData<?, ?> createAddressBookWordSelectData(RunData rundata, Context context) {
        return new AddressBookWordSelectData();
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"name_kana");
        }
        if (!rundata.getParameters().containsKey((Object)"start") && !rundata.getParameters().containsKey((Object)"sort")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"AddressBooksword", (String)rundata.getParameters().getString("sword"));
        }
        this.searchWord = new ALStringField();
        this.searchWord.setTrim(true);
        this.searchWord.setValue(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"AddressBooksword"));
        this.currentTab = "syagai";
        this.hasAuthorityList = this.checkHasAuthority(rundata, 1);
        super.init(action, rundata, context);
    }

    public abstract void loadGroups(RunData var1, Context var2);

    public abstract String getTemplateFilePath();

    public String getCurrentTab() {
        return this.currentTab;
    }

    public boolean getHasAuthorityList() {
        return this.hasAuthorityList;
    }

    public ALStringField getSearchWord() {
        return this.searchWord;
    }

    public abstract List<AddressBookGroupResultData> getGroupList();

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public abstract List<ALEipGroup> getMyGroupList();

    public boolean checkHasAuthority(RunData rundata, int type) {
        String feature = "addressbook_address_inside";
        if ("syagai".equals(this.currentTab)) {
            feature = "addressbook_address_outside";
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        return aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), feature, type);
    }

    protected SelectQuery<M1> buildSelectQueryForListViewSort(SelectQuery<M1> query, RunData rundata, Context context) {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        String sort_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (sort == null) {
            return query;
        }
        crt_key = map.getValue(sort);
        if (crt_key == null) {
            return query;
        }
        if (sort_type != null && "desc".equals(sort_type)) {
            query.orderDesending(crt_key);
            if (sort.equals("name_kana")) {
                query.orderDesending("firstNameKana");
            }
        } else {
            query.orderAscending(crt_key);
            if (sort.equals("name_kana")) {
                query.orderAscending("firstNameKana");
            }
            sort_type = "asc";
        }
        this.current_sort = sort;
        this.current_sort_type = sort_type;
        return query;
    }
}

