/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.addressbook.AddressBookCompanyResultData;
import com.aimluck.eip.addressbook.AddressBookGroupResultData;
import com.aimluck.eip.addressbook.util.AddressBookUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.cayenne.om.portlet.EipTAddressbookGroupMap;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookFormData.class.getName());
    private List<AddressBookGroupResultData> groupList;
    private List<Object> groups;
    private ALStringField group_names;
    private ALStringField firstname;
    private ALStringField lastname;
    private ALStringField first_name_kana;
    private ALStringField last_name_kana;
    private ALStringField email;
    private ALStringField telephone1;
    private ALStringField telephone2;
    private ALStringField telephone3;
    private ALStringField cellular_phone1;
    private ALStringField cellular_phone2;
    private ALStringField cellular_phone3;
    private ALStringField cellular_mail;
    private List<AddressBookCompanyResultData> companyList;
    private ALNumberField company_id;
    private ALStringField position_name;
    private ALStringField public_flag;
    private ALStringField note;
    private ALStringField create_user;
    private ALStringField update_user;
    private ALDateField create_date;
    private ALDateField update_date;
    private ALStringField company_name;
    private ALStringField company_name_kana;
    private ALStringField post_name;
    private ALStringField comp_zipcode1;
    private ALStringField comp_zipcode2;
    private ALStringField comp_address;
    private ALStringField comp_telephone1;
    private ALStringField comp_telephone2;
    private ALStringField comp_telephone3;
    private ALStringField comp_fax_number1;
    private ALStringField comp_fax_number2;
    private ALStringField comp_fax_number3;
    private ALStringField comp_url;
    private boolean is_new_company;
    private int user_id;
    private int owner_id;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.is_new_company = rundata.getParameters().getBoolean("is_new_company");
        this.user_id = ALEipUtils.getUserId((RunData)rundata);
    }

    public void initField() {
        this.groups = new ArrayList<Object>();
        this.group_names = new ALStringField();
        this.lastname = new ALStringField();
        this.lastname.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_LASTNAME"));
        this.lastname.setTrim(true);
        this.firstname = new ALStringField();
        this.firstname.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_FIRSTNAME"));
        this.firstname.setTrim(true);
        this.last_name_kana = new ALStringField();
        this.last_name_kana.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_LASTNAME_KANA"));
        this.last_name_kana.setTrim(true);
        this.first_name_kana = new ALStringField();
        this.first_name_kana.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_FIRSTNAME_KANA"));
        this.first_name_kana.setTrim(true);
        this.email = new ALStringField();
        this.email.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_EMAIL"));
        this.email.setTrim(true);
        this.telephone1 = new ALStringField();
        this.telephone1.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_TELEPHONE"));
        this.telephone1.setTrim(true);
        this.telephone2 = new ALStringField();
        this.telephone2.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_TELEPHONE"));
        this.telephone2.setTrim(true);
        this.telephone3 = new ALStringField();
        this.telephone3.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_TELEPHONE"));
        this.telephone3.setTrim(true);
        this.cellular_phone1 = new ALStringField();
        this.cellular_phone1.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_CELLULAR_PHONE"));
        this.cellular_phone1.setTrim(true);
        this.cellular_phone2 = new ALStringField();
        this.cellular_phone2.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_CELLULAR_PHONE"));
        this.cellular_phone2.setTrim(true);
        this.cellular_phone3 = new ALStringField();
        this.cellular_phone3.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_CELLULAR_PHONE"));
        this.cellular_phone3.setTrim(true);
        this.cellular_mail = new ALStringField();
        this.cellular_mail.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_CELLULAR_MAIL"));
        this.cellular_mail.setTrim(true);
        this.company_id = new ALNumberField();
        this.company_id.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_COMPANY"));
        this.position_name = new ALStringField();
        this.position_name.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_POSITION"));
        this.position_name.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_NOTE"));
        this.note.setTrim(true);
        this.public_flag = new ALStringField();
        this.public_flag.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_PUBLIC"));
        this.public_flag.setTrim(true);
        this.create_user = new ALStringField();
        this.create_user.setFieldName(ALLocalizationUtils.getl10n((String)"COMMON_CREATE_USER"));
        this.update_user = new ALStringField();
        this.update_user.setFieldName(ALLocalizationUtils.getl10n((String)"COMMON_UPDATE_USER"));
        this.create_date = new ALDateField();
        this.create_date.setFieldName(ALLocalizationUtils.getl10n((String)"COMMON_CREATE_DATE"));
        this.update_date = new ALDateField();
        this.update_date.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_LAST_UPDATE_DATE"));
        this.company_name = new ALStringField();
        this.company_name.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_COMPANY_NAME"));
        this.company_name.setTrim(true);
        this.company_name_kana = new ALStringField();
        this.company_name_kana.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_COMPANY_NAME_KANA"));
        this.company_name_kana.setTrim(true);
        this.post_name = new ALStringField();
        this.post_name.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_POST_NAME"));
        this.post_name.setTrim(true);
        this.comp_zipcode1 = new ALStringField();
        this.comp_zipcode1.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_ZIPCODE"));
        this.comp_zipcode1.setTrim(true);
        this.comp_zipcode2 = new ALStringField();
        this.comp_zipcode2.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_ZIPCODE"));
        this.comp_zipcode2.setTrim(true);
        this.comp_address = new ALStringField();
        this.comp_address.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_ADDRESS"));
        this.comp_address.setTrim(true);
        this.comp_telephone1 = new ALStringField();
        this.comp_telephone1.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_TELEPHONE"));
        this.comp_telephone1.setTrim(true);
        this.comp_telephone2 = new ALStringField();
        this.comp_telephone2.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_TELEPHONE"));
        this.comp_telephone2.setTrim(true);
        this.comp_telephone3 = new ALStringField();
        this.comp_telephone3.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_TELEPHONE"));
        this.comp_telephone3.setTrim(true);
        this.comp_fax_number1 = new ALStringField();
        this.comp_fax_number1.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_FAX_NUMBER"));
        this.comp_fax_number1.setTrim(true);
        this.comp_fax_number2 = new ALStringField();
        this.comp_fax_number2.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_FAX_NUMBER"));
        this.comp_fax_number2.setTrim(true);
        this.comp_fax_number3 = new ALStringField();
        this.comp_fax_number3.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_FAX_NUMBER"));
        this.comp_fax_number3.setTrim(true);
        this.comp_url = new ALStringField();
        this.comp_url.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_URL"));
        this.comp_url.setTrim(true);
    }

    public void loadGroupList(RunData rundata, Context context) {
        this.groupList = new ArrayList<AddressBookGroupResultData>();
        try {
            SelectQuery query = Database.query(EipMAddressGroup.class);
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp);
            List aList = query.fetchList();
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipMAddressGroup record = (EipMAddressGroup)aList.get(i);
                AddressBookGroupResultData rd = new AddressBookGroupResultData();
                rd.initField();
                rd.setGroupId(record.getGroupId().intValue());
                rd.setGroupName(record.getGroupName());
                this.groupList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookFormData.loadGroupList", (Throwable)ex);
        }
    }

    public void loadGroups(RunData rundata, Context context) {
        try {
            String addressid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (addressid == null || "".equals(addressid)) {
                return;
            }
            SelectQuery query = Database.query(EipTAddressbookGroupMap.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"eipTAddressGroup.ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"addressId", (Object)Integer.valueOf(addressid));
            query.andQualifier(exp2);
            query.distinct(true);
            List aList = query.fetchList();
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipTAddressbookGroupMap record = (EipTAddressbookGroupMap)aList.get(i);
                AddressBookGroupResultData rd = new AddressBookGroupResultData();
                rd.initField();
                rd.setGroupId(record.getEipTAddressGroup().getGroupId().intValue());
                rd.setGroupName(record.getEipTAddressGroup().getGroupName());
                this.groups.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookFormData.loadGroups", (Throwable)ex);
        }
    }

    public void loadCompanyList(RunData rundata, Context context) {
        this.companyList = new ArrayList<AddressBookCompanyResultData>();
        try {
            SelectQuery query = Database.query(EipMAddressbookCompany.class);
            query.setQualifier(AddressBookUtils.excludeDefaultCompanyCriteria());
            query.orderAscending("companyNameKana");
            List aList = query.fetchList();
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipMAddressbookCompany record = (EipMAddressbookCompany)aList.get(i);
                AddressBookCompanyResultData rd = new AddressBookCompanyResultData();
                rd.initField();
                rd.setCompanyId(record.getCompanyId().intValue());
                rd.setCompanyName(record.getCompanyName() + " " + record.getPostName());
                this.companyList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookFormData.loadCompanyList", (Throwable)ex);
        }
    }

    protected void setValidator() {
        this.lastname.setNotNull(true);
        this.lastname.limitMaxLength(50);
        this.firstname.setNotNull(true);
        this.firstname.limitMaxLength(50);
        this.last_name_kana.setNotNull(true);
        this.last_name_kana.limitMaxLength(50);
        this.first_name_kana.setNotNull(true);
        this.first_name_kana.limitMaxLength(50);
        this.email.setCharacterType(19);
        this.email.limitMaxLength(50);
        this.telephone1.setCharacterType(2);
        this.telephone1.limitMaxLength(5);
        this.telephone2.setCharacterType(2);
        this.telephone2.limitMaxLength(4);
        this.telephone3.setCharacterType(2);
        this.telephone3.limitMaxLength(4);
        this.cellular_phone1.setCharacterType(2);
        this.cellular_phone1.limitMaxLength(5);
        this.cellular_phone2.setCharacterType(2);
        this.cellular_phone2.limitMaxLength(4);
        this.cellular_phone3.setCharacterType(2);
        this.cellular_phone3.limitMaxLength(4);
        this.cellular_mail.setCharacterType(19);
        this.cellular_mail.limitMaxLength(50);
        this.position_name.limitMaxLength(50);
        this.note.limitMaxLength(1000);
        if (this.is_new_company) {
            this.company_name.setNotNull(true);
            this.company_name.limitMaxLength(50);
            this.company_name_kana.setNotNull(true);
            this.company_name_kana.limitMaxLength(50);
            this.post_name.limitMaxLength(50);
            this.comp_zipcode1.setCharacterType(2);
            this.comp_zipcode1.limitLength(3, 3);
            this.comp_zipcode2.setCharacterType(2);
            this.comp_zipcode2.limitLength(4, 4);
            this.comp_address.limitMaxLength(50);
            this.comp_telephone1.setCharacterType(2);
            this.comp_telephone1.limitMaxLength(5);
            this.comp_telephone2.setCharacterType(2);
            this.comp_telephone2.limitMaxLength(4);
            this.comp_telephone3.setCharacterType(2);
            this.comp_telephone3.limitMaxLength(4);
            this.comp_fax_number1.setCharacterType(2);
            this.comp_fax_number1.limitMaxLength(5);
            this.comp_fax_number2.setCharacterType(2);
            this.comp_fax_number2.limitMaxLength(4);
            this.comp_fax_number3.setCharacterType(2);
            this.comp_fax_number3.limitMaxLength(4);
            this.comp_url.setCharacterType(19);
            this.comp_url.limitMaxLength(90);
        }
    }

    protected boolean validate(List<String> msgList) {
        ArrayList dummy = new ArrayList();
        this.lastname.validate(msgList);
        this.firstname.validate(msgList);
        this.last_name_kana.setValue(ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.last_name_kana.toString())));
        this.first_name_kana.setValue(ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.first_name_kana.toString())));
        this.last_name_kana.validate(msgList);
        this.first_name_kana.validate(msgList);
        this.email.validate(msgList);
        if (this.email.getValue().trim().length() > 0 && !ALStringUtil.isMailAddress((String)this.email.getValue())) {
            msgList.add(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_ALERT_SET_EMAIL"));
        }
        if (!(this.telephone1.getValue().equals("") && this.telephone2.getValue().equals("") && this.telephone3.getValue().equals("") || this.telephone1.validate(dummy) && this.telephone2.validate(dummy) && this.telephone3.validate(dummy))) {
            msgList.add(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_ALERT_SET_TELEPHONE"));
        }
        if (!(this.cellular_phone1.getValue().equals("") && this.cellular_phone2.getValue().equals("") && this.cellular_phone3.getValue().equals("") || this.cellular_phone1.validate(dummy) && this.cellular_phone2.validate(dummy) && this.cellular_phone3.validate(dummy))) {
            msgList.add(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_ALERT_SET_CELLPHONE"));
        }
        this.cellular_mail.validate(msgList);
        if (this.cellular_mail.getValue().trim().length() > 0 && !ALStringUtil.isCellPhoneMailAddress((String)this.cellular_mail.getValue())) {
            msgList.add(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_ALERT_SET_CELLMAIL"));
        }
        this.note.validate(msgList);
        this.position_name.validate(msgList);
        if (this.is_new_company) {
            this.company_name.validate(msgList);
            this.company_name_kana.setValue(ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.company_name_kana.toString())));
            this.company_name_kana.validate(msgList);
            this.post_name.validate(msgList);
            if (!(this.comp_zipcode1.getValue().equals("") && this.comp_zipcode2.getValue().equals("") || this.comp_zipcode1.validate(dummy) && this.comp_zipcode2.validate(dummy))) {
                msgList.add(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_ALERT_SET_CO_ZIPCODE"));
            }
            this.comp_address.validate(msgList);
            if (!(this.comp_telephone1.getValue().equals("") && this.comp_telephone2.getValue().equals("") && this.comp_telephone3.getValue().equals("") || this.comp_telephone1.validate(dummy) && this.comp_telephone2.validate(dummy) && this.comp_telephone3.validate(dummy))) {
                msgList.add(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_ALERT_SET_CO_PHONE"));
            }
            if (!(this.comp_fax_number1.getValue().equals("") && this.comp_fax_number2.getValue().equals("") && this.comp_fax_number3.getValue().equals("") || this.comp_fax_number1.validate(dummy) && this.comp_fax_number2.validate(dummy) && this.comp_fax_number3.validate(dummy))) {
                msgList.add(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_ALERT_SET_CO_FAX"));
            }
            this.comp_url.validate(msgList);
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            StringTokenizer token;
            String updatedUserName;
            EipMAddressbook address = AddressBookUtils.getEipMAddressbook(rundata, context);
            if (address == null) {
                return false;
            }
            ALEipUser createdUser = ALEipUtils.getALEipUser((int)address.getCreateUserId());
            String createdUserName = createdUser.getAliasName().getValue();
            this.create_user.setValue(createdUserName);
            if (address.getCreateUserId().equals(address.getUpdateUserId())) {
                updatedUserName = createdUserName;
            } else {
                ALEipUser updatedUser = ALEipUtils.getALEipUser((int)address.getUpdateUserId());
                updatedUserName = updatedUser.getAliasName().getValue();
            }
            this.update_user.setValue(updatedUserName);
            this.group_names.setValue(AddressBookUtils.getMyGroupNamesAsString(rundata, address.getAddressId(), ALEipUtils.getUserId((RunData)rundata)));
            EipMAddressbookCompany company = address.getEipMAddressbookCompany();
            if (company.getCompanyId() > 0) {
                this.company_id.setValue((long)company.getCompanyId().intValue());
            }
            this.firstname.setValue(address.getFirstName());
            this.first_name_kana.setValue(address.getFirstNameKana());
            this.lastname.setValue(address.getLastName());
            this.last_name_kana.setValue(address.getLastNameKana());
            this.email.setValue(address.getEmail());
            if (address.getTelephone() != null && (token = new StringTokenizer(address.getTelephone(), "-")).countTokens() == 3) {
                this.telephone1.setValue(token.nextToken());
                this.telephone2.setValue(token.nextToken());
                this.telephone3.setValue(token.nextToken());
            }
            if (address.getCellularPhone() != null && (token = new StringTokenizer(address.getCellularPhone(), "-")).countTokens() == 3) {
                this.cellular_phone1.setValue(token.nextToken());
                this.cellular_phone2.setValue(token.nextToken());
                this.cellular_phone3.setValue(token.nextToken());
            }
            this.cellular_mail.setValue(address.getCellularMail());
            this.position_name.setValue(address.getPositionName());
            this.note.setValue(address.getNote());
            this.public_flag.setValue(address.getPublicFlag());
            this.create_date.setValue(address.getCreateDate());
            this.update_date.setValue(address.getUpdateDate());
            this.owner_id = address.getOwnerId();
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookFormData.loadFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        int uid = ALEipUtils.getUserId((RunData)rundata);
        try {
            EipMAddressbookCompany company;
            if (!this.is_new_company || !this.insertCompanyData(rundata, context)) {
                // empty if block
            }
            EipMAddressbook address = (EipMAddressbook)Database.create(EipMAddressbook.class);
            address.setLastName(this.lastname.getValue());
            address.setFirstName(this.firstname.getValue());
            address.setLastNameKana(this.last_name_kana.getValue());
            address.setFirstNameKana(this.first_name_kana.getValue());
            address.setEmail(this.email.getValue());
            if (!(this.telephone1.getValue().equals("") || this.telephone2.getValue().equals("") || this.telephone3.getValue().equals(""))) {
                address.setTelephone(new StringBuffer().append(this.telephone1.getValue()).append("-").append(this.telephone2.getValue()).append("-").append(this.telephone3.getValue()).toString());
            } else {
                address.setTelephone("");
            }
            if (!(this.cellular_phone1.getValue().equals("") || this.cellular_phone2.getValue().equals("") || this.cellular_phone3.getValue().equals(""))) {
                address.setCellularPhone(new StringBuffer().append(this.cellular_phone1.getValue()).append("-").append(this.cellular_phone2.getValue()).append("-").append(this.cellular_phone3.getValue()).toString());
            } else {
                address.setCellularPhone("");
            }
            address.setCellularMail(this.cellular_mail.getValue());
            address.setPositionName(this.position_name.getValue());
            address.setNote(this.note.getValue());
            boolean hasCompany = false;
            if (this.company_id.getValue() > 0L && (company = (EipMAddressbookCompany)Database.get(EipMAddressbookCompany.class, (Object)((int)this.company_id.getValue()))).getCompanyId() > 0) {
                address.setEipMAddressbookCompany(company);
                hasCompany = true;
            }
            if (!hasCompany) {
                company = AddressBookUtils.getDummyEipMAddressbookCompany(rundata, context);
                address.setEipMAddressbookCompany(company);
            }
            address.setPublicFlag(this.public_flag.getValue());
            address.setOwnerId(Integer.valueOf(uid));
            address.setCreateUserId(Integer.valueOf(uid));
            address.setUpdateUserId(Integer.valueOf(uid));
            Date now = new Date();
            address.setCreateDate(now);
            address.setUpdateDate(now);
            Database.commit();
            Integer id = address.getAddressId();
            for (int i = 0; i < this.groups.size(); ++i) {
                EipTAddressbookGroupMap map = (EipTAddressbookGroupMap)Database.create(EipTAddressbookGroupMap.class);
                map.setEipMAddressbook((EipMAddressbook)Database.get(EipMAddressbook.class, (Object)id));
                map.setEipTAddressGroup((EipMAddressGroup)this.groups.get(i));
            }
            Database.commit();
            String name = new StringBuffer().append(this.lastname.getValue()).append(" ").append(this.firstname.getValue()).toString();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(address.getAddressId().intValue(), 160, name);
            return true;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AddressBookFormData.insertFormData", (Throwable)ex);
            return false;
        }
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String addressid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (addressid == null || Integer.valueOf(addressid) == null) {
                logger.debug((Object)"[AddressBook] Cannot find Address ID .");
                return false;
            }
            EipMAddressbook addressbook = (EipMAddressbook)Database.get(EipMAddressbook.class, (Object)Integer.valueOf(addressid));
            int entityId = addressbook.getAddressId();
            String name = new StringBuffer().append(addressbook.getLastName()).append(" ").append(addressbook.getFirstName()).toString();
            Database.delete((Persistent)addressbook);
            SelectQuery query = Database.query(EipTAddressbookGroupMap.class);
            Expression exp = ExpressionFactory.matchExp((String)"addressId", (Object)Integer.valueOf(addressid));
            query.setQualifier(exp);
            List maps = query.fetchList();
            Database.deleteAll((List)maps);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId, 160, name);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AddressBookFormData.deleteFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMAddressbookCompany company;
            EipMAddressbook address;
            int uid = ALEipUtils.getUserId((RunData)rundata);
            if (!this.is_new_company || !this.insertCompanyData(rundata, context)) {
                // empty if block
            }
            if ((address = AddressBookUtils.getEipMAddressbook(rundata, context)) == null) {
                return false;
            }
            address.setLastName(this.lastname.getValue());
            address.setFirstName(this.firstname.getValue());
            address.setLastNameKana(this.last_name_kana.getValue());
            address.setFirstNameKana(this.first_name_kana.getValue());
            address.setEmail(this.email.getValue());
            if (!(this.telephone1.getValue().equals("") || this.telephone2.getValue().equals("") || this.telephone3.getValue().equals(""))) {
                address.setTelephone(new StringBuffer().append(this.telephone1.getValue()).append("-").append(this.telephone2.getValue()).append("-").append(this.telephone3.getValue()).toString());
            } else {
                address.setTelephone("");
            }
            if (!(this.cellular_phone1.getValue().equals("") || this.cellular_phone2.getValue().equals("") || this.cellular_phone3.getValue().equals(""))) {
                address.setCellularPhone(new StringBuffer().append(this.cellular_phone1.getValue()).append("-").append(this.cellular_phone2.getValue()).append("-").append(this.cellular_phone3.getValue()).toString());
            } else {
                address.setCellularPhone("");
            }
            address.setCellularMail(this.cellular_mail.getValue());
            boolean hasCompany = false;
            if (this.company_id.getValue() > 0L && (company = (EipMAddressbookCompany)Database.get(EipMAddressbookCompany.class, (Object)((int)this.company_id.getValue()))).getCompanyId() > 0) {
                address.setEipMAddressbookCompany(company);
                hasCompany = true;
            }
            if (!hasCompany) {
                company = AddressBookUtils.getDummyEipMAddressbookCompany(rundata, context);
                address.setEipMAddressbookCompany(company);
            }
            address.setPositionName(this.position_name.getValue());
            address.setNote(this.note.getValue());
            if (this.user_id == address.getOwnerId()) {
                address.setPublicFlag(this.public_flag.getValue());
            }
            address.setUpdateUserId(Integer.valueOf(uid));
            address.setUpdateDate(new Date());
            String addressid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            SelectQuery query1 = Database.query(EipMAddressGroup.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"ownerId", (Object)uid);
            query1.setQualifier(exp1);
            List list = query1.fetchList();
            int listsize = list.size();
            Object[] groupIds = new Integer[listsize];
            for (int i = 0; i < listsize; ++i) {
                groupIds[i] = ((EipMAddressGroup)list.get(i)).getGroupId();
            }
            if (listsize != 0) {
                SelectQuery query2 = Database.query(EipTAddressbookGroupMap.class);
                Expression exp2 = ExpressionFactory.inDbExp((String)"group_id", (Object[])groupIds);
                query2.setQualifier(exp2);
                Expression exp3 = ExpressionFactory.matchExp((String)"addressId", (Object)addressid);
                query2.setQualifier(exp3);
                List maps = query2.fetchList();
                Database.deleteAll((List)maps);
            }
            int groupsize = this.groups.size();
            for (int i = 0; i < groupsize; ++i) {
                EipTAddressbookGroupMap map = (EipTAddressbookGroupMap)Database.create(EipTAddressbookGroupMap.class);
                map.setEipMAddressbook((EipMAddressbook)Database.get(EipMAddressbook.class, (Object)Integer.valueOf(addressid)));
                map.setEipTAddressGroup((EipMAddressGroup)this.groups.get(i));
            }
            Database.commit();
            String name = new StringBuffer().append(this.lastname.getValue()).append(" ").append(this.firstname.getValue()).toString();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(address.getAddressId().intValue(), 160, name);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AddressBookFormData.updateFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        this.groups = new ArrayList<Object>();
        if (res) {
            try {
                Object[] str = rundata.getParameters().getStrings("group_to");
                if (str == null) {
                    return res;
                }
                if (this.isEmpty((String[])str)) {
                    return res;
                }
                SelectQuery query = Database.query(EipMAddressGroup.class);
                Expression exp = ExpressionFactory.inDbExp((String)"GROUP_ID", (Object[])str);
                query.setQualifier(exp);
                List list = query.fetchList();
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    EipMAddressGroup group = (EipMAddressGroup)list.get(i);
                    this.groups.add(group);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"AddressBookFormData.setFormData", (Throwable)ex);
            }
        }
        return res;
    }

    private boolean isEmpty(String[] str) {
        boolean res = true;
        for (int i = 0; i < str.length; ++i) {
            if (str[i] == null || "".equals(str[i])) continue;
            res = false;
        }
        return res;
    }

    public ALStringField getCellularMail() {
        return this.cellular_mail;
    }

    public ALStringField getCellularPhone1() {
        return this.cellular_phone1;
    }

    public ALStringField getCellularPhone2() {
        return this.cellular_phone2;
    }

    public ALStringField getCellularPhone3() {
        return this.cellular_phone3;
    }

    public ALNumberField getCompanyId() {
        return this.company_id;
    }

    public ALStringField getEmail() {
        return this.email;
    }

    public ALStringField getFirstNameKana() {
        return this.first_name_kana;
    }

    public ALStringField getFirstName() {
        return this.firstname;
    }

    public ALStringField getLastNameKana() {
        return this.last_name_kana;
    }

    public ALStringField getLastName() {
        return this.lastname;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALStringField getPositionName() {
        return this.position_name;
    }

    public ALStringField getPublicFlag() {
        return this.public_flag;
    }

    public ALStringField getTelephone1() {
        return this.telephone1;
    }

    public ALStringField getTelephone2() {
        return this.telephone2;
    }

    public ALStringField getTelephone3() {
        return this.telephone3;
    }

    public void setCellularMail(ALStringField field) {
        this.cellular_mail = field;
    }

    public void setCompanyId(ALNumberField field) {
        this.company_id = field;
    }

    public void setEmail(ALStringField field) {
        this.email = field;
    }

    public void setFirstNameKana(ALStringField field) {
        this.first_name_kana = field;
    }

    public void setFirstName(ALStringField field) {
        this.firstname = field;
    }

    public void setLastNameKana(ALStringField field) {
        this.last_name_kana = field;
    }

    public void setLastName(ALStringField field) {
        this.lastname = field;
    }

    public void setNote(ALStringField field) {
        this.note = field;
    }

    public void setPositionName(ALStringField field) {
        this.position_name = field;
    }

    public void setPublicFlag(ALStringField field) {
        this.public_flag = field;
    }

    public ALDateField getCreateDate() {
        return this.create_date;
    }

    public ALDateField getUpdateDate() {
        return this.update_date;
    }

    public void setCreateDate(ALDateField field) {
        this.create_date = field;
    }

    public ALStringField getCreateUser() {
        return this.create_user;
    }

    public void setUpdateDate(ALDateField field) {
        this.update_date = field;
    }

    public ALStringField getUpdateUser() {
        return this.update_user;
    }

    public List<AddressBookGroupResultData> getGroupList() {
        return this.groupList;
    }

    public List<AddressBookCompanyResultData> getCompanyList() {
        return this.companyList;
    }

    public ALStringField getGroupNames() {
        return this.group_names;
    }

    public void setGroupNames(ALStringField field) {
        this.group_names = field;
    }

    public List<Object> getGroups() {
        return this.groups;
    }

    public ALStringField getCompanyName() {
        return this.company_name;
    }

    public ALStringField getCompanyNameKana() {
        return this.company_name_kana;
    }

    public ALStringField getPostName() {
        return this.post_name;
    }

    public ALStringField getCompZipcode1() {
        return this.comp_zipcode1;
    }

    public ALStringField getCompZipcode2() {
        return this.comp_zipcode2;
    }

    public ALStringField getCompAddress() {
        return this.comp_address;
    }

    public ALStringField getCompTelephone1() {
        return this.comp_telephone1;
    }

    public ALStringField getCompTelephone2() {
        return this.comp_telephone2;
    }

    public ALStringField getCompTelephone3() {
        return this.comp_telephone3;
    }

    public ALStringField getCompFaxNumber1() {
        return this.comp_fax_number1;
    }

    public ALStringField getCompFaxNumber2() {
        return this.comp_fax_number2;
    }

    public ALStringField getCompFaxNumber3() {
        return this.comp_fax_number3;
    }

    public ALStringField getCompUrl() {
        return this.comp_url;
    }

    public boolean isNewCompany() {
        return this.is_new_company;
    }

    public int getUserId() {
        return this.user_id;
    }

    public int getOwnerId() {
        return this.owner_id;
    }

    private boolean insertCompanyData(RunData rundata, Context context) {
        int uid = ALEipUtils.getUserId((RunData)rundata);
        try {
            EipMAddressbookCompany company = (EipMAddressbookCompany)Database.create(EipMAddressbookCompany.class);
            rundata.getParameters().setProperties((Object)company);
            company.setCompanyName(this.company_name.getValue());
            company.setCompanyNameKana(this.company_name_kana.getValue());
            company.setPostName(this.post_name.getValue());
            if (!this.comp_zipcode1.getValue().equals("") && !this.comp_zipcode2.getValue().equals("")) {
                company.setZipcode(new StringBuffer().append(this.comp_zipcode1.getValue()).append("-").append(this.comp_zipcode2.getValue()).toString());
            } else {
                company.setZipcode("");
            }
            company.setAddress(this.comp_address.getValue());
            if (!(this.comp_telephone1.getValue().equals("") || this.comp_telephone2.getValue().equals("") || this.comp_telephone3.getValue().equals(""))) {
                company.setTelephone(new StringBuffer().append(this.comp_telephone1.getValue()).append("-").append(this.comp_telephone2.getValue()).append("-").append(this.comp_telephone3.getValue()).toString());
            } else {
                company.setTelephone("");
            }
            if (!(this.comp_fax_number1.getValue().equals("") || this.comp_fax_number2.getValue().equals("") || this.comp_fax_number3.getValue().equals(""))) {
                company.setFaxNumber(new StringBuffer().append(this.comp_fax_number1.getValue()).append("-").append(this.comp_fax_number2.getValue()).append("-").append(this.comp_fax_number3.getValue()).toString());
            } else {
                company.setFaxNumber("");
            }
            company.setUrl(this.comp_url.getValue());
            company.setCreateUserId(Integer.valueOf(uid));
            company.setUpdateUserId(Integer.valueOf(uid));
            Date now = new Date();
            company.setCreateDate(now);
            company.setUpdateDate(now);
            Database.commit();
            this.company_id.setValue(company.getCompanyId().longValue());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AddressBookFormData.insertCompanyData", (Throwable)ex);
            return false;
        }
        return true;
    }

    public String getAclPortletFeature() {
        return "addressbook_address_outside";
    }

    protected boolean doCheckAclPermission(RunData rundata, Context context, int defineAclType) throws ALPermissionException {
        boolean tmp = super.doCheckAclPermission(rundata, context, defineAclType);
        if (defineAclType == 2 || defineAclType == 4 || defineAclType == 16) {
            super.doCheckAclPermission(rundata, context, 1);
            this.hasAuthority = this.hasAuthority && tmp;
        }
        return true;
    }
}

