/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.addressbook.AbstractAddressBookWordSelectData;
import com.aimluck.eip.addressbook.AddressBookGroupResultData;
import com.aimluck.eip.addressbook.AddressBookResultData;
import com.aimluck.eip.addressbook.util.AddressBookUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookWordSelectData
extends AbstractAddressBookWordSelectData<EipMAddressbook, EipMAddressbook> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookWordSelectData.class.getName());
    private List<AddressBookGroupResultData> groupList;
    private final List<ALEipGroup> myGroupList = null;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    protected ResultList<EipMAddressbook> selectList(RunData rundata, Context context) {
        ResultList list;
        try {
            SelectQuery<EipMAddressbook> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            list = query.getResultList();
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookWordSelectData.selectList", (Throwable)ex);
            return null;
        }
        return list;
    }

    protected EipMAddressbook selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultData(EipMAddressbook obj) {
        try {
            AddressBookResultData rd = new AddressBookResultData();
            EipMAddressbook record = obj;
            rd.initField();
            rd.setAddressId(record.getAddressId());
            rd.setName(ALCommonUtils.compressString((String)new StringBuffer().append(record.getLastName()).append(" ").append(record.getFirstName()).toString(), (int)this.getStrLength()));
            rd.setNameKana(ALCommonUtils.compressString((String)new StringBuffer().append(record.getLastNameKana()).append(" ").append(record.getFirstNameKana()).toString(), (int)this.getStrLength()));
            EipMAddressbookCompany company = record.getEipMAddressbookCompany();
            if (!"".equals(company.getCompanyName())) {
                rd.setCompanyId(company.getCompanyId().toString());
                rd.setCompanyName(ALCommonUtils.compressString((String)company.getCompanyName(), (int)this.getStrLength()));
                rd.setPostName(ALCommonUtils.compressString((String)company.getPostName(), (int)this.getStrLength()));
            }
            rd.setPositionName(ALCommonUtils.compressString((String)record.getPositionName(), (int)this.getStrLength()));
            rd.setEmail(ALCommonUtils.compressString((String)record.getEmail(), (int)this.getStrLength()));
            rd.setTelephone(record.getTelephone());
            rd.setCellularPhone(record.getCellularPhone());
            rd.setCellularMail(record.getCellularMail());
            rd.setPublicFlag(record.getPublicFlag());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookWordSelectData.getResultData", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(EipMAddressbook obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("group", "eipTAddressbookGroupMap.eipTAddressGroup.GROUP_ID");
        map.putValue("name_kana", "lastNameKana");
        map.putValue("company_name_kana", "eipMAddressbookCompany.companyNameKana");
        return map;
    }

    private SelectQuery<EipMAddressbook> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = null;
        String word = this.searchWord.getValue();
        String transWord = ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.searchWord.getValue()));
        transWord = transWord.replace("\u3000", " ");
        String[] transWords = transWord.split(" ");
        query = Database.query(EipMAddressbook.class);
        for (int i = 0; i < transWords.length; ++i) {
            Expression exp01 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
            Expression exp02 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            Expression exp03 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"F");
            query.setQualifier(exp01.orExp(exp02.andExp(exp03)));
            Expression exp11 = ExpressionFactory.likeExp((String)"firstName", (Object)("%" + word + "%"));
            Expression exp12 = ExpressionFactory.likeExp((String)"lastName", (Object)("%" + word + "%"));
            Expression exp13 = ExpressionFactory.likeExp((String)"firstNameKana", (Object)("%" + word + "%"));
            Expression exp14 = ExpressionFactory.likeExp((String)"lastNameKana", (Object)("%" + word + "%"));
            Expression exp15 = ExpressionFactory.likeExp((String)"email", (Object)("%" + word + "%"));
            Expression exp16 = ExpressionFactory.likeExp((String)"telephone", (Object)("%" + word + "%"));
            Expression exp17 = ExpressionFactory.likeExp((String)"cellularPhone", (Object)("%" + word + "%"));
            Expression exp18 = ExpressionFactory.likeExp((String)"cellularMail", (Object)("%" + word + "%"));
            Expression exp19 = ExpressionFactory.likeExp((String)"note", (Object)("%" + word + "%"));
            Expression exp21 = ExpressionFactory.likeExp((String)"eipMAddressbookCompany.companyName", (Object)("%" + word + "%"));
            Expression exp22 = ExpressionFactory.likeExp((String)"eipMAddressbookCompany.companyNameKana", (Object)("%" + word + "%"));
            Expression exp23 = ExpressionFactory.likeExp((String)"eipMAddressbookCompany.telephone", (Object)("%" + word + "%"));
            Expression exp31 = ExpressionFactory.likeExp((String)"firstName", (Object)("%" + transWords[i] + "%"));
            Expression exp32 = ExpressionFactory.likeExp((String)"lastName", (Object)("%" + transWords[i] + "%"));
            Expression exp33 = ExpressionFactory.likeExp((String)"firstNameKana", (Object)("%" + transWords[i] + "%"));
            Expression exp34 = ExpressionFactory.likeExp((String)"lastNameKana", (Object)("%" + transWords[i] + "%"));
            Expression exp35 = ExpressionFactory.likeExp((String)"eipMAddressbookCompany.companyName", (Object)("%" + transWords[i] + "%"));
            Expression exp36 = ExpressionFactory.likeExp((String)"eipMAddressbookCompany.companyNameKana", (Object)("%" + transWords[i] + "%"));
            Expression exp37 = ExpressionFactory.likeExp((String)"note", (Object)("%" + transWords[i] + "%"));
            if (word == null || "".equals(word)) continue;
            query.andQualifier(exp11.orExp(exp12).orExp(exp13).orExp(exp14).orExp(exp15).orExp(exp16).orExp(exp17).orExp(exp18).orExp(exp19).orExp(exp21).orExp(exp22).orExp(exp23).orExp(exp31).orExp(exp32).orExp(exp33).orExp(exp34).orExp(exp35).orExp(exp36).orExp(exp37));
        }
        return query;
    }

    @Override
    public void loadGroups(RunData rundata, Context context) {
        this.groupList = AddressBookUtils.getMyGroups(rundata);
    }

    @Override
    public List<AddressBookGroupResultData> getGroupList() {
        return this.groupList;
    }

    @Override
    public List<ALEipGroup> getMyGroupList() {
        return this.myGroupList;
    }

    public String getAclPortletFeature() {
        return "addressbook_address_outside";
    }

    @Override
    public String getTemplateFilePath() {
        return "portlets/html/ja/ajax-addressbook-list.vm";
    }
}

