/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.addressbook.AddressBookFilterdSelectData;
import com.aimluck.eip.addressbook.AddressBookResultData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.screens.ALXlsScreen;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookWordXlsExportScreen
extends ALXlsScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookWordXlsExportScreen.class.getName());
    public static final String FILE_NAME = "addressbook.xls";
    private String userid;
    private String aclPortletFeature = null;

    public void init(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String target_user_id = rundata.getParameters().getString("target_user_id");
        this.userid = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        if (this.userid.equals(target_user_id)) {
            this.aclPortletFeature = "addressbook_address_outside";
        }
        super.init(rundata, context);
    }

    protected boolean createHSSFWorkbook(RunData rundata, Context context, HSSFWorkbook wb) {
        try {
            this.setupAddressBookSheet(rundata, context, wb);
        }
        catch (Exception e) {
            logger.error((Object)"AddressBookWordXlsExportScreen.createHSSFWorkbook", (Throwable)e);
            return false;
        }
        return true;
    }

    private void setupAddressBookSheet(RunData rundata, Context context, HSSFWorkbook wb) throws Exception {
        String sheet_name = "\u30a2\u30c9\u30ec\u30b9\u30d6\u30c3\u30af";
        String[] headers = new String[]{"\u540d\u524d", "\u540d\u524d\uff08\u30d5\u30ea\u30ac\u30ca\uff09", "\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9", "\u96fb\u8a71\u756a\u53f7", "\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09", "\u643a\u5e2f\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9", "\u4f1a\u793e\u540d", "\u4f1a\u793e\u540d\uff08\u30d5\u30ea\u30ac\u30ca\uff09", "\u90e8\u7f72\u540d", "\u90f5\u4fbf\u756a\u53f7", "\u4f4f\u6240", "\u96fb\u8a71\u756a\u53f7", "FAX\u756a\u53f7", "URL", "\u5f79\u8077\u540d", "\u5099\u8003"};
        short[] cell_enc_types = new short[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        HSSFSheet sheet = this.createHSSFSheet(wb, sheet_name, headers, cell_enc_types);
        int rowcount = 0;
        HSSFCellStyle style_col = wb.createCellStyle();
        style_col.setVerticalAlignment((short)1);
        style_col.setAlignment((short)5);
        AddressBookFilterdSelectData listData = new AddressBookFilterdSelectData();
        listData.initField();
        listData.setRowsNum(1000);
        listData.doSelectList((ALAction)this, rundata, context);
        listData.loadGroups(rundata, context);
        int page_num = listData.getPagesNum();
        int current_page = 1;
        while (true) {
            int listsize = listData.getList().size();
            for (int j = 0; j < listsize; ++j) {
                AddressBookResultData rd = (AddressBookResultData)listData.getList().get(j);
                String[] rows = new String[]{rd.getName().getValue(), rd.getNameKana().getValue(), rd.getEmail().getValue(), rd.getTelephone().getValue(), rd.getCellularPhone().getValue(), rd.getCellularMail().getValue(), rd.getCompanyName().getValue(), rd.getCompanyNameKana().getValue(), rd.getPostName().getValue(), rd.getZipcode().getValue(), rd.getCompanyAddress().getValue(), rd.getCompanyTelephone().getValue(), rd.getCompanyFaxNumber().getValue(), rd.getCompanyUrl().getValue(), rd.getPositionName().getValue(), rd.getNoteRaw()};
                this.addRow(sheet.createRow(++rowcount), cell_enc_types, rows);
            }
            if (++current_page > page_num) break;
            listData.setCurrentPage(current_page);
            listData.doSelectList((ALAction)this, rundata, context);
        }
        int uid = ALEipUtils.getUserId((RunData)rundata);
        ALEventlogFactoryService.getInstance().getEventlogHandler().logXlsScreen(uid, "\u30a2\u30c9\u30ec\u30b9\u30d6\u30c3\u30af\u51fa\u529b", 163);
    }

    protected String getFileName() {
        return FILE_NAME;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

