/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratum.scheduler;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.betwixt.strategy.DecapitalizeNameMapper;
import org.apache.commons.betwixt.strategy.DefaultPluralStemmer;
import org.apache.commons.betwixt.strategy.NameMapper;
import org.apache.commons.betwixt.strategy.PluralStemmer;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.exception.NestableException;
import org.apache.log4j.Category;
import org.apache.stratum.lifecycle.Configurable;
import org.apache.stratum.lifecycle.Startable;
import org.apache.stratum.scheduler.JobConfig;
import org.apache.stratum.scheduler.JobStoreConfig;
import org.apache.stratum.scheduler.LoggerConfig;
import org.apache.stratum.scheduler.SchedulerConfig;
import org.apache.stratum.scheduler.ThreadPoolConfig;
import org.apache.stratum.scheduler.TriggerConfig;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.StdSchedulerFactory;

public class Scheduler
implements Configurable,
Startable {
    private static Category log = Category.getInstance((Class)(class$org$apache$stratum$scheduler$Scheduler == null ? (class$org$apache$stratum$scheduler$Scheduler = Scheduler.class$("org.apache.stratum.scheduler.Scheduler")) : class$org$apache$stratum$scheduler$Scheduler));
    private static String confLocation = "/projects/jakarta-turbine-stratum/src/test-conf/Scheduler.properties";
    private StdSchedulerFactory schedulerFactory;
    protected StdScheduler scheduler;
    static /* synthetic */ Class class$org$apache$stratum$scheduler$Scheduler;
    static /* synthetic */ Class class$org$apache$stratum$scheduler$SchedulerConfig;

    public static void main(String[] args) throws Exception {
        Scheduler sched = new Scheduler();
        PropertiesConfiguration conf = new PropertiesConfiguration(confLocation);
        sched.configure((Configuration)conf);
        sched.start();
    }

    public void start() throws Exception {
        this.scheduler.start();
    }

    public void stop() throws Exception {
        this.scheduler.shutdown();
    }

    public void configure(Configuration configuration) throws NestableException {
        String xmlLocation = configuration.getString("scheduler.config.location");
        try {
            Properties factoryProps;
            SchedulerConfig schedConfig = this.getSchedulerConfig(xmlLocation);
            try {
                factoryProps = this.getFactoryProps(schedConfig);
            }
            catch (NullPointerException ex) {
                log.error((Object)"Error loading properties to initialize Scheduler Factory. Please make sure the following elements are properly filled out in the Scheduler .xml config file:\n   <instanceName></instanceName>\n   <loggerName></loggerName>\n    <threadPoolConfig>\n     <className></className>\n     <threadCount></threadCount>\n     <threadPriority></threadPriority>\n     <loggerName></loggerName>\n   </threadPoolConfig>\n   <jobStoreConfig>\n     <className></className>\n     <loggerName></loggerName>\n   </jobStoreConfig>");
                return;
            }
            this.schedulerFactory = new StdSchedulerFactory();
            this.schedulerFactory.initialize(factoryProps);
            this.scheduler = (StdScheduler)this.schedulerFactory.getScheduler();
            List jobConfigs = schedConfig.getJobConfigs();
            if (!jobConfigs.isEmpty()) {
                int i = 0;
                while (i < jobConfigs.size()) {
                    String jobClassName;
                    JobConfig jobConf = (JobConfig)jobConfigs.get(i);
                    String jobName = jobConf.getName();
                    String jobPrefix = "scheduler.job." + jobName;
                    String jobGroup = jobConf.getGroup();
                    JobDetail job = new JobDetail(jobName, jobGroup, Class.forName(jobClassName = jobConf.getClassName()));
                    TriggerConfig triggerConf = this.getTriggerConfig(schedConfig, job.getName());
                    if (triggerConf != null) {
                        job.getName();
                        String triggerGroup = triggerConf.getGroup();
                        String triggerName = triggerConf.getName();
                        String cronExpression = triggerConf.getSeconds() + " " + triggerConf.getMinutes() + " " + triggerConf.getHours() + " " + triggerConf.getDayOfMonth() + " " + triggerConf.getMonth() + " " + triggerConf.getDayOfWeek();
                        CronTrigger cronTrigger = new CronTrigger(triggerName, triggerGroup, jobName, jobGroup, cronExpression);
                        this.scheduler.scheduleJob(job, (Trigger)cronTrigger);
                        triggerConf = null;
                        cronTrigger = null;
                    }
                    ++i;
                }
            }
        }
        catch (SchedulerException ex) {
            log.error((Object)("Error Initializing Scheduler:  " + ex.toString()), (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            log.error((Object)("Error Loading class:  " + ex.toString()), (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)("Error:  " + ex.toString()), (Throwable)ex);
        }
    }

    private Properties getFactoryProps(SchedulerConfig schdConf) {
        Properties props = new Properties();
        props.put("org.quartz.scheduler.instanceName", schdConf.getInstanceName());
        props.put("org.quartz.scheduler.logger", schdConf.getLoggerName());
        List loggers = schdConf.getLoggerConfigs();
        int i = 0;
        while (i < loggers.size()) {
            LoggerConfig logger = (LoggerConfig)loggers.get(i);
            String loggerName = "org.quartz.logger." + logger.getName();
            props.put(loggerName + ".class", logger.getClassName());
            props.put(loggerName + ".loggingPriority", logger.getPriority());
            props.put(loggerName + ".outputFile", logger.getOutputFile());
            if (logger.getCategory() != null) {
                props.put(loggerName + ".categoryName", logger.getCategory());
            }
            ++i;
        }
        ThreadPoolConfig threadPool = schdConf.getThreadPoolConfig();
        props.put("org.quartz.threadPool.class", threadPool.getClassName());
        props.put("org.quartz.threadPool.threadCount", threadPool.getThreadCount());
        props.put("org.quartz.threadPool.threadPriority", threadPool.getThreadPriority());
        props.put("org.quartz.threadPool.logger", threadPool.getLoggerName());
        JobStoreConfig jobStore = schdConf.getJobStoreConfig();
        props.put("org.quartz.jobStore.class", jobStore.getClassName());
        props.put("org.quartz.jobStore.logger", jobStore.getLoggerName());
        return props;
    }

    private SchedulerConfig getSchedulerConfig(String xmlLocation) throws Exception {
        FileInputStream in = new FileInputStream(xmlLocation);
        BeanReader reader = this.createBeanReader();
        SchedulerConfig schedConf = (SchedulerConfig)reader.parse((InputStream)in);
        return schedConf;
    }

    private BeanReader createBeanReader() throws Exception {
        BeanReader reader = new BeanReader();
        reader.setXMLIntrospector(this.createXMLIntrospector());
        reader.registerBeanClass(class$org$apache$stratum$scheduler$SchedulerConfig == null ? (class$org$apache$stratum$scheduler$SchedulerConfig = Scheduler.class$("org.apache.stratum.scheduler.SchedulerConfig")) : class$org$apache$stratum$scheduler$SchedulerConfig);
        return reader;
    }

    private XMLIntrospector createXMLIntrospector() {
        XMLIntrospector introspector = new XMLIntrospector();
        introspector.setAttributesForPrimitives(false);
        introspector.setNameMapper((NameMapper)new DecapitalizeNameMapper());
        introspector.setPluralStemmer((PluralStemmer)new DefaultPluralStemmer());
        return introspector;
    }

    private TriggerConfig getTriggerConfig(SchedulerConfig schedConf, String jobName) {
        TriggerConfig trig = null;
        List triggers = schedConf.getTriggerConfigs();
        int i = 0;
        while (i < triggers.size()) {
            TriggerConfig tmpTrig = (TriggerConfig)triggers.get(i);
            if (tmpTrig.getJobName().equals(jobName)) {
                trig = tmpTrig;
                return trig;
            }
            ++i;
        }
        return trig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

