/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.project;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTProject;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectFile;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectMember;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.project.util.ProjectFile;
import com.aimluck.eip.project.util.ProjectUtils;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ProjectFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ProjectFormData.class.getName());
    private ALStringField project_name;
    private ALStringField explanation;
    private ALNumberField admin_user_id;
    private ALStringField admin_user_name;
    private ALNumberField progress_rate;
    private ALStringField progress_flg;
    private ALEipUser loginUser;
    private List<FileuploadBean> fileuploadList;
    private String folderName;
    private int uid;
    private String orgId;
    private List<ALEipUser> memberList;
    private List<ALEipGroup> myGroupList;
    private final ProjectFile<EipTProjectFile, EipTProject> pfile = new ProjectFile(EipTProjectFile.class);

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        rundata.getUser().setTemp("mygroup", null);
        this.loginUser = ALEipUtils.getALEipUser((RunData)rundata);
        this.myGroupList = ALEipUtils.getMyGroups((RunData)rundata);
        this.folderName = rundata.getParameters().getString("folderName");
        this.uid = ALEipUtils.getUserId((RunData)rundata);
    }

    public void initField() {
        this.project_name = new ALStringField();
        this.project_name.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_NAME"));
        this.project_name.setTrim(true);
        this.explanation = new ALStringField();
        this.explanation.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_EXPLANATION"));
        this.explanation.setTrim(true);
        this.admin_user_id = new ALNumberField();
        this.admin_user_id.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_ADMIN_USER"));
        this.progress_rate = new ALNumberField();
        this.progress_rate.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_PROGRESS_RATE"));
        this.progress_rate.setValue(0L);
        this.progress_flg = new ALStringField();
        this.progress_flg.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_MAIL_SEND"));
        this.progress_flg.setTrim(false);
        this.progress_flg.setValue("f");
        this.fileuploadList = new ArrayList<FileuploadBean>();
        this.memberList = new ArrayList<ALEipUser>();
    }

    protected void setValidator() {
        this.project_name.setNotNull(true);
        this.project_name.limitMaxLength(50);
        this.admin_user_id.setNotNull(true);
        this.progress_rate.limitMaxValue(100L);
        this.progress_rate.limitMinValue(0L);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            if (res) {
                Object[] memberNames = rundata.getParameters().getStrings("members");
                if (memberNames != null && memberNames.length > 0) {
                    SelectQuery query = Database.query(TurbineUser.class);
                    Expression exp = ExpressionFactory.inExp((String)"loginName", (Object[])memberNames);
                    query.setQualifier(exp);
                    this.memberList.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
                }
                this.fileuploadList = this.pfile.getFileuploadList(rundata);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            res = false;
        }
        return res;
    }

    protected boolean validate(List<String> msgList) {
        try {
            this.project_name.validate(msgList);
            this.admin_user_id.validate(msgList);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return msgList.isEmpty();
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTProject project = ProjectUtils.getEipTProject(rundata, context);
            if (project == null) {
                return false;
            }
            this.project_name.setValue(project.getProjectName());
            this.explanation.setValue(project.getExplanation());
            this.admin_user_id.setValue((long)project.getAdminUserId().intValue());
            this.progress_rate.setValue((long)project.getProgressRate().intValue());
            this.progress_flg.setValue(project.getProgressFlg());
            List<EipTProjectMember> members = ProjectUtils.getEipTProjectMember(project);
            EipTProjectMember member = null;
            int size = members.size();
            for (int i = 0; i < size; ++i) {
                member = members.get(i);
                int user_id = member.getUserId();
                this.memberList.add(ALEipUtils.getALEipUser((int)user_id));
            }
            List files = this.pfile.getSelectQueryForFiles("PROJECT_ID", project.getProjectId()).fetchList();
            this.fileuploadList = this.pfile.getFileList(files);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)this.loginUser.getUserId().getValueWithInt());
            EipTProject project = (EipTProject)Database.create(EipTProject.class);
            project.setProjectName(this.project_name.getValue());
            project.setExplanation(this.explanation.getValue());
            project.setAdminUserId(Integer.valueOf((int)this.admin_user_id.getValue()));
            project.setProgressFlg(this.progress_flg.getValue());
            project.setTurbineUser(tuser);
            project.setUpdateUserId(tuser.getUserId());
            project.setCreateDate(Calendar.getInstance().getTime());
            project.setUpdateDate(Calendar.getInstance().getTime());
            int progressRate = (int)this.progress_rate.getValue();
            if ("t".equals(this.progress_flg.getValue())) {
                progressRate = 0;
            }
            project.setProgressRate(Integer.valueOf(progressRate));
            Database.commit();
            ArrayList<ALEipUser> mailUserList = new ArrayList<ALEipUser>();
            boolean containsAdminUser = false;
            for (ALEipUser user : this.memberList) {
                EipTProjectMember member = (EipTProjectMember)Database.create(EipTProjectMember.class);
                member.setEipTProject(project);
                member.setUserId(Integer.valueOf((int)user.getUserId().getValue()));
                if (this.admin_user_id.getValue() == user.getUserId().getValue()) {
                    containsAdminUser = true;
                }
                mailUserList.add(user);
            }
            if (!containsAdminUser) {
                ALEipUser user;
                EipTProjectMember member = (EipTProjectMember)Database.create(EipTProjectMember.class);
                member.setEipTProject(project);
                member.setUserId(Integer.valueOf((int)this.admin_user_id.getValue()));
                user = ALEipUtils.getALEipUser((int)((int)this.admin_user_id.getValue()));
                if (user != null) {
                    mailUserList.add(user);
                }
            }
            if (mailUserList.size() > 0) {
                ProjectUtils.sendMailForProjectMembers(rundata, context, project, mailUserList);
            }
            Database.commit();
            this.pfile.insertAttachmentFiles(this.fileuploadList, this.folderName, this.uid, project, msgList);
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(project.getProjectId().intValue(), 370, ALLocalizationUtils.getl10nFormat((String)"PROJECT_EVENTLOG_ADD", (Object[])new Object[]{project.getProjectName()}));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTProject project = ProjectUtils.getEipTProject(rundata, context);
            if (project == null) {
                return false;
            }
            TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)this.loginUser.getUserId().getValueWithInt());
            project.setProjectName(this.project_name.getValue());
            project.setExplanation(this.explanation.getValue());
            project.setAdminUserId(Integer.valueOf((int)this.admin_user_id.getValue()));
            project.setProgressFlg(this.progress_flg.getValue());
            project.setUpdateUserId(tuser.getUserId());
            project.setUpdateDate(Calendar.getInstance().getTime());
            int progressRate = (int)this.progress_rate.getValue();
            if ("t".equals(this.progress_flg.getValue())) {
                progressRate = ProjectUtils.getProjectProgressRate(project.getProjectId());
            }
            project.setProgressRate(Integer.valueOf(progressRate));
            List<ALEipUser> oldMenber = ProjectUtils.getProjectMembers(project.getProjectId());
            ArrayList<Integer> oldMemberIdList = new ArrayList<Integer>();
            for (ALEipUser rd : oldMenber) {
                oldMemberIdList.add(rd.getUserId().getValueWithInt());
            }
            ProjectUtils.removeProjectMember(project);
            ArrayList<ALEipUser> mailUserList = new ArrayList<ALEipUser>();
            boolean containsAdminUser = false;
            for (ALEipUser user : this.memberList) {
                EipTProjectMember member = (EipTProjectMember)Database.create(EipTProjectMember.class);
                member.setEipTProject(project);
                member.setUserId(Integer.valueOf((int)user.getUserId().getValue()));
                if (this.admin_user_id.getValue() == user.getUserId().getValue()) {
                    containsAdminUser = true;
                }
                if (oldMemberIdList.contains(member.getUserId())) continue;
                mailUserList.add(user);
            }
            if (!containsAdminUser) {
                ALEipUser user;
                EipTProjectMember member = (EipTProjectMember)Database.create(EipTProjectMember.class);
                member.setEipTProject(project);
                member.setUserId(Integer.valueOf((int)this.admin_user_id.getValue()));
                user = ALEipUtils.getALEipUser((int)((int)this.admin_user_id.getValue()));
                if (user != null) {
                    mailUserList.add(user);
                }
            }
            if (mailUserList.size() > 0) {
                ProjectUtils.sendMailForProjectMembers(rundata, context, project, mailUserList);
            }
            List<Integer> attIdList = this.pfile.getRequestedHasFileIdList(this.fileuploadList);
            List files = this.pfile.getSelectQueryForFiles("PROJECT_ID", project.getProjectId()).fetchList();
            if (files != null) {
                for (int i = 0; i < files.size(); ++i) {
                    EipTProjectFile file = (EipTProjectFile)files.get(i);
                    if (attIdList.contains(file.getFileId())) continue;
                    ALStorageService.deleteFile((String)(ProjectFile.getSaveDirPath(this.uid) + file.getFilePath()));
                    Database.delete((Persistent)file);
                }
            }
            this.pfile.insertAttachmentFiles(this.fileuploadList, this.folderName, this.uid, project, msgList);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(project.getProjectId().intValue(), 370, ALLocalizationUtils.getl10nFormat((String)"PROJECT_EVENTLOG_UPDATE", (Object[])new Object[]{project.getProjectName()}));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            int fsize;
            EipTProject project = ProjectUtils.getEipTProject(rundata, context);
            if (project == null) {
                return false;
            }
            if (!ProjectUtils.getEipTProjectTaskCheck(project.getProjectId())) {
                msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_VALIDATE_NOT_DELETE"));
                return false;
            }
            Database.delete((Persistent)project);
            ArrayList<String> fpaths = new ArrayList<String>();
            SelectQuery query = Database.query(EipTProjectFile.class);
            query.andQualifier(ExpressionFactory.matchExp((String)"eipTProject", (Object)project.getProjectId()));
            List files = query.fetchList();
            if (files != null && files.size() > 0) {
                fsize = files.size();
                for (int j = 0; j < fsize; ++j) {
                    fpaths.add(((EipTProjectFile)files.get(j)).getFilePath());
                }
            }
            if (fpaths.size() > 0) {
                fsize = fpaths.size();
                for (int i = 0; i < fsize; ++i) {
                    ALStorageService.deleteFile((String)(ProjectUtils.getSaveDirPath(this.orgId, this.uid) + (String)fpaths.get(i)));
                }
            }
            List<EipTProjectMember> member = ProjectUtils.getEipTProjectMember(project);
            Database.deleteAll(member);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(project.getProjectId().intValue(), 370, ALLocalizationUtils.getl10nFormat((String)"PROJECT_EVENTLOG_DELETE", (Object[])new Object[]{project.getProjectName()}));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getProjectName() {
        return this.project_name;
    }

    public ALStringField getExplanation() {
        return this.explanation;
    }

    public ALNumberField getAdminUserId() {
        return this.admin_user_id;
    }

    public ALStringField getProgressFlg() {
        return this.progress_flg;
    }

    public ALNumberField getProgressRate() {
        return this.progress_rate;
    }

    public List<ALEipGroup> getMyGroupList() {
        return this.myGroupList;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public int getLoginUserId() {
        return this.loginUser.getUserId().getValueWithInt();
    }

    public List<FileuploadBean> getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public ALStringField getAdmin_user_name() {
        return this.admin_user_name;
    }

    public List<ALEipUser> getMemberList() {
        return this.memberList;
    }

    public void setMemberList(ArrayList<ALEipUser> list) {
        this.memberList = list;
    }
}

