/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.project;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ProjectResultData
implements ALData {
    protected ALNumberField project_id;
    protected ALStringField project_name;
    protected ALStringField explanation;
    protected ALNumberField admin_user_id;
    private ALStringField admin_user_name;
    protected ALStringField progress_flg;
    protected ALNumberField progress_rate;
    protected ALNumberField plan_progress_rate;
    private List<ALEipUser> memberList = null;
    private List<FileuploadBean> attachmentFileList = null;
    private ALNumberField create_user_id;
    protected ALStringField create_user_name;
    private ALNumberField update_user_id;
    protected ALStringField update_user_name;
    private ALNumberField login_user_id;
    protected ALDateTimeField create_date;
    protected ALDateTimeField update_date;
    protected ALDateTimeField task_update_date;
    protected BigDecimal plan_workload;
    protected BigDecimal workload;
    protected BigDecimal forecast_workload;
    protected int remainder_task;
    private final DecimalFormat df = new DecimalFormat("#.##");

    public void initField() {
        this.project_id = new ALNumberField();
        this.project_name = new ALStringField();
        this.explanation = new ALStringField();
        this.admin_user_id = new ALNumberField();
        this.admin_user_name = new ALStringField();
        this.progress_flg = new ALStringField();
        this.progress_rate = new ALNumberField();
        this.plan_progress_rate = new ALNumberField();
        this.memberList = new ArrayList<ALEipUser>();
        this.create_user_id = new ALNumberField();
        this.create_user_name = new ALStringField();
        this.update_user_id = new ALNumberField();
        this.update_user_name = new ALStringField();
        this.login_user_id = new ALNumberField();
        this.create_date = new ALDateTimeField("M\u6708d\u65e5");
        this.update_date = new ALDateTimeField("M\u6708d\u65e5");
        this.task_update_date = new ALDateTimeField();
        this.plan_workload = new BigDecimal(0);
        this.workload = new BigDecimal(0);
        this.remainder_task = 0;
        this.forecast_workload = new BigDecimal(0);
    }

    public ALNumberField getProjectId() {
        return this.project_id;
    }

    public void setProjectId(long i) {
        this.project_id.setValue(i);
    }

    public ALStringField getProjectName() {
        return this.project_name;
    }

    public String getProjectNameHtml() {
        return ALCommonUtils.replaceToAutoCR((String)this.project_name.toString());
    }

    public void setProjectName(String string) {
        this.project_name.setValue(string);
    }

    public String getExplanation() {
        return ALEipUtils.getMessageList((String)this.explanation.getValue());
    }

    public void setExplanation(String string) {
        this.explanation.setValue(string);
    }

    public ALNumberField getAdminUserId() {
        return this.admin_user_id;
    }

    public void setAdminUserId(long i) {
        this.admin_user_id.setValue(i);
    }

    public ALStringField getProgressFlg() {
        return this.progress_flg;
    }

    public void setProgressFlg(String string) {
        this.progress_flg.setValue(string);
    }

    public ALNumberField getProgressRate() {
        return this.progress_rate;
    }

    public void setProgressRate(long i) {
        this.progress_rate.setValue(i);
    }

    public ALNumberField getPlanProgressRate() {
        return this.plan_progress_rate;
    }

    public void setPlanProgressRate(long i) {
        this.plan_progress_rate.setValue(i);
    }

    public ALNumberField getCreateUserId() {
        return this.create_user_id;
    }

    public void setCreateUserId(long i) {
        this.create_user_id.setValue(i);
    }

    public ALStringField getCreateUserName() {
        return this.create_user_name;
    }

    public void setCreateUserName(String string) {
        this.create_user_name.setValue(string);
    }

    public ALNumberField getUpdateUserId() {
        return this.update_user_id;
    }

    public void setUpdateUserId(long i) {
        this.update_user_id.setValue(i);
    }

    public ALStringField getUpdateUserName() {
        return this.update_user_name;
    }

    public void setUpdateUserName(String string) {
        this.update_user_name.setValue(string);
    }

    public ALNumberField getLoginUserId() {
        return this.login_user_id;
    }

    public void setLoginUserId(long i) {
        this.login_user_id.setValue(i);
    }

    public ALDateTimeField getCreateDate() {
        return this.create_date;
    }

    public void setCreateDate(Date dt) {
        this.create_date.setValue(dt);
    }

    public ALDateTimeField getUpdateDate() {
        return this.update_date;
    }

    public void setUpdateDate(Date dt) {
        this.update_date.setValue(dt);
    }

    public ALDateTimeField getTaskUpdateDate() {
        return ALEipUtils.getFormattedTime((ALDateTimeField)this.task_update_date);
    }

    public void setTaskUpdateDate(Date dt) {
        this.task_update_date.setValue(dt);
    }

    public List<ALEipUser> getMemberList() {
        return this.memberList;
    }

    public void setMemberList(List<ALEipUser> memberList) {
        this.memberList = memberList;
    }

    public List<FileuploadBean> getAttachmentFileList() {
        return this.attachmentFileList;
    }

    public void setAttachmentFileList(List<FileuploadBean> attachmentFileList) {
        this.attachmentFileList = attachmentFileList;
    }

    public ALStringField getAdminUserName() {
        return this.admin_user_name;
    }

    public void setAdminUserName(String string) {
        this.admin_user_name.setValue(string);
    }

    public BigDecimal getPlanWorkload() {
        return this.plan_workload;
    }

    public void setPlanWorkload(BigDecimal i) {
        this.plan_workload = i;
    }

    public String getPlanWorkloadFormat() {
        return this.df.format(this.plan_workload);
    }

    public BigDecimal getWorkload() {
        return this.workload;
    }

    public void setWorkload(BigDecimal i) {
        this.workload = i;
    }

    public String getWorkloadFormat() {
        return this.df.format(this.workload);
    }

    public BigDecimal getForecastWorkload() {
        return this.forecast_workload;
    }

    public void setForecastWorkload(BigDecimal i) {
        this.forecast_workload = i;
    }

    public String getForecastWorkloadFormat() {
        return this.df.format(this.forecast_workload);
    }

    public void setReminderTask(int i) {
        this.remainder_task = i;
    }

    public int getReminderTask() {
        return this.remainder_task;
    }

    public boolean isDelay() {
        if ("".equals(this.getPlanProgressRate().toString()) || "".equals(this.getProgressRate().toString())) {
            return false;
        }
        return this.getPlanProgressRate().getValue() > this.getProgressRate().getValue();
    }

    public boolean isWorkloadOver() {
        return this.getPlanWorkload().compareTo(this.getForecastWorkload()) < 0;
    }
}

