/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.project;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTaskComment;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTaskCommentFile;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.project.util.ProjectFile;
import com.aimluck.eip.project.util.ProjectUtils;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ProjectTaskCommentFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ProjectTaskCommentFormData.class.getName());
    private ALStringField comment;
    private ALEipUser loginUser;
    private List<FileuploadBean> fileuploadList;
    private String folderName;
    private int uid;
    private final ProjectFile<EipTProjectTaskCommentFile, EipTProjectTaskComment> pfile = new ProjectFile(EipTProjectTaskCommentFile.class);

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        rundata.getUser().setTemp("mygroup", null);
        this.loginUser = ALEipUtils.getALEipUser((RunData)rundata);
        this.folderName = rundata.getParameters().getString("folderName");
        this.uid = ALEipUtils.getUserId((RunData)rundata);
    }

    public void initField() {
        this.comment = new ALStringField();
        this.comment.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_CONTENT"));
        this.comment.setNotNull(true);
        this.fileuploadList = new ArrayList<FileuploadBean>();
    }

    protected void setValidator() {
        this.comment.setNotNull(true);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            if (res) {
                this.fileuploadList = this.pfile.getFileuploadList(rundata);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            res = false;
        }
        return res;
    }

    protected boolean validate(List<String> msgList) {
        try {
            this.comment.validate(msgList);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return msgList.isEmpty();
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)this.loginUser.getUserId().getValueWithInt());
            EipTProjectTaskComment newComment = (EipTProjectTaskComment)Database.create(EipTProjectTaskComment.class);
            newComment.setEipTProjectTask(ProjectUtils.getEipTProjectTask(rundata, context));
            newComment.setComment(this.comment.getValue());
            newComment.setTurbineUser(tuser);
            newComment.setCreateDate(Calendar.getInstance().getTime());
            newComment.setUpdateDate(Calendar.getInstance().getTime());
            this.pfile.insertAttachmentFiles(this.fileuploadList, this.folderName, this.uid, newComment, msgList);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(newComment.getCommentId().intValue(), 370, ALLocalizationUtils.getl10n((String)"PROJECT_EVENTLOG_TASK_COMMENT_ADD"));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String commentId = ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"comment_id");
            EipTProjectTaskComment taskComment = ProjectUtils.getEipTProjectTaskComment(commentId);
            if (taskComment == null) {
                return false;
            }
            this.pfile.removeFile(rundata, "eipTProjectTaskComment", taskComment.getCommentId());
            Database.delete((Persistent)taskComment);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(taskComment.getCommentId().intValue(), 370, ALLocalizationUtils.getl10n((String)"PROJECT_EVENTLOG_TASK_COMMENT_DELETE"));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getComment() {
        return this.comment;
    }
}

