/*
 * Decompiled with CFR 0.152.
 */
package com.develop.delegator;

import com.develop.delegator.ByteCodeGenerator;
import com.develop.delegator.InternalError;
import com.develop.delegator.SerializedProxy;
import com.develop.java.lang.reflect.InvocationHandler;
import com.develop.java.lang.reflect.Proxy;
import com.develop.jcfe.ClassFile;
import com.develop.jcfe.JavaType;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.WeakHashMap;

public class ProxyLoader {
    private static WeakHashMap loader2Group = new WeakHashMap();
    private static WeakHashMap allClasses = new WeakHashMap();
    private static int classCount;
    private static final Object countLock;
    static final String defaultPackage = "com.develop.";
    static final Method defineClassMethod;
    static final Integer ZERO;
    static final boolean LOG = true;
    private static final Method[] objectMethods;
    private static final Class[] NO_ARG_TYPES;
    private static final boolean handleNullCL;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$security$ProtectionDomain;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;

    public static boolean isProxyClass(Class cls) {
        WeakHashMap weakHashMap = allClasses;
        synchronized (weakHashMap) {
            boolean bl = null != allClasses.get(cls);
            return bl;
        }
    }

    public static Object getProxySerializedForm(Proxy p, InvocationHandler h) {
        Class[] itfs = (Class[])allClasses.get(p.getClass());
        if (itfs == null) {
            throw new InternalError("Proxy not found in delegator class table");
        }
        return new SerializedProxy(itfs, h);
    }

    private static Method getDefineClassMethod() {
        try {
            Method meth = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ProxyLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("defineClass", class$java$lang$String == null ? (class$java$lang$String = ProxyLoader.class$("java.lang.String")) : class$java$lang$String, Class.forName("[B"), Integer.TYPE, Integer.TYPE, class$java$security$ProtectionDomain == null ? (class$java$security$ProtectionDomain = ProxyLoader.class$("java.security.ProtectionDomain")) : class$java$security$ProtectionDomain);
            ((AccessibleObject)meth).setAccessible(true);
            return meth;
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    private static String newClassName(String pkg) {
        Object object = countLock;
        synchronized (object) {
            if (pkg != null) {
                if (pkg.length() > 0) {
                    pkg = pkg + ".";
                }
            } else {
                pkg = "";
            }
            String string = pkg + "$ProxyDM" + classCount++;
            return string;
        }
    }

    private static LoaderGroup getLoaderGroup(ClassLoader ldr) {
        WeakHashMap weakHashMap = loader2Group;
        synchronized (weakHashMap) {
            LoaderGroup lg = (LoaderGroup)loader2Group.get(ldr);
            if (lg == null) {
                lg = new LoaderGroup();
                loader2Group.put(ldr, lg);
            }
            LoaderGroup loaderGroup = lg;
            return loaderGroup;
        }
    }

    public static String getProxyKey(Class[] itfs) {
        int length = itfs.length;
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        StringBuffer sb = new StringBuffer();
        int n = 0;
        while (n < length) {
            sb.append(itfs[n].getName());
            sb.append('#');
            ++n;
        }
        return sb.toString();
    }

    public static Class getProxyClass(ClassLoader ldr, Class[] interfaces) {
        if (ldr == null) {
            if (handleNullCL) {
                ldr = ClassLoader.getSystemClassLoader();
                if (ldr == null) {
                    throw new InternalError("getSystemClassLoader failed");
                }
            } else {
                throw new IllegalArgumentException("Proxy implementations not provided by the VM cannot inject classes into bootstrap classloader");
            }
        }
        LoaderGroup grp = ProxyLoader.getLoaderGroup(ldr);
        String key = ProxyLoader.getProxyKey(interfaces);
        LoaderGroup loaderGroup = grp;
        synchronized (loaderGroup) {
            Class cls = grp.getProxy(key);
            if (cls == null) {
                cls = ProxyLoader.createNewProxy(grp, key, ldr, interfaces);
            }
            Class clazz = cls;
            return clazz;
        }
    }

    public static String packageName(Class cls) {
        String name = cls.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return name.substring(0, lastDot);
    }

    static String getMethodKey(Method meth) {
        StringBuffer sb = new StringBuffer(meth.getName());
        Class<?>[] params = meth.getParameterTypes();
        int n = 0;
        while (n < params.length) {
            sb.append(params[n].getName());
            ++n;
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void checkLoaderVisibility(ClassLoader cl, Class cls) {
        boolean succeed = false;
        try {
            try {
                if (cls == Class.forName(cls.getName(), false, cl)) {
                    return;
                }
            }
            catch (ClassNotFoundException cnfe) {
                Object var5_4 = null;
                if (succeed) return;
                throw new IllegalArgumentException("Class " + cls.getName() + " not visible to loader " + cl);
            }
            Object var5_3 = null;
            if (succeed) return;
            throw new IllegalArgumentException("Class " + cls.getName() + " not visible to loader " + cl);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (succeed) throw throwable;
            throw new IllegalArgumentException("Class " + cls.getName() + " not visible to loader " + cl);
        }
    }

    private static Class createNewProxy(LoaderGroup gr, String key, ClassLoader ldr, Class[] itfs) {
        int itfCount = itfs.length;
        String pkgName = null;
        String newPkgName = null;
        int n = 0;
        Class itf = null;
        n = 0;
        while (n < itfCount) {
            itf = itfs[n];
            ProxyLoader.checkLoaderVisibility(ldr, itf);
            int mods = itf.getModifiers();
            if (!Modifier.isInterface(mods)) {
                throw new IllegalArgumentException(itf.getName() + " is not an interface");
            }
            if (!Modifier.isPublic(mods)) {
                newPkgName = ProxyLoader.packageName(itf);
                if (pkgName == null) {
                    pkgName = newPkgName;
                } else if (!pkgName.equals(newPkgName)) {
                    throw new IllegalArgumentException("Proxy cannot be in both packages: '" + pkgName + "' and '" + newPkgName + "'");
                }
            }
            ++n;
        }
        ClassFile cf = new ClassFile();
        String name = ProxyLoader.newClassName(pkgName);
        cf.setThisClass(name);
        cf.setSuperclass("com/develop/java/lang/reflect/Proxy");
        HashSet<String> methsAdded = new HashSet<String>();
        int m = 0;
        while (m < objectMethods.length) {
            String methKey = ProxyLoader.getMethodKey(objectMethods[m]);
            if (methsAdded.add(methKey)) {
                ByteCodeGenerator.addDelegatingMethod(cf, class$java$lang$Object == null ? ProxyLoader.class$("java.lang.Object") : class$java$lang$Object, objectMethods[m]);
            }
            ++m;
        }
        n = 0;
        while (n < itfCount) {
            itf = itfs[n];
            JavaType jt = new JavaType(itf.getName());
            Method[] meths = itf.getDeclaredMethods();
            cf.addImplementedInterface(jt);
            ByteCodeGenerator.initializeProxy(cf);
            int m2 = 0;
            while (m2 < meths.length) {
                String methKey = ProxyLoader.getMethodKey(meths[m2]);
                if (methsAdded.add(methKey)) {
                    ByteCodeGenerator.addDelegatingMethod(cf, itf, meths[m2]);
                }
                ++m2;
            }
            ++n;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            cf.writeToStream(dos);
            dos.close();
            byte[] bytes = bos.toByteArray();
            Class newCls = (Class)defineClassMethod.invoke((Object)ldr, name, bytes, ZERO, new Integer(bytes.length), (class$java$lang$Class == null ? (class$java$lang$Class = ProxyLoader.class$("java.lang.Class")) : class$java$lang$Class).getProtectionDomain());
            WeakHashMap weakHashMap = allClasses;
            synchronized (weakHashMap) {
                allClasses.put(newCls, itfs);
            }
            gr.putProxy(key, newCls);
            return newCls;
        }
        catch (InvocationTargetException ite) {
            throw new InternalError(ite.getTargetException());
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        countLock = new Object();
        defineClassMethod = ProxyLoader.getDefineClassMethod();
        ZERO = new Integer(0);
        objectMethods = new Method[3];
        NO_ARG_TYPES = new Class[0];
        try {
            handleNullCL = null != System.getProperty("com.develop.delegator.HandleNullCL");
            ProxyLoader.objectMethods[0] = (class$java$lang$Object == null ? (class$java$lang$Object = ProxyLoader.class$("java.lang.Object")) : class$java$lang$Object).getMethod("hashCode", NO_ARG_TYPES);
            ProxyLoader.objectMethods[1] = (class$java$lang$Object == null ? (class$java$lang$Object = ProxyLoader.class$("java.lang.Object")) : class$java$lang$Object).getMethod("equals", class$java$lang$Object == null ? (class$java$lang$Object = ProxyLoader.class$("java.lang.Object")) : class$java$lang$Object);
            ProxyLoader.objectMethods[2] = (class$java$lang$Object == null ? (class$java$lang$Object = ProxyLoader.class$("java.lang.Object")) : class$java$lang$Object).getMethod("toString", NO_ARG_TYPES);
        }
        catch (NoSuchMethodException nsme) {
            throw new InternalError(nsme);
        }
    }

    static class LoaderGroup {
        private HashMap map = new HashMap();

        LoaderGroup() {
        }

        Class getProxy(String key) {
            return (Class)this.map.get(key);
        }

        void putProxy(String key, Class proxy) {
            this.map.put(key, proxy);
        }
    }
}

