/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.singlevm;

import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import ojb.broker.Identity;
import ojb.broker.ManageableCollection;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.TransactionAbortedException;
import ojb.broker.TransactionInProgressException;
import ojb.broker.TransactionNotInProgressException;
import ojb.broker.VirtualProxy;
import ojb.broker.accesslayer.CollectionProxy;
import ojb.broker.accesslayer.ConnectionManager;
import ojb.broker.accesslayer.IndirectionHandler;
import ojb.broker.accesslayer.JdbcAccess;
import ojb.broker.accesslayer.PkEnumeration;
import ojb.broker.accesslayer.ReportQueryRsIterator;
import ojb.broker.accesslayer.RsIterator;
import ojb.broker.accesslayer.SqlBasedReportQueryRsIterator;
import ojb.broker.accesslayer.SqlBasedRsIterator;
import ojb.broker.accesslayer.SqlGenerator;
import ojb.broker.accesslayer.StatementManager;
import ojb.broker.cache.ObjectCache;
import ojb.broker.cache.ObjectCacheFactory;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.ClassNotPersistenceCapableException;
import ojb.broker.metadata.CollectionDescriptor;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.metadata.ObjectReferenceDescriptor;
import ojb.broker.metadata.PersistentField;
import ojb.broker.query.Criteria;
import ojb.broker.query.Query;
import ojb.broker.query.QueryByExample;
import ojb.broker.query.QueryBySQL;
import ojb.broker.query.QueryFactory;
import ojb.broker.server.PersistenceBrokerClient;
import ojb.broker.server.ServerEntry;
import ojb.broker.server.ServerPool;
import ojb.broker.util.ArrayIterator;
import ojb.broker.util.IdentityHashMap;
import ojb.broker.util.Logger;
import ojb.broker.util.LoggerFactory;
import ojb.broker.util.ObjectModification;
import ojb.broker.util.SequenceManager;
import ojb.broker.util.SequenceManagerFactory;

public class PersistenceBrokerImpl
implements PersistenceBroker {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private JdbcAccess m_DbAccess;
    private SqlGenerator m_SqlGen = SqlGenerator.getInstance();
    private ObjectCache m_ObjectCache = ObjectCacheFactory.getObjectCache();
    private DescriptorRepository m_DescriptorRepository = null;
    private ConnectionManager m_ConnectionManager = null;
    private SequenceManager m_SequenceManager = null;
    private StatementManager statementManager = null;
    private ServerPool pool = null;
    private boolean inTransaction = false;
    private boolean ignoreAutoCommitExceptions = PersistenceBrokerFactory.getConfiguration().getIgnoreAutoCommitExceptions();
    static /* synthetic */ Class class$ojb$broker$util$ManageableVector;

    public PersistenceBrokerImpl(DescriptorRepository repository) {
        this.m_DescriptorRepository = repository;
        this.m_ConnectionManager = new ConnectionManager(this);
        this.m_DbAccess = new JdbcAccess(this);
        this.m_SequenceManager = SequenceManagerFactory.getSequenceManager(this);
        this.statementManager = new StatementManager(this);
    }

    public StatementManager getStatementManager() {
        return this.statementManager;
    }

    public ConnectionManager getConnectionManager() {
        return this.m_ConnectionManager;
    }

    public void delete(Object obj) throws PersistenceBrokerException {
        this.logger.info("delete " + obj);
        if (obj instanceof VirtualProxy) {
            VirtualProxy proxy = (VirtualProxy)obj;
            obj = proxy.getRealSubject();
        } else if (Proxy.isProxyClass(obj.getClass())) {
            IndirectionHandler handler = (IndirectionHandler)Proxy.getInvocationHandler(obj);
            obj = handler.getRealSubject();
        }
        ClassDescriptor mif = this.m_DescriptorRepository.getDescriptorFor(obj.getClass());
        this.deleteReferences(obj, mif.getObjectReferenceDescriptors());
        this.deleteCollections(obj, mif.getCollectionDescriptors());
        Identity oid = new Identity(obj);
        this.m_DbAccess.executeDelete(mif, obj);
        this.m_ObjectCache.remove(oid);
    }

    private void deleteReferences(Object obj, Vector vecRds) throws PersistenceBrokerException {
        Iterator i = ((AbstractList)vecRds).iterator();
        while (i.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
            if (!rds.getCascadeDelete()) continue;
            try {
                Object r = rds.getPersistentField().get(obj);
                if (r == null) continue;
                rds.setCascadeDelete(false);
                this.delete(r);
                rds.setCascadeDelete(true);
            }
            catch (Throwable t) {
                rds.setCascadeDelete(true);
                throw new PersistenceBrokerException(t);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteCollections(Object obj, Vector vecCds) throws PersistenceBrokerException {
        Iterator i = ((AbstractList)vecCds).iterator();
        while (i.hasNext()) {
            CollectionDescriptor cds = (CollectionDescriptor)i.next();
            if (cds.isMtoNRelation()) {
                this.deleteMtoNImplementor(cds, obj);
            }
            if (!cds.getCascadeDelete()) continue;
            try {
                ArrayIterator colIterator;
                Object col = cds.getPersistentField().get(obj);
                if (col == null) continue;
                if (col instanceof ManageableCollection) {
                    colIterator = ((ManageableCollection)col).ojbIterator();
                } else if (col instanceof Collection) {
                    colIterator = ((Collection)col).iterator();
                } else {
                    if (!col.getClass().isArray()) {
                        throw new RuntimeException(col.getClass() + " can not be managed by OJB, use Array, Collection or ManageableCollection instead !");
                    }
                    colIterator = new ArrayIterator(col);
                }
                while (colIterator.hasNext()) {
                    cds.setCascadeDelete(false);
                    this.delete(colIterator.next());
                    cds.setCascadeDelete(true);
                }
            }
            catch (Exception ex) {
                this.logger.error(ex);
                throw new PersistenceBrokerException(ex);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void store(Object obj) throws PersistenceBrokerException {
        this.logger.info("store " + obj);
        if (obj == null) return;
        if (obj instanceof VirtualProxy) {
            VirtualProxy proxy = (VirtualProxy)obj;
            if (!proxy.alreadyMaterialized()) return;
            obj = proxy.getRealSubject();
        } else if (Proxy.isProxyClass(obj.getClass())) {
            IndirectionHandler handler = (IndirectionHandler)Proxy.getInvocationHandler(obj);
            if (!handler.alreadyMaterialized()) return;
            obj = handler.getRealSubject();
        }
        ClassDescriptor mif = this.m_DescriptorRepository.getDescriptorFor(obj.getClass());
        Identity oid = new Identity(obj);
        boolean doInsert = false;
        if (this.m_DbAccess.materializeObject(mif, oid) == null) {
            doInsert = true;
        }
        this.store(obj, doInsert);
    }

    private void storeReferences(Object obj, Vector vecRds) throws PersistenceBrokerException {
        try {
            Iterator i = ((AbstractList)vecRds).iterator();
            while (i.hasNext()) {
                ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
                Object ref = rds.getPersistentField().get(obj);
                if (!rds.getCascadeStore()) continue;
                rds.setCascadeStore(false);
                this.store(ref);
                rds.setCascadeStore(true);
            }
        }
        catch (Throwable t) {
            throw new PersistenceBrokerException(t);
        }
    }

    private void assertFkAssignment(Object obj, Object ref, ObjectReferenceDescriptor rds) {
        try {
            if (!(obj instanceof VirtualProxy || obj instanceof Proxy || ref == null || ref instanceof VirtualProxy || ref instanceof Proxy)) {
                Identity refOID = new Identity(ref);
                ClassDescriptor refCld = this.m_DescriptorRepository.getDescriptorFor(ref.getClass());
                Object[] refPkValues = refCld.getKeyValues(ref);
                ClassDescriptor objCld = this.m_DescriptorRepository.getDescriptorFor(obj.getClass());
                FieldDescriptor[] objFkFields = rds.getForeignKeyFieldDescriptors(objCld);
                FieldDescriptor fld = null;
                int i = 0;
                while (i < objFkFields.length) {
                    fld = objFkFields[i];
                    fld.getPersistentField().set(obj, refPkValues[i]);
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            this.logger.error(t);
            throw new PersistenceBrokerException(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeCollections(Object obj, Vector vecCds) throws PersistenceBrokerException {
        try {
            Iterator i = ((AbstractList)vecCds).iterator();
            while (i.hasNext()) {
                ArrayIterator colIterator;
                CollectionDescriptor cds = (CollectionDescriptor)i.next();
                Object col = cds.getPersistentField().get(obj);
                if (col == null) continue;
                if (col instanceof ManageableCollection) {
                    colIterator = ((ManageableCollection)col).ojbIterator();
                } else if (col instanceof Collection) {
                    colIterator = ((Collection)col).iterator();
                } else {
                    if (!col.getClass().isArray()) throw new RuntimeException(col.getClass() + " can not be managed by OJB, use Array, Collection or ManageableCollection instead !");
                    colIterator = new ArrayIterator(col);
                }
                while (colIterator.hasNext()) {
                    Object otherObj = colIterator.next();
                    if (cds.isMtoNRelation()) {
                        this.storeMtoNImplementor(cds, obj, otherObj);
                    } else {
                        this.assertFkAssignment(otherObj, obj, cds);
                    }
                    if (!cds.getCascadeStore()) continue;
                    this.store(otherObj);
                }
            }
            return;
        }
        catch (Throwable t) {
            throw new PersistenceBrokerException(t);
        }
    }

    private void storeMtoNImplementor(CollectionDescriptor cod, Object obj, Object otherObj) {
        ClassDescriptor cld = DescriptorRepository.getInstance().getDescriptorFor(obj.getClass());
        Object[] pkValues = cld.getKeyValues(obj);
        Object[] pkColumns = cod.getFksToThisClass();
        ClassDescriptor otherCld = DescriptorRepository.getInstance().getDescriptorFor(otherObj.getClass());
        Object[] otherPkValues = otherCld.getKeyValues(otherObj);
        Object[] otherPkColumns = cod.getFksToItemClass();
        Object[] values = new Object[pkValues.length + otherPkValues.length];
        System.arraycopy(pkValues, 0, values, 0, pkValues.length);
        System.arraycopy(otherPkValues, 0, values, pkValues.length, otherPkValues.length);
        Object[] columns = new Object[pkColumns.length + otherPkColumns.length];
        System.arraycopy(pkColumns, 0, columns, 0, pkColumns.length);
        System.arraycopy(otherPkColumns, 0, columns, pkColumns.length, otherPkColumns.length);
        String table = cod.getIndirectionTable();
        String insertStmt = this.m_SqlGen.getInsertStatement(table, columns, values);
        try {
            this.m_DbAccess.executeUpdateSQL(insertStmt, cld);
        }
        catch (PersistenceBrokerException e) {
            this.logger.debug(e.getMessage());
        }
    }

    private void deleteMtoNImplementor(CollectionDescriptor cod, Object obj) {
        ClassDescriptor cld = DescriptorRepository.getInstance().getDescriptorFor(obj.getClass());
        Object[] pkValues = cld.getKeyValues(obj);
        Object[] pkColumns = cod.getFksToThisClass();
        String table = cod.getIndirectionTable();
        String deleteStmt = this.m_SqlGen.getDeleteStatement(table, pkColumns, pkValues);
        try {
            this.m_DbAccess.executeUpdateSQL(deleteStmt, cld);
        }
        catch (PersistenceBrokerException e) {
            // empty catch block
        }
    }

    public void retrieveReferences(Object newObj, ClassDescriptor mif) throws PersistenceBrokerException {
        Iterator i = ((AbstractList)mif.getObjectReferenceDescriptors()).iterator();
        ObjectReferenceDescriptor rds = null;
        try {
            while (i.hasNext()) {
                rds = (ObjectReferenceDescriptor)i.next();
                this.retrieveReference(newObj, mif, rds);
            }
        }
        catch (Throwable ex) {
            this.logger.error("expected type: " + rds.getPersistentField().getType());
            this.logger.error("actual type:   " + this.getReferencedObject(newObj, rds, mif).getClass());
            this.logger.error(ex);
            throw new PersistenceBrokerException(ex);
        }
    }

    private void retrieveReference(Object obj, ClassDescriptor mif, ObjectReferenceDescriptor rds) throws IllegalAccessException {
        if (rds.getCascadeRetrieve()) {
            Object refObj = this.getReferencedObject(obj, rds, mif);
            PersistentField refField = rds.getPersistentField();
            refField.set(obj, refObj);
        }
    }

    private void retrieveCollection(Object obj, ClassDescriptor mif, CollectionDescriptor cds) throws IllegalAccessException {
        if (cds.getCascadeRetrieve()) {
            Object result;
            Class collectionClass = cds.getCollectionClass();
            PersistentField collectionField = cds.getPersistentField();
            Class itemsClass = cds.getItemClass();
            ClassDescriptor itemsMif = this.m_DescriptorRepository.getDescriptorFor(itemsClass);
            Query fkQuery = null;
            if (cds.isMtoNRelation()) {
                Object[] thisClassesFks = cds.getFksToThisClass();
                Object[] itemClassesFKs = cds.getFksToItemClass();
                Object[] values = mif.getKeyValues(obj);
                fkQuery = this.getMtoNQuery(itemsMif, cds, thisClassesFks, itemClassesFKs, values);
            } else {
                FieldDescriptor[] fields = cds.getForeignKeyFieldDescriptors(itemsMif);
                Object[] values = mif.getKeyValues(obj);
                fkQuery = this.getForeignKeyQuery(itemsMif, fields, values);
            }
            if (cds.getOrderBy() != null) {
                fkQuery.getCriteria().orderBy(cds.getOrderBy(), cds.isAscending());
            }
            if (collectionClass == null) {
                result = this.getCollectionByQuery(fkQuery, cds.isLazy());
                if (collectionField.getType().isArray()) {
                    int length = result.size();
                    Class<?> itemtype = collectionField.getType().getComponentType();
                    Object resultArray = Array.newInstance(itemtype, length);
                    int j = 0;
                    while (j < length) {
                        Array.set(resultArray, j, ((Vector)result).get(j));
                        ++j;
                    }
                    collectionField.set(obj, resultArray);
                } else {
                    collectionField.set(obj, result);
                }
            } else {
                result = this.getCollectionByQuery(collectionClass, fkQuery);
                collectionField.set(obj, result);
            }
        }
    }

    public void retrieveCollections(Object newObj, ClassDescriptor mif) throws PersistenceBrokerException {
        Iterator i = ((AbstractList)mif.getCollectionDescriptors()).iterator();
        try {
            while (i.hasNext()) {
                CollectionDescriptor cds = (CollectionDescriptor)i.next();
                this.retrieveCollection(newObj, mif, cds);
            }
        }
        catch (Throwable t) {
            this.logger.error(t);
            throw new PersistenceBrokerException(t);
        }
    }

    public void refreshRelationships(Object obj, ClassDescriptor cld) throws PersistenceBrokerException {
        try {
            Iterator iter = ((AbstractList)cld.getCollectionDescriptors()).iterator();
            while (iter.hasNext()) {
                CollectionDescriptor cds = (CollectionDescriptor)iter.next();
                if (!cds.isRefresh()) continue;
                this.retrieveCollection(obj, cld, cds);
            }
            iter = ((AbstractList)cld.getObjectReferenceDescriptors()).iterator();
            while (iter.hasNext()) {
                ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)iter.next();
                if (!rds.isRefresh()) continue;
                this.retrieveReference(obj, cld, rds);
            }
        }
        catch (Throwable t) {
            this.logger.error(t);
            throw new PersistenceBrokerException(t);
        }
    }

    private Object getReferencedObject(Object obj, ObjectReferenceDescriptor rds, ClassDescriptor mif) throws PersistenceBrokerException {
        Class referencedClass = rds.getItemClass();
        referencedClass = this.m_DescriptorRepository.getExtentClass(referencedClass);
        Object[] pkVals = rds.getForeignKeyValues(obj, mif);
        Identity id = new Identity(referencedClass, pkVals);
        Class referencedProxy = rds.getItemProxyClass();
        if (referencedProxy != null) {
            try {
                return VirtualProxy.createProxy(referencedProxy, id);
            }
            catch (Throwable t) {
                this.logger.error(t);
                throw new PersistenceBrokerException(t);
            }
        }
        return this.getObjectByIdentity(id);
    }

    public synchronized void abortTransaction() throws TransactionNotInProgressException {
        if (!this.inTransaction) {
            throw new TransactionNotInProgressException();
        }
        this.inTransaction = false;
        Enumeration allConnections = this.m_ConnectionManager.enumeration();
        while (allConnections.hasMoreElements()) {
            try {
                Connection conn = (Connection)allConnections.nextElement();
                conn.rollback();
                conn.setAutoCommit(true);
            }
            catch (Throwable t) {
                this.logger.error("Error in Transaction abort: " + t.getMessage());
            }
        }
    }

    private boolean ignoreAutoCommitExceptions() {
        return this.ignoreAutoCommitExceptions;
    }

    public synchronized void beginTransaction() throws TransactionInProgressException, TransactionAbortedException {
        if (this.inTransaction) {
            throw new TransactionInProgressException();
        }
        this.inTransaction = true;
        Enumeration allConnections = this.m_ConnectionManager.enumeration();
        while (allConnections.hasMoreElements()) {
            try {
                Connection conn = (Connection)allConnections.nextElement();
                conn.setAutoCommit(false);
            }
            catch (SQLException ex) {
                if (!this.ignoreAutoCommitExceptions()) {
                    this.abortTransaction();
                    throw new TransactionAbortedException();
                }
                this.logger.info("Driver problems: " + ex.getMessage());
            }
            catch (Throwable t) {
                this.abortTransaction();
                throw new TransactionAbortedException();
            }
        }
    }

    public synchronized void commitTransaction() throws TransactionNotInProgressException, TransactionAbortedException {
        if (!this.inTransaction) {
            throw new TransactionNotInProgressException();
        }
        this.inTransaction = false;
        Enumeration allConnections = this.m_ConnectionManager.enumeration();
        while (allConnections.hasMoreElements()) {
            try {
                Connection conn = (Connection)allConnections.nextElement();
                conn.commit();
                conn.setAutoCommit(true);
            }
            catch (Throwable t) {
                this.abortTransaction();
                throw new TransactionAbortedException();
            }
        }
    }

    public synchronized void checkPoint() throws TransactionNotInProgressException, TransactionAbortedException {
        Enumeration allConnections = this.m_ConnectionManager.enumeration();
        while (allConnections.hasMoreElements()) {
            try {
                Connection conn = (Connection)allConnections.nextElement();
                conn.commit();
            }
            catch (Throwable t) {
                this.logger.error("checkpoint failed!");
                this.logger.error(t);
                throw new TransactionAbortedException();
            }
        }
    }

    private ManageableCollection getCollectionByQuery(Class collectionClass, Class itemClass, Query query) throws ClassNotPersistenceCapableException, PersistenceBrokerException {
        this.logger.info("getCollectionByQuery (" + collectionClass + ", " + itemClass + ", " + query + ")");
        ClassDescriptor mif = this.m_DescriptorRepository.getDescriptorFor(itemClass);
        ManageableCollection result = null;
        try {
            result = (ManageableCollection)collectionClass.newInstance();
            Iterator i = this.getIteratorFromQuery(query, mif);
            while (i.hasNext()) {
                Object candidate = i.next();
                if (!itemClass.equals(candidate.getClass()) && !Proxy.isProxyClass(candidate.getClass()) && !(candidate instanceof VirtualProxy)) continue;
                result.ojbAdd(candidate);
            }
        }
        catch (InstantiationException ex) {
            this.logger.error(ex);
            throw new PersistenceBrokerException(ex);
        }
        catch (IllegalAccessException ex) {
            this.logger.error(ex);
            throw new PersistenceBrokerException(ex);
        }
        return result;
    }

    private Collection getCollectionFromQuery(Class itemClass, Query query) throws ClassNotPersistenceCapableException {
        this.logger.info("getCollectionByQuery " + itemClass + ", " + query);
        ClassDescriptor mif = this.m_DescriptorRepository.getDescriptorFor(itemClass);
        Vector res = new Vector();
        Iterator i = this.getIteratorFromQuery(query, mif);
        while (i.hasNext()) {
            res.add(i.next());
        }
        return res;
    }

    public ManageableCollection getCollectionByQuery(Class collectionClass, Query query) throws PersistenceBrokerException {
        return this.getCollectionByQuery(collectionClass, query, false);
    }

    public ManageableCollection getCollectionByQuery(Class collectionClass, Query query, boolean lazy) throws PersistenceBrokerException {
        Class itemClass = query.getSearchClass();
        ClassDescriptor cld = this.m_DescriptorRepository.getDescriptorFor(itemClass);
        ManageableCollection result = null;
        if (!cld.isInterface()) {
            if (lazy) {
                return new CollectionProxy(collectionClass, this, query);
            }
            result = this.getCollectionByQuery(collectionClass, itemClass, query);
        }
        if (cld.isExtent()) {
            IdentityHashMap tmpMap = new IdentityHashMap();
            Vector extentClasses = cld.getExtentClasses();
            int i = 0;
            while (i < extentClasses.size()) {
                Class ec = (Class)extentClasses.get(i);
                cld = this.m_DescriptorRepository.getDescriptorFor(ec);
                Class concreteItemClass = cld.getClassOfObject();
                ManageableCollection tmp = this.getCollectionByQuery(collectionClass, concreteItemClass, query);
                Iterator iter = tmp.ojbIterator();
                while (iter.hasNext()) {
                    IndirectionHandler handler = null;
                    Class candidateClass = null;
                    Object candidate = iter.next();
                    if (candidate instanceof VirtualProxy) {
                        handler = VirtualProxy.getIndirectionHandler((VirtualProxy)candidate);
                    } else if (candidate instanceof Proxy) {
                        handler = (IndirectionHandler)Proxy.getInvocationHandler(candidate);
                    }
                    candidateClass = handler != null ? handler.getIdentity().getObjectsClass() : candidate.getClass();
                    if (!itemClass.isAssignableFrom(candidateClass)) continue;
                    tmpMap.add(candidate);
                }
                ++i;
            }
            if (tmpMap.size() > 0) {
                if (result == null) {
                    try {
                        result = (ManageableCollection)collectionClass.newInstance();
                    }
                    catch (Throwable t) {
                        throw new PersistenceBrokerException(t);
                    }
                }
                Iterator iter = tmpMap.values().iterator();
                while (iter.hasNext()) {
                    result.ojbAdd(iter.next());
                }
            }
        }
        return result;
    }

    public Collection getCollectionByQuery(Query query) throws PersistenceBrokerException {
        return this.getCollectionByQuery(query, false);
    }

    public Collection getCollectionByQuery(Query query, boolean lazy) throws PersistenceBrokerException {
        return (Collection)((Object)this.getCollectionByQuery(class$ojb$broker$util$ManageableVector == null ? (class$ojb$broker$util$ManageableVector = PersistenceBrokerImpl.class$("ojb.broker.util.ManageableVector")) : class$ojb$broker$util$ManageableVector, query, lazy));
    }

    private Object getDBObject(Identity oid) throws ClassNotPersistenceCapableException {
        Class c = oid.getObjectsClass();
        ClassDescriptor mif = this.m_DescriptorRepository.getDescriptorFor(c);
        Object newObj = null;
        if (!mif.isInterface()) {
            newObj = this.m_DbAccess.materializeObject(mif, oid);
        }
        if (newObj == null && mif.isExtent()) {
            Vector extentClasses = mif.getExtentClasses();
            int i = 0;
            while (i < extentClasses.size()) {
                Class ec = (Class)extentClasses.get(i);
                mif = this.m_DescriptorRepository.getDescriptorFor(ec);
                newObj = this.m_DbAccess.materializeObject(mif, oid);
                if (newObj != null) break;
                ++i;
            }
        }
        if (newObj != null) {
            this.m_ObjectCache.cache(oid, newObj);
            this.retrieveReferences(newObj, mif);
            this.retrieveCollections(newObj, mif);
        }
        return newObj;
    }

    public Iterator getIteratorByQuery(Query query) throws PersistenceBrokerException {
        Class itemClass = query.getSearchClass();
        ClassDescriptor cld = this.m_DescriptorRepository.getDescriptorFor(itemClass);
        return this.getIteratorFromQuery(query, cld);
    }

    private Iterator getIteratorFromQuery(Query query, ClassDescriptor mif) throws PersistenceBrokerException {
        try {
            RsIterator iter = null;
            iter = query instanceof QueryBySQL ? new SqlBasedRsIterator(mif, ((QueryBySQL)query).getSql(), this) : new RsIterator(query, mif, this);
            return iter;
        }
        catch (Throwable t) {
            this.logger.error(t);
            throw new PersistenceBrokerException(t);
        }
    }

    private Object getObjectByExample(Object exampleObj) throws PersistenceBrokerException {
        Identity oid = new Identity(exampleObj);
        return this.getObjectByIdentity(oid);
    }

    public Object getObjectByIdentity(Identity id) throws PersistenceBrokerException {
        this.logger.info("getObjectByIdentity " + id);
        Object obj = this.m_ObjectCache.lookup(id);
        if (obj == null) {
            obj = this.getDBObject(id);
        } else {
            ClassDescriptor mif = this.m_DescriptorRepository.getDescriptorFor(obj.getClass());
            this.refreshRelationships(obj, mif);
        }
        return obj;
    }

    public Object getObjectByQuery(Query query) throws PersistenceBrokerException {
        if (query instanceof QueryByExample) {
            Object obj = query.getExampleObject();
            if (obj instanceof Identity) {
                return this.getObjectByIdentity((Identity)obj);
            }
            return this.getObjectByExample(obj);
        }
        Vector coll = (Vector)this.getCollectionByQuery(query);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        return coll.get(0);
    }

    public Enumeration getPKEnumerationByQuery(Class primaryKeyClass, Query query) throws PersistenceBrokerException {
        this.logger.info("getPKEnumerationByQuery " + query);
        ClassDescriptor cld = this.m_DescriptorRepository.getDescriptorFor(query.getSearchClass());
        return new PkEnumeration(query, cld, primaryKeyClass, this);
    }

    public void store(Object obj, ObjectModification mod) throws PersistenceBrokerException {
        Identity oid = new Identity(obj);
        if (mod.needsInsert()) {
            this.store(obj, true);
        } else if (mod.needsUpdate()) {
            this.store(obj, false);
        } else {
            PersistenceBrokerException ex = new PersistenceBrokerException("called store(), but ObjectModification tells: don't store...");
            this.logger.error(ex);
            throw ex;
        }
    }

    private void store(Object obj, boolean insert) throws PersistenceBrokerException {
        ClassDescriptor mif;
        this.logger.info("store " + obj + ", " + insert);
        if (obj != null) {
            if (obj instanceof VirtualProxy) {
                VirtualProxy proxy = (VirtualProxy)obj;
                if (proxy.alreadyMaterialized()) {
                    obj = proxy.getRealSubject();
                } else {
                    return;
                }
            }
            mif = this.m_DescriptorRepository.getDescriptorFor(obj.getClass());
            this.assignReferenceFKs(obj, mif.getObjectReferenceDescriptors());
            if (insert) {
                this.m_DbAccess.executeInsert(mif, obj);
            } else {
                this.m_DbAccess.executeUpdate(mif, obj);
            }
        } else {
            return;
        }
        this.m_ObjectCache.cache(obj);
        this.storeReferences(obj, mif.getObjectReferenceDescriptors());
        this.storeCollections(obj, mif.getCollectionDescriptors());
    }

    private void assignReferenceFKs(Object obj, Vector vecRds) throws PersistenceBrokerException {
        try {
            Iterator i = ((AbstractList)vecRds).iterator();
            while (i.hasNext()) {
                ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
                Object ref = rds.getPersistentField().get(obj);
                this.assertFkAssignment(obj, ref, rds);
            }
        }
        catch (Throwable t) {
            throw new PersistenceBrokerException(t);
        }
    }

    public boolean isInTransaction() {
        return this.inTransaction;
    }

    private Query getForeignKeyQuery(ClassDescriptor cld, FieldDescriptor[] fields, Object[] values) {
        Criteria criteria = new Criteria();
        int i = 0;
        while (i < fields.length) {
            FieldDescriptor fld = fields[i];
            criteria.addEqualTo(fld.getPersistentField().getName(), values[i]);
            ++i;
        }
        criteria.orderBy(cld.getOrderby());
        Query result = QueryFactory.newQuery(cld.getClassOfObject(), criteria);
        return result;
    }

    private Query getMtoNQuery(ClassDescriptor cld, CollectionDescriptor cod, Object[] thisClassFks, Object[] itemClassFks, Object[] values) {
        Criteria criteria = new Criteria();
        int i = 0;
        while (i < thisClassFks.length) {
            criteria.addEqualTo(thisClassFks[i].toString(), values[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < itemClassFks.length) {
            criteria.addEqualToColumn(cod.getIndirectionTable() + "." + itemClassFks[i2].toString(), cld.getPkFields()[i2].getFullColumnName());
            ++i2;
        }
        criteria.orderBy(cld.getOrderby());
        Query result = QueryFactory.newQuery(cld.getClassOfObject(), cld.getFullTableName() + ", " + cod.getIndirectionTable(), criteria);
        return result;
    }

    public int getUniqueId(Class extent, String attribute) {
        return this.m_SequenceManager.getUniqueId(extent, attribute);
    }

    public void removeFromCache(Object obj) throws PersistenceBrokerException {
        this.m_ObjectCache.remove(obj);
    }

    public String getUniqueString(Class extent, String attribute) throws PersistenceBrokerException {
        return this.m_SequenceManager.getUniqueString(extent, attribute);
    }

    public Object getUniqueObject(Class extent, String attribute) throws PersistenceBrokerException {
        return this.m_SequenceManager.getUniqueObject(extent, attribute);
    }

    public ClassDescriptor getClassDescriptor(Class clazz) throws PersistenceBrokerException {
        return this.m_DescriptorRepository.getDescriptorFor(clazz);
    }

    public void clearCache() throws PersistenceBrokerException {
        this.m_ObjectCache.clear();
    }

    public void setClassDescriptor(ClassDescriptor modifiedOrNewDescriptor) throws PersistenceBrokerException {
        this.m_DescriptorRepository.put(modifiedOrNewDescriptor.getClassOfObject(), modifiedOrNewDescriptor);
    }

    public Class getExtentClass(Class clazz) throws PersistenceBrokerException {
        return this.m_DescriptorRepository.getExtentClass(clazz);
    }

    public void invalidate(Identity oid) throws PersistenceBrokerException {
        if (PersistenceBrokerFactory.getConfiguration().isServerUsed()) {
            Iterator iter = this.getPool().getAllEntries();
            while (iter.hasNext()) {
                ServerEntry entry = (ServerEntry)iter.next();
                PersistenceBrokerClient client = new PersistenceBrokerClient(entry);
                client.removeFromCache(oid);
            }
        } else {
            this.removeFromCache(oid);
        }
    }

    private synchronized ServerPool getPool() {
        if (this.pool == null) {
            this.pool = new ServerPool(PersistenceBrokerFactory.getConfiguration().getServers());
        }
        return this.pool;
    }

    public long getUniqueLong(Class extent, String attribute) throws PersistenceBrokerException {
        return this.m_SequenceManager.getUniqueLong(extent, attribute);
    }

    public int getCount(Query query) throws PersistenceBrokerException {
        return this.m_DbAccess.executeCount(query, this.getClassDescriptor(query.getSearchClass()));
    }

    public Iterator getReportQueryIteratorByQuery(Query query) throws PersistenceBrokerException {
        ClassDescriptor cld = this.m_DescriptorRepository.getDescriptorFor(query.getSearchClass());
        if (query instanceof QueryBySQL) {
            String sql = ((QueryBySQL)query).getSql();
            return new SqlBasedReportQueryRsIterator(cld, sql, this);
        }
        return new ReportQueryRsIterator(query, cld, this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

