/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.util;

import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.util.Logger;
import ojb.broker.util.PersistenceBrokerFactoryConfiguration;

public class PoorMansLoggerImpl
implements Logger {
    private String name;
    private int level = 0;

    public PoorMansLoggerImpl(String name) {
        this.name = name;
    }

    protected int getLevel() {
        if (this.level == 0) {
            this.level = PoorMansLoggerImpl.getLevel(this.name);
        }
        return this.level;
    }

    void setLevel(int pLevel) {
        this.level = pLevel;
    }

    protected static int getLevel(String loggerName) {
        int logLevel = 3;
        String level = "WARN";
        PersistenceBrokerFactoryConfiguration config = PersistenceBrokerFactory.getConfiguration();
        level = config != null ? config.getLogLevel(loggerName) : "DEBUG";
        if (level.equalsIgnoreCase("DEBUG")) {
            logLevel = 1;
        } else if (level.equalsIgnoreCase("INFO")) {
            logLevel = 2;
        } else if (level.equalsIgnoreCase("WARN")) {
            logLevel = 3;
        } else if (level.equalsIgnoreCase("ERROR")) {
            logLevel = 4;
        } else if (level.equalsIgnoreCase("FATAL")) {
            logLevel = 5;
        }
        return logLevel;
    }

    public void debug(Object pObject) {
        if (1 >= this.getLevel()) {
            this.log("DEBUG: ", pObject);
        }
    }

    public void info(Object pObject) {
        if (2 >= this.getLevel()) {
            this.log("INFO: ", pObject);
        }
    }

    public void warn(Object pObject) {
        if (3 >= this.getLevel()) {
            this.log("WARN: ", pObject);
        }
    }

    public void error(Object pObject) {
        if (4 >= this.getLevel()) {
            this.log("ERROR: ", pObject);
        }
    }

    public void fatal(Object pObject) {
        if (5 >= this.getLevel()) {
            this.log("FATAL: ", pObject);
        }
    }

    protected void log(String pHeader, Object pObject) {
        System.out.print("[" + this.name + "] " + pHeader);
        if (pObject == null) {
            System.out.println("null");
            return;
        }
        if (pObject instanceof Throwable) {
            try {
                System.out.println(((Throwable)pObject).getMessage());
                ((Throwable)pObject).printStackTrace();
            }
            catch (Throwable throwable) {}
        } else {
            System.out.println(pObject.toString());
        }
    }
}

