/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg.collections;

import java.io.Serializable;
import java.util.Map;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.odmg.OJB;
import ojb.odmg.TransactionImpl;
import ojb.odmg.collections.DMapImpl;

public class DMapEntry
implements Map.Entry,
Serializable {
    private int id;
    private int dMapId;
    private byte[] keySerializedOID;
    private Identity keyOID;
    private Object keyRealSubject;
    private byte[] valueSerializedOID;
    private Identity valueOID;
    private Object valueRealSubject;

    public DMapEntry() {
    }

    public DMapEntry(int id, int mapId, byte[] keySerOID, byte[] valueSerOID) {
        this.id = id;
        this.dMapId = mapId;
        this.keySerializedOID = keySerOID;
        this.keyOID = Identity.fromByteArray(keySerOID);
        this.valueSerializedOID = valueSerOID;
        this.valueOID = Identity.fromByteArray(valueSerOID);
    }

    public DMapEntry(DMapImpl map, Object key, Object value) {
        this.id = this.generateNewId();
        this.dMapId = map.getId();
        this.keyRealSubject = key;
        this.keyOID = new Identity(key);
        this.keySerializedOID = this.keyOID.serialize();
        this.valueRealSubject = value;
        this.valueOID = new Identity(value);
        this.valueSerializedOID = this.valueOID.serialize();
    }

    protected int generateNewId() {
        PersistenceBroker broker = ((TransactionImpl)OJB.getInstance().currentTransaction()).getBroker();
        try {
            return broker.getUniqueId(this.getClass(), "id");
        }
        catch (PersistenceBrokerException e) {
            return -1;
        }
    }

    public Object getKey() {
        try {
            if (this.keyRealSubject == null) {
                this.keyRealSubject = ((TransactionImpl)OJB.getInstance().currentTransaction()).getBroker().getObjectByIdentity(this.keyOID);
            }
        }
        catch (Throwable ignored) {
            OJB.getLogger().error(ignored);
        }
        return this.keyRealSubject;
    }

    public Object getValue() {
        try {
            if (this.valueRealSubject == null) {
                this.valueRealSubject = ((TransactionImpl)OJB.getInstance().currentTransaction()).getBroker().getObjectByIdentity(this.valueOID);
            }
        }
        catch (Throwable ignored) {
            OJB.getLogger().error(ignored);
        }
        return this.valueRealSubject;
    }

    public Object setValue(Object obj) {
        TransactionImpl tx = (TransactionImpl)OJB.getInstance().currentTransaction();
        if (tx != null) {
            tx.lock(this, 4);
        }
        this.valueRealSubject = obj;
        this.valueOID = new Identity(obj);
        this.valueSerializedOID = this.valueOID.serialize();
        return obj;
    }
}

