/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.tutorial1;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Vector;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerFactory;
import test.ojb.tutorial1.UCDeleteProduct;
import test.ojb.tutorial1.UCEditProduct;
import test.ojb.tutorial1.UCEnterNewProduct;
import test.ojb.tutorial1.UCListAllProducts;
import test.ojb.tutorial1.UCQuitApplication;
import test.ojb.tutorial1.UseCase;

public class Application {
    private Vector useCases;

    public Application() {
        PersistenceBroker broker = null;
        try {
            broker = PersistenceBrokerFactory.createPersistenceBroker("repository.xml");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.useCases = new Vector();
        this.useCases.add(new UCListAllProducts(broker));
        this.useCases.add(new UCEnterNewProduct(broker));
        this.useCases.add(new UCEditProduct(broker));
        this.useCases.add(new UCDeleteProduct(broker));
        this.useCases.add(new UCQuitApplication(broker));
    }

    public void displayUseCases() {
        System.out.println();
        int i = 0;
        while (i < this.useCases.size()) {
            System.out.println("[" + i + "] " + ((UseCase)this.useCases.get(i)).getDescription());
            ++i;
        }
    }

    public static void main(String[] args) {
        Application app = new Application();
        app.run();
    }

    private String readLine() {
        try {
            BufferedReader rin = new BufferedReader(new InputStreamReader(System.in));
            return rin.readLine();
        }
        catch (Exception e) {
            return "";
        }
    }

    public void run() {
        System.out.println("Welcome to the OJB tutorial application");
        System.out.println();
        while (true) {
            try {
                UseCase uc = this.selectUseCase();
                uc.apply();
                continue;
            }
            catch (Throwable t) {
                System.out.println(t.getMessage());
                continue;
            }
            break;
        }
    }

    public UseCase selectUseCase() {
        this.displayUseCases();
        System.out.println("type in number to select a use case");
        String in = this.readLine();
        int index = Integer.parseInt(in);
        return (UseCase)this.useCases.get(index);
    }
}

