/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.List;
import org.apache.cayenne.CayenneContext;
import org.apache.cayenne.CayenneContextGraphManager;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.remote.RemoteIncrementalFaultList;
import org.apache.cayenne.util.ListResponse;
import org.apache.cayenne.util.ObjectContextQueryAction;

class CayenneContextQueryAction
extends ObjectContextQueryAction {
    CayenneContextQueryAction(CayenneContext actingContext, ObjectContext targetContext, Query query) {
        super(actingContext, targetContext, query);
    }

    public QueryResponse execute() {
        if (!(this.interceptOIDQuery() || this.interceptRelationshipQuery() || this.interceptLocalCache() || this.interceptPaginatedQuery())) {
            this.runQuery();
        }
        this.interceptObjectConversion();
        return this.response;
    }

    private boolean interceptPaginatedQuery() {
        if (this.metadata.getPageSize() > 0) {
            this.response = new ListResponse(new RemoteIncrementalFaultList(this.actingContext, this.query));
            return true;
        }
        return false;
    }

    private boolean interceptLocalCache() {
        List cachedResults;
        boolean cacheOrCacheRefresh;
        String cacheKey = this.metadata.getCacheKey();
        if (cacheKey == null) {
            return false;
        }
        boolean cache = "localcache".equals(this.metadata.getCachePolicy());
        boolean bl = cacheOrCacheRefresh = cache || "localcache_refresh".equals(this.metadata.getCachePolicy());
        if (!cacheOrCacheRefresh) {
            return false;
        }
        CayenneContextGraphManager graphManager = ((CayenneContext)this.actingContext).internalGraphManager();
        if (cache && (cachedResults = graphManager.getCachedQueryResult(cacheKey)) != null) {
            this.response = new ListResponse(cachedResults);
            return true;
        }
        if (!this.interceptPaginatedQuery()) {
            this.runQuery();
        }
        graphManager.cacheQueryResult(cacheKey, this.response.firstList());
        return true;
    }
}

