/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.log4j.Level;

class DataNodeQueryAction
implements OperationObserver {
    OperationObserver observer;
    DataNode node;
    private Query currentQuery;

    public DataNodeQueryAction(DataNode node, OperationObserver observer) {
        this.observer = observer;
        this.node = node;
    }

    public void runQuery(Connection connection, Query query) throws SQLException, Exception {
        this.currentQuery = query;
        SQLAction action = this.node.getAdapter().getAction(query, this.node);
        action.performAction(connection, this);
    }

    public void nextBatchCount(Query query, int[] resultCount) {
        this.observer.nextBatchCount(this.currentQuery, resultCount);
    }

    public void nextCount(Query query, int resultCount) {
        this.observer.nextCount(this.currentQuery, resultCount);
    }

    public void nextDataRows(Query query, List dataRows) {
        this.observer.nextDataRows(this.currentQuery, dataRows);
    }

    public void nextDataRows(Query q, ResultIterator it) {
        this.observer.nextDataRows(this.currentQuery, it);
    }

    public void nextGeneratedDataRows(Query query, ResultIterator keysIterator) {
        this.observer.nextGeneratedDataRows(this.currentQuery, keysIterator);
    }

    public void nextGlobalException(Exception ex) {
        this.observer.nextGlobalException(ex);
    }

    public void nextQueryException(Query query, Exception ex) {
        this.observer.nextQueryException(this.currentQuery, ex);
    }

    public Level getLoggingLevel() {
        return this.observer.getLoggingLevel();
    }

    public boolean isIteratedResult() {
        return this.observer.isIteratedResult();
    }
}

