/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.access.types.DefaultType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.VoidType;
import org.apache.cayenne.util.Util;

public class ExtendedTypeMap {
    protected Map typeMap = new HashMap();
    protected DefaultType defaultType = new DefaultType();
    Constructor enumTypeConstructor;
    Collection extendedTypeFactories;

    public ExtendedTypeMap() {
        try {
            Class enumTypeClass = Util.getJavaClass("org.apache.cayenne.access.types.EnumType");
            this.enumTypeConstructor = enumTypeClass.getConstructor(Class.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.initDefaultTypes();
    }

    protected void initDefaultTypes() {
        this.registerType(new VoidType());
        Iterator it = DefaultType.defaultTypes();
        while (it.hasNext()) {
            this.registerType(new DefaultType((String)it.next()));
        }
    }

    public Collection getFactories() {
        return this.extendedTypeFactories != null ? Collections.unmodifiableCollection(this.extendedTypeFactories) : Collections.EMPTY_SET;
    }

    public void addFactory(ExtendedTypeFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Attempt to add null factory");
        }
        if (this.extendedTypeFactories == null) {
            this.extendedTypeFactories = new ArrayList();
        }
        this.extendedTypeFactories.add(factory);
    }

    public void removeFactory(ExtendedTypeFactory factory) {
        if (factory != null && this.extendedTypeFactories != null && this.extendedTypeFactories.remove(factory) && this.extendedTypeFactories.isEmpty()) {
            this.extendedTypeFactories = null;
        }
    }

    public void registerType(ExtendedType type) {
        this.typeMap.put(type.getClassName(), type);
    }

    public ExtendedType getDefaultType() {
        return this.defaultType;
    }

    public ExtendedType getRegisteredType(String javaClassName) {
        ExtendedType type = (ExtendedType)this.typeMap.get(javaClassName);
        if (type != null) {
            return type;
        }
        type = this.getDefaultType(javaClassName);
        if (type != null) {
            this.registerType(type);
            return type;
        }
        return this.getDefaultType();
    }

    public ExtendedType getRegisteredType(Class javaClass) {
        String name = null;
        name = javaClass.isArray() ? javaClass.getComponentType() + "[]" : javaClass.getName();
        return this.getRegisteredType(name);
    }

    public void unregisterType(String javaClassName) {
        this.typeMap.remove(javaClassName);
    }

    public String[] getRegisteredTypeNames() {
        Set keys = this.typeMap.keySet();
        int len = keys.size();
        String[] types = new String[len];
        Iterator it = keys.iterator();
        for (int i = 0; i < len; ++i) {
            types[i] = (String)it.next();
        }
        return types;
    }

    protected ExtendedType getDefaultType(String javaClassName) {
        Class typeClass;
        if (javaClassName == null) {
            return null;
        }
        try {
            typeClass = Util.getJavaClass(javaClassName);
        }
        catch (Throwable th) {
            return null;
        }
        if (this.extendedTypeFactories != null) {
            Iterator it = this.extendedTypeFactories.iterator();
            while (it.hasNext()) {
                ExtendedTypeFactory factory = (ExtendedTypeFactory)it.next();
                ExtendedType type = factory.getType(typeClass);
                if (type == null) continue;
                return type;
            }
        }
        return this.checkEnumType(typeClass);
    }

    ExtendedType checkEnumType(Class typeClass) {
        if (this.enumTypeConstructor == null) {
            return null;
        }
        try {
            ExtendedType type = (ExtendedType)this.enumTypeConstructor.newInstance(typeClass);
            return type;
        }
        catch (Throwable th) {
            return null;
        }
    }
}

