/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.event.DataContextEvent;
import org.apache.cayenne.access.event.DataContextTransactionEventListener;
import org.apache.cayenne.access.event.DataObjectTransactionEventListener;
import org.apache.cayenne.access.util.DefaultOperationObserver;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.Util;
import org.apache.log4j.Level;

public class ContextCommitObserver
extends DefaultOperationObserver
implements DataContextTransactionEventListener {
    protected List updObjects;
    protected List delObjects;
    protected List insObjects;
    protected List objectsToNotify;
    protected DataContext context;

    public ContextCommitObserver(Level logLevel, DataContext context, List insObjects, List updObjects, List delObjects) {
        super.setLoggingLevel(logLevel);
        this.context = context;
        this.insObjects = insObjects;
        this.updObjects = updObjects;
        this.delObjects = delObjects;
        this.objectsToNotify = new ArrayList();
        Iterator<List> collIter = Arrays.asList(delObjects, updObjects, insObjects).iterator();
        while (collIter.hasNext()) {
            Iterator objIter = ((Collection)collIter.next()).iterator();
            while (objIter.hasNext()) {
                Object element = objIter.next();
                if (!(element instanceof DataObjectTransactionEventListener)) continue;
                this.objectsToNotify.add(element);
            }
        }
    }

    public void nextQueryException(Query query, Exception ex) {
        super.nextQueryException(query, ex);
        throw new CayenneRuntimeException("Raising from query exception.", Util.unwindException(ex));
    }

    public void nextGlobalException(Exception ex) {
        super.nextGlobalException(ex);
        throw new CayenneRuntimeException("Raising from underlyingQueryEngine exception.", Util.unwindException(ex));
    }

    public void registerForDataContextEvents() {
        EventManager mgr = this.context.getEventManager();
        mgr.addListener(this, "dataContextWillCommit", DataContextEvent.class, DataContext.WILL_COMMIT, this.context);
        mgr.addListener(this, "dataContextDidCommit", DataContextEvent.class, DataContext.DID_COMMIT, this.context);
        mgr.addListener(this, "dataContextDidRollback", DataContextEvent.class, DataContext.DID_ROLLBACK, this.context);
    }

    public void unregisterFromDataContextEvents() {
        EventManager mgr = this.context.getEventManager();
        mgr.removeListener(this, DataContext.WILL_COMMIT);
        mgr.removeListener(this, DataContext.DID_COMMIT);
        mgr.removeListener(this, DataContext.DID_ROLLBACK);
    }

    public void dataContextWillCommit(DataContextEvent event) {
        Iterator iter = this.objectsToNotify.iterator();
        while (iter.hasNext()) {
            ((DataObjectTransactionEventListener)iter.next()).willCommit(event);
        }
    }

    public void dataContextDidCommit(DataContextEvent event) {
        Iterator iter = this.objectsToNotify.iterator();
        while (iter.hasNext()) {
            ((DataObjectTransactionEventListener)iter.next()).didCommit(event);
        }
    }

    public void dataContextDidRollback(DataContextEvent event) {
    }
}

