/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.io.InputStream;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.conf.ConfigLoader;
import org.apache.cayenne.conf.ConfigLoaderDelegate;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.RuntimeLoadDelegate;
import org.apache.cayenne.util.ResourceLocator;
import org.apache.cayenne.util.Util;
import org.apache.log4j.Logger;

public class DefaultConfiguration
extends Configuration {
    private static Logger logObj = Logger.getLogger(DefaultConfiguration.class);
    private ResourceLocator locator;

    public DefaultConfiguration() {
        this("cayenne.xml");
    }

    public DefaultConfiguration(String domainConfigurationName) {
        super(domainConfigurationName);
        if (domainConfigurationName == null) {
            throw new ConfigurationException("cannot use null as domain file name.");
        }
        logObj.debug("using domain file name: " + domainConfigurationName);
        ResourceLocator locator = new ResourceLocator();
        locator.setSkipAbsolutePath(true);
        locator.setSkipClasspath(false);
        locator.setSkipCurrentDirectory(true);
        locator.setSkipHomeDirectory(true);
        if (!this.getClass().equals(DefaultConfiguration.class)) {
            locator.addClassPath(Util.getPackagePath(this.getClass().getName()));
        }
        this.setResourceLocator(locator);
    }

    public DefaultConfiguration(String domainConfigurationName, ResourceLocator locator) {
        super(domainConfigurationName);
        this.setResourceLocator(locator);
    }

    public void addClassPath(String customPath) {
        this.getResourceLocator().addClassPath(customPath);
    }

    public void addResourcePath(String path) {
        this.getResourceLocator().addFilesystemPath(path);
    }

    public boolean canInitialize() {
        logObj.debug("canInitialize started.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        logObj.debug("initialize starting.");
        InputStream in = this.getDomainConfiguration();
        if (in == null) {
            StringBuffer msg = new StringBuffer();
            msg.append("[").append(this.getClass().getName()).append("] : Domain configuration file \"").append(this.getDomainConfigurationName()).append("\" is not found.");
            throw new ConfigurationException(msg.toString());
        }
        ConfigLoaderDelegate delegate = this.getLoaderDelegate();
        if (delegate == null) {
            delegate = new RuntimeLoadDelegate(this, this.getLoadStatus());
        }
        ConfigLoader loader = new ConfigLoader(delegate);
        try {
            loader.loadDomains(in);
        }
        finally {
            this.setLoadStatus(delegate.getStatus());
            in.close();
        }
        logObj.debug("initialize finished.");
    }

    public void didInitialize() {
        logObj.debug("didInitialize finished.");
    }

    protected ResourceLocator getResourceLocator() {
        return this.locator;
    }

    protected void setResourceLocator(ResourceLocator locator) {
        this.locator = locator;
    }

    protected InputStream getDomainConfiguration() {
        return this.locator.findResourceStream(this.getDomainConfigurationName());
    }

    protected InputStream getMapConfiguration(String location) {
        return this.locator.findResourceStream(location);
    }

    protected InputStream getViewConfiguration(String location) {
        return this.locator.findResourceStream(location);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('[').append(this.getClass().getName()).append(": classloader=").append(this.locator.getClassLoader()).append(']');
        return buf.toString();
    }
}

