/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conn;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.cayenne.conn.ConnectionEventLoggingDelegate;

public class DriverDataSource
implements DataSource {
    protected Driver driver;
    protected String connectionUrl;
    protected String userName;
    protected String password;
    protected ConnectionEventLoggingDelegate logger;

    public DriverDataSource(String driverClassName, String connectionUrl) throws SQLException {
        this.connectionUrl = connectionUrl;
        if (driverClassName != null) {
            try {
                this.driver = (Driver)Class.forName(driverClassName).newInstance();
            }
            catch (Exception ex) {
                throw new SQLException("Can not load JDBC driver named '" + driverClassName + "': " + ex.getMessage());
            }
        }
    }

    public DriverDataSource(Driver driver, String connectionUrl, String userName, String password) {
        this.driver = driver;
        this.connectionUrl = connectionUrl;
        this.userName = userName;
        this.password = password;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.userName, this.password);
    }

    public Connection getConnection(String userName, String password) throws SQLException {
        try {
            if (this.logger != null) {
                this.logger.logConnect(this.connectionUrl, userName, password);
            }
            Connection c = null;
            if (this.driver == null) {
                c = DriverManager.getConnection(this.connectionUrl, userName, password);
            } else {
                Properties connectProperties = new Properties();
                if (userName != null) {
                    connectProperties.put("user", userName);
                }
                if (password != null) {
                    connectProperties.put("password", password);
                }
                c = this.driver.connect(this.connectionUrl, connectProperties);
            }
            if (c == null) {
                throw new SQLException("Can't establish connection: " + this.connectionUrl);
            }
            if (this.logger != null) {
                this.logger.logConnectSuccess();
            }
            return c;
        }
        catch (SQLException sqlex) {
            if (this.logger != null) {
                this.logger.logConnectFailure(sqlex);
            }
            throw sqlex;
        }
    }

    public int getLoginTimeout() throws SQLException {
        return -1;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
    }

    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    public ConnectionEventLoggingDelegate getLogger() {
        return this.logger;
    }

    public void setLogger(ConnectionEventLoggingDelegate delegate) {
        this.logger = delegate;
    }
}

