/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dataview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.dataview.DataView;
import org.apache.cayenne.dataview.ObjEntityViewField;
import org.apache.cayenne.map.ObjEntity;
import org.apache.commons.lang.Validate;

public class ObjEntityView {
    private DataView owner;
    private ObjEntity objEntity;
    private List fields = new ArrayList();
    private Map nameFieldMap = new HashMap();
    private List readOnlyFields = Collections.unmodifiableList(this.fields);
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Validate.notNull(name);
        this.name = name;
    }

    public List getFields() {
        return this.readOnlyFields;
    }

    public List getVisibleFields() {
        int size = this.getFieldCount();
        ArrayList<ObjEntityViewField> dst = new ArrayList<ObjEntityViewField>(size);
        for (int i = 0; i < size; ++i) {
            ObjEntityViewField field = this.getField(i);
            if (!field.isVisible()) continue;
            dst.add(field);
        }
        return dst;
    }

    public List getEditableFields() {
        int size = this.getFieldCount();
        ArrayList<ObjEntityViewField> dst = new ArrayList<ObjEntityViewField>(size);
        for (int i = 0; i < size; ++i) {
            ObjEntityViewField field = this.getField(i);
            if (!field.isVisible() || !field.isEditable()) continue;
            dst.add(field);
        }
        return dst;
    }

    public ObjEntity getObjEntity() {
        return this.objEntity;
    }

    public void setObjEntity(ObjEntity objEntity) {
        Validate.notNull(objEntity);
        this.objEntity = objEntity;
    }

    public ObjEntityViewField getField(int index) {
        return (ObjEntityViewField)this.fields.get(index);
    }

    public ObjEntityViewField getField(String fieldName) {
        return (ObjEntityViewField)this.nameFieldMap.get(fieldName);
    }

    public ObjEntityViewField getFieldForObjAttribute(String objAttributeName) {
        for (int i = 0; i < this.fields.size(); ++i) {
            ObjEntityViewField field = this.getField(i);
            if (!objAttributeName.equals(field.getObjAttribute().getName())) continue;
            return field;
        }
        return null;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public boolean hasFields() {
        return !this.fields.isEmpty();
    }

    public void clearFields() {
        for (int i = 0; i < this.getFieldCount(); ++i) {
            ObjEntityViewField field = this.getField(i);
            field.setOwner(null);
            field.setIndex(-1);
        }
        this.fields.clear();
        this.nameFieldMap.clear();
    }

    public boolean removeField(ObjEntityViewField field) {
        if (field.getOwner() != this) {
            return false;
        }
        field.setOwner(null);
        field.setIndex(-1);
        this.nameFieldMap.remove(field.getName());
        return this.fields.remove(field);
    }

    public int insertField(ObjEntityViewField field) {
        if (field.getOwner() == this) {
            return field.getIndex();
        }
        Validate.notNull(field.getName());
        Validate.isTrue(!this.nameFieldMap.containsKey(field.getName()));
        field.setOwner(this);
        this.nameFieldMap.put(field.getName(), field);
        int prefIndex = field.getPreferredIndex();
        int fieldCount = this.getFieldCount();
        if (prefIndex < 0) {
            int newIndex = fieldCount;
            this.fields.add(field);
            field.setIndex(newIndex);
            return newIndex;
        }
        int index = 0;
        int curPrefIndex = -1;
        while (index < fieldCount && (curPrefIndex = this.getField(index++).getPreferredIndex()) <= prefIndex && curPrefIndex >= 0) {
        }
        this.fields.add(index, field);
        field.setIndex(index);
        ++fieldCount;
        for (int i = index + 1; i < fieldCount; ++i) {
            this.getField(i).setIndex(i);
        }
        return index;
    }

    public DataView getOwner() {
        return this.owner;
    }

    void setOwner(DataView owner) {
        this.owner = owner;
    }
}

