/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.event.DispatchQueue;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.util.Invocation;

public class EventManager {
    private static EventManager defaultManager;
    public static final int DEFAULT_DISPATCH_THREAD_COUNT = 5;
    protected Map subjects = Collections.synchronizedMap(new WeakHashMap());
    protected List eventQueue = Collections.synchronizedList(new LinkedList());
    protected boolean singleThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventManager getDefaultManager() {
        if (defaultManager == null) {
            Class clazz = EventManager.class;
            synchronized (clazz) {
                if (defaultManager == null) {
                    defaultManager = new EventManager(2);
                }
            }
        }
        return defaultManager;
    }

    public EventManager() {
        this(5);
    }

    public EventManager(int dispatchThreadCount) {
        this.singleThread = dispatchThreadCount <= 0;
        for (int i = 0; i < dispatchThreadCount; ++i) {
            new DispatchThread("EventDispatchThread-" + i).start();
        }
    }

    public boolean isSingleThreaded() {
        return this.singleThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getEventQueue() {
        List list = this.eventQueue;
        synchronized (list) {
            return new ArrayList(this.eventQueue);
        }
    }

    public void addListener(Object listener, String methodName, Class eventParameterClass, EventSubject subject) {
        this.addListener(listener, methodName, eventParameterClass, subject, null, true);
    }

    public void addNonBlockingListener(Object listener, String methodName, Class eventParameterClass, EventSubject subject) {
        if (this.singleThread) {
            throw new IllegalStateException("EventManager is configured to be single-threaded.");
        }
        this.addListener(listener, methodName, eventParameterClass, subject, null, false);
    }

    public void addListener(Object listener, String methodName, Class eventParameterClass, EventSubject subject, Object sender) {
        this.addListener(listener, methodName, eventParameterClass, subject, sender, true);
    }

    public void addNonBlockingListener(Object listener, String methodName, Class eventParameterClass, EventSubject subject, Object sender) {
        if (this.singleThread) {
            throw new IllegalStateException("EventManager is configured to be single-threaded.");
        }
        this.addListener(listener, methodName, eventParameterClass, subject, sender, false);
    }

    protected void addListener(Object listener, String methodName, Class eventParameterClass, EventSubject subject, Object sender, boolean blocking) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener must not be null.");
        }
        if (eventParameterClass == null) {
            throw new IllegalArgumentException("Event class must not be null.");
        }
        if (subject == null) {
            throw new IllegalArgumentException("Subject must not be null.");
        }
        try {
            Invocation invocation = blocking ? new Invocation(listener, methodName, eventParameterClass) : new NonBlockingInvocation(listener, methodName, eventParameterClass);
            this.dispatchQueueForSubject(subject, true).addInvocation(invocation, sender);
        }
        catch (NoSuchMethodException nsm) {
            throw new CayenneRuntimeException("Error adding listener, method name: " + methodName, nsm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(Object listener) {
        if (listener == null) {
            return false;
        }
        boolean didRemove = false;
        Map map = this.subjects;
        synchronized (map) {
            if (!this.subjects.isEmpty()) {
                Iterator subjectIter = this.subjects.keySet().iterator();
                while (subjectIter.hasNext()) {
                    didRemove |= this.removeListener(listener, (EventSubject)subjectIter.next());
                }
            }
        }
        return didRemove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllListeners(EventSubject subject) {
        if (subject != null) {
            Map map = this.subjects;
            synchronized (map) {
                return this.subjects.remove(subject) != null;
            }
        }
        return false;
    }

    public boolean removeListener(Object listener, EventSubject subject) {
        return this.removeListener(listener, subject, null);
    }

    public boolean removeListener(Object listener, EventSubject subject, Object sender) {
        if (listener == null || subject == null) {
            return false;
        }
        DispatchQueue subjectQueue = this.dispatchQueueForSubject(subject, false);
        if (subjectQueue == null) {
            return false;
        }
        return subjectQueue.removeInvocations(listener, sender);
    }

    public void postEvent(EventObject event, EventSubject subject) {
        this.dispatchEvent(new Dispatch(event, subject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postNonBlockingEvent(EventObject event, EventSubject subject) {
        if (this.singleThread) {
            throw new IllegalStateException("EventManager is configured to be single-threaded.");
        }
        List list = this.eventQueue;
        synchronized (list) {
            this.eventQueue.add(new Dispatch(event, subject));
            this.eventQueue.notifyAll();
        }
    }

    private void dispatchEvent(Dispatch dispatch) {
        DispatchQueue dispatchQueue = this.dispatchQueueForSubject(dispatch.subject, false);
        if (dispatchQueue != null) {
            dispatchQueue.dispatchEvent(dispatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DispatchQueue dispatchQueueForSubject(EventSubject subject, boolean create) {
        Map map = this.subjects;
        synchronized (map) {
            DispatchQueue listenersStore = (DispatchQueue)this.subjects.get(subject);
            if (create && listenersStore == null) {
                listenersStore = new DispatchQueue();
                this.subjects.put(subject, listenersStore);
            }
            return listenersStore;
        }
    }

    final class DispatchThread
    extends Thread {
        DispatchThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Dispatch dispatch = null;
                List list = EventManager.this.eventQueue;
                synchronized (list) {
                    if (EventManager.this.eventQueue.size() > 0) {
                        dispatch = (Dispatch)EventManager.this.eventQueue.remove(0);
                    } else {
                        try {
                            EventManager.this.eventQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (dispatch == null) continue;
                try {
                    dispatch.fire();
                }
                catch (Throwable throwable) {
                }
            }
        }
    }

    final class NonBlockingInvocation
    extends Invocation {
        public NonBlockingInvocation(Object target, String methodName, Class parameterType) throws NoSuchMethodException {
            super(target, methodName, parameterType);
        }
    }

    class InvocationDispatch
    extends Dispatch {
        Invocation target;

        InvocationDispatch(EventObject[] eventArgument, EventSubject subject, Invocation target) {
            super(eventArgument, subject);
            this.target = target;
        }

        void fire() {
            this.target.fire(this.eventArgument);
        }
    }

    class Dispatch {
        EventObject[] eventArgument;
        EventSubject subject;

        Dispatch(EventObject event, EventSubject subject) {
            this(new EventObject[]{event}, subject);
        }

        Dispatch(EventObject[] eventArgument, EventSubject subject) {
            this.eventArgument = eventArgument;
            this.subject = subject;
        }

        Object getSender() {
            return this.eventArgument[0].getSource();
        }

        void fire() {
            EventManager.this.dispatchEvent(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean fire(Invocation invocation) {
            if (invocation instanceof NonBlockingInvocation) {
                if (invocation.getTarget() == null) {
                    return false;
                }
                List list = EventManager.this.eventQueue;
                synchronized (list) {
                    EventManager.this.eventQueue.add(new InvocationDispatch(this.eventArgument, this.subject, invocation));
                    EventManager.this.eventQueue.notifyAll();
                }
                return true;
            }
            return invocation.fire(this.eventArgument);
        }
    }
}

