/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.hessian;

import com.caucho.hessian.client.HessianRuntimeException;
import com.caucho.hessian.io.HessianProtocolException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.remote.BaseConnection;
import org.apache.cayenne.remote.ClientMessage;
import org.apache.cayenne.remote.RemoteService;
import org.apache.cayenne.remote.RemoteSession;
import org.apache.cayenne.remote.hessian.ClientSerializerFactory;
import org.apache.cayenne.remote.hessian.EnumSerializerProxy;
import org.apache.cayenne.remote.hessian.HessianConfig;
import org.apache.cayenne.remote.hessian.HessianProxyFactory;
import org.apache.cayenne.util.Util;

public class HessianConnection
extends BaseConnection {
    public static final String[] CLIENT_SERIALIZER_FACTORIES = new String[]{ClientSerializerFactory.class.getName(), EnumSerializerProxy.class.getName()};
    protected String url;
    protected String userName;
    protected String password;
    protected String sharedSessionName;
    protected RemoteSession session;
    protected RemoteService service;

    public HessianConnection(String url) {
        this(url, null, null, null);
    }

    public HessianConnection(String url, String userName, String password, String sharedSessionName) {
        if (url == null) {
            throw new IllegalArgumentException("URL of Cayenne service is null.");
        }
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.sharedSessionName = sharedSessionName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSharedSessionName() {
        return this.sharedSessionName;
    }

    public EventBridge getServerEventBridge() throws CayenneRuntimeException {
        if (this.session == null) {
            this.connect();
        }
        return this.session.isServerEventsEnabled() ? this.session.createServerEventBridge() : null;
    }

    RemoteSession getSession() {
        return this.session;
    }

    protected void beforeSendMessage(ClientMessage message) throws CayenneRuntimeException {
        if (this.session == null) {
            this.connect();
        }
    }

    protected Object doSendMessage(ClientMessage message) throws CayenneRuntimeException {
        try {
            return this.service.processMessage(message);
        }
        catch (Throwable th) {
            th = this.unwindThrowable(th);
            String errorMessage = this.buildExceptionMessage("Remote error", th);
            throw new CayenneRuntimeException(errorMessage, th);
        }
    }

    protected synchronized void connect() throws CayenneRuntimeException {
        if (this.session != null) {
            return;
        }
        long t0 = 0L;
        if (this.logger.isInfoEnabled()) {
            t0 = System.currentTimeMillis();
            StringBuffer log = new StringBuffer("Connecting to [");
            if (this.userName != null) {
                log.append(this.userName);
                if (this.password != null) {
                    log.append(":*******");
                }
                log.append("@");
            }
            log.append(this.url);
            log.append("]");
            if (this.sharedSessionName != null) {
                log.append(" - shared session '").append(this.sharedSessionName).append("'");
            } else {
                log.append(" - dedicated session.");
            }
            this.logger.info(log.toString());
        }
        HessianProxyFactory factory = new HessianProxyFactory(this);
        factory.setSerializerFactory(HessianConfig.createFactory(CLIENT_SERIALIZER_FACTORIES, null));
        factory.setUser(this.userName);
        factory.setPassword(this.password);
        try {
            this.service = (RemoteService)factory.create(RemoteService.class, this.url);
        }
        catch (Throwable th) {
            th = this.unwindThrowable(th);
            String message = this.buildExceptionMessage("URL error", th);
            throw new CayenneRuntimeException(message, th);
        }
        try {
            RemoteSession remoteSession = this.session = this.sharedSessionName != null ? this.service.establishSharedSession(this.sharedSessionName) : this.service.establishSession();
            if (this.logger.isInfoEnabled()) {
                long time = System.currentTimeMillis() - t0;
                this.logger.info("=== Connected, session: " + this.session + " - took " + time + " ms.");
            }
        }
        catch (Throwable th) {
            th = this.unwindThrowable(th);
            th.printStackTrace();
            String message = this.buildExceptionMessage("Error establishing remote session", th);
            throw new CayenneRuntimeException(message, th);
        }
    }

    String buildExceptionMessage(String message, Throwable th) {
        StringBuffer buffer = new StringBuffer(message);
        buffer.append(". URL - ").append(this.url);
        String thMessage = th.getMessage();
        if (!Util.isEmptyString(thMessage)) {
            buffer.append("; CAUSE - ").append(thMessage);
        }
        return buffer.toString();
    }

    Throwable unwindThrowable(Throwable th) {
        Throwable cause;
        if (th instanceof HessianProtocolException) {
            Throwable cause2 = ((HessianProtocolException)th).getRootCause();
            if (cause2 != null) {
                return this.unwindThrowable(cause2);
            }
        } else if (th instanceof HessianRuntimeException && (cause = ((HessianRuntimeException)th).getRootCause()) != null) {
            return this.unwindThrowable(cause);
        }
        return Util.unwindException(th);
    }
}

