/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.xml;

import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.property.PropertyUtils;
import org.apache.cayenne.xml.XMLDecoder;
import org.apache.cayenne.xml.XMLEncoder;
import org.apache.cayenne.xml.XMLMappingDescriptor;
import org.apache.cayenne.xml.XMLSerializable;
import org.apache.cayenne.xml.XMLUtil;
import org.w3c.dom.Element;

class SerializableEntity
implements XMLSerializable {
    Element descriptor;
    XMLMappingDescriptor descriptorMap;
    transient Object object;

    public SerializableEntity(XMLMappingDescriptor descriptorMap, Element descriptor) {
        this.descriptor = descriptor;
        this.descriptorMap = descriptorMap;
    }

    String getName() {
        return this.descriptor.getAttribute("name");
    }

    Element getDescriptor() {
        return this.descriptor;
    }

    void setObject(Object object) {
        this.object = object;
    }

    public void encodeAsXML(XMLEncoder encoder) {
        if (this.object instanceof Collection) {
            Collection c = (Collection)this.object;
            if (!c.isEmpty()) {
                Iterator it = c.iterator();
                this.encodeObject(encoder, it.next(), true);
                while (it.hasNext()) {
                    this.encodeObject(encoder, it.next(), false);
                }
                encoder.pop();
            }
        } else {
            this.encodeObject(encoder, this.object, true);
            encoder.pop();
        }
    }

    public void decodeFromXML(XMLDecoder decoder) {
        throw new CayenneRuntimeException("Decoding is not supported by this object");
    }

    void encodeObject(XMLEncoder encoder, Object object, boolean push) {
        encoder.setRoot(this.descriptor.getAttribute("xmlTag"), null, push);
        Iterator it = XMLUtil.getChildren(this.descriptor).iterator();
        while (it.hasNext()) {
            Element property = (Element)it.next();
            String xmlTag = property.getAttribute("xmlTag");
            String name = property.getAttribute("name");
            Object value = PropertyUtils.getProperty(object, name);
            if (value == null) continue;
            SerializableEntity relatedEntity = this.descriptorMap.getEntity(xmlTag);
            if (relatedEntity != null) {
                relatedEntity.setObject(value);
                relatedEntity.encodeAsXML(encoder);
                continue;
            }
            encoder.encodeProperty(xmlTag, value, false);
        }
    }
}

