/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.objectstyle.ashwood.graph.layout.Layer;
import org.objectstyle.ashwood.graph.layout.LayerVertex;

public class ArcStraightener {
    private Layer[] layers;
    private SortedMap classes;
    private double horizontalSpacing;

    public void positionDummies(Layer[] layerArray, double d) {
        this.layers = layerArray;
        this.horizontalSpacing = d;
        this.computeLeftPositions();
        int n = 0;
        while (n < layerArray.length) {
            int n2 = 0;
            while (n2 < layerArray[n].size()) {
                layerArray[n].getVertex(n2).setClassIndex(-1);
                ++n2;
            }
            ++n;
        }
        this.computeRightPositions();
        this.position();
    }

    private void computeLeftPositions() {
        this.computeClasses(true);
        Iterator iterator = this.classes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            int n = entry.getKey().hashCode();
            List list = (List)entry.getValue();
            int n2 = 0;
            while (n2 < list.size()) {
                LayerVertex layerVertex = (LayerVertex)list.get(n2);
                if (!layerVertex.isDefinedLeftX()) {
                    this.placeLeft(layerVertex);
                }
                ++n2;
            }
            this.adjustLeftClass(n);
        }
    }

    private void computeRightPositions() {
        this.computeClasses(false);
        Iterator iterator = this.classes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            int n = entry.getKey().hashCode();
            List list = (List)entry.getValue();
            int n2 = 0;
            while (n2 < list.size()) {
                LayerVertex layerVertex = (LayerVertex)list.get(n2);
                if (!layerVertex.isDefinedRightX()) {
                    this.placeRight(layerVertex);
                }
                ++n2;
            }
            this.adjustRightClass(n);
        }
    }

    private void position() {
        int n = 0;
        while (n < this.layers.length) {
            int n2 = 0;
            while (n2 < this.layers[n].size()) {
                LayerVertex layerVertex = this.layers[n].getVertex(n2);
                layerVertex.setCenterX((layerVertex.getLeftX() + layerVertex.getRightX()) / 2.0);
                ++n2;
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void computeClasses(boolean var1_1) {
        this.classes = new TreeMap<K, V>();
        var2_2 = 0;
        while (var2_2 < this.layers.length) {
            var3_3 = var2_2;
            var4_4 = var1_1 != false ? 0 : this.layers[var2_2].size() - 1;
            var5_5 = var1_1 != false ? this.layers[var2_2].size() : -1;
            var6_6 = var1_1 != false ? 1 : -1;
            var7_7 = var4_4;
            while (var7_7 != var5_5) {
                block4: {
                    block3: {
                        var8_8 = this.layers[var2_2].getVertex(var7_7);
                        if (var8_8.getClassIndex() < 0) break block3;
                        var3_3 = var8_8.getClassIndex();
                        break block4;
                    }
                    var9_9 = this.getClazz(var3_3);
                    if (var8_8.isDummy()) ** GOTO lbl26
                    var8_8.setClassIndex(var3_3);
                    var9_9.add(var8_8);
                    break block4;
lbl-1000:
                    // 1 sources

                    {
                        var8_8.setClassIndex(var3_3);
                        var9_9.add(var8_8);
                        if (var8_8.outDegree() != 1) break;
                        var8_8 = var8_8.getSuccessor(0);
lbl26:
                        // 2 sources

                        ** while (var8_8.isDummy())
                    }
                }
                var7_7 += var6_6;
            }
            ++var2_2;
        }
    }

    private List getClazz(int n) {
        Integer n2 = new Integer(n);
        ArrayList arrayList = (ArrayList)this.classes.get(n2);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.classes.put(n2, arrayList);
        }
        return arrayList;
    }

    private void placeLeft(LayerVertex layerVertex) {
        Layer layer = this.layers[layerVertex.getRank()];
        double d = Double.NEGATIVE_INFINITY;
        if (!layerVertex.isDummy()) {
            if (layer.isFirst(layerVertex)) {
                d = 0.0;
            } else {
                LayerVertex layerVertex2 = layer.getLeft(layerVertex);
                if (layerVertex2.getClassIndex() == layerVertex.getClassIndex()) {
                    if (!layerVertex2.isDefinedLeftX()) {
                        this.placeLeft(layerVertex2);
                    }
                    double d2 = layerVertex.minCenterDistance(layerVertex2, this.horizontalSpacing);
                    d = layerVertex2.getLeftX() + d2;
                } else {
                    d = 0.0;
                }
            }
            layerVertex.setLeftX(d);
        } else {
            LayerVertex layerVertex3 = layerVertex;
            while (layerVertex.isDummy()) {
                LayerVertex layerVertex4;
                layer = this.layers[layerVertex.getRank()];
                if (!layer.isFirst(layerVertex) && (layerVertex4 = layer.getLeft(layerVertex)).getClassIndex() == layerVertex.getClassIndex()) {
                    if (!layerVertex4.isDefinedLeftX()) {
                        this.placeLeft(layerVertex4);
                    }
                    double d3 = layerVertex.minCenterDistance(layerVertex4, this.horizontalSpacing);
                    d = Math.max(d, layerVertex4.getLeftX() + d3);
                }
                if (layerVertex.outDegree() != 1) break;
                layerVertex = layerVertex.getSuccessor(0);
            }
            d = Double.isInfinite(d) ? 0.0 : d;
            layerVertex = layerVertex3;
            while (layerVertex.isDummy()) {
                layerVertex.setLeftX(d);
                if (layerVertex.outDegree() != 1) break;
                layerVertex = layerVertex.getSuccessor(0);
            }
        }
    }

    private void placeRight(LayerVertex layerVertex) {
        Layer layer = this.layers[layerVertex.getRank()];
        double d = Double.POSITIVE_INFINITY;
        if (!layerVertex.isDummy()) {
            if (layer.isLast(layerVertex)) {
                d = 0.0;
            } else {
                LayerVertex layerVertex2 = layer.getRight(layerVertex);
                if (layerVertex2.getClassIndex() == layerVertex.getClassIndex()) {
                    try {
                        if (!layerVertex2.isDefinedRightX()) {
                            this.placeRight(layerVertex2);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    double d2 = layerVertex.minCenterDistance(layerVertex2, this.horizontalSpacing);
                    d = layerVertex2.getRightX() - d2;
                } else {
                    d = 0.0;
                }
            }
            layerVertex.setRightX(d);
        } else {
            LayerVertex layerVertex3 = layerVertex;
            while (layerVertex.isDummy()) {
                LayerVertex layerVertex4;
                layer = this.layers[layerVertex.getRank()];
                if (!layer.isLast(layerVertex) && (layerVertex4 = layer.getRight(layerVertex)).getClassIndex() == layerVertex.getClassIndex()) {
                    if (!layerVertex4.isDefinedRightX()) {
                        this.placeRight(layerVertex4);
                    }
                    double d3 = layerVertex.minCenterDistance(layerVertex4, this.horizontalSpacing);
                    d = Math.min(d, layerVertex4.getRightX() - d3);
                }
                if (layerVertex.outDegree() != 1) break;
                layerVertex = layerVertex.getSuccessor(0);
            }
            d = Double.isInfinite(d) ? 0.0 : d;
            layerVertex = layerVertex3;
            while (layerVertex.isDummy()) {
                layerVertex.setRightX(d);
                if (layerVertex.outDegree() != 1) break;
                layerVertex = layerVertex.getSuccessor(0);
            }
        }
    }

    private void adjustLeftClass(int n) {
        LayerVertex layerVertex;
        Object object;
        Object object2;
        List list = (List)this.classes.get(new Integer(n));
        double d = Double.POSITIVE_INFINITY;
        int n2 = 0;
        while (n2 < list.size()) {
            object2 = (LayerVertex)list.get(n2);
            object = this.layers[((LayerVertex)object2).getRank()];
            if (!((Layer)object).isLast((LayerVertex)object2) && (layerVertex = ((Layer)object).getRight((LayerVertex)object2)).getClassIndex() != n) {
                double d2 = ((LayerVertex)object2).minCenterDistance(layerVertex, this.horizontalSpacing);
                d = Math.min(d, layerVertex.getLeftX() - ((LayerVertex)object2).getLeftX() - d2);
            }
            ++n2;
        }
        if (Double.isInfinite(d)) {
            object2 = new ArrayList(list.size() + 1);
            int n3 = 0;
            while (n3 < list.size()) {
                layerVertex = (LayerVertex)list.get(n3);
                int n4 = 0;
                while (n4 < layerVertex.inDegree()) {
                    LayerVertex layerVertex2 = layerVertex.getPredecessor(n4);
                    if (layerVertex2.getClassIndex() < n) {
                        object2.add(new Double(layerVertex2.getLeftX() - layerVertex.getLeftX()));
                    }
                    ++n4;
                }
                int n5 = 0;
                while (n5 < layerVertex.outDegree()) {
                    LayerVertex layerVertex3 = layerVertex.getSuccessor(n5);
                    if (layerVertex3.getClassIndex() < n) {
                        object2.add(new Double(layerVertex3.getLeftX() - layerVertex.getLeftX()));
                    }
                    ++n5;
                }
                ++n3;
            }
            if (object2.size() == 0) {
                d = 0.0;
            } else {
                Collections.sort(object2);
                d = (Double)object2.get(object2.size() / 2);
            }
        }
        int n6 = 0;
        while (n6 < list.size()) {
            object = (LayerVertex)list.get(n6);
            ((LayerVertex)object).setLeftX(((LayerVertex)object).getLeftX() + d);
            ++n6;
        }
    }

    private void adjustRightClass(int n) {
        LayerVertex layerVertex;
        Object object;
        Object object2;
        List list = (List)this.classes.get(new Integer(n));
        double d = Double.POSITIVE_INFINITY;
        int n2 = 0;
        while (n2 < list.size()) {
            object2 = (LayerVertex)list.get(n2);
            object = this.layers[((LayerVertex)object2).getRank()];
            if (!((Layer)object).isFirst((LayerVertex)object2) && (layerVertex = ((Layer)object).getLeft((LayerVertex)object2)).getClassIndex() != n) {
                double d2 = ((LayerVertex)object2).minCenterDistance(layerVertex, this.horizontalSpacing);
                d = Math.min(d, ((LayerVertex)object2).getRightX() - layerVertex.getRightX() - d2);
            }
            ++n2;
        }
        if (Double.isInfinite(d)) {
            object2 = new ArrayList(list.size() + 1);
            int n3 = 0;
            while (n3 < list.size()) {
                layerVertex = (LayerVertex)list.get(n3);
                int n4 = 0;
                while (n4 < layerVertex.inDegree()) {
                    LayerVertex layerVertex2 = layerVertex.getPredecessor(n4);
                    if (layerVertex2.getClassIndex() < n) {
                        object2.add(new Double(layerVertex2.getRightX() - layerVertex.getRightX()));
                    }
                    ++n4;
                }
                int n5 = 0;
                while (n5 < layerVertex.outDegree()) {
                    LayerVertex layerVertex3 = layerVertex.getSuccessor(n5);
                    if (layerVertex3.getClassIndex() < n) {
                        object2.add(new Double(layerVertex3.getRightX() - layerVertex.getRightX()));
                    }
                    ++n5;
                }
                ++n3;
            }
            if (object2.size() == 0) {
                d = 0.0;
            } else {
                Collections.sort(object2);
                d = -((Double)object2.get(object2.size() / 2)).doubleValue();
            }
        }
        int n6 = 0;
        while (n6 < list.size()) {
            object = (LayerVertex)list.get(n6);
            ((LayerVertex)object).setRightX(((LayerVertex)object).getRightX() - d);
            ++n6;
        }
    }

    private void printLayers() {
        int n = 0;
        while (n < this.layers.length) {
            int n2 = 0;
            while (n2 < this.layers[n].size()) {
                LayerVertex layerVertex = this.layers[n].getVertex(n2);
                System.out.println("v=" + layerVertex.getUserVertex() + ", c=" + layerVertex.getClassIndex() + ", lx=" + layerVertex.getLeftX() + ", rx=" + layerVertex.getRightX() + ", w=" + layerVertex.getWidth());
                ++n2;
            }
            ++n;
        }
    }
}

