/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.configuration.BasePathConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ConfigurationFactory {
    private String configurationFileName;
    private String basePath;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$configuration$ConfigurationFactory == null ? (class$org$apache$commons$configuration$ConfigurationFactory = ConfigurationFactory.class$("org.apache.commons.configuration.ConfigurationFactory")) : class$org$apache$commons$configuration$ConfigurationFactory));
    private URL digesterRules;
    private String digesterRuleNamespaceURI;
    static /* synthetic */ Class class$org$apache$commons$configuration$ConfigurationFactory;
    static /* synthetic */ Class class$org$apache$commons$configuration$PropertiesConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$DOM4JConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$JNDIConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$Configuration;

    public ConfigurationFactory() {
    }

    public ConfigurationFactory(String configurationFileName) {
        this.configurationFileName = configurationFileName;
    }

    public Configuration getConfiguration() throws Exception {
        Digester digester;
        CompositeConfiguration configuration = new CompositeConfiguration();
        FileInputStream input = new FileInputStream(new File(this.getConfigurationFileName()));
        if (this.getDigesterRules() == null) {
            digester = new Digester();
            this.configureNamespace(digester);
            this.initDefaultDigesterRules(digester);
        } else {
            digester = DigesterLoader.createDigester((URL)this.getDigesterRules());
            this.configureNamespace(digester);
        }
        digester.push((Object)configuration);
        try {
            digester.parse((InputStream)input);
            ((InputStream)input).close();
        }
        catch (SAXException e) {
            log.error((Object)"SAX Exception caught", (Throwable)e);
            throw e;
        }
        return configuration;
    }

    public String getConfigurationFileName() {
        return this.configurationFileName;
    }

    public void setConfigurationFileName(String configurationFileName) {
        this.configurationFileName = configurationFileName;
    }

    public URL getDigesterRules() {
        return this.digesterRules;
    }

    public void setDigesterRules(URL digesterRules) {
        this.digesterRules = digesterRules;
    }

    protected void initDefaultDigesterRules(Digester digester) {
        this.setupDigesterInstance(digester, "configuration/properties", new BasePathConfigurationFactory(class$org$apache$commons$configuration$PropertiesConfiguration == null ? (class$org$apache$commons$configuration$PropertiesConfiguration = ConfigurationFactory.class$("org.apache.commons.configuration.PropertiesConfiguration")) : class$org$apache$commons$configuration$PropertiesConfiguration));
        this.setupDigesterInstance(digester, "configuration/dom4j", new BasePathConfigurationFactory(class$org$apache$commons$configuration$DOM4JConfiguration == null ? (class$org$apache$commons$configuration$DOM4JConfiguration = ConfigurationFactory.class$("org.apache.commons.configuration.DOM4JConfiguration")) : class$org$apache$commons$configuration$DOM4JConfiguration));
        this.setupDigesterInstance(digester, "configuration/jndi", class$org$apache$commons$configuration$JNDIConfiguration == null ? (class$org$apache$commons$configuration$JNDIConfiguration = ConfigurationFactory.class$("org.apache.commons.configuration.JNDIConfiguration")) : class$org$apache$commons$configuration$JNDIConfiguration);
    }

    protected void setupDigesterInstance(Digester digester, String matchString, ObjectCreationFactory factory) {
        digester.addFactoryCreate(matchString, factory);
        digester.addSetProperties(matchString);
        digester.addCallMethod(matchString, "load");
        digester.addSetNext(matchString, "addConfiguration", (class$org$apache$commons$configuration$Configuration == null ? (class$org$apache$commons$configuration$Configuration = ConfigurationFactory.class$("org.apache.commons.configuration.Configuration")) : class$org$apache$commons$configuration$Configuration).getName());
    }

    protected void setupDigesterInstance(Digester digester, String matchString, Class clazz) {
        digester.addFactoryCreate(matchString, clazz);
        digester.addSetProperties(matchString);
        digester.addSetNext(matchString, "addConfiguration", (class$org$apache$commons$configuration$Configuration == null ? (class$org$apache$commons$configuration$Configuration = ConfigurationFactory.class$("org.apache.commons.configuration.Configuration")) : class$org$apache$commons$configuration$Configuration).getName());
    }

    public String getDigesterRuleNamespaceURI() {
        return this.digesterRuleNamespaceURI;
    }

    public void setDigesterRuleNamespaceURI(String digesterRuleNamespaceURI) {
        this.digesterRuleNamespaceURI = digesterRuleNamespaceURI;
    }

    private void configureNamespace(Digester digester) {
        if (this.getDigesterRuleNamespaceURI() != null) {
            digester.setNamespaceAware(true);
            digester.setRuleNamespaceURI(this.getDigesterRuleNamespaceURI());
        } else {
            digester.setNamespaceAware(false);
        }
        digester.setValidating(false);
    }

    public String getBasePath() {
        return StringUtils.isEmpty((String)this.basePath) ? "." : this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class BasePathConfigurationFactory
    extends AbstractObjectCreationFactory
    implements ObjectCreationFactory {
        private Class clazz;

        public BasePathConfigurationFactory(Class clazz) {
            this.clazz = clazz;
        }

        public Object createObject(Attributes attributes) throws Exception {
            BasePathConfiguration bpc = (BasePathConfiguration)this.clazz.newInstance();
            bpc.setBasePath(ConfigurationFactory.this.getBasePath());
            return bpc;
        }
    }
}

