/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.msgboard;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategoryMap;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.common.ALAbstractMultiFilterSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.msgboard.MsgboardCategoryResultData;
import com.aimluck.eip.msgboard.MsgboardTopicResultData;
import com.aimluck.eip.msgboard.util.MsgboardUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MsgboardTopicSelectData
extends ALAbstractMultiFilterSelectData<EipTMsgboardTopic, EipTMsgboardTopic>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardTopicSelectData.class.getName());
    private List<MsgboardCategoryResultData> categoryList;
    private List<ALEipGroup> postList;
    private int topicSum;
    private Object parentTopic;
    private List<MsgboardTopicResultData> coTopicList;
    private int uid;
    private boolean showReplyForm = false;
    private boolean hasAclCategoryList;
    private boolean hasAclUpdateTopicOthers;
    private boolean hasAclDeleteTopicOthers;
    private int table_colum_num;
    private String filterType = "";
    private String categoryId = "";
    private ALStringField target_keyword;
    private String postId = "";
    private String categoryName = "";
    private String postName = "";
    private boolean isFileUploadable;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
            String sortStr = null;
            sortStr = portlet != null ? portlet.getPortletConfig().getInitParameter("p2a-sort") : "update_date";
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)sortStr);
            if ("update_date".equals(sortStr)) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
            }
        }
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAclCategoryList = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "msgboard_category", 1);
        this.hasAclDeleteTopicOthers = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "msgboard_topic_other", 16);
        this.hasAclUpdateTopicOthers = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "msgboard_topic_other", 8);
        this.postList = ALEipUtils.getMyGroups((RunData)rundata);
        try {
            this.updateCategoryName();
        }
        catch (Exception ex) {
            logger.error((Object)"msgboard", (Throwable)ex);
        }
        this.target_keyword = new ALStringField();
        this.isFileUploadable = ALEipUtils.isFileUploadable((RunData)rundata);
    }

    public void loadCategoryList(RunData rundata, Context context) {
        this.categoryList = MsgboardUtils.loadCategoryList(rundata);
        this.setCategory(rundata, context);
    }

    public void setCategory(RunData rundata, Context context) {
        String filter = rundata.getParameters().getString("filter", "");
        String filterType = rundata.getParameters().getString("filtertype", "");
        String sesFilter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        String sesFilterType = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        sesFilter = sesFilter == null ? "" : sesFilter;
        String string = sesFilterType = sesFilterType == null ? "" : sesFilterType;
        if (filterType.isEmpty()) {
            filter = sesFilter;
            filterType = sesFilterType;
        }
        if (filterType.equals("category")) {
            filter = "0," + filter;
            filterType = "post,category";
        } else if (!filterType.equals("post,category")) {
            filter = "";
            filterType = "";
        }
        if (StringUtils.isEmpty((String)filter) || StringUtils.isEmpty((String)filterType)) {
            this.filterType = "";
            this.categoryId = "";
            return;
        }
        String[] splited = filter.split(",");
        if (splited.length < 2) {
            this.filterType = "";
            this.categoryId = "";
            return;
        }
        this.categoryId = filter.split(",")[1];
        this.filterType = filterType;
        boolean existCategory = false;
        for (MsgboardCategoryResultData data : this.categoryList) {
            if (!this.categoryId.equals(data.getCategoryId().toString())) continue;
            existCategory = true;
            break;
        }
        if (!existCategory) {
            this.categoryId = "0";
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)(filter.split(",")[0] + "," + this.categoryId));
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)"post,category");
        }
    }

    public ResultList<EipTMsgboardTopic> selectList(RunData rundata, Context context) {
        try {
            if (MsgboardUtils.hasResetFlag(rundata, context)) {
                MsgboardUtils.resetFilter(rundata, context, ((Object)((Object)this)).getClass().getName());
                this.target_keyword.setValue("");
            } else {
                this.target_keyword.setValue(MsgboardUtils.getTargetKeyword(rundata, context));
            }
            SelectQuery<EipTMsgboardTopic> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.topicSum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"msgboard", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTMsgboardTopic> getSelectQuery(RunData rundata, Context context) {
        if (this.target_keyword != null && !this.target_keyword.getValue().equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR, (String)this.target_keyword.getValue());
        } else {
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR);
        }
        SelectQuery query = Database.query(EipTMsgboardTopic.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"parentId", (Object)0);
        query.setQualifier(exp1);
        Expression exp01 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)"T");
        Expression exp02 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.eipTMsgboardCategoryMaps.status", (Object)"O");
        Expression exp03 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.eipTMsgboardCategoryMaps.status", (Object)"A");
        Expression exp11 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)"F");
        Expression exp12 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.eipTMsgboardCategoryMaps.userId", (Object)ALEipUtils.getUserId((RunData)rundata));
        query.andQualifier(exp01.andExp(exp02.orExp(exp03)).orExp(exp11.andExp(exp12)));
        query.distinct(true);
        return this.buildSelectQueryForFilter((SelectQuery<EipTMsgboardTopic>)query, rundata, context);
    }

    protected void parseFilterMap(String key, String val) {
        super.parseFilterMap(key, val);
        HashSet unUse = new HashSet();
        for (Map.Entry pair : this.current_filterMap.entrySet()) {
            if (!((List)pair.getValue()).contains("0")) continue;
            unUse.add(pair.getKey());
        }
        for (String unusekey : unUse) {
            this.current_filterMap.remove(unusekey);
        }
    }

    protected SelectQuery<EipTMsgboardTopic> buildSelectQueryForFilter(SelectQuery<EipTMsgboardTopic> query, RunData rundata, Context context) {
        String search;
        if (this.current_filterMap.containsKey("category")) {
            List categoryIds = (List)this.current_filterMap.get("category");
            this.categoryId = ((String)categoryIds.get(0)).toString();
            List<MsgboardCategoryResultData> categoryList = MsgboardUtils.loadCategoryList(rundata);
            boolean existCategory = false;
            if (categoryList != null && categoryList.size() > 0) {
                for (MsgboardCategoryResultData msgboardCategoryResultData : categoryList) {
                    if (!this.categoryId.equals(msgboardCategoryResultData.getCategoryId().toString())) continue;
                    existCategory = true;
                    break;
                }
            }
            if (!existCategory) {
                this.categoryId = "";
                this.current_filterMap.remove("category");
            }
            this.updateCategoryName();
        }
        super.buildSelectQueryForFilter(query, rundata, context);
        if (this.current_filterMap.containsKey("post")) {
            List postIds = (List)this.current_filterMap.get("post");
            boolean existPost = false;
            for (int i = 0; i < this.postList.size(); ++i) {
                String pid = this.postList.get(i).getName().toString();
                if (!pid.equals(((String)postIds.get(0)).toString())) continue;
                existPost = true;
                break;
            }
            Map map = ALEipManager.getInstance().getPostMap();
            if (postIds != null && !postIds.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    String pid = ((ALEipPost)entry.getValue()).getGroupName().toString();
                    if (!pid.equals(((String)postIds.get(0)).toString())) continue;
                    existPost = true;
                    break;
                }
            }
            if (existPost) {
                HashSet<Integer> userIds = new HashSet<Integer>();
                for (String post : postIds) {
                    List userId = ALEipUtils.getUserIds((String)post);
                    userIds.addAll(userId);
                }
                if (userIds.isEmpty()) {
                    userIds.add(-1);
                }
                Expression expression = ExpressionFactory.inExp((String)"ownerId", userIds);
                query.andQualifier(expression);
                this.postId = ((String)postIds.get(0)).toString();
                this.updatePostName();
            } else {
                this.postId = "";
                this.updatePostName();
                this.current_filterMap.remove("post");
            }
        }
        if ((search = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR)) != null && !"".equals(search)) {
            this.current_search = search;
            Expression ex1 = ExpressionFactory.likeExp((String)"note", (Object)("%" + search + "%"));
            Expression ex2 = ExpressionFactory.likeExp((String)"topicName", (Object)("%" + search + "%"));
            SelectQuery q = Database.query(EipTMsgboardTopic.class);
            q.andQualifier(ex1.orExp(ex2));
            List list = q.fetchList();
            ArrayList<Integer> resultid = new ArrayList<Integer>();
            for (EipTMsgboardTopic item : list) {
                if (item.getParentId() != 0 && !resultid.contains(item.getParentId())) {
                    resultid.add(item.getParentId());
                    continue;
                }
                if (resultid.contains(item.getTopicId())) continue;
                resultid.add(item.getTopicId());
            }
            if (resultid.size() == 0) {
                resultid.add(-1);
            }
            Expression ex = ExpressionFactory.inDbExp((String)"TOPIC_ID", resultid);
            query.andQualifier(ex);
        }
        return query;
    }

    protected Object getResultData(EipTMsgboardTopic record) {
        try {
            MsgboardTopicResultData rd = new MsgboardTopicResultData();
            rd.initField();
            rd.setTopicId(record.getTopicId().longValue());
            rd.setTopicName(record.getTopicName());
            rd.setCategoryId(record.getEipTMsgboardCategory().getCategoryId().longValue());
            rd.setCategoryName(record.getEipTMsgboardCategory().getCategoryName());
            rd.setPublicFlag("T".equals(record.getEipTMsgboardCategory().getPublicFlag()));
            rd.setOwnerId(record.getOwnerId().longValue());
            rd.setOwnerName(ALEipUtils.getUserFullName((int)record.getOwnerId()));
            rd.setUpdateUser(ALEipUtils.getUserFullName((int)record.getUpdateUserId()));
            rd.setUpdateDate(record.getUpdateDate());
            Date date = record.getUpdateDate();
            Calendar now = Calendar.getInstance();
            now.add(5, -1);
            rd.setNewTopicFlag(date.after(now.getTime()));
            rd.setReplyCount(MsgboardUtils.countReply(record.getTopicId()).intValue());
            rd.setLoginUserId(this.uid);
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"msgboard", (Throwable)ex);
            return null;
        }
    }

    public boolean doViewDetail(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 2);
            action.setMode("detail");
            List<EipTMsgboardTopic> aList = this.selectDetailList(rundata, context);
            if (aList != null) {
                this.coTopicList = new ArrayList<MsgboardTopicResultData>();
                int size = aList.size();
                for (int i = 0; i < size; ++i) {
                    this.coTopicList.add((MsgboardTopicResultData)this.getResultDataDetail(aList.get(i)));
                }
            }
            action.setResultData((Object)this);
            action.putData(rundata, context);
            return true;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public List<EipTMsgboardTopic> selectDetailList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String topicid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        if (topicid == null || Integer.valueOf(topicid) == null) {
            logger.debug((Object)"[MsgboardTopic] Empty ID...");
            throw new ALPageNotFoundException();
        }
        VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
        String cotopicsort = null;
        cotopicsort = portlet != null ? portlet.getPortletConfig().getInitParameter("p2b-sort") : "response_old";
        try {
            this.parentTopic = this.getResultDataDetail(MsgboardUtils.getEipTMsgboardParentTopic(rundata, context, false));
            SelectQuery<EipTMsgboardTopic> query = this.getSelectQueryForCotopic(rundata, context, topicid, cotopicsort);
            if ("response_new".equals(cotopicsort)) {
                query.orderDesending("createDate");
            } else {
                query.orderAscending("createDate");
            }
            List resultList = query.fetchList();
            return resultList;
        }
        catch (ALPageNotFoundException pageNotFound) {
            throw pageNotFound;
        }
        catch (Exception ex) {
            logger.error((Object)"[MsgboardTopicSelectData]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public EipTMsgboardTopic selectDetail(RunData rundata, Context context) {
        ALEipUtils.redirectPageNotFound((RunData)rundata);
        return null;
    }

    private SelectQuery<EipTMsgboardTopic> getSelectQueryForCotopic(RunData rundata, Context context, String topicid, String cotopicsort) {
        SelectQuery query = Database.query(EipTMsgboardTopic.class);
        Expression exp = ExpressionFactory.matchExp((String)"parentId", (Object)Integer.valueOf(topicid));
        query.setQualifier(exp);
        query.distinct(true);
        return query;
    }

    private SelectQuery<EipTMsgboardFile> getSelectQueryForFiles(int topicid) {
        SelectQuery query = Database.query(EipTMsgboardFile.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"TOPIC_ID", (Object)topicid);
        query.setQualifier(exp);
        query.orderAscending("updateDate");
        query.orderAscending("filePath");
        return query;
    }

    protected Object getResultDataDetail(EipTMsgboardTopic record) throws ALPageNotFoundException, ALDBErrorException {
        try {
            if (record.getParentId() == 0) {
                EipTMsgboardCategory category = record.getEipTMsgboardCategory();
                if ("T".equals(category.getPublicFlag())) {
                    List categoryMap = category.getEipTMsgboardCategoryMaps();
                    int mapsize = categoryMap.size();
                    for (int i = 0; i < mapsize; ++i) {
                        EipTMsgboardCategoryMap map = (EipTMsgboardCategoryMap)categoryMap.get(i);
                        if ("A".equals(map.getStatus())) {
                            this.showReplyForm = true;
                            continue;
                        }
                        if (map.getUserId() != this.uid) continue;
                        this.showReplyForm = true;
                        break;
                    }
                } else {
                    this.showReplyForm = true;
                }
            }
            MsgboardTopicResultData rd = new MsgboardTopicResultData();
            rd.initField();
            rd.setTopicId(record.getTopicId().longValue());
            rd.setTopicName(record.getTopicName());
            rd.setParentId(record.getParentId().longValue());
            rd.setCategoryId(record.getEipTMsgboardCategory().getCategoryId().longValue());
            rd.setCategoryName(record.getEipTMsgboardCategory().getCategoryName());
            rd.setPublicFlag("T".equals(record.getEipTMsgboardCategory().getPublicFlag()));
            rd.setOwnerId(record.getOwnerId().longValue());
            rd.setOwnerName(ALEipUtils.getUserFullName((int)record.getOwnerId()));
            ALEipUser user = ALEipUtils.getALEipUser((int)record.getOwnerId());
            if (user != null) {
                rd.setOwnerHasPhoto(user.hasPhoto());
            }
            rd.setNote(record.getNote());
            rd.setCreateDate(record.getCreateDate());
            rd.setUpdateDate(record.getUpdateDate());
            rd.setLoginUserId(this.uid);
            List list = this.getSelectQueryForFiles(record.getTopicId()).fetchList();
            if (list != null && list.size() > 0) {
                ArrayList<FileuploadBean> attachmentFileList = new ArrayList<FileuploadBean>();
                FileuploadBean filebean = null;
                EipTMsgboardFile file = null;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    file = (EipTMsgboardFile)list.get(i);
                    String realname = file.getFileName();
                    DataHandler hData = new DataHandler((DataSource)new FileDataSource(realname));
                    filebean = new FileuploadBean();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(realname);
                    if (hData != null) {
                        filebean.setContentType(hData.getContentType());
                    }
                    filebean.setIsImage(FileuploadUtils.isImage((String)realname));
                    attachmentFileList.add(filebean);
                }
                rd.setAttachmentFiles(attachmentFileList);
            }
            return rd;
        }
        catch (Exception e) {
            logger.error((Object)"[MsgboardTopicSelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
    }

    public List<MsgboardCategoryResultData> getCategoryList() {
        if (this.hasAclCategoryList) {
            return this.categoryList;
        }
        return new ArrayList<MsgboardCategoryResultData>();
    }

    public int getTopicSum() {
        return this.topicSum;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("topic_name", "topicName");
        map.putValue("update_date", "updateDate");
        map.putValue("category", "CATEGORY_ID");
        map.putValue("category_name", "eipTMsgboardCategory.categoryName");
        map.putValue("owner_name", "ownerId");
        map.putValue("update_user", "updateUserId");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public List<ALEipUser> getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public Object getParentTopic() {
        return this.parentTopic;
    }

    public List<MsgboardTopicResultData> getCoTopicList() {
        return this.coTopicList;
    }

    public int getUserId() {
        return this.uid;
    }

    public boolean showReplyForm() {
        return this.showReplyForm;
    }

    public String getAclPortletFeature() {
        return "msgboard_topic";
    }

    public boolean hasAclUpdateTopicOthers() {
        return this.hasAclUpdateTopicOthers;
    }

    public boolean hasAclDeleteTopicOthers() {
        return this.hasAclDeleteTopicOthers;
    }

    public String getCurrentSearchWithSanitize() {
        return ALStringUtil.sanitizing((String)this.getCurrentSearch());
    }

    public ALStringField getTargetKeyword() {
        return this.target_keyword;
    }

    public int getTableColumNum() {
        return this.table_colum_num;
    }

    public void setTableColumNum(int table_colum_num) {
        this.table_colum_num = table_colum_num;
    }

    public List<ALEipGroup> getPostList() {
        return this.postList;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public void setFiltersFromPSML(VelocityPortlet portlet, Context context, RunData rundata) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)portlet.getPortletConfig().getInitParameter("p12f-filters"));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)portlet.getPortletConfig().getInitParameter("p12g-filtertypes"));
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getPostId() {
        return this.postId;
    }

    private void updateCategoryName() {
        this.categoryName = "";
        if (this.categoryList != null) {
            for (int i = 0; i < this.categoryList.size(); ++i) {
                String cid = this.categoryList.get(i).getCategoryId().toString();
                if (cid == null || this.categoryId == null || !cid.equals(this.categoryId.toString())) continue;
                this.categoryName = this.categoryList.get(i).getCategoryName().toString();
                return;
            }
        }
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    private void updatePostName() {
        this.postName = "";
        for (int i = 0; i < this.postList.size(); ++i) {
            String pid = this.postList.get(i).getName().toString();
            if (!pid.equals(this.postId.toString())) continue;
            this.postName = this.postList.get(i).getAliasName().toString();
            return;
        }
        Map map = ALEipManager.getInstance().getPostMap();
        for (Map.Entry item : map.entrySet()) {
            String pid = ((ALEipPost)item.getValue()).getGroupName().toString();
            if (!pid.equals(this.postId.toString())) continue;
            this.postName = ((ALEipPost)item.getValue()).getPostName().toString();
            return;
        }
    }

    public String getPostName() {
        return this.postName;
    }

    public boolean isFileUploadable() {
        return this.isFileUploadable;
    }
}

