/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.msgboard.util;

import com.aimluck.commons.utils.ALDeleteFileUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategoryMap;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.common.ALActivity;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALFileNotRemovedException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.msgboard.MsgboardCategoryResultData;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.social.ALActivityService;
import com.aimluck.eip.services.social.model.ALActivityPutRequest;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.customlocalization.CustomLocalizationService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class MsgboardUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardUtils.class.getName());
    public static final String OWNER_ID = "ownerid";
    private static final String FOLDER_FILEDIR_MSGBOARD = JetspeedResources.getString((String)"aipo.filedir", (String)"");
    protected static final String CATEGORY_KEY = JetspeedResources.getString((String)"aipo.msgboard.categorykey", (String)"");
    public static final String FILE_ENCODING = JetspeedResources.getString((String)"content.defaultencoding", (String)"UTF-8");
    public static final int ACCESS_PUBLIC_ALL = 0;
    public static final int ACCESS_PUBLIC_MEMBER = 1;
    public static final int ACCESS_SEACRET_MEMBER = 2;
    public static final int ACCESS_SEACRET_SELF = 3;
    public static final String PUBLIC_FLG_VALUE_PUBLIC = "T";
    public static final String PUBLIC_FLG_VALUE_NONPUBLIC = "F";
    public static final String STAT_VALUE_OWNER = "O";
    public static final String STAT_VALUE_SHARE = "S";
    public static final String STAT_VALUE_ALL = "A";
    public static final String MSGBOARD_PORTLET_NAME = "Msgboard";
    public static final String TARGET_KEYWORD = "keyword";
    private static final String RESET_FLAG = "reset_params";

    public static EipTMsgboardTopic getEipTMsgboardParentTopic(RunData rundata, Context context, boolean isJoin) throws ALPageNotFoundException, ALDBErrorException {
        String topicid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (topicid == null || Integer.valueOf(topicid) == null) {
                logger.debug((Object)"[MsgboardTopic] Empty ID...");
                throw new ALPageNotFoundException();
            }
            int userid = ALEipUtils.getUserId((RunData)rundata);
            SelectQuery query = Database.query(EipTMsgboardTopic.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"TOPIC_ID", (Object)Integer.valueOf(topicid));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"parentId", (Object)0);
            query.andQualifier(exp2);
            query.distinct(true);
            List topics = query.fetchList();
            if (topics == null || topics.size() == 0) {
                logger.debug((Object)"[MsgboardTopic] Not found ID...");
                throw new ALPageNotFoundException();
            }
            EipTMsgboardTopic topic = (EipTMsgboardTopic)topics.get(0);
            EipTMsgboardCategory category = topic.getEipTMsgboardCategory();
            boolean accessible = false;
            if (category == null) {
                logger.debug((Object)"[MsgboardTopic] Not found Category...");
                throw new ALPageNotFoundException();
            }
            if (category.getPublicFlag().equals(PUBLIC_FLG_VALUE_PUBLIC)) {
                accessible = true;
            } else {
                List maps = category.getEipTMsgboardCategoryMaps();
                for (EipTMsgboardCategoryMap map : maps) {
                    if (!map.getUserId().equals(userid)) continue;
                    accessible = true;
                    break;
                }
            }
            if (!accessible) {
                ALEipUtils.redirectPermissionError((RunData)rundata);
            }
            return topic;
        }
        catch (ALPageNotFoundException pageNotFound) {
            throw pageNotFound;
        }
        catch (Exception ex) {
            logger.error((Object)"[MsgboardUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTMsgboardTopic getEipTMsgboardTopicReply(RunData rundata, Context context, String topicid, boolean isSuperUser) throws ALPageNotFoundException, ALDBErrorException {
        try {
            List topics;
            if (topicid == null || Integer.valueOf(topicid) == null) {
                logger.debug((Object)"[MsgboardTopic] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTMsgboardTopic.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"TOPIC_ID", (Object)Integer.valueOf(topicid));
            query.setQualifier(exp1);
            if (!isSuperUser) {
                Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
                query.andQualifier(exp2);
            }
            if ((topics = query.fetchList()) == null || topics.size() == 0) {
                logger.debug((Object)"[MsgboardTopic] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTMsgboardTopic)topics.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[MsgboardUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTMsgboardFile getEipTMsgboardFile(RunData rundata) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int attachmentIndex = rundata.getParameters().getInt("attachmentIndex", -1);
            if (attachmentIndex < 0) {
                logger.debug((Object)"[MsgboardUtils] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTMsgboardFile.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)attachmentIndex);
            query.andQualifier(exp);
            List files = query.fetchList();
            if (files == null || files.size() == 0) {
                logger.debug((Object)"[MsgboardUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTMsgboardFile)files.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[MsgboardUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List<EipTMsgboardTopic> getEipTMsgboardTopicList(RunData rundata, Context context, boolean isJoin) throws ALPageNotFoundException, ALDBErrorException {
        String topicid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (topicid == null || Integer.valueOf(topicid) == null) {
                logger.debug((Object)"[MsgboardTopic] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTMsgboardTopic.class);
            Expression exp001 = ExpressionFactory.matchExp((String)"parentId", (Object)Integer.valueOf(topicid));
            Expression exp01 = ExpressionFactory.matchDbExp((String)"TOPIC_ID", (Object)Integer.valueOf(topicid));
            Expression exp11 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)PUBLIC_FLG_VALUE_PUBLIC);
            Expression exp21 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)PUBLIC_FLG_VALUE_NONPUBLIC);
            Expression exp22 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.eipTMsgboardCategoryMaps.userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp01.andExp(exp11.orExp(exp21.andExp(exp22))).orExp(exp001));
            query.distinct(true);
            List topics = query.fetchList();
            if (topics == null || topics.size() == 0) {
                logger.debug((Object)"[MsgboardTopic] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return topics;
        }
        catch (Exception ex) {
            logger.error((Object)"[MsgboardUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List<EipTMsgboardTopic> getEipTMsgboardTopicListToDeleteTopic(RunData rundata, Context context, boolean isSuperUser) throws ALPageNotFoundException, ALDBErrorException {
        String topicid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (topicid == null || Integer.valueOf(topicid) == null) {
                logger.debug((Object)"[MsgboardTopic] Empty ID...");
                throw new ALPageNotFoundException();
            }
            int userid = ALEipUtils.getUserId((RunData)rundata);
            SelectQuery query = Database.query(EipTMsgboardTopic.class);
            Expression exp01 = ExpressionFactory.matchDbExp((String)"OWNER_ID", (Object)userid);
            Expression exp02 = ExpressionFactory.matchDbExp((String)"TOPIC_ID", (Object)Integer.valueOf(topicid));
            Expression exp03 = ExpressionFactory.matchExp((String)"parentId", (Object)Integer.valueOf(topicid));
            if (isSuperUser) {
                query.andQualifier(exp02.orExp(exp03));
            } else {
                query.andQualifier(exp01.andExp(exp02).orExp(exp03));
            }
            List topics = query.fetchList();
            if (topics == null || topics.size() == 0) {
                logger.debug((Object)"[MsgboardTopic] Not found ID...");
                throw new ALPageNotFoundException();
            }
            boolean isdelete = false;
            int size = topics.size();
            for (int i = 0; i < size; ++i) {
                EipTMsgboardTopic topic = (EipTMsgboardTopic)topics.get(i);
                if (topic.getOwnerId() != userid && !isSuperUser) continue;
                isdelete = true;
                break;
            }
            if (!isdelete) {
                logger.debug((Object)"[MsgboardTopic] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return topics;
        }
        catch (Exception ex) {
            logger.error((Object)"[MsgboardUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTMsgboardCategory getEipTMsgboardCategory(RunData rundata, Context context, boolean ownerOnly) throws ALPageNotFoundException, ALDBErrorException {
        String categoryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (categoryid == null || Integer.valueOf(categoryid) == null) {
                logger.debug((Object)"[MsgboardCategory] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTMsgboardCategory.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"CATEGORY_ID", (Object)Integer.valueOf(categoryid));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.noMatchDbExp((String)"turbineUser.USER_ID", (Object)0);
            query.andQualifier(exp2);
            if (ownerOnly) {
                // empty if block
            }
            int loginUserId = ALEipUtils.getUserId((RunData)rundata);
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            boolean hasAclviewOther = aclhandler.hasAuthority(loginUserId, "msgboard_category_other", 1);
            Expression exp01 = ExpressionFactory.matchExp((String)"publicFlag", (Object)PUBLIC_FLG_VALUE_PUBLIC);
            Expression exp02 = ExpressionFactory.matchExp((String)"eipTMsgboardCategoryMaps.status", (Object)STAT_VALUE_OWNER);
            Expression exp03 = ExpressionFactory.matchExp((String)"eipTMsgboardCategoryMaps.status", (Object)STAT_VALUE_ALL);
            Expression exp11 = ExpressionFactory.matchExp((String)"publicFlag", (Object)PUBLIC_FLG_VALUE_NONPUBLIC);
            Expression exp12 = ExpressionFactory.matchExp((String)"eipTMsgboardCategoryMaps.userId", (Object)loginUserId);
            if (!hasAclviewOther) {
                query.andQualifier(exp01.andExp(exp02.orExp(exp03)).orExp(exp11.andExp(exp12)));
            } else {
                query.andQualifier(exp01.andExp(exp02.orExp(exp03)).orExp(exp11.andExp(exp02.orExp(exp03))));
            }
            query.distinct(true);
            List categories = query.fetchList();
            if (categories == null || categories.size() == 0) {
                logger.debug((Object)"[MsgboardUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTMsgboardCategory)categories.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[MsgboardUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List<Integer> getWhatsNewInsertList(RunData rundata, int categoryid, String is_public) throws ALPageNotFoundException, ALDBErrorException {
        int userid = ALEipUtils.getUserId((RunData)rundata);
        ArrayList<ALEipUser> result = new ArrayList<ALEipUser>();
        if (PUBLIC_FLG_VALUE_NONPUBLIC.equals(is_public)) {
            try {
                SelectQuery query = Database.query(EipTMsgboardCategoryMap.class);
                query.select("USER_ID");
                Expression exp1 = ExpressionFactory.matchExp((String)"categoryId", (Object)categoryid);
                query.setQualifier(exp1);
                Expression exp11 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)PUBLIC_FLG_VALUE_PUBLIC);
                Expression exp12 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)PUBLIC_FLG_VALUE_NONPUBLIC);
                Expression exp13 = ExpressionFactory.matchExp((String)"status", (Object)STAT_VALUE_SHARE);
                Expression exp14 = ExpressionFactory.matchExp((String)"status", (Object)STAT_VALUE_OWNER);
                query.andQualifier(exp11.orExp(exp12.andExp(exp13)).orExp(exp12.andExp(exp14)));
                query.distinct(true);
                List uids = query.fetchList();
                ArrayList<Integer> userIds = new ArrayList<Integer>();
                if (uids != null && uids.size() != 0) {
                    int size = uids.size();
                    for (int i = 0; i < size; ++i) {
                        EipTMsgboardCategoryMap uid = (EipTMsgboardCategoryMap)uids.get(i);
                        Integer id = uid.getUserId();
                        if (id == userid) continue;
                        result.add(ALEipUtils.getALEipUser((int)id));
                        userIds.add((int)id);
                    }
                }
                return userIds;
            }
            catch (Exception ex) {
                logger.error((Object)"[MsgboardUtils]", (Throwable)ex);
                throw new ALDBErrorException();
            }
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        List userIds = aclhandler.getAcceptUserIdsExceptLoginUser(ALEipUtils.getUserId((RunData)rundata), "msgboard_topic", 2);
        return userIds;
    }

    public static List<MsgboardCategoryResultData> loadCategoryList(RunData rundata) {
        ArrayList<MsgboardCategoryResultData> categoryList = new ArrayList<MsgboardCategoryResultData>();
        try {
            SelectQuery query = Database.query(EipTMsgboardCategory.class);
            Expression exp01 = ExpressionFactory.matchExp((String)"publicFlag", (Object)PUBLIC_FLG_VALUE_PUBLIC);
            Expression exp02 = ExpressionFactory.matchExp((String)"eipTMsgboardCategoryMaps.status", (Object)STAT_VALUE_OWNER);
            Expression exp03 = ExpressionFactory.matchExp((String)"eipTMsgboardCategoryMaps.status", (Object)STAT_VALUE_ALL);
            Expression exp11 = ExpressionFactory.matchExp((String)"publicFlag", (Object)PUBLIC_FLG_VALUE_NONPUBLIC);
            Expression exp12 = ExpressionFactory.matchExp((String)"eipTMsgboardCategoryMaps.userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp01.andExp(exp02.orExp(exp03)).orExp(exp11.andExp(exp12)));
            query.orderAscending("categoryName");
            query.distinct(true);
            MsgboardCategoryResultData otherRd = null;
            List aList = query.fetchList();
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipTMsgboardCategory record = (EipTMsgboardCategory)aList.get(i);
                MsgboardCategoryResultData rd = new MsgboardCategoryResultData();
                rd.initField();
                rd.setCategoryId(record.getCategoryId().longValue());
                rd.setCategoryName(record.getCategoryName());
                if (record.getCategoryId().longValue() == 1L) {
                    otherRd = rd;
                    continue;
                }
                categoryList.add(rd);
            }
            if (otherRd != null) {
                categoryList.add(otherRd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"msgboard", (Throwable)ex);
            return null;
        }
        return categoryList;
    }

    public static void deleteFiles(int timelineId, String orgId, int uid, List<String> fpaths) throws ALFileNotRemovedException {
        ALDeleteFileUtil.deleteFiles((int)timelineId, (String)"eipTMsgboardTopic", (String)MsgboardUtils.getSaveDirPath(orgId, uid), fpaths, EipTMsgboardFile.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<FileuploadLiteBean> getFileuploadList(RunData rundata) {
        int fileid;
        String[] fileids = rundata.getParameters().getStrings("attachments");
        if (fileids == null) {
            return null;
        }
        ArrayList<String> hadfileids = new ArrayList<String>();
        ArrayList<String> newfileids = new ArrayList<String>();
        for (int j = 0; j < fileids.length; ++j) {
            if (fileids[j].trim().startsWith("s")) {
                hadfileids.add(fileids[j].trim().substring(1));
                continue;
            }
            newfileids.add(fileids[j].trim());
        }
        ArrayList<FileuploadLiteBean> fileNameList = new ArrayList<FileuploadLiteBean>();
        FileuploadLiteBean filebean = null;
        if (newfileids.size() > 0) {
            String folderName = rundata.getParameters().getString("folderName");
            if (folderName == null || folderName.equals("")) {
                return null;
            }
            for (String newfileid : newfileids) {
                if ("".equals(newfileid)) continue;
                fileid = 0;
                try {
                    fileid = Integer.parseInt(newfileid);
                }
                catch (Exception e) {
                    continue;
                }
                if (fileid == 0) {
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName("photo");
                    filebean.setFileName("\u4ee5\u524d\u306e\u5199\u771f\u30d5\u30a1\u30a4\u30eb");
                    fileNameList.add(filebean);
                    continue;
                }
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(ALStorageService.getFile((String)FileuploadUtils.FOLDER_TMP_FOR_ATTACHMENT_FILES, (String)(ALEipUtils.getUserId((RunData)rundata) + ALStorageService.separator() + folderName), (String)(fileid + ".txt")), FILE_ENCODING));
                    String line = reader.readLine();
                    if (line == null || line.length() <= 0) continue;
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName(newfileid);
                    filebean.setFileId(fileid);
                    filebean.setFileName(line);
                    fileNameList.add(filebean);
                }
                catch (Exception e) {
                    logger.error((Object)"msgboard", (Throwable)e);
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"msgboard", (Throwable)e);
                    }
                }
            }
        }
        if (hadfileids.size() > 0) {
            ArrayList<Integer> hadfileidsValue = new ArrayList<Integer>();
            for (String hadfileid : hadfileids) {
                fileid = 0;
                try {
                    fileid = Integer.parseInt(hadfileid);
                    hadfileidsValue.add(fileid);
                }
                catch (Exception e) {}
            }
            try {
                SelectQuery reqquery = Database.query(EipTMsgboardFile.class);
                Expression reqexp1 = ExpressionFactory.inDbExp((String)"FILE_ID", hadfileidsValue);
                reqquery.setQualifier(reqexp1);
                List requests = reqquery.fetchList();
                for (EipTMsgboardFile file : requests) {
                    filebean = new FileuploadBean();
                    filebean.initField();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(file.getFileName());
                    filebean.setFlagNewFile(false);
                    fileNameList.add(filebean);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"[BlogUtils] Exception.", (Throwable)ex);
            }
        }
        return fileNameList;
    }

    public static boolean insertFileDataDelegate(RunData rundata, Context context, EipTMsgboardTopic topic, List<FileuploadLiteBean> fileuploadList, String folderName, List<String> msgList) {
        if (fileuploadList == null || fileuploadList.size() <= 0) {
            fileuploadList = new ArrayList<FileuploadLiteBean>();
        }
        int uid = ALEipUtils.getUserId((RunData)rundata);
        String orgId = Database.getDomainName();
        ArrayList<Integer> hadfileids = new ArrayList<Integer>();
        for (FileuploadLiteBean file : fileuploadList) {
            if (file.isNewFile()) continue;
            hadfileids.add(file.getFileId());
        }
        SelectQuery dbquery = Database.query(EipTMsgboardFile.class);
        dbquery.andQualifier(ExpressionFactory.matchDbExp((String)"eipTMsgboardTopic", (Object)topic.getTopicId()));
        List existsFiles = dbquery.fetchList();
        ArrayList<EipTMsgboardFile> delFiles = new ArrayList<EipTMsgboardFile>();
        for (EipTMsgboardFile file : existsFiles) {
            if (hadfileids.contains(file.getFileId())) continue;
            delFiles.add(file);
        }
        if (delFiles.size() > 0) {
            int delsize = delFiles.size();
            for (int i = 0; i < delsize; ++i) {
                ALStorageService.deleteFile((String)(MsgboardUtils.getSaveDirPath(orgId, uid) + ((EipTMsgboardFile)delFiles.get(i)).getFilePath()));
            }
            Database.deleteAll(delFiles);
        }
        try {
            for (FileuploadLiteBean filebean : fileuploadList) {
                if (!filebean.isNewFile()) continue;
                String[] acceptExts = ImageIO.getWriterFormatNames();
                FileuploadUtils.ShrinkImageSet shrinkImageSet = FileuploadUtils.getBytesShrinkFilebean((String)orgId, (String)folderName, (int)uid, (FileuploadLiteBean)filebean, (String[])acceptExts, (int)86, (int)86, msgList, (boolean)true);
                String filename = "0_" + String.valueOf(System.nanoTime());
                EipTMsgboardFile file = (EipTMsgboardFile)Database.create(EipTMsgboardFile.class);
                file.setOwnerId(Integer.valueOf(uid));
                file.setEipTMsgboardTopic(topic);
                file.setFileName(filebean.getFileName());
                file.setFilePath(MsgboardUtils.getRelativePath(filename));
                if (shrinkImageSet != null && shrinkImageSet.getShrinkImage() != null) {
                    file.setFileThumbnail(shrinkImageSet.getShrinkImage());
                }
                file.setCreateDate(Calendar.getInstance().getTime());
                file.setUpdateDate(Calendar.getInstance().getTime());
                if (shrinkImageSet != null && shrinkImageSet.getFixImage() != null) {
                    ALStorageService.createNewFile((InputStream)new ByteArrayInputStream(shrinkImageSet.getFixImage()), (String)(FOLDER_FILEDIR_MSGBOARD + ALStorageService.separator() + Database.getDomainName() + ALStorageService.separator() + CATEGORY_KEY + ALStorageService.separator() + uid + ALStorageService.separator() + filename));
                    continue;
                }
                ALStorageService.copyTmpFile((int)uid, (String)folderName, (String)String.valueOf(filebean.getFileId()), (String)FOLDER_FILEDIR_MSGBOARD, (String)(CATEGORY_KEY + ALStorageService.separator() + uid), (String)filename);
            }
            ALStorageService.deleteTmpFolder((int)uid, (String)folderName);
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"msgboard", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getSaveDirPath(String orgId, int uid) {
        return ALStorageService.getDocumentPath((String)FOLDER_FILEDIR_MSGBOARD, (String)(CATEGORY_KEY + ALStorageService.separator() + uid));
    }

    public static String getRelativePath(String fileName) {
        return new StringBuffer().append("/").append(fileName).toString();
    }

    @Deprecated
    public static void shiftWhatsNewReadFlag(RunData rundata, int entityid) {
        int uid = ALEipUtils.getUserId((RunData)rundata);
        boolean isPublic = false;
        SelectQuery query = Database.query(EipTMsgboardTopic.class);
        Expression exp = ExpressionFactory.matchExp((String)"parentId", (Object)entityid);
        query.setQualifier(exp);
        query.select("TOPIC_ID");
        query.distinct(true);
        List topics = query.fetchList();
        query = Database.query(EipTMsgboardTopic.class);
        exp = ExpressionFactory.matchDbExp((String)"TOPIC_ID", (Object)entityid);
        query.setQualifier(exp);
        List topic = query.fetchList();
        if (topic != null && ((EipTMsgboardTopic)topic.get(0)).getEipTMsgboardCategory().getPublicFlag().equals(PUBLIC_FLG_VALUE_PUBLIC)) {
            isPublic = true;
        }
        if (topics != null) {
            int size = topics.size();
            Integer _id = null;
            if (isPublic) {
                for (int i = 0; i < size; ++i) {
                    EipTMsgboardTopic record = (EipTMsgboardTopic)topics.get(i);
                    _id = record.getTopicId();
                    WhatsNewUtils.shiftWhatsNewReadFlagPublic((int)4, (int)_id, (int)uid);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    EipTMsgboardTopic record = (EipTMsgboardTopic)topics.get(i);
                    _id = record.getTopicId();
                    WhatsNewUtils.shiftWhatsNewReadFlag((int)4, (int)_id, (int)uid);
                }
            }
        }
        if (isPublic) {
            WhatsNewUtils.shiftWhatsNewReadFlagPublic((int)4, (int)entityid, (int)uid);
        } else {
            WhatsNewUtils.shiftWhatsNewReadFlag((int)4, (int)entityid, (int)uid);
        }
    }

    public static String getTargetKeyword(RunData rundata, Context context) {
        String target_keyword = null;
        String keywordParam = rundata.getParameters().getString(TARGET_KEYWORD);
        target_keyword = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD);
        if (keywordParam == null && target_keyword == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
            target_keyword = "";
        } else if (keywordParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)keywordParam.trim());
            target_keyword = keywordParam;
        }
        return target_keyword;
    }

    public static boolean hasResetFlag(RunData rundata, Context context) {
        String resetflag = rundata.getParameters().getString(RESET_FLAG);
        return resetflag != null;
    }

    public static void resetFilter(RunData rundata, Context context, String className) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
    }

    public static boolean checkPermission(RunData rundata, Context context, int defineAclType, String pfeature) {
        if (defineAclType == 0) {
            return true;
        }
        if (pfeature == null || "".equals(pfeature)) {
            return true;
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        boolean hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), pfeature, defineAclType);
        return hasAuthority;
    }

    public static Integer countReply(Integer topic_id) {
        SelectQuery query = Database.query(EipTMsgboardTopic.class);
        Expression exp1 = ExpressionFactory.matchDbExp((String)"PARENT_ID", (Object)topic_id);
        query.setQualifier(exp1);
        return query.getCount();
    }

    public static void createTopicActivity(EipTMsgboardTopic topic, String loginName, boolean isNew) {
        MsgboardUtils.createTopicActivity(topic, loginName, null, isNew);
    }

    public static void createTopicActivity(EipTMsgboardTopic topic, String loginName, List<String> recipients, boolean isNew) {
        ALActivity RecentActivity = ALActivity.getRecentActivity((String)MSGBOARD_PORTLET_NAME, (int)topic.getTopicId(), (float)0.0f);
        boolean isDeletePrev = RecentActivity != null && RecentActivity.isReplace(loginName);
        String title = "\u63b2\u793a\u677f\u300c" + topic.getTopicName() + "\u300d\u3092" + (isNew ? "\u4f5c\u6210\u3057\u307e\u3057\u305f\u3002" : "\u7de8\u96c6\u3057\u307e\u3057\u305f\u3002");
        String portletParams = "?template=MsgboardTopicDetailScreen" + "&entityid=" + topic.getTopicId();
        if (recipients != null && recipients.size() > 0) {
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(MSGBOARD_PORTLET_NAME).withUserId(topic.getOwnerId().intValue()).withLoginName(loginName).withPortletParams(portletParams).withRecipients(recipients).withTitle(title).withPriority(0.0f).withExternalId(String.valueOf(topic.getTopicId())));
        } else {
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(MSGBOARD_PORTLET_NAME).withLoginName(loginName).withUserId(topic.getOwnerId().intValue()).withPortletParams(portletParams).withTitle(title).withPriority(0.0f).withExternalId(String.valueOf(topic.getTopicId())));
        }
        if (isDeletePrev) {
            RecentActivity.delete();
        }
    }

    public static void createNewTopicActivity(EipTMsgboardTopic topic, String loginName, List<String> recipient, EipTMsgboardTopic childTopic) {
        boolean isDeletePrev;
        ALActivity RecentActivity = ALActivity.getRecentActivity((String)MSGBOARD_PORTLET_NAME, (int)topic.getTopicId(), (float)1.0f);
        boolean bl = isDeletePrev = RecentActivity != null && RecentActivity.isReplace(loginName);
        if (recipient != null) {
            StringBuilder b = new StringBuilder("\u63b2\u793a\u677f\u300c");
            b.append(ALCommonUtils.compressString((String)topic.getTopicName(), (int)30)).append("\u300d").append("\u306b\u8fd4\u4fe1\u3057\u307e\u3057\u305f\u3002");
            String portletParams = "?template=MsgboardTopicDetailScreen" + "&entityid=" + topic.getTopicId();
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(MSGBOARD_PORTLET_NAME).withUserId(childTopic.getOwnerId().intValue()).withLoginName(loginName).withPortletParams(portletParams).withRecipients(recipient).withTitle(b.toString()).withPriority(1.0f).withExternalId(String.valueOf(topic.getTopicId())));
        } else {
            StringBuilder b = new StringBuilder("\u63b2\u793a\u677f\u300c");
            b.append(ALCommonUtils.compressString((String)topic.getTopicName(), (int)30)).append("\u300d").append("\u306b\u8fd4\u4fe1\u3057\u307e\u3057\u305f\u3002");
            String portletParams = "?template=MsgboardTopicDetailScreen" + "&entityid=" + topic.getTopicId();
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(MSGBOARD_PORTLET_NAME).withUserId(childTopic.getOwnerId().intValue()).withLoginName(loginName).withPortletParams(portletParams).withTitle(b.toString()).withPriority(1.0f).withExternalId(String.valueOf(topic.getTopicId())));
        }
        if (isDeletePrev) {
            RecentActivity.delete();
        }
    }

    public static void createNewCommentActivity(EipTMsgboardTopic topic, String loginName, EipTMsgboardTopic childTopic) {
        MsgboardUtils.createNewCommentActivity(topic, loginName, null, childTopic);
    }

    public static void createNewCommentActivity(EipTMsgboardTopic topic, String loginName, List<String> recipients, EipTMsgboardTopic childTopic) {
        String title = "\u63b2\u793a\u677f\u300c" + ALCommonUtils.compressString((String)topic.getTopicName(), (int)30) + "\u300d\u306b" + "\u8fd4\u4fe1\u3057\u307e\u3057\u305f\u3002";
        String portletParams = "?template=MsgboardTopicDetailScreen" + "&entityid=" + topic.getTopicId();
        if (recipients != null && recipients.size() > 0) {
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(MSGBOARD_PORTLET_NAME).withUserId(childTopic.getOwnerId().intValue()).withLoginName(loginName).withPortletParams(portletParams).withRecipients(recipients).withTitle(title).withPriority(0.0f).withExternalId(String.valueOf(topic.getTopicId())));
        } else {
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withUserId(childTopic.getOwnerId().intValue()).withAppId(MSGBOARD_PORTLET_NAME).withLoginName(loginName).withPortletParams(portletParams).withTitle(title).withPriority(0.0f).withExternalId(String.valueOf(topic.getTopicId())));
        }
    }

    public static String createReplyMsgForPc(RunData rundata, EipTMsgboardTopic parenttopic, EipTMsgboardTopic topic, List<ALEipUser> memberList) throws ALDBErrorException {
        VelocityContext context = new VelocityContext();
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        ALEipUser loginUser = null;
        ALBaseUser user = null;
        try {
            loginUser = ALEipUtils.getALEipUser((RunData)rundata);
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(loginUser.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        context.put("loginUser", (Object)loginUser.getAliasName().toString());
        context.put("hasEmail", (Object)(!user.getEmail().equals("") ? 1 : 0));
        context.put("email", (Object)user.getEmail());
        context.put("topicName", (Object)parenttopic.getTopicName().toString());
        StringBuffer Note = new StringBuffer();
        if (topic.getNote().toString().length() > 0) {
            Note.append(topic.getNote().toString());
        }
        context.put("note", (Object)Note);
        context.put("serviceAlias", (Object)ALOrgUtilsService.getAlias());
        context.put("enableAsp", (Object)enableAsp);
        context.put("globalurl", (Object)ALMailUtils.getGlobalurl());
        context.put("localurl", (Object)ALMailUtils.getLocalurl());
        CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService");
        String lang = locService.getLocale(rundata).getLanguage();
        StringWriter writer = new StringWriter();
        try {
            Template template;
            if (lang != null && lang.equals("ja")) {
                template = Velocity.getTemplate((String)("portlets/mail/" + lang + "/msgboard-notification-mail.vm"), (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            } else {
                template = Velocity.getTemplate((String)"portlets/mail/msgboard-notification-mail.vm", (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        writer.flush();
        String ret = writer.getBuffer().toString();
        return ret;
    }

    public static String createReplyMsgForCellPhone(RunData rundata, EipTMsgboardTopic parenttopic, EipTMsgboardTopic topic, List<ALEipUser> memberList) throws ALDBErrorException {
        VelocityContext context = new VelocityContext();
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        ALEipUser loginUser = null;
        ALBaseUser user = null;
        try {
            loginUser = ALEipUtils.getALEipUser((RunData)rundata);
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(loginUser.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        context.put("loginUser", (Object)loginUser.getAliasName().toString());
        context.put("hasEmail", (Object)(!user.getEmail().equals("") ? 1 : 0));
        context.put("email", (Object)user.getEmail());
        context.put("topicName", (Object)parenttopic.getTopicName().toString());
        StringBuffer Note = new StringBuffer();
        if (topic.getNote().toString().length() > 0) {
            Note.append(topic.getNote().toString());
        }
        context.put("note", (Object)Note);
        context.put("serviceAlias", (Object)ALOrgUtilsService.getAlias());
        context.put("enableAsp", (Object)enableAsp);
        context.put("globalurl", (Object)ALMailUtils.getGlobalurl());
        context.put("localurl", (Object)ALMailUtils.getLocalurl());
        CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService");
        String lang = locService.getLocale(rundata).getLanguage();
        StringWriter writer = new StringWriter();
        try {
            Template template;
            if (lang != null && lang.equals("ja")) {
                template = Velocity.getTemplate((String)("portlets/mail/" + lang + "/msgboard-notification-mail.vm"), (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            } else {
                template = Velocity.getTemplate((String)"portlets/mail/msgboard-notification-mail.vm", (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        writer.flush();
        String ret = writer.getBuffer().toString();
        return ret;
    }

    public static void deleteAttachmentFiles(EipTMsgboardTopic topic) {
        String orgId = Database.getDomainName();
        List files = topic.getEipTMsgboardFileArray();
        int uid = topic.getOwnerId();
        for (EipTMsgboardFile file : files) {
            ALStorageService.deleteFile((String)(MsgboardUtils.getSaveDirPath(orgId, uid) + file.getFilePath()));
        }
    }

    public static boolean hasAuthorityToReply(int user_id, EipTMsgboardCategory category) {
        if (category.getTurbineUser().getUserId() == user_id) {
            return true;
        }
        boolean canAllReply = PUBLIC_FLG_VALUE_PUBLIC.equals(category.getPublicFlag());
        List categoryMap = category.getEipTMsgboardCategoryMaps();
        int mapsize = categoryMap.size();
        for (int i = 0; i < mapsize; ++i) {
            EipTMsgboardCategoryMap map = (EipTMsgboardCategoryMap)categoryMap.get(i);
            if (canAllReply && STAT_VALUE_ALL.equals(map.getStatus())) {
                return true;
            }
            if (map.getUserId() != user_id) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static String passPSML(RunData rundata, Context context, String key, String value) {
        VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
        PortletConfig config = portlet.getPortletConfig();
        if (value == null || "".equals(value)) {
            value = config != null ? config.getInitParameter(key) : "";
        } else {
            ALEipUtils.setPsmlParameters((RunData)rundata, (Context)context, (String)key, (String)value);
        }
        return value;
    }
}

