/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.whatsnew.util;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogComment;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.cayenne.om.portlet.EipTNote;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTWhatsNew;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequestMap;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.WhatsNewContainer;
import com.aimluck.eip.whatsnew.WhatsNewResultData;
import com.aimluck.eip.whatsnew.beans.WhatsNewBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class WhatsNewUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WhatsNewUtils.class.getName());
    public static final int WHATS_NEW_TYPE_BLOG_ENTRY = 1;
    public static final int WHATS_NEW_TYPE_BLOG_COMMENT = 2;
    public static final int WHATS_NEW_TYPE_WORKFLOW_REQUEST = 3;
    public static final int WHATS_NEW_TYPE_MSGBOARD_TOPIC = 4;
    public static final int WHATS_NEW_TYPE_NOTE = 5;
    public static final int WHATS_NEW_TYPE_SCHEDULE = 6;
    public static final int INDIVIDUAL_WHATS_NEW = -1;
    public static final String WHATSNEW_PORTLET_NAME = "WhatsNew";

    @Deprecated
    public static void insertWhatsNew(int type, int entityid, int uid) {
        EipTWhatsNew entry = null;
        try {
            SelectQuery query = Database.query(EipTWhatsNew.class);
            Expression exp = ExpressionFactory.matchExp((String)"portletType", (Object)type);
            query.setQualifier(exp);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)uid);
            query.andQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"entityId", (Object)entityid);
            query.andQualifier(exp2);
            Expression exp3 = ExpressionFactory.matchExp((String)"parentId", (Object)-1);
            query.andQualifier(exp3);
            List entries = query.fetchList();
            if (entries == null || entries.size() < 1) {
                entry = (EipTWhatsNew)Database.create(EipTWhatsNew.class);
                entry.setCreateDate(Calendar.getInstance().getTime());
                entry.setEntityId(Integer.valueOf(entityid));
                entry.setPortletType(Integer.valueOf(type));
                entry.setParentId(Integer.valueOf(-1));
            } else {
                entry = (EipTWhatsNew)entries.get(0);
            }
            entry.setUpdateDate(Calendar.getInstance().getTime());
            entry.setUserId(Integer.valueOf(uid));
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"whatsnew", (Throwable)e);
        }
    }

    @Deprecated
    public static void insertWhatsNewPublic(int type, int entityid, int uid) {
        EipTWhatsNew entry = null;
        try {
            SelectQuery query = Database.query(EipTWhatsNew.class);
            Expression exp = ExpressionFactory.matchExp((String)"portletType", (Object)type);
            query.setQualifier(exp);
            Expression exp1 = ExpressionFactory.matchExp((String)"parentId", (Object)Integer.valueOf("0"));
            query.andQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"entityId", (Object)entityid);
            query.andQualifier(exp2);
            List entries = query.fetchList();
            if (entries != null && entries.size() > 0) {
                ArrayList<Integer> parentIds = new ArrayList<Integer>();
                for (EipTWhatsNew _entry : entries) {
                    parentIds.add(_entry.getWhatsNewId());
                }
                SelectQuery childQuery = Database.query(EipTWhatsNew.class);
                Expression childExp = ExpressionFactory.inExp((String)"parentId", parentIds);
                childQuery.setQualifier(childExp);
                childQuery.deleteAll();
                Database.deleteAll((List)entries);
            }
            entry = (EipTWhatsNew)Database.create(EipTWhatsNew.class);
            entry.setCreateDate(Calendar.getInstance().getTime());
            entry.setEntityId(Integer.valueOf(entityid));
            entry.setPortletType(Integer.valueOf(type));
            entry.setUpdateDate(Calendar.getInstance().getTime());
            entry.setUserId(Integer.valueOf(uid));
            entry.setParentId(Integer.valueOf("0"));
            Database.commit();
            EipTWhatsNew entry2 = (EipTWhatsNew)Database.create(EipTWhatsNew.class);
            entry2.setCreateDate(Calendar.getInstance().getTime());
            entry2.setEntityId(Integer.valueOf(entityid));
            entry2.setPortletType(Integer.valueOf(type));
            entry2.setUpdateDate(Calendar.getInstance().getTime());
            entry2.setUserId(Integer.valueOf(uid));
            entry2.setParentId(entry.getWhatsNewId());
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"whatsnew", (Throwable)e);
        }
    }

    @Deprecated
    public static void shiftWhatsNewReadFlag(int type, int entityid, int uid) {
        WhatsNewUtils.shiftWhatsNewReadFlag(type, entityid, uid, true);
    }

    @Deprecated
    private static void shiftWhatsNewReadFlag(int type, int entityid, int uid, boolean call) {
        try {
            SelectQuery query = Database.query(EipTWhatsNew.class);
            Expression exp = ExpressionFactory.matchExp((String)"portletType", (Object)type);
            query.setQualifier(exp);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)uid);
            query.andQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"entityId", (Object)entityid);
            query.andQualifier(exp2);
            Expression exp3 = ExpressionFactory.matchExp((String)"parentId", (Object)Integer.valueOf("-1"));
            query.andQualifier(exp3);
            List entries = query.fetchList();
            if (entries != null && entries.size() > 0) {
                Database.deleteAll((List)entries);
            } else if (type == 4 && call) {
                WhatsNewUtils.shiftWhatsNewReadFlagPublic(type, entityid, uid, false);
            }
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"[WhatsNewUtils]", t);
        }
    }

    @Deprecated
    public static void shiftWhatsNewReadFlagPublic(int type, int entityid, int uid) {
        WhatsNewUtils.shiftWhatsNewReadFlagPublic(type, entityid, uid, true);
    }

    private static void shiftWhatsNewReadFlagPublic(int type, int entityid, int uid, boolean call) {
        try {
            SelectQuery query = Database.query(EipTWhatsNew.class);
            List uids = ALEipUtils.getUserIds((String)"LoginUser");
            Expression exp = ExpressionFactory.matchExp((String)"portletType", (Object)type);
            query.setQualifier(exp);
            Expression exp2 = ExpressionFactory.matchExp((String)"entityId", (Object)entityid);
            query.andQualifier(exp2);
            query.orderAscending("parentId");
            List entries = query.fetchList();
            if (entries != null && entries.size() > 0 && ((EipTWhatsNew)entries.get(0)).getParentId() != -1) {
                if (entries.size() == uids.size()) {
                    Database.deleteAll((List)entries);
                    Database.commit();
                    return;
                }
                EipTWhatsNew parent = (EipTWhatsNew)entries.get(0);
                Integer parentid = parent.getWhatsNewId();
                boolean hasReadFlag = false;
                for (int i = 1; i < entries.size(); ++i) {
                    if (((EipTWhatsNew)entries.get(i)).getUserId() == uid) {
                        hasReadFlag = true;
                        break;
                    }
                    if (hasReadFlag) continue;
                    EipTWhatsNew entry = null;
                    entry = (EipTWhatsNew)Database.create(EipTWhatsNew.class);
                    entry.setCreateDate(Calendar.getInstance().getTime());
                    entry.setUpdateDate(Calendar.getInstance().getTime());
                    entry.setEntityId(Integer.valueOf(entityid));
                    entry.setPortletType(Integer.valueOf(type));
                    entry.setUserId(Integer.valueOf(uid));
                    entry.setParentId(parentid);
                    Database.commit();
                }
            } else if (call) {
                WhatsNewUtils.shiftWhatsNewReadFlag(type, entityid, uid, false);
            }
            Calendar cal = Calendar.getInstance();
            cal.add(2, -1);
            exp = ExpressionFactory.lessExp((String)"updateDate", (Object)cal.getTime());
            Database.deleteAll((List)Database.query(EipTWhatsNew.class, (Expression)exp).fetchList());
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"whatsnew", (Throwable)e);
        }
    }

    public static WhatsNewResultData setupWhatsNewResultData(WhatsNewContainer record, int uid, int num, int span) {
        try {
            WhatsNewBean bean;
            EipTBlogComment entry;
            List entries;
            WhatsNewResultData rd = new WhatsNewResultData();
            rd.initField();
            int size = 0;
            int type = record.getType();
            Object[] eids = null;
            Object[] deids = null;
            Date[] dates = null;
            List<EipTWhatsNew> entity_ids = record.getList();
            ArrayList<EipTWhatsNew> deny_whatsnew = new ArrayList<EipTWhatsNew>();
            if (entity_ids != null && (size = entity_ids.size()) > 0) {
                if (size > num) {
                    eids = new Integer[num];
                    dates = new Date[num];
                    deids = new Integer[size - num];
                } else {
                    eids = new Integer[size];
                    dates = new Date[size];
                }
                for (int i = 0; i < size; ++i) {
                    try {
                        EipTWhatsNew wn = entity_ids.get(i);
                        if (i < num) {
                            eids[i] = wn.getEntityId();
                            dates[i] = wn.getUpdateDate();
                            continue;
                        }
                        deids[i - num] = wn.getEntityId();
                        deny_whatsnew.add(wn);
                        continue;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            } else {
                return null;
            }
            rd.setType(type);
            if (deids != null) {
                SelectQuery query = Database.query(EipTWhatsNew.class);
                Expression exp = ExpressionFactory.matchExp((String)"portletType", (Object)type);
                query.setQualifier(exp);
                Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)uid);
                query.andQualifier(exp1);
                Expression exp2 = ExpressionFactory.inExp((String)"entityId", (Object[])deids);
                query.andQualifier(exp2);
                List entries2 = query.fetchList();
                if (entries2 != null && entries2.size() > 0) {
                    Database.deleteAll((List)entries2);
                    Database.commit();
                }
            }
            if (1 == type) {
                Expression exp = ExpressionFactory.inDbExp((String)"ENTRY_ID", (Object[])eids);
                entries = Database.query(EipTBlogEntry.class, (Expression)exp).orderDesending("createDate").select(new String[]{"ENTRY_ID", "TITLE", "OWNER_ID"}).fetchList();
                if (entries == null || entries.size() <= 0) {
                    return null;
                }
                size = entries.size();
                rd.setCreateDate(new Date());
                rd.setUpdateDate(new Date());
                rd.setPortletName("[ \u30d6\u30ed\u30b0 ]  \u65b0\u7740\u8a18\u4e8b");
                for (int i = 0; i < size; ++i) {
                    entry = (EipTBlogEntry)entries.get(i);
                    bean = new WhatsNewBean();
                    bean.initField();
                    bean.setEntityId(entry.getEntryId());
                    bean.addParamMap("template", "BlogDetailScreen");
                    bean.setJsFunctionName("aipo.blog.onLoadBlogDetailDialog");
                    bean.setPortletName("[ \u30d6\u30ed\u30b0 ] ");
                    try {
                        ALEipUser owner = ALEipUtils.getALEipUser((int)entry.getOwnerId());
                        bean.setOwnerName(owner.getAliasName().getValue());
                    }
                    catch (Exception e) {
                        bean.setOwnerName("");
                    }
                    bean.setName(entry.getTitle());
                    bean.setUpdateDate(ALDateUtil.format((Date)dates[i], (String)"yyyy/MM/dd/"));
                    rd.setBean(bean);
                }
            } else if (2 == type) {
                Expression exp = ExpressionFactory.inDbExp((String)"COMMENT_ID", (Object[])eids);
                entries = Database.query(EipTBlogComment.class, (Expression)exp).orderDesending("createDate").fetchList();
                if (entries == null || entries.size() <= 0) {
                    return null;
                }
                size = entries.size();
                rd.setCreateDate(new Date());
                rd.setUpdateDate(new Date());
                rd.setPortletName("[ \u30d6\u30ed\u30b0 ]  \u65b0\u7740\u30b3\u30e1\u30f3\u30c8");
                for (int i = 0; i < size; ++i) {
                    entry = (EipTBlogComment)entries.get(i);
                    int entryId = entry.getEipTBlogEntry().getEntryId();
                    int size2 = 0;
                    List<WhatsNewBean> tmp = rd.getBeans();
                    boolean is_contain = false;
                    if (tmp != null && (size2 = tmp.size()) > 0) {
                        for (int j = 0; j < size2; ++j) {
                            WhatsNewBean tmpb = tmp.get(j);
                            if (tmpb.getEntityId().getValue() != (long)entryId) continue;
                            StringBuffer sb = new StringBuffer(tmpb.getOwnerName().getValue());
                            try {
                                List<String> array = Arrays.asList(sb.toString().split(","));
                                ALEipUser tmpowner = ALEipUtils.getALEipUser((int)entry.getOwnerId());
                                if (array.contains(tmpowner.getAliasName().getValue())) continue;
                                sb.append(",").append(tmpowner.getAliasName().getValue());
                                tmpb.setOwnerName(sb.toString());
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            is_contain = true;
                            break;
                        }
                    }
                    if (is_contain) continue;
                    WhatsNewBean bean2 = new WhatsNewBean();
                    bean2.initField();
                    bean2.setEntityId(entryId);
                    bean2.addParamMap("template", "BlogDetailScreen");
                    bean2.setJsFunctionName("aipo.blog.onLoadBlogDetailDialog");
                    bean2.setPortletName("[ \u30d6\u30ed\u30b0 ] ");
                    try {
                        ALEipUser owner = ALEipUtils.getALEipUser((int)entry.getOwnerId());
                        bean2.setOwnerName(owner.getAliasName().getValue());
                    }
                    catch (Exception e) {
                        bean2.setOwnerName("");
                    }
                    bean2.setName(entry.getEipTBlogEntry().getTitle());
                    bean2.setUpdateDate(ALDateUtil.format((Date)dates[i], (String)"yyyy/MM/dd/"));
                    rd.setBean(bean2);
                }
            } else if (3 == type) {
                Expression exp = ExpressionFactory.inDbExp((String)"REQUEST_ID", (Object[])eids);
                entries = Database.query(EipTWorkflowRequest.class, (Expression)exp).orderDesending("updateDate").fetchList();
                if (entries == null || entries.size() <= 0) {
                    return null;
                }
                size = entries.size();
                rd.setCreateDate(new Date());
                rd.setUpdateDate(new Date());
                rd.setPortletName("[ \u30ef\u30fc\u30af\u30d5\u30ed\u30fc ]  \u65b0\u7740\u4f9d\u983c");
                for (int i = 0; i < size; ++i) {
                    entry = (EipTWorkflowRequest)entries.get(i);
                    bean = new WhatsNewBean();
                    bean.initField();
                    bean.setEntityId(entry.getRequestId());
                    bean.addParamMap("template", "WorkflowDetailScreen");
                    bean.setJsFunctionName("aipo.workflow.onLoadWorkflowDetail");
                    bean.setPortletName("[ \u30ef\u30fc\u30af\u30d5\u30ed\u30fc ] ");
                    try {
                        EipTWorkflowRequestMap map;
                        List<EipTWorkflowRequestMap> maps = WhatsNewUtils.getEipTWorkflowRequestMap((EipTWorkflowRequest)entry);
                        int m_size = maps.size();
                        String lastUpdateUser = "";
                        if ("A".equals(entry.getProgress())) {
                            map = maps.get(m_size - 1);
                            ALEipUser user = ALEipUtils.getALEipUser((int)map.getUserId());
                            lastUpdateUser = user.getAliasName().getValue();
                        } else {
                            int unum = 0;
                            for (int j = 0; j < m_size; ++j) {
                                map = maps.get(j);
                                if ("C".equals(map.getStatus())) {
                                    unum = j - 1;
                                    continue;
                                }
                                if (!"D".equals(map.getStatus())) continue;
                                unum = j;
                                break;
                            }
                            map = maps.get(unum);
                            ALEipUser user = ALEipUtils.getALEipUser((int)map.getUserId());
                            lastUpdateUser = user.getAliasName().getValue();
                        }
                        bean.setOwnerName(lastUpdateUser);
                    }
                    catch (Exception e) {
                        bean.setOwnerName("");
                    }
                    String cname = entry.getEipTWorkflowCategory().getCategoryName();
                    String rname = entry.getRequestName();
                    String title = "\u3010" + cname + "\u3011 " + rname;
                    bean.setName(title);
                    bean.setUpdateDate(ALDateUtil.format((Date)dates[i], (String)"yyyy/MM/dd/"));
                    bean.addParamMap("mode", "detail");
                    bean.addParamMap("prvid", bean.getEntityId().toString());
                    rd.setBean(bean);
                }
            } else if (4 == type) {
                Expression exp = ExpressionFactory.inDbExp((String)"TOPIC_ID", (Object[])eids);
                entries = Database.query(EipTMsgboardTopic.class, (Expression)exp).orderDesending("createDate").select(new String[]{"TOPIC_ID", "TOPIC_NAME", "OWNER_ID", "PARENT_ID"}).fetchList();
                if (entries == null || entries.size() <= 0) {
                    return null;
                }
                size = entries.size();
                rd.setCreateDate(new Date());
                rd.setUpdateDate(new Date());
                rd.setPortletName("[ \u63b2\u793a\u677f ]  \u65b0\u3057\u3044\u66f8\u304d\u8fbc\u307f");
                for (int i = 0; i < size; ++i) {
                    EipTMsgboardTopic topic = (EipTMsgboardTopic)entries.get(i);
                    bean = new WhatsNewBean();
                    bean.initField();
                    int parentId = topic.getParentId();
                    if (parentId > 0) {
                        bean.setEntityId(parentId);
                    } else {
                        bean.setEntityId(topic.getTopicId());
                    }
                    bean.addParamMap("template", "MsgboardTopicDetailScreen");
                    bean.setJsFunctionName("aipo.msgboard.onLoadMsgboardDetail");
                    bean.setPortletName("[ \u63b2\u793a\u677f ] ");
                    try {
                        ALEipUser owner = ALEipUtils.getALEipUser((int)topic.getOwnerId());
                        bean.setOwnerName(owner.getAliasName().getValue());
                    }
                    catch (Exception e) {
                        bean.setOwnerName("");
                    }
                    bean.setName(topic.getTopicName());
                    bean.setUpdateDate(ALDateUtil.format((Date)dates[i], (String)"yyyy/MM/dd/"));
                    rd.setBean(bean);
                }
            } else if (5 == type) {
                Expression exp = ExpressionFactory.inDbExp((String)"NOTE_ID", (Object[])eids);
                entries = Database.query(EipTNote.class, (Expression)exp).orderDesending("createDate").select(new String[]{"NOTE_ID", "CLIENT_NAME", "SUBJECT_TYPE", "CUSTOM_SUBJECT", "OWNER_ID"}).fetchList();
                if (entries == null || entries.size() <= 0) {
                    return null;
                }
                size = entries.size();
                rd.setCreateDate(new Date());
                rd.setUpdateDate(new Date());
                rd.setPortletName("[ \u4f1d\u8a00\u30e1\u30e2 ]  \u65b0\u7740\u30e1\u30e2");
                for (int i = 0; i < size; ++i) {
                    EipTNote note = (EipTNote)entries.get(i);
                    bean = new WhatsNewBean();
                    bean.initField();
                    bean.setEntityId(note.getNoteId());
                    bean.addParamMap("template", "NoteDetailScreen");
                    bean.setJsFunctionName("aipo.note.onLoadDetail");
                    bean.setPortletName("[ \u4f1d\u8a00\u30e1\u30e2 ] ");
                    try {
                        ALEipUser owner = ALEipUtils.getALEipUser((int)Integer.valueOf(note.getOwnerId()));
                        bean.setOwnerName(owner.getAliasName().getValue());
                    }
                    catch (Exception e) {
                        bean.setOwnerName("");
                    }
                    String clname = note.getClientName();
                    String subject = "";
                    String stype = note.getSubjectType();
                    if ("0".equals(stype)) {
                        subject = note.getCustomSubject();
                    } else if ("1".equals(stype)) {
                        subject = "\u518d\u5ea6\u96fb\u8a71\u3057\u307e\u3059\u3002";
                    } else if ("2".equals(stype)) {
                        subject = "\u6298\u8fd4\u3057\u304a\u96fb\u8a71\u304f\u3060\u3055\u3044\u3002";
                    } else if ("3".equals(stype)) {
                        subject = "\u9023\u7d61\u304c\u3042\u3063\u305f\u3053\u3068\u3092\u304a\u4f1d\u3048\u304f\u3060\u3055\u3044\u3002";
                    } else if ("4".equals(stype)) {
                        subject = "\u4f1d\u8a00\u3092\u304a\u9858\u3044\u3057\u307e\u3059\u3002";
                    }
                    String title = "\u3010" + clname + "\u3011 " + subject;
                    bean.setName(title);
                    bean.setUpdateDate(ALDateUtil.format((Date)dates[i], (String)"yyyy/MM/dd/"));
                    rd.setBean(bean);
                }
            } else if (6 == type) {
                Expression exp = ExpressionFactory.inDbExp((String)"SCHEDULE_ID", (Object[])eids);
                entries = Database.query(EipTSchedule.class, (Expression)exp).orderDesending("updateDate").select(new String[]{"SCHEDULE_ID", "START_DATE", "NAME", "OWNER_ID", "UPDATE_USER_ID"}).fetchList();
                if (entries == null || entries.size() <= 0) {
                    return null;
                }
                size = entries.size();
                rd.setCreateDate(new Date());
                rd.setUpdateDate(new Date());
                rd.setPortletName("[ \u30b9\u30b1\u30b8\u30e5\u30fc\u30eb ]  \u65b0\u7740\u4e88\u5b9a");
                for (int i = 0; i < size; ++i) {
                    EipTSchedule schedule = (EipTSchedule)entries.get(i);
                    bean = new WhatsNewBean();
                    bean.initField();
                    bean.setEntityId(schedule.getScheduleId());
                    bean.addParamMap("template", "ScheduleDetailScreen");
                    bean.setJsFunctionName("aipo.schedule.onLoadScheduleDetail");
                    bean.setPortletName("[ \u30b9\u30b1\u30b8\u30e5\u30fc\u30eb ] ");
                    try {
                        ALEipUser owner = ALEipUtils.getALEipUser((int)schedule.getOwnerId());
                        bean.setOwnerName(owner.getAliasName().getValue());
                    }
                    catch (Exception e) {
                        bean.setOwnerName("");
                    }
                    bean.setName(schedule.getName());
                    bean.setUpdateDate(ALDateUtil.format((Date)dates[i], (String)"yyyy/MM/dd/"));
                    bean.addParamMap("userid", Integer.toString(uid).trim());
                    Date start_date = schedule.getStartDate();
                    bean.addParamMap("view_date", ALDateUtil.format((Date)start_date, (String)"yyyy-MM-dd-00-00"));
                    rd.setBean(bean);
                }
            } else {
                rd = null;
            }
            return rd;
        }
        catch (RuntimeException ex) {
            Database.rollback();
            logger.error((Object)"whatsnew", (Throwable)ex);
            return null;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"whatsnew", (Throwable)ex);
            return null;
        }
    }

    private static List<EipTWorkflowRequestMap> getEipTWorkflowRequestMap(EipTWorkflowRequest request) {
        try {
            Expression exp = ExpressionFactory.matchDbExp((String)"eipTWorkflowRequest.REQUEST_ID", (Object)request.getRequestId());
            List maps = Database.query(EipTWorkflowRequestMap.class, (Expression)exp).orderAscending("orderIndex").fetchList();
            if (maps == null || maps.size() == 0) {
                logger.debug((Object)"[WorkflowSelectData] Not found ID...");
                return null;
            }
            return maps;
        }
        catch (Exception ex) {
            logger.error((Object)"whatsnew", (Throwable)ex);
            return null;
        }
    }

    public static void removeSpanOverWhatsNew(int uid, int span) {
        if (span > 0) {
            try {
                Calendar cal = Calendar.getInstance();
                if (span == 31) {
                    cal.add(2, -1);
                } else {
                    cal.add(5, -1 * span);
                }
                Expression exp1 = ExpressionFactory.lessExp((String)"updateDate", (Object)cal.getTime());
                List entries1 = Database.query(EipTWhatsNew.class, (Expression)exp1).fetchList();
                if (entries1 != null && entries1.size() > 0) {
                    Database.deleteAll((List)entries1);
                    Database.commit();
                }
            }
            catch (Throwable t) {
                Database.rollback();
                logger.error((Object)"[WhatsNewUtils]", t);
            }
        }
    }

    public static void removeMonthOverWhatsNew() {
        try {
            int span = 31;
            Calendar cal = Calendar.getInstance();
            cal.add(5, -1 * span);
            Expression exp1 = ExpressionFactory.lessExp((String)"updateDate", (Object)cal.getTime());
            List entries1 = Database.query(EipTWhatsNew.class, (Expression)exp1).fetchList();
            if (entries1 != null && entries1.size() > 0) {
                Database.deleteAll((List)entries1);
                Database.commit();
            }
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"[WhatsNewUtils]", t);
        }
    }
}

