/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.Nullable;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.config.AbstractContainerConfig;
import org.apache.shindig.config.ContainerConfigELResolver;
import org.apache.shindig.config.ContainerConfigException;
import org.apache.shindig.config.DynamicConfigProperty;
import org.apache.shindig.expressions.Expressions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class JsonContainerConfig
extends AbstractContainerConfig {
    private static final Logger LOG = Logger.getLogger(JsonContainerConfig.class.getName());
    public static final char FILE_SEPARATOR = ',';
    public static final String PARENT_KEY = "parent";
    public static final String CONTAINER_KEY = "gadgets.container";
    public static final String SERVER_PORT = "SERVER_PORT";
    public static final String SERVER_HOST = "SERVER_HOST";
    private final Map<String, Map<String, Object>> config;
    private final Expressions expressions;
    private static final Pattern CRLF_PATTERN = Pattern.compile("[\r\n]+");
    private final String host;
    private final String port;

    public JsonContainerConfig(String containers, Expressions expressions) throws ContainerConfigException {
        this(containers, "localhost", "8080", expressions);
    }

    @Inject
    public JsonContainerConfig(@Named(value="shindig.containers.default") String containers, @Nullable @Named(value="shindig.host") String host, @Nullable @Named(value="shindig.port") String port, Expressions expressions) throws ContainerConfigException {
        this.expressions = expressions;
        this.host = host;
        this.port = port;
        JSONObject configJson = this.loadContainers(containers);
        this.config = this.createContainers(configJson);
        this.init();
    }

    public JsonContainerConfig(JSONObject json, Expressions expressions) {
        this.expressions = expressions;
        this.host = null;
        this.port = null;
        this.config = this.createContainers(json);
        this.init();
    }

    protected void init() {
        for (Map.Entry<String, Map<String, Object>> configEntry : this.config.entrySet()) {
            Map value = (Map)this.evaluateAll(configEntry.getValue());
            configEntry.setValue(value);
        }
    }

    @Override
    public Collection<String> getContainers() {
        return Collections.unmodifiableSet(this.config.keySet());
    }

    @Override
    public Map<String, Object> getProperties(String container) {
        return this.config.get(container);
    }

    @Override
    public Object getProperty(String container, String property) {
        if (property.startsWith("${")) {
            try {
                ValueExpression expression = this.expressions.parse(property, Object.class);
                return expression.getValue(this.createExpressionContext(container));
            }
            catch (ELException e) {
                return null;
            }
        }
        Map<String, Object> containerData = this.config.get(container);
        if (containerData == null) {
            return null;
        }
        return containerData.get(property);
    }

    private Map<String, Map<String, Object>> createContainers(JSONObject json) {
        HashMap map = Maps.newHashMap();
        for (String container : JSONObject.getNames((JSONObject)json)) {
            ELContext context = this.createExpressionContext(container);
            map.put(container, JsonContainerConfig.jsonToMap(json.optJSONObject(container), this.expressions, context));
        }
        return map;
    }

    protected Expressions getExpressions() {
        return this.expressions;
    }

    protected ELContext createExpressionContext(String container) {
        return this.getExpressions().newELContext(new ContainerConfigELResolver(this, container));
    }

    private static Object jsonToConfig(Object json, Expressions expressions, ELContext context) {
        if (JSONObject.NULL.equals(json)) {
            return null;
        }
        if (json instanceof CharSequence) {
            return new DynamicConfigProperty(json.toString(), expressions, context);
        }
        if (json instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)json;
            ArrayList<Object> values = new ArrayList<Object>(jsonArray.length());
            int j = jsonArray.length();
            for (int i = 0; i < j; ++i) {
                values.add(JsonContainerConfig.jsonToConfig(jsonArray.opt(i), expressions, context));
            }
            return Collections.unmodifiableList(values);
        }
        if (json instanceof JSONObject) {
            return JsonContainerConfig.jsonToMap((JSONObject)json, expressions, context);
        }
        return json;
    }

    private static Map<String, Object> jsonToMap(JSONObject json, Expressions expressions, ELContext context) {
        HashMap<String, Object> values = new HashMap<String, Object>(json.length(), 1.0f);
        for (String key : JSONObject.getNames((JSONObject)json)) {
            Object val = JsonContainerConfig.jsonToConfig(json.opt(key), expressions, context);
            if (val == null) continue;
            values.put(key, val);
        }
        return Collections.unmodifiableMap(values);
    }

    private void loadFiles(File[] files, JSONObject all) throws ContainerConfigException {
        for (File file : files) {
            try {
                if (file == null) continue;
                LOG.info("Reading container config: " + file.getName());
                if (file.isDirectory()) {
                    this.loadFiles(file.listFiles(), all);
                    continue;
                }
                if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".js") || file.getName().toLowerCase(Locale.ENGLISH).endsWith(".json")) {
                    if (!file.exists()) {
                        throw new ContainerConfigException("The file '" + file.getAbsolutePath() + "' doesn't exist.");
                    }
                    this.loadFromString(ResourceLoader.getContent(file), all);
                    continue;
                }
                if (!LOG.isLoggable(Level.FINEST)) continue;
                LOG.finest(file.getAbsolutePath() + " doesn't seem to be a JS or JSON file.");
            }
            catch (IOException e) {
                throw new ContainerConfigException("The file '" + file.getAbsolutePath() + "' has errors", e);
            }
        }
    }

    private void loadResources(String[] files, JSONObject all) throws ContainerConfigException {
        try {
            for (String entry : files) {
                LOG.info("Reading container config: " + entry);
                String content = ResourceLoader.getContent(entry);
                if (content == null || content.length() == 0) {
                    throw new IOException("The file " + entry + "is empty");
                }
                this.loadFromString(content, all);
            }
        }
        catch (IOException e) {
            throw new ContainerConfigException(e);
        }
    }

    private JSONObject mergeObjects(JSONObject base, JSONObject merge) throws JSONException {
        String[] fields;
        JSONObject clone = new JSONObject(base, JSONObject.getNames((JSONObject)base));
        for (String field : fields = JSONObject.getNames((JSONObject)merge)) {
            Object existing = clone.opt(field);
            Object update = merge.get(field);
            if (JSONObject.NULL.equals(existing) || JSONObject.NULL.equals(update)) {
                clone.put(field, update);
                continue;
            }
            if (update instanceof JSONObject && existing instanceof JSONObject) {
                clone.put(field, (Object)this.mergeObjects((JSONObject)existing, (JSONObject)update));
                continue;
            }
            clone.put(field, update);
        }
        return clone;
    }

    private JSONObject mergeParents(String container, JSONObject all) throws ContainerConfigException, JSONException {
        JSONObject base = all.getJSONObject(container);
        if ("default".equals(container)) {
            return base;
        }
        String parent = base.optString(PARENT_KEY, "default");
        if (!all.has(parent)) {
            throw new ContainerConfigException("Unable to locate parent '" + parent + "' required by " + base.getString(CONTAINER_KEY));
        }
        return this.mergeObjects(this.mergeParents(parent, all), base);
    }

    protected void loadFromString(String json, JSONObject all) throws ContainerConfigException {
        try {
            JSONObject contents = new JSONObject(json);
            JSONArray containers = contents.getJSONArray(CONTAINER_KEY);
            int j = containers.length();
            for (int i = 0; i < j; ++i) {
                String container = containers.getString(i);
                all.put(container, (Object)contents);
            }
        }
        catch (JSONException e) {
            LOG.warning("Trouble parsing " + json);
            throw new ContainerConfigException("Trouble parsing " + json, e);
        }
    }

    private JSONObject loadContainers(String path) throws ContainerConfigException {
        JSONObject all = new JSONObject();
        try {
            for (String location : StringUtils.split((String)path, (char)',')) {
                if (location.startsWith("res://")) {
                    location = location.substring(6);
                    LOG.info("Loading resources from: " + location);
                    if (path.endsWith(".txt")) {
                        this.loadResources(CRLF_PATTERN.split(ResourceLoader.getContent(location)), all);
                        continue;
                    }
                    this.loadResources(new String[]{location}, all);
                    continue;
                }
                LOG.info("Loading files from: " + location);
                File file = new File(location);
                this.loadFiles(new File[]{file}, all);
            }
            try {
                all.getJSONObject("default").put(SERVER_PORT, (Object)this.port);
                all.getJSONObject("default").put(SERVER_HOST, (Object)this.host);
            }
            catch (JSONException e) {
                // empty catch block
            }
            for (String container : JSONObject.getNames((JSONObject)all)) {
                all.put(container, (Object)this.mergeParents(container, all));
            }
            return all;
        }
        catch (IOException e) {
            throw new ContainerConfigException(e);
        }
        catch (JSONException e) {
            throw new ContainerConfigException(e);
        }
    }

    public String toString() {
        return JsonSerializer.serialize(this.config);
    }

    private Object evaluateAll(Object value) {
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            ImmutableMap.Builder newMap = ImmutableMap.builder();
            for (Map.Entry entry : mapValue.entrySet()) {
                newMap.put(entry.getKey(), this.evaluateAll(entry.getValue()));
            }
            return newMap.build();
        }
        if (value instanceof List) {
            ImmutableList.Builder newList = ImmutableList.builder();
            for (Object entry : (List)value) {
                newList.add(this.evaluateAll(entry));
            }
            return newList.build();
        }
        return value;
    }
}

