/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.factory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.factory.Factory;
import org.apache.fulcrum.factory.FactoryService;
import org.apache.fulcrum.pool.ObjectInputStreamForContext;

public class TurbineFactoryService
extends BaseService
implements FactoryService {
    public static final String CLASS_LOADERS = "class.loaders";
    public static final String OBJECT_FACTORY = "factory.";
    protected static final String DEFAULT_FACTORY = "default";
    private static HashMap primitiveClasses;
    private ArrayList classLoaders;
    private HashMap objectFactories;

    protected static Class getPrimitiveClass(String string) {
        return (Class)primitiveClasses.get(string);
    }

    public TurbineFactoryService() {
        primitiveClasses = new HashMap(8);
        primitiveClasses.put(Boolean.TYPE.toString(), Boolean.TYPE);
        primitiveClasses.put(Character.TYPE.toString(), Character.TYPE);
        primitiveClasses.put(Byte.TYPE.toString(), Byte.TYPE);
        primitiveClasses.put(Short.TYPE.toString(), Short.TYPE);
        primitiveClasses.put(Integer.TYPE.toString(), Integer.TYPE);
        primitiveClasses.put(Long.TYPE.toString(), Long.TYPE);
        primitiveClasses.put(Float.TYPE.toString(), Float.TYPE);
        primitiveClasses.put(Double.TYPE.toString(), Double.TYPE);
        this.classLoaders = new ArrayList();
        this.objectFactories = new HashMap();
    }

    public void init() throws InitializationException {
        if (this.getConfiguration() != null) {
            Vector vector = this.getConfiguration().getVector(CLASS_LOADERS);
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    try {
                        this.classLoaders.add(this.loadClass((String)vector.get(n)).newInstance());
                    }
                    catch (Exception exception) {
                        throw new InitializationException("No such class loader '" + (String)vector.get(n) + "' for TurbinbeFactoryService", exception);
                    }
                    ++n;
                }
            }
            Iterator iterator = this.getConfiguration().getKeys(OBJECT_FACTORY);
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.getConfiguration().getString(string);
                this.objectFactories.put(string.substring(OBJECT_FACTORY.length()), string2);
            }
        }
        this.setInit(true);
    }

    public Object getInstance(String string) throws ServiceException {
        if (string == null) {
            throw new ServiceException(new NullPointerException("String className"));
        }
        Factory factory = this.getFactory(string);
        if (factory == null) {
            Class clazz;
            try {
                clazz = this.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ServiceException("Instantiation failed for class " + string, classNotFoundException);
            }
            return this.getInstance(clazz);
        }
        return factory.getInstance();
    }

    public Object getInstance(String string, ClassLoader classLoader) throws ServiceException {
        if (string == null) {
            throw new ServiceException(new NullPointerException("String className"));
        }
        Factory factory = this.getFactory(string);
        if (factory == null) {
            if (classLoader != null) {
                Class clazz;
                try {
                    clazz = this.loadClass(string, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ServiceException("Instantiation failed for class " + string, classNotFoundException);
                }
                return this.getInstance(clazz);
            }
            return this.getInstance(string);
        }
        return factory.getInstance(classLoader);
    }

    public Object getInstance(String string, Object[] objectArray, String[] stringArray) throws ServiceException {
        if (string == null) {
            throw new ServiceException(new NullPointerException("String className"));
        }
        Factory factory = this.getFactory(string);
        if (factory == null) {
            Class clazz;
            try {
                clazz = this.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ServiceException("Instantiation failed for class " + string, classNotFoundException);
            }
            return this.getInstance(clazz, objectArray, stringArray);
        }
        return factory.getInstance(objectArray, stringArray);
    }

    public Object getInstance(String string, ClassLoader classLoader, Object[] objectArray, String[] stringArray) throws ServiceException {
        if (string == null) {
            throw new ServiceException(new NullPointerException("String className"));
        }
        Factory factory = this.getFactory(string);
        if (factory == null) {
            if (classLoader != null) {
                Class clazz;
                try {
                    clazz = this.loadClass(string, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ServiceException("Instantiation failed for class " + string, classNotFoundException);
                }
                return this.getInstance(clazz, objectArray, stringArray);
            }
            return this.getInstance(string, objectArray, stringArray);
        }
        return factory.getInstance(classLoader, objectArray, stringArray);
    }

    public boolean isLoaderSupported(String string) throws ServiceException {
        Factory factory = this.getFactory(string);
        return factory != null ? factory.isLoaderSupported() : true;
    }

    protected Object getInstance(Class clazz) throws ServiceException {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ServiceException("Instantiation failed for " + clazz.getName(), exception);
        }
    }

    protected Object getInstance(Class clazz, Object[] objectArray, String[] stringArray) throws ServiceException {
        try {
            Class[] classArray = this.getSignature(clazz, objectArray, stringArray);
            return clazz.getConstructor(classArray).newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new ServiceException("Instantiation failed for " + clazz.getName(), exception);
        }
    }

    protected Class[] getSignature(Class clazz, Object[] objectArray, String[] stringArray) throws ClassNotFoundException {
        if (stringArray != null) {
            ClassLoader classLoader = clazz.getClassLoader();
            Class[] classArray = new Class[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                classArray[n] = TurbineFactoryService.getPrimitiveClass(stringArray[n]);
                if (classArray[n] == null) {
                    if (classLoader != null) {
                        classArray[n] = classLoader.loadClass(stringArray[n]);
                        ClassLoader classLoader2 = classArray[n].getClassLoader();
                        if (objectArray[n] != null && classLoader2 != null && !classLoader2.equals(objectArray[n].getClass().getClassLoader())) {
                            objectArray[n] = this.switchObjectContext(objectArray[n], classLoader);
                        }
                    } else {
                        classArray[n] = this.loadClass(stringArray[n]);
                    }
                }
                ++n;
            }
            return classArray;
        }
        return null;
    }

    protected Object switchObjectContext(Object object, ClassLoader classLoader) {
        Closeable closeable;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            closeable = new ObjectOutputStream(byteArrayOutputStream);
            closeable.writeObject(object);
            closeable.flush();
        }
        catch (Exception exception) {
            return object;
        }
        try {
            closeable = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStreamForContext objectInputStreamForContext = new ObjectInputStreamForContext((InputStream)closeable, classLoader);
            return objectInputStreamForContext.readObject();
        }
        catch (Exception exception) {
            return object;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Class loadClass(String var1_1) throws ClassNotFoundException {
        var2_2 = this.getClass().getClassLoader();
        try {
            return var2_2 != null ? var2_2.loadClass(var1_1) : Class.forName(var1_1);
        }
        catch (ClassNotFoundException var3_3) {
            var4_4 = this.classLoaders.iterator();
            ** while (var4_4.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            try {
                return ((ClassLoader)var4_4.next()).loadClass(var1_1);
            }
            catch (ClassNotFoundException var5_5) {
                // empty catch block
            }
            continue;
        }
lbl12:
        // 1 sources

        throw var3_3;
    }

    protected Class loadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        return classLoader != null ? classLoader.loadClass(string) : this.loadClass(string);
    }

    protected Factory getFactory(String string) throws ServiceException {
        HashMap hashMap = this.objectFactories;
        Object object = hashMap.get(string);
        if (object == null) {
            object = hashMap.get(DEFAULT_FACTORY);
        }
        if (object != null) {
            if (object instanceof String) {
                try {
                    object = (Factory)this.getInstance((String)object);
                    ((Factory)object).init(string);
                }
                catch (ServiceException serviceException) {
                    throw serviceException;
                }
                catch (ClassCastException classCastException) {
                    throw new ServiceException("Incorrect factory " + (String)object + " for class " + string, classCastException);
                }
                hashMap = (HashMap)hashMap.clone();
                hashMap.put(string, object);
                this.objectFactories = hashMap;
            }
            return (Factory)object;
        }
        return null;
    }
}

