/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.StackKeyedObjectPool;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.IntakeService;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.transform.XmlToAppData;
import org.apache.fulcrum.intake.xmlmodel.AppData;
import org.apache.fulcrum.intake.xmlmodel.XmlGroup;

public class TurbineIntakeService
extends BaseService
implements IntakeService {
    private String[] groupNames;
    private Map groupNameMap;
    private Map groupKeyMap;
    private Map getterMap;
    private Map setterMap;
    private AppData appData;
    KeyedObjectPool keyedPool;
    private static final int GETTER = 0;
    private static final int SETTER = 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws InitializationException {
        String string = this.getConfiguration().getString("xml.path", "WEB-INF/conf/intake.xml");
        String string2 = this.getConfiguration().getString("serialize.path", "WEB-INF/appData.ser");
        String string3 = "Intake initialization could not be serialized because writing to " + string2 + " was not " + "allowed.  This will require that the xml file be " + "parsed when restarting the application.";
        if (string == null) {
            String string4 = "Path to intake.xml was not specified.  Check that the property exists in TR.props and was loaded.";
            this.getCategory().error((Object)string4);
            throw new InitializationException(string4);
        }
        File file = null;
        File file2 = null;
        file2 = new File(string);
        if (!file2.canRead() && !(file2 = new File(string = this.getRealPath(string))).canRead()) {
            String string5 = "Could not read input file.  Even tried relative to webapp root.";
            this.getCategory().error((Object)string5);
            throw new InitializationException(string5);
        }
        file = new File(string2);
        try {
            file.createNewFile();
            file.delete();
        }
        catch (Exception exception) {
            string2 = this.getRealPath(string2);
            file = new File(string2);
            try {
                file.createNewFile();
                file.delete();
            }
            catch (Exception exception2) {
                this.getCategory().info((Object)string3);
            }
        }
        try {
            Object object;
            block19: {
                if (file.exists() && file.lastModified() > file2.lastModified()) {
                    object = null;
                    try {
                        Object var9_15;
                        try {
                            object = new FileInputStream(file);
                            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
                            this.appData = (AppData)objectInputStream.readObject();
                        }
                        catch (Exception exception) {
                            this.writeAppData(string, string2, file);
                            var9_15 = null;
                            if (object != null) {
                                ((InputStream)object).close();
                            }
                            break block19;
                        }
                        var9_15 = null;
                        if (object == null) break block19;
                    }
                    catch (Throwable throwable) {
                        Object var9_16 = null;
                        if (object == null) throw throwable;
                        ((InputStream)object).close();
                        throw throwable;
                    }
                    ((InputStream)object).close();
                } else {
                    this.writeAppData(string, string2, file);
                }
            }
            this.groupNames = new String[this.appData.getGroups().size()];
            this.groupKeyMap = new HashMap();
            this.groupNameMap = new HashMap();
            this.getterMap = new HashMap();
            this.setterMap = new HashMap();
            object = this.appData.getBasePackage();
            int n = 0;
            List list = this.appData.getGroups();
            int n2 = list.size() - 1;
            block10: while (true) {
                String string6;
                Object object2;
                if (n2 < 0) {
                    object2 = new Group.GroupFactory(this.appData);
                    this.keyedPool = new StackKeyedObjectPool((KeyedPoolableObjectFactory)object2, n);
                    this.setInit(true);
                    return;
                }
                object2 = (XmlGroup)list.get(n2);
                this.groupNames[n2] = string6 = ((XmlGroup)object2).getName();
                this.groupKeyMap.put(string6, ((XmlGroup)object2).getKey());
                this.groupNameMap.put(((XmlGroup)object2).getKey(), string6);
                n = Math.max(n, Integer.parseInt(((XmlGroup)object2).getPoolCapacity()));
                List list2 = ((XmlGroup)object2).getMapToObjects();
                Iterator iterator = list2.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        --n2;
                        continue block10;
                    }
                    String string7 = (String)iterator.next();
                    if (this.getterMap.containsKey(string7)) continue;
                    this.getterMap.put(string7, new HashMap());
                    this.setterMap.put(string7, new HashMap());
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new InitializationException("TurbineIntakeService failed to initialize", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeAppData(String string, String string2, File file) throws Exception {
        InputStream inputStream;
        block7: {
            XmlToAppData xmlToAppData = new XmlToAppData();
            this.appData = xmlToAppData.parseFile(string);
            FileOutputStream fileOutputStream = null;
            inputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(file);
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeObject(this.appData);
                    objectOutputStream.flush();
                    inputStream = new FileInputStream(file);
                    ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                    this.appData = (AppData)objectInputStream.readObject();
                }
                catch (Exception exception) {
                    this.getCategory().info((Object)("Intake initialization could not be serialized because writing to " + string2 + " was not " + "allowed.  This will require that the xml file be " + "parsed when restarting the application."));
                    Object var10_11 = null;
                    if (fileOutputStream != null) {
                        ((OutputStream)fileOutputStream).close();
                    }
                    if (inputStream == null) return;
                    inputStream.close();
                    return;
                }
                Object var10_10 = null;
                if (fileOutputStream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            ((OutputStream)fileOutputStream).close();
        }
        if (inputStream == null) return;
        inputStream.close();
    }

    public Group getGroup(String string) throws ServiceException {
        Group group = null;
        if (string == null) {
            throw new ServiceException("Intake TurbineIntakeService.getGroup(groupName) is null");
        }
        try {
            group = (Group)this.keyedPool.borrowObject((Object)string);
        }
        catch (Exception exception) {
            new ServiceException(exception);
        }
        return group;
    }

    public void releaseGroup(Group group) {
        if (group != null) {
            String string = group.getIntakeGroupName();
            try {
                this.keyedPool.returnObject((Object)string, (Object)group);
            }
            catch (Exception exception) {
                new ServiceException(exception);
            }
        }
    }

    public int getSize(String string) {
        return this.keyedPool.numActive((Object)string) + this.keyedPool.numIdle((Object)string);
    }

    public String[] getGroupNames() {
        return this.groupNames;
    }

    public String getGroupKey(String string) {
        return (String)this.groupKeyMap.get(string);
    }

    public String getGroupName(String string) {
        return (String)this.groupNameMap.get(string);
    }

    public Method getFieldSetter(String string, String string2) {
        Map map = (Map)this.setterMap.get(string);
        Method method = (Method)map.get(string2);
        if (method == null) {
            PropertyDescriptor propertyDescriptor = null;
            Map map2 = this.setterMap;
            synchronized (map2) {
                try {
                    propertyDescriptor = new PropertyDescriptor(string2, Class.forName(string));
                    method = propertyDescriptor.getWriteMethod();
                    ((Map)this.setterMap.get(string)).put(string2, method);
                    if (method == null) {
                        this.getCategory().error((Object)("Intake: setter for '" + string2 + "' in class '" + string + "' could not be found."));
                    }
                }
                catch (Exception exception) {
                    this.getCategory().error((Object)exception);
                }
            }
            Map map3 = this.getterMap;
            synchronized (map3) {
                try {
                    Method method2 = propertyDescriptor.getReadMethod();
                    ((Map)this.getterMap.get(string)).put(string2, method2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return method;
    }

    public Method getFieldGetter(String string, String string2) {
        Map map = (Map)this.getterMap.get(string);
        Method method = (Method)map.get(string2);
        if (method == null) {
            PropertyDescriptor propertyDescriptor = null;
            Map map2 = this.getterMap;
            synchronized (map2) {
                try {
                    propertyDescriptor = new PropertyDescriptor(string2, Class.forName(string));
                    method = propertyDescriptor.getReadMethod();
                    ((Map)this.getterMap.get(string)).put(string2, method);
                    if (method == null) {
                        this.getCategory().error((Object)("Intake: getter for '" + string2 + "' in class '" + string + "' could not be found."));
                    }
                }
                catch (Exception exception) {
                    this.getCategory().error((Object)exception);
                }
            }
            Map map3 = this.setterMap;
            synchronized (map3) {
                try {
                    Method method2 = propertyDescriptor.getWriteMethod();
                    ((Map)this.setterMap.get(string)).put(string2, method2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return method;
    }
}

