/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.DefaultValidator;
import org.apache.fulcrum.intake.validator.ValidationException;

public class DateStringValidator
extends DefaultValidator {
    private static final String DEFAULT_DATE_MESSAGE = "Date could not be parsed";
    private List dateFormats;
    private String dateFormatMessage;
    private boolean flexible;
    private DateFormat df;
    private SimpleDateFormat sdf;

    public DateStringValidator(Map map) throws ServiceException {
        this();
        this.init(map);
    }

    public DateStringValidator() {
    }

    public void init(Map map) throws ServiceException {
        super.init(map);
        this.dateFormats = new ArrayList(5);
        Constraint constraint = (Constraint)map.get("format");
        if (constraint != null) {
            this.dateFormats.add(constraint.getValue());
            this.setDateFormatMessage(constraint.getMessage());
        }
        int n = 1;
        constraint = (Constraint)map.get("format" + n);
        while (constraint != null) {
            this.dateFormats.add(constraint.getValue());
            this.setDateFormatMessage(constraint.getMessage());
            constraint = (Constraint)map.get("format" + ++n);
        }
        if (this.dateFormatMessage == null || this.dateFormatMessage.equals("")) {
            this.dateFormatMessage = DEFAULT_DATE_MESSAGE;
        }
        if ((constraint = (Constraint)map.get("flexible")) != null) {
            this.flexible = Boolean.valueOf(constraint.getValue());
        }
        if (this.dateFormats.size() == 0 || this.flexible) {
            this.df = DateFormat.getInstance();
            this.df.setLenient(true);
        }
        if (this.dateFormats.size() != 0) {
            this.sdf = new SimpleDateFormat();
        }
    }

    protected void doAssertValidity(String string) throws ValidationException {
        try {
            this.parse(string);
        }
        catch (ParseException parseException) {
            this.message = this.dateFormatMessage;
            throw new ValidationException(this.dateFormatMessage);
        }
    }

    public Date parse(String string) throws ParseException {
        Date date = null;
        if (string == null) {
            throw new ParseException("Input string was null", -1);
        }
        int n = 0;
        while (n < this.dateFormats.size()) {
            this.sdf.applyPattern((String)this.dateFormats.get(n));
            try {
                date = this.sdf.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (date != null) break;
            ++n;
        }
        if (date == null && this.df != null) {
            date = this.df.parse(string);
        }
        return date;
    }

    public String format(Date date) {
        String string = null;
        if (date != null) {
            this.sdf.applyPattern((String)this.dateFormats.get(0));
            string = this.sdf.format(date);
        }
        return string;
    }

    public String getDateFormatMessage() {
        return this.dateFormatMessage;
    }

    public void setDateFormatMessage(String string) {
        if (string != null && !string.equals("")) {
            this.dateFormatMessage = string;
        }
    }

    public List getDateFormats() {
        return this.dateFormats;
    }

    public void setDateFormats(List list) {
        this.dateFormats = list;
    }

    public boolean isFlexible() {
        return this.flexible;
    }

    public void setFlexible(boolean bl) {
        this.flexible = bl;
    }
}

