/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.util.Map;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.NumberValidator;
import org.apache.fulcrum.intake.validator.ValidationException;

public class IntegerValidator
extends NumberValidator {
    private static String INVALID_NUMBER = "Entry was not a valid integer";
    private int minValue;
    private int maxValue;

    public IntegerValidator(Map map) throws ServiceException {
        this();
        this.init(map);
    }

    public IntegerValidator() {
    }

    protected void doInit(Map map) {
        String string;
        this.minValue = Integer.MIN_VALUE;
        this.maxValue = Integer.MAX_VALUE;
        Constraint constraint = (Constraint)map.get("minValue");
        if (constraint != null) {
            string = constraint.getValue();
            this.minValue = Integer.parseInt(string);
            this.minValueMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)map.get("maxValue")) != null) {
            string = constraint.getValue();
            this.maxValue = Integer.parseInt(string);
            this.maxValueMessage = constraint.getMessage();
        }
    }

    protected String getDefaultInvalidNumberMessage() {
        return INVALID_NUMBER;
    }

    protected void doAssertValidity(String string) throws ValidationException {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (RuntimeException runtimeException) {
            this.message = this.invalidNumberMessage;
            throw new ValidationException(this.invalidNumberMessage);
        }
        if (n < this.minValue) {
            this.message = this.minValueMessage;
            throw new ValidationException(this.minValueMessage);
        }
        if (n > this.maxValue) {
            this.message = this.maxValueMessage;
            throw new ValidationException(this.maxValueMessage);
        }
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int n) {
        this.minValue = n;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int n) {
        this.maxValue = n;
    }
}

