/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db.entity;

import java.util.Iterator;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineGroup;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.TurbineSecurityException;

public class TurbineGroup
extends BaseTurbineGroup
implements Group,
Comparable {
    public TurbineGroup() {
    }

    public TurbineGroup(String string) {
        this.setName(string);
    }

    public static Group getGlobalGroup() {
        return TurbineSecurity.getGlobalGroup();
    }

    public static Group create(String string) throws TurbineSecurityException {
        return TurbineSecurity.createGroup(string);
    }

    public void save() throws TurbineSecurityException {
        TurbineSecurity.saveGroup(this);
    }

    public void remove() throws TurbineSecurityException {
        TurbineSecurity.removeGroup(this);
    }

    public void rename(String string) throws TurbineSecurityException {
        TurbineSecurity.renameGroup(this, string);
    }

    public void grant(User user, Role role) throws TurbineSecurityException {
        TurbineSecurity.grant(user, this, role);
    }

    public void grant(User user, RoleSet roleSet) throws TurbineSecurityException {
        Iterator iterator = roleSet.elements();
        while (iterator.hasNext()) {
            TurbineSecurity.grant(user, this, (Role)iterator.next());
        }
    }

    public void revoke(User user, Role role) throws TurbineSecurityException {
        TurbineSecurity.revoke(user, this, role);
    }

    public void revoke(User user, RoleSet roleSet) throws TurbineSecurityException {
        Iterator iterator = roleSet.elements();
        while (iterator.hasNext()) {
            TurbineSecurity.revoke(user, this, (Role)iterator.next());
        }
    }

    public int compareTo(Object object) {
        if (this.getClass() != object.getClass()) {
            throw new ClassCastException();
        }
        String string = ((SecurityEntity)object).getName();
        String string2 = this.getName();
        return string2.compareTo(string);
    }
}

