/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.TurbineSecurityException;

public class AccessControlList
implements Serializable {
    private Map roleSets;
    private Map permissionSets;
    public static String SESSION_KEY = "turbine.AccessControlList";

    public AccessControlList(Map map, Map map2) {
        this.roleSets = map;
        this.permissionSets = map2;
    }

    public RoleSet getRoles(Group group) {
        if (group == null) {
            return null;
        }
        return (RoleSet)this.roleSets.get(group);
    }

    public RoleSet getRoles() {
        return this.getRoles(TurbineSecurity.getGlobalGroup());
    }

    public PermissionSet getPermissions(Group group) {
        if (group == null) {
            return null;
        }
        return (PermissionSet)this.permissionSets.get(group);
    }

    public PermissionSet getPermissions() {
        return this.getPermissions(TurbineSecurity.getGlobalGroup());
    }

    public boolean hasRole(Role role, Group group) {
        RoleSet roleSet = this.getRoles(group);
        if (roleSet == null || role == null) {
            return false;
        }
        return roleSet.contains(role);
    }

    public boolean hasRole(Role role, GroupSet groupSet) {
        if (role == null) {
            return false;
        }
        Iterator iterator = groupSet.elements();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            RoleSet roleSet = this.getRoles(group);
            if (roleSet == null || !roleSet.contains(role)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRole(String string, String string2) {
        try {
            return this.hasRole(TurbineSecurity.getRole(string), TurbineSecurity.getGroup(string2));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasRole(String string, GroupSet groupSet) {
        Role role;
        try {
            role = TurbineSecurity.getRole(string);
        }
        catch (TurbineSecurityException turbineSecurityException) {
            return false;
        }
        if (role == null) {
            return false;
        }
        Iterator iterator = groupSet.elements();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            RoleSet roleSet = this.getRoles(group);
            if (roleSet == null || !roleSet.contains(role)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRole(Role role) {
        return this.hasRole(role, TurbineSecurity.getGlobalGroup());
    }

    public boolean hasRole(String string) {
        try {
            return this.hasRole(TurbineSecurity.getRole(string));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasPermission(Permission permission, Group group) {
        PermissionSet permissionSet = this.getPermissions(group);
        if (permissionSet == null || permission == null) {
            return false;
        }
        return permissionSet.contains(permission);
    }

    public boolean hasPermission(Permission permission, GroupSet groupSet) {
        if (permission == null) {
            return false;
        }
        Iterator iterator = groupSet.elements();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            PermissionSet permissionSet = this.getPermissions(group);
            if (permissionSet == null || !permissionSet.contains(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(String string, String string2) {
        try {
            return this.hasPermission(TurbineSecurity.getPermission(string), TurbineSecurity.getGroup(string2));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasPermission(String string, Group group) {
        try {
            return this.hasPermission(TurbineSecurity.getPermission(string), group);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasPermission(String string, GroupSet groupSet) {
        Permission permission;
        try {
            permission = TurbineSecurity.getPermission(string);
        }
        catch (TurbineSecurityException turbineSecurityException) {
            return false;
        }
        if (permission == null) {
            return false;
        }
        Iterator iterator = groupSet.elements();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            PermissionSet permissionSet = this.getPermissions(group);
            if (permissionSet == null || !permissionSet.contains(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(Permission permission) {
        return this.hasPermission(permission, TurbineSecurity.getGlobalGroup());
    }

    public boolean hasPermission(String string) {
        try {
            return this.hasPermission(TurbineSecurity.getPermission(string));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Group[] getAllGroups() {
        try {
            return TurbineSecurity.getAllGroups().getGroupsArray();
        }
        catch (TurbineSecurityException turbineSecurityException) {
            return new Group[0];
        }
    }
}

