/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.xmlrpc;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.fulcrum.Fulcrum;
import org.apache.fulcrum.InstantiationException;
import org.apache.fulcrum.ServiceManager;
import org.apache.fulcrum.TurbineServices;
import org.apache.fulcrum.xmlrpc.TurbineXmlRpc;
import org.apache.fulcrum.xmlrpc.XmlRpcService;

public class XmlRpcTest
extends TestCase {
    public static final String CONFIG_FILE = "src/test/org/apache/fulcrum/xmlrpc/Fulcrum.properties";
    private ServiceManager manager = null;
    private Fulcrum fulcrum = null;
    private static boolean initialized = false;
    static /* synthetic */ Class class$org$apache$fulcrum$xmlrpc$XmlRpcTest;

    public XmlRpcTest(String string) {
        super(string);
    }

    public void testInitializeTurbineServices() {
        Class clazz = class$org$apache$fulcrum$xmlrpc$XmlRpcTest == null ? (class$org$apache$fulcrum$xmlrpc$XmlRpcTest = XmlRpcTest.class$("org.apache.fulcrum.xmlrpc.XmlRpcTest")) : class$org$apache$fulcrum$xmlrpc$XmlRpcTest;
        synchronized (clazz) {
            this.initTurbineServices();
            try {
                XmlRpcService xmlRpcService = TurbineXmlRpc.getService();
                Assert.assertNotNull((Object)xmlRpcService);
                Assert.assertTrue((boolean)xmlRpcService.isInitialized());
            }
            catch (InstantiationException instantiationException) {
                Assert.fail((String)"could not get the service: XmlRpcService");
            }
            this.shutdownTurbineServices();
        }
    }

    public void testInitializeFulcrum() {
        Class clazz = class$org$apache$fulcrum$xmlrpc$XmlRpcTest == null ? (class$org$apache$fulcrum$xmlrpc$XmlRpcTest = XmlRpcTest.class$("org.apache.fulcrum.xmlrpc.XmlRpcTest")) : class$org$apache$fulcrum$xmlrpc$XmlRpcTest;
        synchronized (clazz) {
            this.initFulcrum();
            try {
                XmlRpcService xmlRpcService = TurbineXmlRpc.getService();
                Assert.assertNotNull((Object)xmlRpcService);
                Assert.assertTrue((boolean)xmlRpcService.isInitialized());
            }
            catch (InstantiationException instantiationException) {
                Assert.fail((String)"could not get the service: XmlRpcService");
            }
            this.shutdownFulcrum();
        }
    }

    private void initFulcrum() {
        try {
            this.fulcrum = new Fulcrum();
            this.fulcrum.configure((Configuration)new PropertiesConfiguration(CONFIG_FILE));
            this.fulcrum.initialize();
        }
        catch (IOException iOException) {
            this.reportIOExceptionAndFail("Fulcrum", iOException);
        }
        catch (Exception exception) {
            this.reportExceptionAndFail("Fulcrum", exception);
        }
    }

    private void initTurbineServices() {
        try {
            this.manager = TurbineServices.getInstance();
            this.manager.setConfiguration((Configuration)new PropertiesConfiguration(CONFIG_FILE));
            this.manager.init();
        }
        catch (IOException iOException) {
            this.reportIOExceptionAndFail("Fulcrum", iOException);
        }
        catch (Exception exception) {
            this.reportExceptionAndFail("Fulcrum", exception);
        }
    }

    private void shutdownFulcrum() {
        Fulcrum.shutdownServices();
    }

    private void shutdownTurbineServices() {
        this.manager.shutdownServices();
    }

    private void reportIOExceptionAndFail(String string, IOException iOException) {
        String string2 = string + " could not be configured with file '" + CONFIG_FILE + "'.";
        iOException.printStackTrace();
        Assert.fail((String)string2);
    }

    private void reportExceptionAndFail(String string, Exception exception) {
        String string2 = string + " could not be initialized!";
        exception.printStackTrace();
        Assert.fail((String)string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

