/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions;

import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.modules.Action;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.util.RunData;

public class ChangePassword
extends Action {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ChangePassword.class.getName());

    public void doPerform(RunData rundata) throws Exception {
        String cancelBtn = rundata.getParameters().getString(Localization.getString((RunData)rundata, (String)"PASSWORDFORM_CANCEL"));
        String username = rundata.getParameters().getString("username", "");
        String oldPassword = JetspeedSecurity.convertPassword(rundata.getParameters().getString("old_password", ""));
        String password = JetspeedSecurity.convertPassword(rundata.getParameters().getString("password", ""));
        String password2 = JetspeedSecurity.convertPassword(rundata.getParameters().getString("password_confirm", ""));
        if (cancelBtn != null && cancelBtn.equalsIgnoreCase(Localization.getString((RunData)rundata, (String)"PASSWORDFORM_CANCEL"))) {
            return;
        }
        String returnTemplate = JetspeedResources.getString("template.change.password", "ChangePassword");
        try {
            JetspeedUser user = JetspeedSecurity.getUser(username);
            if (!password.equals(password2)) {
                rundata.setMessage(Localization.getString((RunData)rundata, (String)"UPDATEACCOUNT_PWNOTMATCH"));
                rundata.setScreenTemplate(returnTemplate);
                return;
            }
            if (password.equals(oldPassword)) {
                rundata.setMessage(Localization.getString((RunData)rundata, (String)"PASSWORDFORM_THESAME_MSG"));
                rundata.setScreenTemplate(returnTemplate);
                return;
            }
            JetspeedSecurity.changePassword(user, oldPassword, password);
            rundata.setMessage(Localization.getString((RunData)rundata, (String)"PASSWORDFORM_DONE"));
            rundata.getParameters().setString("username", username);
            rundata.getParameters().setString("password", password);
            String userRequestsRememberMe = rundata.getParameters().getString("rememberme");
            rundata.getParameters().setString("rememberme", userRequestsRememberMe);
            ActionLoader.getInstance().getInstance(JetspeedResources.getString("action.login")).doPerform(rundata);
            JetspeedRunData jdata = (JetspeedRunData)rundata;
            jdata.setProfile(Profiler.getProfile((RunData)jdata));
        }
        catch (Exception e) {
            logger.error("Exception", e);
            rundata.setMessage(e.getMessage() != null ? e.getMessage() : e.toString());
            rundata.setScreenTemplate(returnTemplate);
        }
    }
}

