/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.controllers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.jetspeed.modules.actions.controllers.VelocityControllerAction;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.IdentityElement;
import org.apache.jetspeed.om.profile.Layout;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.psml.PsmlLayout;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.AutoProfile;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class RowColumnControllerAction
extends VelocityControllerAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(RowColumnControllerAction.class.getName());

    protected void buildNormalContext(PortletController controller, Context context, RunData rundata) {
        String sizes = controller.getConfig().getInitParameter("sizes");
        context.put("sizes", (Object)RowColumnControllerAction.getCellSizes(sizes));
    }

    public static List getCellSizes(String sizelist) {
        Vector<String> list = new Vector<String>();
        if (sizelist != null) {
            StringTokenizer st = new StringTokenizer(sizelist, ",");
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    protected void buildCustomizeContext(PortletController controller, Context context, RunData rundata) {
        IdentityElement p;
        int i;
        super.buildCustomizeContext(controller, context, rundata);
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        PortletSet set = (PortletSet)jdata.getCustomized();
        Portlets portlets = jdata.getCustomizedProfile().getDocument().getPortletsById(set.getID());
        ArrayList<IdentityElement> plist = new ArrayList<IdentityElement>();
        ArrayList<IdentityElement> work = new ArrayList<IdentityElement>();
        List<Object> filler = Collections.nCopies(portlets.getPortletsCount() + portlets.getEntryCount(), null);
        plist.addAll(filler);
        for (i = 0; i < portlets.getPortletsCount(); ++i) {
            void var12_15;
            Layout layout;
            p = portlets.getPortlets(i);
            if (logger.isDebugEnabled()) {
                logger.debug("RowColumnControllerAction: processing portlet: " + p.getTitle());
            }
            if ((layout = p.getLayout()) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RowColumnControllerAction: no layout, creating a new one");
                }
                PsmlLayout psmlLayout = new PsmlLayout();
                psmlLayout.setPosition(i);
                p.setLayout(psmlLayout);
            }
            if (var12_15 != null) {
                try {
                    int pos = (int)var12_15.getPosition();
                    if (logger.isDebugEnabled()) {
                        logger.debug("RowColumnControllerAction: layout has position: " + pos);
                    }
                    if (pos >= 0 && pos < plist.size()) {
                        plist.set(pos, p);
                        continue;
                    }
                    work.add(p);
                }
                catch (Exception e) {
                    logger.error("Layout error", e);
                    var12_15.setPosition(-1L);
                    work.add(p);
                }
                continue;
            }
            work.add(p);
        }
        for (i = 0; i < portlets.getEntryCount(); ++i) {
            p = portlets.getEntry(i);
            Layout layout = p.getLayout();
            if (layout != null) {
                try {
                    int pos = (int)layout.getPosition();
                    if (pos >= 0) {
                        plist.set(pos, p);
                        continue;
                    }
                    work.add(p);
                }
                catch (Exception e) {
                    layout.setPosition(-1L);
                    work.add(p);
                }
                continue;
            }
            work.add(p);
        }
        Iterator i2 = work.iterator();
        for (int idx = 0; idx < plist.size(); ++idx) {
            if (plist.get(idx) != null) continue;
            if (i2.hasNext()) {
                plist.set(idx, (IdentityElement)i2.next());
                continue;
            }
            plist.remove(idx);
        }
        HashMap<String, String> titles = new HashMap<String, String>();
        for (Object e : plist) {
            IdentityElement entry;
            if (e instanceof Portlets) {
                entry = (Portlets)e;
                if (entry.getMetaInfo() == null || entry.getMetaInfo().getTitle() == null) continue;
                titles.put(entry.getId(), entry.getMetaInfo().getTitle());
                continue;
            }
            entry = (Entry)e;
            if (entry.getMetaInfo() != null && entry.getMetaInfo().getTitle() != null) {
                titles.put(entry.getId(), entry.getMetaInfo().getTitle());
                continue;
            }
            RegistryEntry pentry = Registry.getEntry(Registry.PORTLET, entry.getParent());
            if (pentry == null) continue;
            titles.put(entry.getId(), pentry.getTitle());
        }
        context.put("portlets", plist);
        context.put("titles", titles);
        context.put("runs", (Object)AutoProfile.getPortletList(rundata));
    }

    public void doCancel(RunData data, Context context) {
        ((JetspeedRunData)data).setCustomized(null);
        if (((JetspeedRunData)data).getCustomized() == null) {
            try {
                ActionLoader.getInstance().exec(data, "controls.EndCustomize");
            }
            catch (Exception e) {
                logger.error("Unable to load action controls.EndCustomize ", e);
            }
        }
    }

    public void doSave(RunData data, Context context) {
        this.doApply(data, context);
    }

    public void doApply(RunData data, Context context) {
        ((JetspeedRunData)data).setCustomized(null);
        if (((JetspeedRunData)data).getCustomized() == null) {
            try {
                ((JetspeedRunData)data).getCustomizedProfile().store();
            }
            catch (Exception e) {
                logger.error("Unable to save profile ", e);
            }
            try {
                ActionLoader.getInstance().exec(data, "controls.EndCustomize");
            }
            catch (Exception e) {
                logger.error("Unable to load action controls.EndCustomize ", e);
            }
        }
    }

    public void doDelete(RunData data, Context context) throws Exception {
        Portlets set;
        JetspeedRunData jdata = (JetspeedRunData)data;
        PortletSet customizedSet = (PortletSet)jdata.getCustomized();
        int position = data.getParameters().getInt("position", -1);
        Profile profile = jdata.getCustomizedProfile();
        if (customizedSet == null) {
            return;
        }
        if (position > -1 && (set = profile.getDocument().getPortletsById(customizedSet.getID())) != null) {
            int lpos;
            Layout layout;
            IdentityElement p;
            int i;
            for (i = 0; i < set.getPortletsCount(); ++i) {
                p = set.getPortlets(i);
                layout = p.getLayout();
                if (layout == null || layout.getPosition() == -1L || (lpos = (int)layout.getPosition()) != position) continue;
                set.removePortlets(i);
                this.updateLayoutPositions(set);
                return;
            }
            for (i = 0; i < set.getEntryCount(); ++i) {
                p = set.getEntry(i);
                layout = p.getLayout();
                if (layout == null || layout.getPosition() == -1L || (lpos = (int)layout.getPosition()) != position) continue;
                set.removeEntry(i);
                return;
            }
            if (position < set.getPortletsCount()) {
                set.removePortlets(position);
                return;
            }
            if (position < set.getEntryCount()) {
                set.removeEntry(position);
                return;
            }
        }
    }

    private void updateLayoutPositions(Portlets set) {
        ArrayList<Portlets> list = new ArrayList<Portlets>();
        for (int i = 0; i < set.getPortletsCount(); ++i) {
            Portlets pane = set.getPortlets(i);
            list.add(pane);
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object pane1, Object pane2) {
                Long pos1 = new Long(((Portlets)pane1).getLayout().getPosition());
                Long pos2 = new Long(((Portlets)pane2).getLayout().getPosition());
                return pos1.compareTo(pos2);
            }
        });
        int position = 0;
        for (Portlets pane : list) {
            Layout layout = pane.getLayout();
            layout.setPosition(position++);
        }
    }

    public void doUp(RunData data, Context context) throws Exception {
        this.doMove(data, context, true);
    }

    public void doDown(RunData data, Context context) throws Exception {
        this.doMove(data, context, false);
    }

    public void doMove(RunData data, Context context, boolean moveUp) throws Exception {
        JetspeedRunData jdata = (JetspeedRunData)data;
        PortletSet customizedSet = (PortletSet)jdata.getCustomized();
        int position = data.getParameters().getInt("position", -1);
        Profile profile = jdata.getCustomizedProfile();
        if (customizedSet == null) {
            return;
        }
        if (position > -1) {
            int target = -1;
            Portlets set = profile.getDocument().getPortletsById(customizedSet.getID());
            Layout targetLayout = null;
            Layout baseLayout = null;
            if (set != null) {
                int lpos;
                Layout layout;
                IdentityElement p;
                int i;
                if (moveUp) {
                    if (position >= set.getPortletsCount() && position >= set.getEntryCount()) {
                        return;
                    }
                    target = position + 1;
                } else {
                    if (position == 0) {
                        return;
                    }
                    target = position - 1;
                }
                for (i = 0; i < set.getPortletsCount() && (targetLayout == null || baseLayout == null); ++i) {
                    p = set.getPortlets(i);
                    layout = p.getLayout();
                    if (layout == null || layout.getPosition() == -1L) continue;
                    lpos = (int)layout.getPosition();
                    if (baseLayout == null && lpos == position) {
                        baseLayout = layout;
                    }
                    if (targetLayout != null || lpos != target) continue;
                    targetLayout = layout;
                }
                for (i = 0; i < set.getEntryCount() && (targetLayout == null || baseLayout == null); ++i) {
                    p = set.getEntry(i);
                    layout = p.getLayout();
                    if (layout == null || layout.getPosition() == -1L) continue;
                    lpos = (int)layout.getPosition();
                    if (baseLayout == null && lpos == position) {
                        baseLayout = layout;
                    }
                    if (targetLayout != null || lpos != target) continue;
                    targetLayout = layout;
                }
                if (baseLayout == null) {
                    if (position < set.getPortletsCount()) {
                        Portlets p2 = set.getPortlets(position);
                        if (p2.getLayout() == null) {
                            p2.setLayout(new PsmlLayout());
                        }
                        baseLayout = p2.getLayout();
                    }
                    if (position < set.getEntryCount()) {
                        Entry p3 = set.getEntry(position);
                        if (p3.getLayout() == null) {
                            p3.setLayout(new PsmlLayout());
                        }
                        baseLayout = p3.getLayout();
                    }
                }
                if (targetLayout == null) {
                    if (target < set.getPortletsCount()) {
                        Portlets p4 = set.getPortlets(target);
                        if (p4.getLayout() == null) {
                            p4.setLayout(new PsmlLayout());
                        }
                        targetLayout = p4.getLayout();
                    }
                    if (target < set.getEntryCount()) {
                        Entry p5 = set.getEntry(target);
                        if (p5.getLayout() == null) {
                            p5.setLayout(new PsmlLayout());
                        }
                        targetLayout = p5.getLayout();
                    }
                }
                if (baseLayout == null || targetLayout == null) {
                    return;
                }
                baseLayout.setPosition(target);
                targetLayout.setPosition(position);
            }
        }
    }
}

