/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.SerializationUtils;
import org.apache.jetspeed.modules.actions.portlets.CustomizeSetAction;
import org.apache.jetspeed.modules.actions.portlets.PortletFilter;
import org.apache.jetspeed.modules.actions.portlets.RegistryUpdateAction;
import org.apache.jetspeed.om.BaseSecurityReference;
import org.apache.jetspeed.om.registry.MediaTypeRegistry;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.base.BaseParameter;
import org.apache.jetspeed.om.registry.base.BaseSecurity;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;
import org.apache.velocity.context.Context;

public class PortletUpdateAction
extends RegistryUpdateAction {
    private static final String PORTLET_UPDATE_PANE = "portlet-form";
    private static final String PORTLET_NAME = "portlet_name";
    private static final String TAB_PARAMETER = "tab";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(PortletUpdateAction.class.getName());

    public PortletUpdateAction() {
        this.registryEntryName = PORTLET_NAME;
        this.registry = Registry.PORTLET;
        this.pane = PORTLET_UPDATE_PANE;
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        PortletEntry portletEntry;
        String portletName;
        super.buildNormalContext(portlet, context, rundata);
        String mode = rundata.getParameters().getString("mode");
        if (mode != null && mode.equals("insert")) {
            context.put("parents", (Object)PortletFilter.buildParentList(PortletFilter.getAllPortlets()));
            context.put("securitys", (Object)CustomizeSetAction.buildList(rundata, Registry.SECURITY));
        }
        if (mode != null && mode.equals("update")) {
            portletName = rundata.getParameters().getString(PORTLET_NAME);
            portletEntry = (PortletEntry)Registry.getEntry(Registry.PORTLET, portletName);
            context.put("groups", (Object)this.iteratorToCollection(JetspeedSecurity.getGroups()));
            context.put("categories", (Object)PortletFilter.buildCategoryList(PortletFilter.getAllPortlets()));
            String tab = rundata.getParameters().getString(TAB_PARAMETER);
            context.put("currentTab", (Object)tab);
            context.put("securitys", (Object)CustomizeSetAction.buildList(rundata, Registry.SECURITY));
            context.put("entry", (Object)portletEntry);
            MediaTypeRegistry mediaTypeReg = (MediaTypeRegistry)Registry.get(Registry.MEDIA_TYPE);
            context.put("media_types", (Object)this.iteratorToCollection(mediaTypeReg.listEntryNames()));
            if (portletEntry.getType() != null && portletEntry.getType().equals("ref")) {
                PortletEntry parentEntry = (PortletEntry)Registry.getEntry(Registry.PORTLET, portletEntry.getParent());
                if (parentEntry == null) {
                    logger.error(((Object)((Object)this)).getClass().getName() + ": Portlet " + portletName + " of type ref has no parent.  This portlet will not work properly.");
                } else {
                    Collection parentCategories = this.iteratorToCollection(parentEntry.listCategories());
                    context.put("parent_categories", (Object)parentCategories);
                    Collection parentMediaTypes = this.iteratorToCollection(parentEntry.listMediaTypes());
                    context.put("parent_mediatypes", (Object)parentMediaTypes);
                }
            }
        }
        if (mode != null && mode.equals("delete")) {
            portletName = rundata.getParameters().getString(PORTLET_NAME);
            portletEntry = (PortletEntry)Registry.getEntry(this.registry, portletName);
            context.put("entry", (Object)portletEntry);
        }
    }

    public void doInsert(RunData rundata, Context context) throws Exception {
        super.doInsert(rundata, context);
        String entryName = rundata.getParameters().getString(this.registryEntryName);
        PortletEntry portletEntry = (PortletEntry)Registry.getEntry(this.registry, entryName);
        if (portletEntry == null) {
            String message = "Portlet entry " + entryName + " does not exist.  The portlet was not added to the registry.";
            logger.error(((Object)((Object)this)).getClass().getName() + ": " + message);
            throw new IllegalStateException(message);
        }
        if (portletEntry.getType().equals("ref")) {
            PortletEntry parentEntry = (PortletEntry)Registry.getEntry(Registry.PORTLET, portletEntry.getParent());
            if (parentEntry == null) {
                logger.error(((Object)((Object)this)).getClass().getName() + ": Portlet " + entryName + " of type ref has no parent.  This portlet will not work properly.");
            } else {
                Iterator paramIter = portletEntry.getParameterNames();
                while (paramIter.hasNext()) {
                    String paramName = (String)paramIter.next();
                    BaseParameter param = (BaseParameter)portletEntry.getParameter(paramName);
                    BaseParameter clonedParameter = (BaseParameter)SerializationUtils.clone((Serializable)param);
                    portletEntry.addParameter(clonedParameter);
                }
                Registry.addEntry(Registry.PORTLET, portletEntry);
            }
        }
    }

    protected void updateRegistryEntry(RunData rundata, RegistryEntry registryEntry) throws Exception {
        super.updateRegistryEntry(rundata, registryEntry);
        this.setPortletEntryInfo(rundata, (PortletEntry)registryEntry);
    }

    private void setPortletEntryInfo(RunData rundata, PortletEntry portletEntry) {
        String parent = rundata.getParameters().getString("parent");
        String title = rundata.getParameters().getString("title");
        String description = rundata.getParameters().getString("description");
        String url = rundata.getParameters().getString("url");
        String type = rundata.getParameters().getString("portlet_type");
        String mediaType = rundata.getParameters().getString("media_type");
        String image = rundata.getParameters().getString("image");
        String className = rundata.getParameters().getString("class_name");
        boolean isApplication = rundata.getParameters().getBoolean("is_application", false);
        boolean isCachedOnURL = rundata.getParameters().getBoolean("is_cached_on_url", false);
        boolean isHidden = rundata.getParameters().getBoolean("is_hidden", false);
        boolean isAdmin = rundata.getParameters().getBoolean("is_admin", false);
        String newSecurityParent = rundata.getParameters().getString("security_ref");
        String newSecurityRole = rundata.getParameters().getString("security_role");
        portletEntry.setTitle(title);
        portletEntry.setDescription(description);
        portletEntry.setURL(url);
        portletEntry.setParent(parent);
        portletEntry.setType(type);
        portletEntry.getMetaInfo().setImage(image);
        portletEntry.listMediaTypes();
        portletEntry.addMediaType(mediaType);
        if (className != null && className.length() > 0) {
            portletEntry.setClassname(className);
        }
        portletEntry.setApplication(isApplication);
        portletEntry.setCachedOnURL(isCachedOnURL);
        portletEntry.setHidden(isHidden);
        if (newSecurityParent != null && newSecurityParent.length() > 0) {
            BaseSecurityReference securityRef = new BaseSecurityReference();
            securityRef.setParent(newSecurityParent);
            portletEntry.setSecurityRef(securityRef);
        }
        if (newSecurityRole != null && newSecurityRole.length() > 0) {
            BaseSecurity securityRole = new BaseSecurity();
            securityRole.setRole(newSecurityRole);
            portletEntry.setSecurity(securityRole);
        }
    }

    public void doAddcategory(RunData rundata, Context context) throws Exception {
        try {
            String portletName = rundata.getParameters().getString(PORTLET_NAME);
            PortletEntry portletEntry = (PortletEntry)Registry.getEntry(Registry.PORTLET, portletName);
            if (portletEntry != null) {
                String categoryName = rundata.getParameters().getString("category_name");
                if (categoryName != null && categoryName.length() > 0) {
                    String categoryGroup = rundata.getParameters().getString("category_group", "Jetspeed");
                    portletEntry.addCategory(categoryName, categoryGroup);
                    Registry.addEntry(this.registry, portletEntry);
                    this.clearUserData(rundata);
                } else {
                    DynamicURI duri = this.redirect(rundata, "update", 5);
                    rundata.setRedirectURI(duri.toString());
                    this.resetForm(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error("Failed to find registry entry while trying to add category");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 0);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    public void doRemovecategories(RunData rundata, Context context) throws Exception {
        try {
            String portletName = rundata.getParameters().getString(PORTLET_NAME);
            PortletEntry portletEntry = (PortletEntry)Registry.getEntry(Registry.PORTLET, portletName);
            if (portletEntry != null) {
                String[] categories = rundata.getParameters().getStrings("category_name");
                if (categories != null && categories.length > 0) {
                    for (int i = 0; i < categories.length; ++i) {
                        String categoryName = categories[i];
                        String categoryGroup = rundata.getParameters().getString(categoryName + ".category_group", "Jetspeed");
                        portletEntry.removeCategory(categoryName, categoryGroup);
                    }
                    Registry.addEntry(this.registry, portletEntry);
                    this.clearUserData(rundata);
                } else {
                    DynamicURI duri = this.redirect(rundata, "update", 5);
                    duri = duri.addQueryData(PORTLET_NAME, portletName);
                    rundata.setRedirectURI(duri.toString());
                    this.resetForm(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error("Failed to find registry entry while trying to remove categories");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 0);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    protected void resetForm(RunData rundata) {
        super.resetForm(rundata);
        String parent = rundata.getParameters().getString("parent");
        String title = rundata.getParameters().getString("title");
        String description = rundata.getParameters().getString("description");
        String url = rundata.getParameters().getString("url");
        String type = rundata.getParameters().getString("portlet_type");
        String image = rundata.getParameters().getString("image");
        String className = rundata.getParameters().getString("class_name");
        String isApplication = rundata.getParameters().getString("is_application");
        String isCachedOnURL = rundata.getParameters().getString("is_cached_on_url");
        String isHidden = rundata.getParameters().getString("is_hidden");
        String isAdmin = rundata.getParameters().getString("is_admin");
        String newSecurityParent = rundata.getParameters().getString("security_ref");
        rundata.getUser().setTemp("parent", (Object)parent);
        rundata.getUser().setTemp("portlet_type", (Object)type);
        rundata.getUser().setTemp("class_name", (Object)className);
        rundata.getUser().setTemp("url", (Object)url);
        rundata.getUser().setTemp("image", (Object)image);
        rundata.getUser().setTemp("is_application", (Object)isApplication);
        rundata.getUser().setTemp("is_cached_on_url", (Object)isCachedOnURL);
        rundata.getUser().setTemp("is_hidden", (Object)isHidden);
        rundata.getUser().setTemp("is_admin", (Object)isAdmin);
        rundata.getUser().setTemp("security_ref", (Object)newSecurityParent);
    }

    protected void clearUserData(RunData rundata) {
        block2: {
            try {
                super.clearUserData(rundata);
                rundata.getUser().removeTemp("parameter_name");
                rundata.getUser().removeTemp("paramter_value");
                rundata.getUser().removeTemp("parent");
                rundata.getUser().removeTemp("portlet_type");
                rundata.getUser().removeTemp("class_name");
                rundata.getUser().removeTemp("url");
                rundata.getUser().removeTemp("image");
                rundata.getUser().removeTemp("is_application");
                rundata.getUser().removeTemp("is_cached_on_url");
                rundata.getUser().removeTemp("is_hidden");
                rundata.getUser().removeTemp("is_admin");
                rundata.getUser().removeTemp("security_ref");
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("PortletUpdateAction: Failed to clear user data");
            }
        }
    }

    protected DynamicURI redirect(RunData rundata, String mode, int reason) throws TurbineException {
        DynamicURI duri = super.redirect(rundata, mode, reason);
        String tab = rundata.getParameters().getString(TAB_PARAMETER);
        if (tab != null && tab.length() > 0) {
            duri.addQueryData(TAB_PARAMETER, tab);
        }
        return duri;
    }
}

