/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.modules.actions.portlets.GenericMVCAction;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class RegistryBrowseAction
extends GenericMVCAction {
    public static final String PREFIX = "RegistryBrowseAction:";
    public static final String REFRESH = "refresh";
    public static final String FILTER_FIELDS = "filter_fields";
    public static final String FILTER_VALUES = "filter_values";
    public static final String START = "start";
    public static final String RESULTS = "results";
    public static final String FILTERED_RESULTS = "filtered_results";

    protected void buildNormalContext(Portlet portlet, Context context, RunData rundata) {
        int end;
        String pageSize;
        int size;
        int prev;
        int start;
        String regName = portlet.getPortletConfig().getInitParameter("registry", Registry.PORTLET);
        Boolean refresh = (Boolean)PortletSessionState.getAttribute(rundata, PREFIX + regName + ":" + REFRESH, Boolean.FALSE);
        if (refresh.equals(Boolean.TRUE)) {
            PortletSessionState.clearAttribute(portlet, rundata, START);
            PortletSessionState.clearAttribute(portlet, rundata, RESULTS);
            PortletSessionState.clearAttribute(portlet, rundata, FILTERED_RESULTS);
            PortletSessionState.clearAttribute(rundata, PREFIX + regName + ":" + REFRESH);
        }
        if ((start = this.getStart(rundata, portlet)) < 0) {
            start = 0;
        }
        if ((prev = start - (size = Integer.parseInt(pageSize = portlet.getPortletConfig().getInitParameter("page-size", "20")))) < 0) {
            prev = 0;
        }
        String[] filterFields = (String[])PortletSessionState.getAttribute(portlet, rundata, FILTER_FIELDS);
        String[] filterValues = (String[])PortletSessionState.getAttribute(portlet, rundata, FILTER_VALUES);
        ArrayList<RegistryEntry> regEntries = (ArrayList<RegistryEntry>)PortletSessionState.getAttribute(portlet, rundata, RESULTS);
        List filteredEntries = (List)PortletSessionState.getAttribute(portlet, rundata, FILTERED_RESULTS);
        if (regEntries == null) {
            Iterator i = Registry.get(regName).listEntryNames();
            regEntries = new ArrayList<RegistryEntry>();
            while (i.hasNext()) {
                String name = (String)i.next();
                RegistryEntry regEntry = Registry.getEntry(regName, name);
                if (regEntry == null || regEntry.isHidden()) continue;
                regEntries.add(regEntry);
            }
            Collections.sort(regEntries, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String t1 = ((RegistryEntry)o1).getName().toLowerCase();
                    String t2 = ((RegistryEntry)o2).getName().toLowerCase();
                    return t1.compareTo(t2);
                }
            });
            PortletSessionState.setAttribute(portlet, rundata, RESULTS, regEntries);
            filteredEntries = this.filter(regEntries, filterFields, filterValues);
            PortletSessionState.setAttribute(portlet, rundata, FILTERED_RESULTS, (Object)filteredEntries);
        }
        if (filterFields != null && filterValues != null && filterFields.length == filterValues.length) {
            for (int i = 0; i < filterFields.length; ++i) {
                String field = filterFields[i];
                String value = filterValues[i];
                context.put(field + "_filter_value", (Object)value);
            }
        }
        if ((end = start + size) > filteredEntries.size()) {
            end = filteredEntries.size();
        }
        List pageEntries = filteredEntries.subList(start, end);
        context.put("registry", pageEntries);
        context.put("filtered_entries", (Object)filteredEntries);
        if (start > 0) {
            context.put("prev", (Object)String.valueOf(prev));
        }
        if (end < filteredEntries.size()) {
            context.put("next", (Object)String.valueOf(end));
        }
    }

    private int getStart(RunData rundata, Portlet portlet) {
        int start = 0;
        Integer startInteger = rundata.getParameters().getInteger(START, -1);
        if (startInteger == -1) {
            startInteger = (Integer)PortletSessionState.getAttribute(portlet, rundata, START);
            if (startInteger != null) {
                start = startInteger;
            }
        } else {
            PortletSessionState.setAttribute(portlet, rundata, START, (Object)startInteger);
            start = startInteger;
        }
        return start;
    }

    public void doFilter(RunData rundata, Context context) throws Exception {
        String[] filterFields = rundata.getParameters().getStrings("filter_field");
        String[] filterValues = new String[filterFields.length];
        for (int i = 0; i < filterFields.length; ++i) {
            String filterValue;
            String filterField = filterFields[i];
            filterValues[i] = filterValue = rundata.getParameters().getString(filterField + ":filter_value");
        }
        String regName = this.getPortlet(context).getPortletConfig().getInitParameter("registry", Registry.PORTLET);
        PortletSessionState.setAttribute(this.getPortlet(context), rundata, FILTER_FIELDS, (Object)filterFields);
        PortletSessionState.setAttribute(this.getPortlet(context), rundata, FILTER_VALUES, (Object)filterValues);
        PortletSessionState.setAttribute(rundata, PREFIX + regName + ":" + REFRESH, Boolean.TRUE);
    }

    protected List filter(List entries, String[] fields, String[] values) {
        return entries;
    }
}

