/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets.browser;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction;
import org.apache.jetspeed.modules.actions.portlets.browser.ActionParameter;
import org.apache.jetspeed.modules.actions.portlets.browser.BrowserQuery;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.portal.portlets.browser.BrowserIterator;
import org.apache.jetspeed.portal.portlets.browser.DatabaseBrowserIterator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.PortletConfigState;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.torque.Torque;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class DatabaseBrowserAction
extends VelocityPortletAction
implements BrowserQuery {
    protected static final String SQL = "sql";
    protected static final String POOLNAME = "poolname";
    protected static final String START = "start";
    protected static final String CUSTOMIZE_TEMPLATE = "customizeTemplate";
    protected static final String WINDOW_SIZE = "windowSize";
    protected static final String USER_OBJECT_NAMES = "user-object-names";
    protected static final String USER_OBJECT_TYPES = "user-object-types";
    protected static final String USER_OBJECTS = "user-objects";
    protected static final String SQL_PARAM_PREFIX = "sqlparam";
    protected static final String LINKS_READ = "linksRead";
    protected static final String ROW_LINK = "rowLinks";
    protected static final String TABLE_LINK = "tableLinks";
    protected static final String ROW_LINK_IDS = "row-link-ids";
    protected static final String ROW_LINK_TYPES = "row-link-types";
    protected static final String ROW_LINK_TARGETS = "row-link-targets";
    protected static final String TABLE_LINK_IDS = "table-link-ids";
    protected static final String TABLE_LINK_TYPES = "table-link-types";
    protected static final String TABLE_LINK_TARGETS = "table-link-targets";
    protected static final String BROWSER_TABLE_SIZE = "tableSize";
    protected static final String DATABASE_BROWSER_ACTION_KEY = "database_browser_action_key";
    protected static final String BROWSER_ITERATOR = "table";
    protected static final String BROWSER_TITLE_ITERATOR = "title";
    protected static final String NEXT = "next";
    protected static final String PREVIOUS = "prev";
    protected static final String VELOCITY_NULL_ENTRY = "-";
    protected static final String PEID = "js_peid";
    protected static final String SORT_COLUMN_NAME = "js_dbcolumn";
    protected List sqlParameters = new Vector();
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(DatabaseBrowserAction.class.getName());

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildConfigureContext(VelocityPortlet portlet, Context context, RunData rundata) {
        try {
            super.buildConfigureContext(portlet, context, rundata);
        }
        catch (Exception ex) {
            logger.error("Exception", ex);
        }
        context.put(SQL, (Object)this.getQueryString(portlet, rundata, context));
        context.put(WINDOW_SIZE, (Object)this.getParameterUsingFallback(portlet, rundata, WINDOW_SIZE, null));
        this.setTemplate(rundata, this.getParameterUsingFallback(portlet, rundata, CUSTOMIZE_TEMPLATE, null));
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        BrowserIterator iterator = this.getDatabaseBrowserIterator(portlet, rundata);
        String sortColName = this.getRequestParameter(portlet, rundata, SORT_COLUMN_NAME);
        int start = this.getStartVariable(portlet, rundata, START, sortColName, iterator);
        int windowSize = Integer.parseInt(this.getParameterUsingFallback(portlet, rundata, WINDOW_SIZE, "10"));
        int next = start + windowSize;
        int prev = start - windowSize;
        try {
            if (iterator == null || PortletSessionState.getPortletConfigChanged(portlet, rundata)) {
                String sql = this.getQueryString(portlet, rundata, context);
                if (sql != null) {
                    this.readUserParameters(portlet, rundata, context);
                    this.getRows(portlet, rundata, sql, windowSize);
                    iterator = this.getDatabaseBrowserIterator(portlet, rundata);
                } else {
                    logger.info("The sql query is null, hence not generating the result set.");
                }
            } else {
                if (sortColName != null) {
                    iterator.sort(sortColName);
                }
                iterator.setTop(start);
            }
            this.readLinkParameters(portlet, rundata, context);
            if (iterator != null) {
                int resultSetSize = iterator.getResultSetSize();
                if (next < resultSetSize) {
                    context.put(NEXT, (Object)String.valueOf(next));
                }
                if (prev <= resultSetSize && prev >= 0) {
                    context.put(PREVIOUS, (Object)String.valueOf(prev));
                }
                context.put(BROWSER_ITERATOR, (Object)iterator);
                context.put(BROWSER_TITLE_ITERATOR, (Object)iterator.getResultSetTitleList());
                context.put(BROWSER_TABLE_SIZE, (Object)new Integer(resultSetSize));
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
            rundata.setMessage("Error in Jetspeed Database Browser: " + e.toString());
            rundata.setStackTrace(StringUtils.stackTrace((Throwable)e), (Throwable)e);
            rundata.setScreenTemplate(JetspeedResources.getString("template.error", "Error"));
        }
    }

    public void doUpdate(RunData rundata, Context context) {
        VelocityPortlet portlet = (VelocityPortlet)context.get("portlet");
        String sql = this.getRequestParameter(portlet, rundata, SQL);
        String pageSize = this.getRequestParameter(portlet, rundata, WINDOW_SIZE);
        if (sql != null) {
            this.setParameterToPSML(portlet, rundata, SQL, sql);
            context.put(SQL, (Object)sql);
            this.clearDatabaseBrowserIterator(portlet, rundata);
        }
        if (pageSize != null) {
            this.setParameterToPSML(portlet, rundata, WINDOW_SIZE, pageSize);
            context.put(WINDOW_SIZE, (Object)pageSize);
        }
        this.buildNormalContext(portlet, context, rundata);
    }

    public void doRefresh(RunData rundata, Context context) {
        VelocityPortlet portlet = (VelocityPortlet)context.get("portlet");
        if (this.isMyRequest(portlet, rundata)) {
            this.clearDatabaseBrowserIterator(portlet, rundata);
        }
        this.buildNormalContext(portlet, context, rundata);
    }

    public boolean filter(List row, RunData rundata) {
        return false;
    }

    protected void getRows(VelocityPortlet portlet, RunData rundata, String sql, int windowSize) throws Exception {
        ArrayList resultSetList = new ArrayList();
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        Connection con = null;
        Statement selectStmt = null;
        ResultSet rs = null;
        try {
            int i;
            String poolname = this.getParameterUsingFallback(portlet, rundata, POOLNAME, null);
            con = poolname == null || poolname.length() == 0 ? Torque.getConnection() : Torque.getConnection((String)poolname);
            selectStmt = con.prepareStatement(sql);
            this.readSqlParameters(portlet, rundata);
            Iterator it = this.sqlParameters.iterator();
            int ix = 0;
            while (it.hasNext()) {
                Object object = it.next();
                selectStmt.setObject(++ix, object);
            }
            rs = selectStmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnNum = rsmd.getColumnCount();
            List userObjList = (List)this.getParameterFromTemp(portlet, rundata, USER_OBJECTS);
            int userObjListSize = 0;
            if (userObjList != null) {
                userObjListSize = userObjList.size();
            }
            boolean[] columnDisplayed = new boolean[columnNum + userObjListSize];
            for (i = 1; i <= columnNum; ++i) {
                int type = rsmd.getColumnType(i);
                if (type != 2004 && type != 2005 && type != -2 && type != -4 && type != -3) {
                    resultSetTitleList.add(rsmd.getColumnName(i));
                    resultSetTypeList.add(String.valueOf(type));
                    columnDisplayed[i - 1] = true;
                    continue;
                }
                columnDisplayed[i - 1] = false;
            }
            for (i = columnNum; i < columnNum + userObjListSize; ++i) {
                ActionParameter usrObj = (ActionParameter)userObjList.get(i - columnNum);
                resultSetTitleList.add(usrObj.getName());
                resultSetTypeList.add(usrObj.getType());
                columnDisplayed[i] = true;
            }
            int index = 0;
            while (rs.next()) {
                int i2;
                ArrayList<Object> row = new ArrayList<Object>(columnNum);
                for (i2 = 1; i2 <= columnNum; ++i2) {
                    if (!columnDisplayed[i2 - 1]) continue;
                    Object obj = rs.getObject(i2);
                    if (obj == null) {
                        obj = VELOCITY_NULL_ENTRY;
                    }
                    row.add(obj);
                }
                for (i2 = columnNum; i2 < columnNum + userObjListSize; ++i2) {
                    ActionParameter usrObj = (ActionParameter)userObjList.get(i2 - columnNum);
                    if (!columnDisplayed[i2]) continue;
                    Class<?> c = Class.forName(usrObj.getType());
                    row.add(c.newInstance());
                    this.populate(index, i2, row);
                }
                if (this.filter(row, rundata)) continue;
                resultSetList.add(row);
                ++index;
            }
            DatabaseBrowserIterator iterator = new DatabaseBrowserIterator(resultSetList, resultSetTitleList, resultSetTypeList, windowSize);
            this.setDatabaseBrowserIterator(portlet, rundata, iterator);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (null != selectStmt) {
                selectStmt.close();
            }
            if (null != rs) {
                rs.close();
            }
            if (null != con) {
                Torque.closeConnection((Connection)con);
            }
        }
    }

    protected BrowserIterator getDatabaseBrowserIterator(VelocityPortlet portlet, RunData rundata) {
        BrowserIterator iterator = (BrowserIterator)this.getParameterFromTemp(portlet, rundata, DATABASE_BROWSER_ACTION_KEY);
        return iterator;
    }

    protected void setDatabaseBrowserIterator(VelocityPortlet portlet, RunData rundata, BrowserIterator iterator) {
        this.setParameterToTemp(portlet, rundata, DATABASE_BROWSER_ACTION_KEY, iterator);
    }

    protected void clearDatabaseBrowserIterator(VelocityPortlet portlet, RunData rundata) {
        this.clearParameterFromTemp(portlet, rundata, DATABASE_BROWSER_ACTION_KEY);
    }

    public String getQueryString(RunData rundata, Context context) {
        return null;
    }

    protected String getQueryString(VelocityPortlet portlet, RunData rundata, Context context) {
        String sql = this.getQueryString(rundata, context);
        if (sql == null) {
            sql = this.getParameterUsingFallback(portlet, rundata, SQL, null);
        }
        return sql;
    }

    protected void clearQueryString(VelocityPortlet portlet, RunData rundata) {
        this.clearParameterFromPSML(portlet, rundata, SQL);
    }

    protected int getStartIndex() {
        return 0;
    }

    protected String getParameterUsingFallback(VelocityPortlet portlet, RunData rundata, String attrName, String attrDefValue) {
        return PortletConfigState.getParameter(portlet, rundata, attrName, attrDefValue);
    }

    protected void clearParameterFromPSML(VelocityPortlet portlet, RunData rundata, String attributeName) {
        PortletConfigState.clearInstanceParameter(portlet, rundata, attributeName);
    }

    protected void setParameterToPSML(VelocityPortlet portlet, RunData rundata, String attrName, String attrValue) {
        PortletConfigState.setInstanceParameter(portlet, rundata, attrName, attrValue);
    }

    protected String getParameterFromPSML(VelocityPortlet portlet, RunData rundata, String attrName, String attrDefValue) {
        return PortletConfigState.getInstanceParameter(portlet, rundata, attrName);
    }

    protected String getParameterFromRegistry(VelocityPortlet portlet, String attrName, String attrDefValue) {
        return PortletConfigState.getConfigParameter(portlet, attrName, attrDefValue);
    }

    protected Object getParameterFromTemp(VelocityPortlet portlet, RunData rundata, String attrName) {
        return PortletSessionState.getAttribute(portlet, rundata, attrName);
    }

    protected void setParameterToTemp(VelocityPortlet portlet, RunData rundata, String attrName, Object attrValue) {
        PortletSessionState.setAttribute(portlet, rundata, attrName, attrValue);
    }

    protected void clearParameterFromTemp(VelocityPortlet portlet, RunData rundata, String attrName) {
        PortletSessionState.clearAttribute(portlet, rundata, attrName);
    }

    protected boolean isMyRequest(VelocityPortlet portlet, RunData rundata) {
        String peId = portlet.getID();
        return peId != null && peId.equals(rundata.getParameters().getString(PEID));
    }

    protected String getRequestParameter(VelocityPortlet portlet, RunData rundata, String attrName) {
        if (this.isMyRequest(portlet, rundata)) {
            return rundata.getParameters().getString(attrName);
        }
        return null;
    }

    protected int getStartVariable(VelocityPortlet portlet, RunData rundata, String attrName, String sortColName, BrowserIterator iterator) {
        int start = -1;
        if (sortColName != null) {
            start = this.getStartIndex();
        }
        if (start < 0) {
            String startStr = this.getRequestParameter(portlet, rundata, attrName);
            if (startStr != null && startStr.length() > 0) {
                start = Integer.parseInt(startStr);
            } else if (start == -1 && iterator != null) {
                start = iterator.getTop();
            }
            if (start < 0) {
                start = 0;
            }
        }
        return start;
    }

    public void setSQLParameters(List parameters) {
        this.sqlParameters = parameters;
    }

    public List getSQLParameters() {
        return this.sqlParameters;
    }

    protected void readSqlParameters(VelocityPortlet portlet, RunData rundata) {
        String param;
        ArrayList<String> sqlParamList = null;
        int i = 1;
        while ((param = this.getParameterUsingFallback(portlet, rundata, SQL_PARAM_PREFIX + i, null)) != null) {
            if (sqlParamList == null) {
                sqlParamList = new ArrayList<String>();
            }
            sqlParamList.add(param);
            ++i;
        }
        if (sqlParamList != null) {
            this.setSQLParameters(sqlParamList);
        }
    }

    protected void readUserParameters(VelocityPortlet portlet, RunData rundata, Context context) {
        Object userObjRead = this.getParameterFromTemp(portlet, rundata, USER_OBJECTS);
        if (userObjRead != null) {
            context.put(USER_OBJECTS, (Object)((List)userObjRead));
        } else {
            String userObjTypes = this.getParameterFromRegistry(portlet, USER_OBJECT_TYPES, null);
            String userObjNames = this.getParameterFromRegistry(portlet, USER_OBJECT_NAMES, null);
            if (userObjTypes != null && userObjTypes.length() > 0) {
                ArrayList<ActionParameter> userObjectList = new ArrayList<ActionParameter>();
                int userObjectIndex = 0;
                StringTokenizer tokenizer1 = new StringTokenizer(userObjNames, ",");
                StringTokenizer tokenizer3 = new StringTokenizer(userObjTypes, ",");
                while (tokenizer1.hasMoreTokens() && tokenizer3.hasMoreTokens()) {
                    userObjectList.add(userObjectIndex, new ActionParameter(tokenizer1.nextToken(), null, tokenizer3.nextToken()));
                    ++userObjectIndex;
                }
                context.put(USER_OBJECTS, userObjectList);
                this.setParameterToTemp(portlet, rundata, USER_OBJECTS, userObjectList);
            }
        }
    }

    protected void readLinkParameters(VelocityPortlet portlet, RunData rundata, Context context) {
        Object linksRead = this.getParameterFromTemp(portlet, rundata, LINKS_READ);
        if (linksRead != null && ((String)linksRead).equals(LINKS_READ)) {
            Object tmp = this.getParameterFromTemp(portlet, rundata, ROW_LINK);
            if (tmp != null) {
                context.put(ROW_LINK, (Object)((List)tmp));
            }
            if ((tmp = this.getParameterFromTemp(portlet, rundata, TABLE_LINK)) != null) {
                context.put(TABLE_LINK, (Object)((List)tmp));
            }
        } else {
            String rowLinkIds = this.getParameterFromRegistry(portlet, ROW_LINK_IDS, null);
            String rowLinkClasses = this.getParameterFromRegistry(portlet, ROW_LINK_TARGETS, null);
            String rowLinkTypes = this.getParameterFromRegistry(portlet, ROW_LINK_TYPES, null);
            if (rowLinkIds != null && rowLinkIds.length() > 0) {
                ArrayList<ActionParameter> rowList = new ArrayList<ActionParameter>();
                int rowIndex = 0;
                StringTokenizer tokenizer1 = new StringTokenizer(rowLinkIds, ",");
                StringTokenizer tokenizer2 = new StringTokenizer(rowLinkClasses, ",");
                StringTokenizer tokenizer3 = new StringTokenizer(rowLinkTypes, ",");
                while (tokenizer1.hasMoreTokens() && tokenizer2.hasMoreTokens() && tokenizer3.hasMoreTokens()) {
                    rowList.add(rowIndex, new ActionParameter(tokenizer1.nextToken(), tokenizer2.nextToken(), tokenizer3.nextToken()));
                    ++rowIndex;
                }
                context.put(ROW_LINK, rowList);
                this.setParameterToTemp(portlet, rundata, ROW_LINK, rowList);
            }
            String tableLinkIds = this.getParameterFromRegistry(portlet, TABLE_LINK_IDS, null);
            String tableLinkClasses = this.getParameterFromRegistry(portlet, TABLE_LINK_TARGETS, null);
            String tableLinkTypes = this.getParameterFromRegistry(portlet, TABLE_LINK_TYPES, null);
            if (tableLinkIds != null && tableLinkIds.length() > 0) {
                ArrayList<ActionParameter> tableList = new ArrayList<ActionParameter>();
                int tableIndex = 0;
                StringTokenizer tokenizer1 = new StringTokenizer(tableLinkIds, ",");
                StringTokenizer tokenizer2 = new StringTokenizer(tableLinkClasses, ",");
                StringTokenizer tokenizer3 = new StringTokenizer(tableLinkTypes, ",");
                while (tokenizer1.hasMoreTokens() && tokenizer2.hasMoreTokens() && tokenizer3.hasMoreTokens()) {
                    tableList.add(tableIndex, new ActionParameter(tokenizer1.nextToken(), tokenizer2.nextToken(), tokenizer3.nextToken()));
                    ++tableIndex;
                }
                context.put(TABLE_LINK, tableList);
                this.setParameterToTemp(portlet, rundata, TABLE_LINK, tableList);
            }
            this.setParameterToTemp(portlet, rundata, LINKS_READ, LINKS_READ);
        }
    }

    public void populate(int rowIndex, int columnIndex, List row) {
    }
}

