/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets.security;

import org.apache.jetspeed.modules.actions.portlets.SecureVelocityPortletAction;
import org.apache.jetspeed.modules.actions.portlets.security.SecurityConstants;
import org.apache.jetspeed.om.security.JetspeedPermissionFactory;
import org.apache.jetspeed.om.security.Permission;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class PermissionUpdateAction
extends SecureVelocityPortletAction {
    private static final String TEMP_PERMISSION = "tempPermission";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(PermissionUpdateAction.class.getName());

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildConfigureContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        try {
            String msgid;
            Permission permission = null;
            String mode = rundata.getParameters().getString("mode");
            if (mode != null && (mode.equals("update") || mode.equals("delete"))) {
                String permissionname = rundata.getParameters().getString("entityid");
                permission = JetspeedSecurity.getPermission(permissionname);
                context.put("permission", (Object)permission);
            }
            if ((msgid = rundata.getParameters().getString("msgid")) != null) {
                Permission tempPermission;
                int id = Integer.parseInt(msgid);
                if (id < SecurityConstants.MESSAGES.length) {
                    context.put("msg", (Object)SecurityConstants.MESSAGES[id]);
                }
                if ((tempPermission = (Permission)rundata.getUser().getTemp(TEMP_PERMISSION)) != null) {
                    context.put("permission", (Object)tempPermission);
                }
            }
            context.put("mode", (Object)mode);
        }
        catch (Exception e) {
            logger.error("Error in Jetspeed User Security", e);
            rundata.setMessage("Error in Jetspeed User Security: " + e.toString());
            rundata.setStackTrace(StringUtils.stackTrace((Throwable)e), (Throwable)e);
            rundata.setScreenTemplate(JetspeedResources.getString("template.error", "Error"));
        }
    }

    public void doInsert(RunData rundata, Context context) throws Exception {
        block3: {
            Permission permission = null;
            try {
                String name = rundata.getParameters().getString("name");
                if (name == null || name.trim().length() == 0) {
                    DynamicURI duri = new DynamicURI(rundata);
                    duri.addPathInfo("js_panename", "PermissionForm");
                    duri.addPathInfo("msgid", 2);
                    rundata.setRedirectURI(duri.toString());
                    rundata.getUser().setTemp(TEMP_PERMISSION, null);
                    return;
                }
                permission = JetspeedPermissionFactory.getInstance();
                permission.setName(name);
                JetspeedSecurity.addPermission(permission);
            }
            catch (JetspeedSecurityException e) {
                logger.error("Exception", (Throwable)((Object)e));
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "PermissionForm");
                duri.addPathInfo("msgid", 3);
                rundata.setRedirectURI(duri.toString());
                if (permission == null) break block3;
                rundata.getUser().setTemp(TEMP_PERMISSION, (Object)permission);
            }
        }
    }

    public void doUpdate(RunData rundata, Context context) throws Exception {
        block3: {
            Permission permission = null;
            try {
                permission = JetspeedSecurity.getPermission(rundata.getParameters().getString("entityid"));
                JetspeedSecurity.savePermission(permission);
            }
            catch (Exception e) {
                logger.error("Exception", e);
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "PermissionForm");
                duri.addPathInfo("msgid", 0);
                if (permission != null) {
                    duri.addPathInfo("entityid", permission.getName());
                }
                duri.addQueryData("mode", "update");
                rundata.setRedirectURI(duri.toString());
                if (permission == null) break block3;
                rundata.getUser().setTemp(TEMP_PERMISSION, (Object)permission);
            }
        }
    }

    public void doDelete(RunData rundata, Context context) throws Exception {
        block3: {
            Permission permission = null;
            try {
                permission = JetspeedSecurity.getPermission(rundata.getParameters().getString("entityid"));
                JetspeedSecurity.removePermission(permission.getName());
            }
            catch (Exception e) {
                logger.error("Exception", e);
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "PermissionForm");
                duri.addPathInfo("msgid", 1);
                if (permission != null) {
                    duri.addPathInfo("entityid", permission.getName());
                }
                duri.addQueryData("mode", "delete");
                rundata.setRedirectURI(duri.toString());
                if (permission == null) break block3;
                rundata.getUser().setTemp(TEMP_PERMISSION, (Object)permission);
            }
        }
    }
}

