/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.dbpsml;

import java.sql.Connection;
import java.util.List;
import org.apache.jetspeed.om.dbpsml.BaseJetspeedUserProfilePeer;
import org.apache.jetspeed.om.dbpsml.JetspeedUserProfile;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.psmlmanager.db.DBOperations;
import org.apache.jetspeed.services.psmlmanager.db.DBUtils;
import org.apache.jetspeed.services.psmlmanager.db.DatabasePsmlManager;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public class JetspeedUserProfilePeer
extends BaseJetspeedUserProfilePeer
implements DBOperations {
    public void insert(Profile profile, Connection connection) throws Exception {
        this.doInsertOrUpdate(profile, 1, connection);
    }

    public void update(Profile profile, Connection connection) throws Exception {
        this.doInsertOrUpdate(profile, 2, connection);
    }

    private void doInsertOrUpdate(Profile profile, int operation, Connection connection) throws Exception {
        JetspeedUserProfile userProfile = new JetspeedUserProfile();
        DatabasePsmlManager service = (DatabasePsmlManager)PsmlManager.getService();
        userProfile.setUserName(profile.getUser().getUserName());
        userProfile.setMediaType(profile.getMediaType());
        String language = profile.getLanguage();
        if (language != null && !language.equals("-1")) {
            userProfile.setLanguage(language);
        } else {
            userProfile.setLanguage(null);
        }
        String country = profile.getCountry();
        if (country != null && !country.equals("-1")) {
            userProfile.setCountry(country);
        } else {
            userProfile.setCountry(null);
        }
        String name = profile.getName();
        if (name == null || name.equals("")) {
            profile.setName("default.psml");
        } else if (!name.endsWith(".psml")) {
            profile.setName(name + ".psml");
        }
        userProfile.setPage(profile.getName());
        userProfile.setProfile(DBUtils.portletsToBytes(profile.getDocument().getPortlets(), service.getMapping()));
        if (operation == 1) {
            BaseJetspeedUserProfilePeer.doInsert(userProfile, connection);
        } else if (operation == 2) {
            Criteria values = JetspeedUserProfilePeer.buildCriteria(userProfile);
            Criteria select = JetspeedUserProfilePeer.buildCriteria(userProfile);
            select.remove(PROFILE);
            BasePeer.doUpdate((Criteria)select, (Criteria)values, (Connection)connection);
        }
    }

    public void delete(ProfileLocator locator, Connection connection) throws Exception {
        BaseJetspeedUserProfilePeer.doDelete(this.buildCriteria(locator), connection);
    }

    public List select(ProfileLocator locator, Connection connection) throws Exception {
        Criteria criteria = this.buildCriteria(locator);
        return BaseJetspeedUserProfilePeer.doSelect(criteria, connection);
    }

    public List selectOrdered(ProfileLocator locator, Connection connection) throws Exception {
        Criteria criteria = this.buildCriteria(locator);
        criteria.addAscendingOrderByColumn(USER_NAME);
        criteria.addAscendingOrderByColumn(MEDIA_TYPE);
        criteria.addAscendingOrderByColumn(LANGUAGE);
        criteria.addAscendingOrderByColumn(COUNTRY);
        criteria.addAscendingOrderByColumn(PAGE);
        return BaseJetspeedUserProfilePeer.doSelect(criteria, connection);
    }

    public void delete(JetspeedUser user, Connection connection) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(USER_NAME, (Object)user.getUserName());
        BaseJetspeedUserProfilePeer.doDelete(criteria, connection);
    }

    protected Criteria buildCriteria(ProfileLocator locator) {
        Criteria criteria = new Criteria();
        String mediaType = locator.getMediaType();
        String language = locator.getLanguage();
        String country = locator.getCountry();
        String pageName = locator.getName();
        String userName = null;
        JetspeedUser user = locator.getUser();
        if (user != null) {
            userName = user.getUserName();
        }
        if (userName != null && userName.length() > 0) {
            criteria.add(USER_NAME, (Object)userName);
        }
        if (pageName != null && pageName.length() > 0) {
            criteria.add(PAGE, (Object)pageName);
        }
        if (mediaType != null && mediaType.length() > 0) {
            criteria.add(MEDIA_TYPE, (Object)mediaType);
        }
        if (language != null && language.length() > 0 && !language.equals("-1")) {
            criteria.add(LANGUAGE, (Object)language);
        } else if (language != null && language.equals("-1")) {
            criteria.add(LANGUAGE, null);
        }
        if (country != null && country.length() > 0 && !country.equals("-1")) {
            criteria.add(COUNTRY, (Object)country);
        } else if (country != null && country.equals("-1")) {
            criteria.add(COUNTRY, null);
        }
        return criteria;
    }
}

