/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.profile.psml;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.om.profile.Controller;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Layout;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Reference;
import org.apache.jetspeed.om.profile.Security;
import org.apache.jetspeed.om.profile.psml.PsmlIdentityElement;
import org.apache.jetspeed.om.profile.psml.PsmlLayout;
import org.apache.jetspeed.om.profile.psml.PsmlReference;

public class PsmlPortlets
extends PsmlIdentityElement
implements Portlets,
Serializable {
    private Controller controller = null;
    private Security security = null;
    private Vector portlets = new Vector();
    private Vector entries = new Vector();
    private Vector refs = new Vector();
    private SecurityReference securityRef = null;
    private Portlets parentPortlets;

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public Security getSecurity() {
        return this.security;
    }

    public Vector getEntries() {
        return this.entries;
    }

    public void setEntries(Vector entries) {
        this.entries = entries;
    }

    public Vector getPortlets() {
        Vector<Portlets> v = new Vector<Portlets>();
        for (int ix = 0; ix < this.portlets.size(); ++ix) {
            Portlets p = (Portlets)this.portlets.get(ix);
            if (p instanceof Reference) continue;
            v.add(p);
        }
        return v;
    }

    public void setPortlets(Vector portlets) {
        this.portlets = portlets;
    }

    public Vector getReferences() {
        return this.refs;
    }

    public void addPortlets(PsmlPortlets p) {
        this.portlets.addElement(p);
    }

    public void addReference(PsmlReference ref) {
        this.refs.addElement(ref);
        this.portlets.addElement(ref);
    }

    public void addReference(Reference ref) throws IndexOutOfBoundsException {
        this.refs.addElement(ref);
        this.portlets.addElement(ref);
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    public int getReferenceCount() {
        return this.refs.size();
    }

    public int getPortletsCount() {
        return this.portlets.size();
    }

    public Entry removeEntry(int index) {
        Object obj = this.entries.elementAt(index);
        this.entries.removeElementAt(index);
        return (Entry)obj;
    }

    public Portlets removePortlets(int index) {
        Object obj = this.portlets.elementAt(index);
        if (null == obj) {
            return (Portlets)obj;
        }
        this.portlets.removeElementAt(index);
        if (obj instanceof Reference) {
            this.refs.remove(obj);
        }
        return (Portlets)obj;
    }

    public Reference removeReference(int index) {
        Object obj = this.refs.elementAt(index);
        this.refs.removeElementAt(index);
        this.portlets.remove(obj);
        return (Reference)obj;
    }

    public Entry getEntry(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.entries.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Entry)this.entries.elementAt(index);
    }

    public Portlets getPortlets(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.portlets.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Portlets)this.portlets.elementAt(index);
    }

    public Reference getReference(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.refs.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Reference)this.refs.elementAt(index);
    }

    public Iterator getEntriesIterator() {
        return this.entries.iterator();
    }

    public Iterator getPortletsIterator() {
        return this.portlets.iterator();
    }

    public Iterator getReferenceIterator() {
        return this.refs.iterator();
    }

    public void addEntry(Entry entry) throws IndexOutOfBoundsException {
        this.entries.addElement(entry);
    }

    public void addPortlets(Portlets p) throws IndexOutOfBoundsException {
        this.portlets.addElement(p);
        int end = this.getEntryCount();
        Layout layout = p.getLayout();
        if (layout == null) {
            layout = new PsmlLayout();
            layout.setPosition(end);
            layout.setSize(-1L);
            p.setLayout(layout);
        }
    }

    public Entry[] getEntriesArray() {
        int size = this.entries.size();
        Entry[] mArray = new Entry[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Entry)this.entries.elementAt(index);
        }
        return mArray;
    }

    public Portlets[] getPortletsArray() {
        int size = this.portlets.size();
        Portlets[] mArray = new Portlets[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Portlets)this.portlets.elementAt(index);
        }
        return mArray;
    }

    public Reference[] getReferenceArray() {
        int size = this.refs.size();
        Reference[] mArray = new Reference[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Reference)this.refs.elementAt(index);
        }
        return mArray;
    }

    public SecurityReference getSecurityRef() {
        return this.securityRef;
    }

    public void setSecurityRef(SecurityReference securityRef) {
        this.securityRef = securityRef;
    }

    public Object clone() throws CloneNotSupportedException {
        Iterator it;
        Object cloned = super.clone();
        ((PsmlPortlets)cloned).controller = this.controller == null ? null : (Controller)this.controller.clone();
        Security security = ((PsmlPortlets)cloned).security = this.security == null ? null : (Security)this.security.clone();
        if (this.portlets != null) {
            ((PsmlPortlets)cloned).portlets = new Vector(this.portlets.size());
            it = this.portlets.iterator();
            while (it.hasNext()) {
                ((PsmlPortlets)cloned).portlets.add(((Portlets)it.next()).clone());
            }
        }
        if (this.entries != null) {
            ((PsmlPortlets)cloned).entries = new Vector(this.entries.size());
            it = this.entries.iterator();
            while (it.hasNext()) {
                ((PsmlPortlets)cloned).entries.add(((Entry)it.next()).clone());
            }
        }
        if (this.refs != null) {
            ((PsmlPortlets)cloned).refs = new Vector(this.refs.size());
            it = this.refs.iterator();
            while (it.hasNext()) {
                ((PsmlPortlets)cloned).refs.add(((Reference)it.next()).clone());
            }
        }
        ((PsmlPortlets)cloned).securityRef = this.securityRef == null ? null : (SecurityReference)this.securityRef.clone();
        return cloned;
    }

    public Portlets getParentPortlets() {
        return this.parentPortlets;
    }

    public void setParentPortlets(Portlets parent) {
        this.parentPortlets = parent;
    }
}

